;+
;PROCEDURE: calc_proton_norm_sum_defl
;PURPOSE: A subroutine of calc_proton_bulk_v2.  Counts are summed across deflection steps to reduce 
;	the distribution to 1-D.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 19 November 2009
;
;MODIFICATION HISTORY:
;    November 2009:  created
;
;-

PRO calc_proton_norm_sum_defl, full_data_hz, delta_counts_hz, sum_full_data, sum_delta_counts, peak_ESA, num_records5

Defl_count = INTARR(num_records5)
Defl_count(*) = 0


FOR j = 0L, num_records5-1 DO BEGIN
    FOR k = 0, 31 DO BEGIN	
        temp_count = 0		
        FOR ll = 0, 7 DO BEGIN
            IF full_data_hz(k, ll, j) GT 0 THEN BEGIN		
                sum_full_data[j, k] = sum_full_data(j, k)+(full_data_hz(k, ll, j))*(COS(-0.26180+0.08727*ll))
				; multiply by cosine of deflection angle to account for projection effect
		sum_delta_counts[j,k]=SQRT(sum_delta_counts(j,k)^2.0+(delta_counts_hz(k,ll,j)*COS(-0.26180+0.08727*ll))^2.0)
                Defl_count[j] = Defl_count(j)+1
                temp_count = temp_count + 1
            ENDIF
        ENDFOR
        IF temp_count LE 0 THEN BEGIN
		sum_full_data[j, k] = 0.0
		sum_delta_counts[j,k]=0.0
	ENDIF 
    ENDFOR		
    peak_count = 0
    FOR g = 0, 31 DO BEGIN
        IF (sum_full_data(j, g) GT peak_count) THEN peak_count = sum_full_data(j, g)
        IF (sum_full_data(j, g) GE peak_count) THEN peak_ESA(j) = g
    ENDFOR
ENDFOR

full_data_hz = 0 ; free memory
delta_counts_hz = 0

print, 'Finished summing over deflection steps.'

END