;+
;PROCEDURE: calc_proton_fit_maxwellian
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  Proton distribution functions are
; fit with a maxwellian in order to obtain density, speed, and temperature.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 27 May 2011
;
;MODIFICATION HISTORY:
;    November 2009:  created
;    27 May 2011: added variables for main channel speeds
;
;-



 PRO calc_proton_fit_maxwellian, sat, num_records1, coeff, density, avg_v, temp_K, v_th, good_fit, $
	peak_dist, dist_funct, delta_dist_funct, v_S, v_main, std_error, error1, s_chan, epoch1
compile_opt strictarrsubs

; Fit the distribution function versus velocity data to a 1-D Gaussian.

k=0L
m=0L

FOR n=0L, num_records1-1 DO BEGIN
	temp = dblarr(3)
	temp(*) = -1.0
	guess_0 = dblarr(3)
	guess_0(*) = !values.d_nan
	red_chi = !values.f_nan

	v = fltarr(128)
	v(*) = !values.f_nan
	
	FOR nn = 0, 127 DO BEGIN
		IF nn GE s_chan(n) THEN v(nn) = v_S(nn)
		IF nn LT s_chan(n) THEN v(nn) = v_main(nn)
	ENDFOR

	; increased range of points to fit when measure_errors term added on 19 November, 2007
	; added measure_errors term 19 November, 2007
	IF (peak_dist(n) LT 119) AND (peak_dist(n) GE 66) THEN BEGIN ; changed from 119 to 123 by KDCS, 12 October 2009
        	k = 128*n+peak_dist(n)-3 ;2 
        	m = 128*n+peak_dist(n)+5 ;4
		delta_dist_funct(k:m) = 0.05*MAX(dist_funct(k:m))
		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-3:peak_dist(n)+5)), double(dist_funct(k:m)), double(temp), $
                  nterms = 3, measure_errors = delta_dist_funct(k:m), chisq=red_chi)

        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

        	density(n) = coeff(3*n)*((2*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc ; changed from 2 pi ^ 1/2 which gave a result of 1 (13 August, 2007)
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
		
 		; Make a second loop with no guess if the fit fails the first time.  This is important at times when there are shocks. KDCS
			
        	IF density(n) LE 0.001 OR avg_v(n) LT 230 OR avg_v(n) GT 2000 OR v_th(n) GT 400 OR good_fit(n) GE 5.0 THEN BEGIN
            		FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-3:peak_dist(n)+6)), double(dist_funct(k:m+1)), double(temp), $
                                  nterms = 3, measure_errors = delta_dist_funct(k:m+1),chisq=red_chi)            
            		coeff(3*n) = temp(0)
            		coeff(3*n+1) = temp(1)
            		coeff(3*n+2) = temp(2)
       		
         	  	density(n) = coeff(3*n)*((2*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
          	  	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
           	 	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
            		v_th(n) = SQRT(2)*(coeff(3*n+2))*1.0E-3 ; km/s
	    		good_fit(n) = red_chi
        	ENDIF

	        IF n GE 1 THEN BEGIN
            		IF v_th(n) GE 1.75*v_th(n-1) AND std_error(n) NE 1 THEN std_error(n) = 6
	    		IF v_th(n) LE 0.57*v_th(n-1) AND std_error(n) NE 1 THEN std_error(n) = 6 
        	ENDIF
    	ENDIF

    	IF peak_dist(n) GE 119 AND peak_dist(n) LT 124 THEN BEGIN
        	k = 128*n+peak_dist(n)-4	
        	m = 128*n+124
		delta_dist_funct(k:m) = 0.05*MAX(dist_funct(k:m)) 
        	FIT_MATRIX = GAUSSFIT(double(v(peak_dist(n)-4:124)), double(dist_funct(k:m)), double(temp), $
                              nterms = 3, measure_errors = delta_dist_funct(k:m),chisq=red_chi)
        	coeff(3*n) = temp(0)
        	coeff(3*n+1) = temp(1)
        	coeff(3*n+2) = temp(2)

	        density(n) = coeff(3*n)*((2*!PI)^(0.5))*coeff(3*n+2)*1.0E-11 ; 1/cc
        	avg_v(n) = coeff(3*n+1)*1.0E-3 ; km/s
        	temp_K(n) = (coeff(3*n+2)^2)*(1.67E-27)/(1.38E-23) ;deg K
        	v_th(n) = SQRT(2)*(coeff(3*n+2))*1.0E-3 ; km/s
		good_fit(n) = red_chi
        
        	IF error1(n) GT 0 THEN std_error(n) = 2

	        IF n GE 1 THEN BEGIN
            		IF v_th(n) GE 1.75*v_th(n-1) AND std_error(n) NE 1 THEN std_error(n) = 6
	    		IF v_th(n) LE 0.57*v_th(n-1) AND std_error(n) NE 1 THEN std_error(n) = 6 ; added Feb 2009
        	ENDIF
    	ENDIF

    	IF peak_dist(n) GE 124 OR peak_dist(n) LT 66 THEN BEGIN	
        	density(n) = !values.f_nan
        	avg_v(n) = !values.f_nan
        	temp_K(n) = !values.f_nan
        	v_th(n) = !values.f_nan
        	std_error(n) = 5
    	ENDIF

ENDFOR

END
