;+
;PROCEDURE: calc_proton_finished_ascii
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  This subroutine writes out ascii text
;	for quick review of final results.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 19 November 2009
;
;MODIFICATION HISTORY:
;    November 2009:  created
;
;-



PRO calc_proton_finished_ascii, sat, small_epoch1, kev_time, small_density, small_avg_v, small_temp_K, small_v_th, SMALL_S_MAX, small_std_error, $
	small_caution, small_good_fit, hour_start_time, hour_small_density, hour_speed, hour_temp, hour_small_v_th, hour_ns, $
	hour_error, hour_caution, hour_count, ten_min_start_time, ten_min_small_density, ten_min_speed, ten_min_temp, $
	ten_min_small_v_th, ten_min_ns, ten_min_error, ten_min_caution, ten_min_count
compile_opt strictarrsubs

;; print 1 minute data to output folder

    TAB = STRING(9B)
    time_i = 0
    WHILE finite(small_epoch1[time_i]) EQ 0 DO BEGIN 
        time_i = time_i + 1
    ENDWHILE 
    label_time = time_struct(small_epoch1(time_i))
    label_year = STRING(label_time.year, FORMAT = '(I04)')
    label_month = STRING(label_time.month, FORMAT = '(I02)')
    label_day = STRING(label_time.date, FORMAT = '(I02)')
 	outfile_2 = '/home/ksimunac/Output/'+'PLA_ST'+sat+'_L2_1DMax_'+label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'.txt'
    	openw, out_lun_2, outfile_2, /GET_LUN
    	line = ','

   	temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'sec'+tab+'date and time'+tab+'1 keV/q time'+tab+$
                 'ST'+sat+' Np [1/cc]'+tab+'ST'+sat+' Vp [km/s]'+tab+'ST'+sat+' Tkin [deg K]'+tab+'ST'+sat+' v_th [km/s]'+tab+$
                 'ST'+sat+' N/S [deg]'+tab+'Error Code'+tab+'Caution'+tab+'Chi_sq'
  	 printf, out_lun_2, temp_string


  FOR qq = 0L, N_ELEMENTS(small_density_2) - 1 DO BEGIN

	apid_time = time_struct(small_epoch1(qq))
	kev_struct = time_struct(kev_time(qq))
        YEAR = STRING(apid_time.year, FORMAT = '(I04)')
        DOY = STRING(apid_time.doy, FORMAT = '(I03)')
        HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
        MIN = STRING(apid_time.min, FORMAT = '(I02)')
        SEC = STRING(apid_time.sec, FORMAT = '(I02)')
        N = STRING(small_density(qq), FORMAT = '(F0.2)')
        V = STRING(round(small_avg_v(qq)), FORMAT = '(I4)')
        T = STRING(small_temp_K(qq), FORMAT = '(E10.2)')
        V_TEMP = STRING(small_v_th(qq), FORMAT = '(F0.1)') 
        NS = STRING(SMALL_S_MAX(qq), FORMAT = '(F0.1)')
        ERROR = STRING(small_std_error(qq), FORMAT = '(I1)')
        CAUTION = STRING(small_caution(qq), FORMAT = '(I1)')
	FIT_GOOD = STRING(small_good_fit(qq),FORMAT = '(F0.2)')

	temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+SEC+tab+string(apid_time.month, format = '(I2.2)')+'/'+$
                          string(apid_time.date, format = '(I2.2)')+'/'+string(apid_time.year, format = '(I4.4)')+' '$
                         +string(apid_time.hour, format = '(I2.2)')+':'+string(apid_time.min, format = '(I2.2)')+':'$
                         +string(apid_time.sec, format = '(I2.2)')+tab+string(kev_struct.month, format = '(I2.2)')+'/'+$
                         string(kev_struct.date, format = '(I2.2)')+'/'+string(kev_struct.year, format = '(I4.4)')+' '$
                         +string(kev_struct.hour, format = '(I2.2)')+':'+string(kev_struct.min, format = '(I2.2)')+':'$
                         +string(kev_struct.sec, format = '(I2.2)')+tab+$
                         N+tab+V+tab+T+tab+V_TEMP+tab+NS+tab+ERROR+tab+CAUTION+tab+FIT_GOOD
        printf, out_lun_2, temp_string

   ENDFOR
	close, out_lun_2
	free_lun, out_lun_2


;; print 1 hour data to output folder
 	outfile_1 = '/home/ksimunac/Output/'+'PLA_ST'+sat+'_L2_1DMax_'+label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'_1_hour.txt'
    	openw, out_lun_1, outfile_1, /GET_LUN
    	line = ','

   	temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'date and time'+tab+$
                  'ST'+sat+' Np [1/cc]'+tab+'ST'+sat+' Vp [km/s]'+tab+'ST'+sat+' Tkin [deg K]'+tab+'ST'+sat+' v_th [km/s]'+tab+$
                  'ST'+sat+' N/S [deg]'+tab+'Cycle Count'+tab+'Error Code'+tab+'Caution'
   	 printf, out_lun_1, temp_string

	FOR p = 0, n_elements(hour_speed) - 1 DO BEGIN
		apid_time = time_struct(hour_start_time(p))
        	YEAR = STRING(apid_time.year, FORMAT = '(I04)')
	        DOY = STRING(apid_time.doy, FORMAT = '(I03)')
        	HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
	        MIN = STRING(apid_time.min, FORMAT = '(I02)')
	        SEC = STRING(apid_time.sec, FORMAT = '(I02)')
       	N = STRING(hour_small_density(p), FORMAT = '(F0.2)')
	        V = STRING(round(hour_speed(p)), FORMAT = '(I4)')
        	T = STRING(hour_temp(p), FORMAT = '(E10.2)')
	        V_TEMP = STRING(hour_small_v_th(p), FORMAT = '(F0.1)') 
	       	NS = STRING(hour_ns(p), FORMAT = '(F0.1)')
	        ERROR = STRING(hour_error(p), FORMAT = '(I1)')
	        CAUTION = STRING(hour_caution(p), FORMAT = '(I1)')
		CYCLE_COUNT = STRING(hour_count(p),FORMAT = '(I2)')

	
		temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+string(apid_time.month, format = '(I2.2)')+'/'+$
                          string(apid_time.date, format = '(I2.2)')+'/'+string(apid_time.year, format = '(I4.4)')+' '$
                          +string(apid_time.hour, format = '(I2.2)')+':'+string(apid_time.min, format = '(I2.2)')+tab $
                        +N+tab+V+tab+T+tab+V_TEMP+tab+NS+tab+CYCLE_COUNT+tab+ERROR+tab+CAUTION
           	IF year NE '1970' THEN printf, out_lun_1, temp_string


	ENDFOR
	close, out_lun_1
	free_lun, out_lun_1


;; print 10 minute data to output folder
 	outfile_3 = '/home/ksimunac/Output/'+'PLA_ST'+sat+'_L2_1DMax_'+label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'_10_min.txt'
    	openw, out_lun_3, outfile_3, /GET_LUN
    	line = ','

    	temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'date and time'+tab+$
                  'ST'+sat+' Np [1/cc]'+tab+'ST'+sat+' Vp [km/s]'+tab+'ST'+sat+' Tkin [deg K]'+tab+'ST'+sat+' v_th [km/s]'+tab+$
                  'ST'+sat+' N/S [deg]'+tab+'Cycle Count'+tab+'Error Code'+tab+'Caution'
   	 printf, out_lun_3, temp_string


 
    FOR pp = 0L, N_ELEMENTS(ten_min_speed) - 1 DO BEGIN

        apid_time = time_struct(ten_min_start_time(pp))
        YEAR = STRING(apid_time.year, FORMAT = '(I04)')
        DOY = STRING(apid_time.doy, FORMAT = '(I03)')
        HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
        MIN = STRING(apid_time.min, FORMAT = '(I02)')
        SEC = STRING(apid_time.sec, FORMAT = '(I02)')
        N = STRING(ten_min_small_density(pp), FORMAT = '(F0.2)')
        V = STRING(round(ten_min_speed(pp)), FORMAT = '(I4)')
        T = STRING(ten_min_temp(pp), FORMAT = '(E10.2)')
        V_TEMP = STRING(ten_min_small_v_th(pp), FORMAT = '(F0.1)') 
        NS = STRING(ten_min_ns(pp), FORMAT = '(F0.1)')
        ERROR = STRING(ten_min_error(pp), FORMAT = '(I1)')
        CAUTION = STRING(ten_min_caution(pp), FORMAT = '(I1)')
	CYCLE_COUNT = STRING(ten_min_count(pp),FORMAT = '(I2)')
            
 	temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+string(apid_time.month, format = '(I2.2)')+'/'+$
                          string(apid_time.date, format = '(I2.2)')+'/'+string(apid_time.year, format = '(I4.4)')+' '$
                          +string(apid_time.hour, format = '(I2.2)')+':'+string(apid_time.min, format = '(I2.2)')+tab $
                         +N+tab+V+tab+T+tab+V_TEMP+tab+NS+tab+CYCLE_COUNT+tab+ERROR+tab+CAUTION
        IF year NE '1970' THEN    printf, out_lun_3, temp_string


    ENDFOR
	close, out_lun_3
	free_lun, out_lun_3
END
