;+
;PROCEDURE: calc_proton_defl_peak
;PURPOSE:  A subroutine of calc_proton_bulk_v2.  Gaussians are fit to the
;	deflection count distribution in both the main and small channels.
;
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 23 November 2009
;
;MODIFICATION HISTORY:
;    November 2009:  created
;
;-



PRO calc_proton_defl_peak, num_records1, full_data_no_bkgd2, s_chan, S_MAX, MAIN_MAX
compile_opt strictarrsubs

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Find the deflection count peak
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

s_count = FLTARR(32, num_records1)
s_count(*,*) = 0.0
main_count = FLTARR(32, num_records1)
main_count(*,*) = 0.0
defl_steps = INTARR(32)

FOR z=0,31 DO BEGIN
    defl_steps(z) = z
ENDFOR

temp = DBLARR(3)
temp_2=DBLARR(3)
temp(*) = -1.0
temp_2(*) = -1.0

FOR j=0,31 DO BEGIN ; DEFL Steps
    FOR i = 64, 127 DO BEGIN ; ESA Steps
        FOR k = 0L, num_records1-1 DO BEGIN ; Time Steps
	zz = FINITE(full_data_no_bkgd2(i,j,k))
            IF zz EQ 1 THEN BEGIN
                IF i LT s_chan(k) THEN main_count(j, k) = main_count(j, k) + full_data_no_bkgd2(i, j, k)
                IF i GE s_chan(k) THEN s_count(j, k) = s_count(j, k) + full_data_no_bkgd2(i, j, k)
            ENDIF
        ENDFOR	
    ENDFOR
ENDFOR

FOR l = 0L, num_records1-1 DO BEGIN
    FOR m = 1, 31 DO BEGIN
        IF main_count(m, l) GT main_count(MAIN_MAX(l), l) THEN MAIN_MAX(l) = m
        IF s_count(m, l) GT s_count(S_MAX(l), l) THEN S_MAX(l) = m
    ENDFOR

    IF S_MAX(l) GE 2 AND S_MAX(l) LE 29 THEN BEGIN
        yy = S_MAX(l) - 2
        zz = S_MAX(l) + 2
        result = gaussfit(double(defl_steps(yy:zz)), double(s_count(l*32+yy:l*32+zz)), double(temp), nterms = 3)
        S_MAX(l) = temp(1)
    ENDIF ELSE BEGIN
        S_MAX(l) = !values.f_nan
    ENDELSE
    IF MAIN_MAX(l) GE 2 AND MAIN_MAX(l) LE 29 THEN BEGIN
        aa = MAIN_MAX(l) - 2
        bb = MAIN_MAX(l) + 2
        result = gaussfit(double(defl_steps(aa:bb)), double(main_count(l*32+aa:l*32+bb)), double(temp_2), nterms = 3)
        MAIN_MAX(l) = temp_2(1)
    ENDIF ELSE BEGIN
        MAIN_MAX(l) = !values.f_nan
    ENDELSE
ENDFOR

END
