;+
;PROCEDURE: adjust_reduced_dist
;PURPOSE:  Take tplot value of reduced dist, and put into 128 array
; and apply schan factor. Create adjusted tplot variables.
; Reduced dist products are:
;  01: SW-all                 : h_alpha
;  02: SW-H(D)                : h+peak
;  03: SW-alpha(D)            : he++peak
;  04: SW-alpha(T)            : he++trc
;
;INPUT
;PARAMETERS: var         : string with name of product to adjust. Options are:
;                             STA(B)_PLA_ENSPEC_COUNTS_H_ALPHA
;                             STA(B)_PLA_ENSPEC_COUNTS_H+PEAK
;                             STA(B)_PLA_ENSPEC_COUNTS_HE++PEAK
;                             STA(B)_PLA_ENSPEC_COUNTS_HE++TCR
;            schan_factor: int, factor by which to multiply counts in schan
;
;CREATED BY: L. Ellis
;
;MODIFICATION HISTORY:
;    11/07/2008: LBE: Created by copying Marissa's code from plot_spec_line_schan.pro
;    01/26/2009: LBE: Changed so esa steps with no values are NaN.
;-

PRO adjust_reduced_dist, var, schan_factor
compile_opt strictarrsubs

schan_var = var+'_s_chan_esa'   ; get _s_chan_step
peak_var = var+'_peak_esa'      ; get _peak_esa
get_data, var, data = data, dlimit = dlimit, limit = limit
get_data, schan_var, data = schan_data, dlimit = schan_dlimit, limit = schan_limit

dtime = data.x
ntime = N_ELEMENTS(data.x)

num_records = n_elements(schan_data.y)     
data_size = SIZE(data.y, /DIMENSIONS)
get_data, peak_var, data = peak_data, dlimit = peak_dlimit, limit = peak_limit
new_ydata = fltarr(num_records, 128)
new_vdata = fltarr(num_records, 128)
new_ydata[*, *] = !values.f_nan
FOR ij = 0L, num_records-1 DO BEGIN
                                ; check for peak at end of esa
    IF peak_data.y[ij] GE 123 THEN temp_peak = 123 ELSE temp_peak = peak_data.y[ij]
    IF peak_data.y[ij] LT 5 AND data_size[1] EQ 10 THEN temp_peak = 5 $
    ELSE IF peak_data.y[ij] LT 15 AND data_size[1] EQ 20 THEN temp_peak = 15 
    IF data_size[1] EQ 10 THEN peak_s = temp_peak - 5
    IF data_size[1] EQ 20 THEN peak_s = temp_peak - 15
    peak_e = temp_peak + 4
    new_ydata[ij, peak_s:peak_e] = data.y[ij, 0:data_size[1]-1]
    new_vdata[ij, peak_s:peak_e] = data.v[ij, 0:data_size[1]-1]
ENDFOR
temp_data_y = new_ydata
temp_data_v = new_vdata

;*********************************************************************
; adjust schan
IF schan_factor NE 1 THEN BEGIN 
    FOR ii = 0, num_records-1 DO BEGIN 
        temp_data_y[ii, schan_data.y[ii]:127] = $
          temp_data_y[ii, schan_data.y[ii]:127]* schan_factor
    ENDFOR 
ENDIF 

; store adjusted variable
adj_var = var+'_adj'
store_data, adj_var, data = {x:data.x, y:temp_data_y, v: temp_data_v}, dlimit = dlimit, limit = limit

END 
