; Lorna Ellis
; 07/13/2010
; transform_stereo_mag.pro

; This takes mag data and creates yearly files that have RTN, GSE and
; GSM versions of the data.

; 06/07/2011 Changed path, added average_tplot_variable.
; 03/03/2015 Check for missing files.

PRO transform_stereo_mag, year, start_month, stop_month, sat = sat
compile_opt strictarrsubs

IF keyword_set(sat) THEN sats = [sat] ELSE sats = ['A', 'B']

tab = string(9B)
FOR sat_i = 0, n_elements(sats)-1 DO BEGIN
    sat = sats[sat_i]
    FOR month = start_month, stop_month DO BEGIN 

        SWITCH month OF
            1:
            3:
            5:
            7:
            8:
            10:
            12: BEGIN
                num_days = 31
                BREAK
            END 
            2: BEGIN
                IF year MOD 4 EQ 0 THEN num_days = 29 ELSE num_days = 28
                BREAK
            END 
            4:
            6:
            9:
            11: BEGIN
                num_days = 30
                BREAK
            END 
        ENDSWITCH 

        rtn_x = 'ST'+sat+'_MAG_RTN_X'
        rtn_y = 'ST'+sat+'_MAG_RTN_Y'
        rtn_z = 'ST'+sat+'_MAG_RTN_Z'
        rtn_t = 'ST'+sat+'_MAG_RTN_T'
        gse_x = 'ST'+sat+'_MAG_GSE_X'
        gse_y = 'ST'+sat+'_MAG_GSE_Y'
        gse_z = 'ST'+sat+'_MAG_GSE_Z'
        gse_t = 'ST'+sat+'_MAG_GSE_T'
        gsm_x = 'ST'+sat+'_MAG_GSM_X'
        gsm_y = 'ST'+sat+'_MAG_GSM_Y'
        gsm_z = 'ST'+sat+'_MAG_GSM_Z'
        gsm_t = 'ST'+sat+'_MAG_GSM_T'

        file = '/data1/Aux_Data/mag/'+sat+'/'+string(year, format = '(I4.4)')+'/'+$
               'ST'+sat+'_L1_MAG_Transformed_'+string(year, format = '(I4.4)')+string(month, format = '(I2.2)')+'_V02.txt'
        openw, out_lun, file, /get_lun
        header = 'STEREO '+sat+' Mag data'
        printf, out_lun, header
        header = 'Time'+tab+'RTN_X'+tab+'RTN_Y'+tab+'RTN_Z'+tab+'RTN_T'+tab+$
                 'GSE_X'+tab+'GSE_Y'+tab+'GSE_Z'+tab+'GSE_T'+tab+$
                 'GSM_X'+tab+'GSM_Y'+tab+'GSM_Z'+tab+'GSM_T'
        printf, out_lun, header
        
        FOR date = 1, num_days DO BEGIN 
            start = string(year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                    string(date, format = '(I2.2)')+'/00:00:00'
            timespan, start, 1, /DAYS
            
            get_stereo_mag, sat
            get_data, rtn_x, rtn_xt, rtn_xd
            IF n_elements(rtn_xd) GT 1 THEN BEGIN 
                get_data, rtn_y, rtn_yt, rtn_yd
                get_data, rtn_z, rtn_zt, rtn_zd
                get_data, rtn_t, rtn_tt, rtn_td
                IF array_equal(rtn_xt, rtn_yt) NE 1 THEN stop
                IF array_equal(rtn_xt, rtn_zt) NE 1 THEN stop
                IF array_equal(rtn_xt, rtn_tt) NE 1 THEN stop
                bad_xd = where(rtn_xd LT -1.0e29, bad_xdc)
                IF bad_xdc GT 0 THEN BEGIN ; fix fill
                    bad_yd = where(rtn_yd LT -1.0e29, bad_ydc)
                    bad_zd = where(rtn_zd LT -1.0e29, bad_zdc)
                    bad_td = where(rtn_td LT -1.0e29, bad_tdc)
                    IF array_equal(bad_yd, bad_xd) NE 1 THEN stop
                    IF array_equal(bad_zd, bad_xd) NE 1 THEN stop
                    IF array_equal(bad_td, bad_xd) NE 1 THEN stop
                    rtn_xd[bad_xd] = !values.f_nan
                    rtn_yd[bad_yd] = !values.f_nan
                    rtn_zd[bad_zd] = !values.f_nan
                    rtn_td[bad_td] = !values.f_nan
                    store_data, rtn_x, data = {x:rtn_xt, y:rtn_xd}
                    store_data, rtn_y, data = {x:rtn_yt, y:rtn_yd}
                    store_data, rtn_z, data = {x:rtn_zt, y:rtn_zd}
                    store_data, rtn_t, data = {x:rtn_tt, y:rtn_td}
                ENDIF 
                average_tplot_variable, rtn_x, 60, start_time = start ; put to 1 minute
                average_tplot_variable, rtn_y, 60, start_time = start 
                average_tplot_variable, rtn_z, 60, start_time = start 
                average_tplot_variable, rtn_t, 60, start_time = start 
                get_data, rtn_x, rtn_xt, rtn_xd
                get_data, rtn_y, rtn_yt, rtn_yd
                get_data, rtn_z, rtn_zt, rtn_zd
                get_data, rtn_t, rtn_tt, rtn_td
                IF array_equal(rtn_xt, rtn_yt) NE 1 THEN stop
                IF array_equal(rtn_xt, rtn_zt) NE 1 THEN stop
                IF array_equal(rtn_xt, rtn_tt) NE 1 THEN stop
                bad_xd = where(rtn_xd LT -1.0e29, bad_xdc)
                IF bad_xdc GT 0 THEN BEGIN ; fix fill
                    bad_yd = where(rtn_yd LT -1.0e29, bad_ydc)
                    bad_zd = where(rtn_zd LT -1.0e29, bad_zdc)
                    bad_td = where(rtn_td LT -1.0e29, bad_tdc)
                    IF array_equal(bad_yd, bad_xd) NE 1 THEN stop
                    IF array_equal(bad_zd, bad_xd) NE 1 THEN stop
                    IF array_equal(bad_td, bad_xd) NE 1 THEN stop
                    rtn_xd[bad_xd] = !values.f_nan
                    rtn_yd[bad_yd] = !values.f_nan
                    rtn_zd[bad_zd] = !values.f_nan
                    rtn_td[bad_td] = !values.f_nan
                ENDIF 
            ENDIF 

            size = size(rtn_xt)
            IF size[0] GT 0 THEN BEGIN ; have dblarr
                temp_time = time_string(rtn_xt)
                strput, temp_time, 'T', 10 ; change time string format for SolarSoft
                gse_data = [[rtn_xd], [rtn_yd], [rtn_zd]]
                gsm_data = [[rtn_xd], [rtn_yd], [rtn_zd]]
                gse_data = transpose(gse_data)
                gsm_data = transpose(gsm_data)
                convert_stereo_coord, temp_time, gse_data, 'RTN', 'GSE', spacecraft = sat, /ignore_origin
                convert_stereo_coord, temp_time, gsm_data, 'RTN', 'GSM', spacecraft = sat, /ignore_origin
                gse_total = sqrt((reform(gse_data[0, *]) * reform(gse_data[0, *])) + $
                                 (reform(gse_data[1, *]) * reform(gse_data[1, *])) + $
                                 (reform(gse_data[2, *]) * reform(gse_data[2, *])))
                gsm_total = sqrt((reform(gsm_data[0, *]) * reform(gsm_data[0, *])) + $
                                 (reform(gsm_data[1, *]) * reform(gsm_data[1, *])) + $
                                 (reform(gsm_data[2, *]) * reform(gsm_data[2, *])))
            ENDIF 

            rtn_xt = rtn_xt-30  ; put to beginning of minute
            time_base = strmid(start, 0, 11)
            index = 0
            FOR hour_i = 0, 23 DO BEGIN
                FOR min_i = 0, 59 DO BEGIN 
                    temp_time = time_base+string(hour_i, format = '(I2.2)')+':'+string(min_i, format = '(I2.2)')+':00'
                    IF size[0] GT 0 THEN BEGIN ; have dblarr
                        IF index LT n_elements(rtn_xt) THEN BEGIN 
                            IF (temp_time EQ time_string(rtn_xt[index])) THEN BEGIN 
                                IF finite(rtn_xd[index]) EQ 1 THEN BEGIN 
                                    temp_string = time_string(rtn_xt[index])+tab+$
                                                  string(rtn_xd[index])+tab+string(rtn_yd[index])+tab+$
                                                  string(rtn_zd[index])+tab+string(rtn_td[index])+tab+$
                                                  string(gse_data[0, index])+tab+string(gse_data [1, index])+tab+$
                                                  string(gse_data[2, index])+tab+string(gse_total[   index])+tab+$
                                                  string(gsm_data[0, index])+tab+string(gsm_data [1, index])+tab+$
                                                  string(gsm_data[2, index])+tab+string(gsm_total[   index])
                                ENDIF ELSE BEGIN 
                                    temp_string = temp_time
                                    FOR jj = 0, 11 DO BEGIN 
                                        temp_string = temp_string+tab+'-1.00E31'
                                    ENDFOR
                                ENDELSE 
                                index = index+1
                            ENDIF ELSE BEGIN 
                                temp_string = temp_time
                                FOR jj = 0, 11 DO BEGIN 
                                    temp_string = temp_string+tab+'-1.00E31'
                                ENDFOR
                            ENDELSE 
                        ENDIF ELSE BEGIN 
                            temp_string = temp_time
                            FOR jj = 0, 11 DO BEGIN 
                                temp_string = temp_string+tab+'-1.00E31'
                            ENDFOR
                        ENDELSE 
                        printf, out_lun, temp_string
                    ENDIF ELSE BEGIN 
                        temp_string = temp_time
                        FOR jj = 0, 11 DO BEGIN 
                            temp_string = temp_string+tab+'-1.00E31'
                        ENDFOR
                        printf, out_lun, temp_string
                    ENDELSE 
                ENDFOR 
            ENDFOR 

            tplot_names, '*', names = names
            IF n_elements(names) GT 0 THEN store_data, names, /DEL
        ENDFOR 

        close, out_lun
        free_lun, out_lun
    ENDFOR 
ENDFOR 

print, 'done'
END 
