; Lorna Ellis
; 06/04/2010
; get_wind_swe_hourly.pro

; This reads the wind swe hourly files from their web page.
; NB: This is incomplete. I'm only reading what I need so far.

PRO get_wind_swe_hourly
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

path = getenv('WINDDATA')+'/swe/'

get_timespan, ts
ts_st      = time_struct(ts)
start_year = ts_st[0].year
stop_year  = ts_st[1].year
start_doy  = ts_st[0].doy
stop_doy   = ts_st[1].doy
IF ts_st[1].doy EQ 1 AND ts_st[1].hour EQ 0 THEN stop_year = stop_year - 1

num_years = stop_year - start_year + 1

times  = strarr(num_years*366*24)
den    = fltarr(num_years*366*24)
vel    = fltarr(num_years*366*24)
den[*] = !values.f_nan
vel[*] = !values.f_nan

line = ''
ii   = 0
FOR year = start_year, stop_year DO BEGIN 
    file = path+string(year, format = '(I4.4)')+'_WIND_hourly_averages'
    found = file_test(file)
    IF found EQ 0 THEN BEGIN
        get_err_no =  1
        get_err_msg =  'No files found'
        RETURN
    ENDIF
    IF year MOD 4 EQ 0 THEN num_days = 366 ELSE num_days = 365

    openr, in_lun, file, /get_lun
    need_line = 1
    FOR doy = 1, num_days DO BEGIN 
        FOR hour = 0, 23 DO BEGIN 
            IF eof(in_lun) EQ 1 THEN BEGIN
                IF year EQ stop_year THEN doy = num_days+1 ELSE BEGIN
                    print, 'ERROR: Data file ended prematurely'
                    stop
                ENDELSE 
            ENDIF ELSE BEGIN 
                doy_to_month_date, year, doy, month, date
                times[ii] = string(year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                            string(date, format = '(I2.2)')+'/'+string(hour,  format = '(I2.2)')+':00:00'
                IF need_line EQ 1 THEN BEGIN 
                    readf, in_lun, line
                    parts = strsplit(line, /extract)
                ENDIF 
                IF parts[0] NE year OR parts[1] NE doy OR parts[2] NE hour THEN BEGIN 
                    need_line = 0 
                    print, parts[0], year, ' ', parts[1], doy, ' ', parts[2], hour
                ENDIF ELSE BEGIN ; data gap
                    vel[ii] = float(parts[3])
                    den[ii] = float(parts[6])
                    need_line = 1
                ENDELSE 
                ii = ii + 1
            ENDELSE
        ENDFOR 
    ENDFOR 
    close, in_lun
    free_lun, in_lun  
ENDFOR 

time = time_double(times)
wanted_i = where(time GE ts[0] AND time LE ts[1], count)
IF count GT 0 THEN BEGIN
    time = time[wanted_i]
    den  = den [wanted_i]
    vel  = vel [wanted_i]
    store_data, 'wind_swe_proton_density_hourly', data = {x:time, y: den}
    store_data, 'wind_swe_proton_speed_hourly',   data = {x:time, y: vel}
ENDIF ELSE BEGIN
    print, 'Error: No valid wind swe hourly data'
ENDELSE 

END

            
