; 10/30/2009 LBE: Created

PRO get_wind_orbit
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, 'W', 'wind_orbit', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, temp_epoch, rec_count = epochinfo.maxrec+1
            epoch = reform(temp_epoch[0, *]) ; not sure why this is 3 elements, all the same
            
            prod_name = 'GSE_POS'  ; position in GSE (which is also SE?)
            cdf_varget, cdf_id, prod_name, cdf_gse_pos, rec_count = epochinfo.maxrec+1
            
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch    = REFORM(time_double(epoch, /epoch))
                gse_pos            = cdf_gse_pos
            ENDIF ELSE BEGIN
                converted_epoch    = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                gse_pos            = TRANSPOSE([TRANSPOSE(gse_pos), TRANSPOSE(cdf_gse_pos)])
            ENDELSE

            ifwd =  ifwd + 1
            
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
    
ENDFOR

IF ifwd EQ 0 THEN BEGIN

    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN

ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP


; Change to HERTN
time_st = time_string(converted_epoch)
strput, time_st, 'T', 10
temp_pos = gse_pos
convert_stereo_coord, time_st, gse_pos, 'GSE', 'HEE'
;a = total(hee, 1)
rad = reform(gse_pos[0, *])
;state = get_stereo_coord(time_st, 'Earth', system = 'GSE')
;temp_state = state
;convert_stereo_coord, time_st, state, 'GSE', 'RTN', spacecraft = 'Earth'
;rad = reform(state[0, *]) - reform(gse_pos[0, *])
;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'wind_sc_'

;store_data, varstr+'gse_pos', $
;            data = {x:converted_epoch, y:gse_pos}, $
;            dlim = {panel_size:1, ylog:1, $
;                    ytitle:'Spcrft Pos. GSE!C!C(km)'}
;rad = reform(gse_pos[0, *]) ; radial distance in km
store_data, varstr+'rad', $
            data = {x:converted_epoch, y:rad}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Spcrft Radial Distance!C!C(km)'}

END
