; 07/14/2010 LBE: Created

PRO get_transformed_mag, sats
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

FOR sat_i = 0, n_elements(sats)-1 DO BEGIN
    sat = sats[sat_i]

    seek_files, sat, 'stereo_mag', filesfound, browse = browse
    iff = WHERE(filesfound NE '',  ciff)

    IF ciff EQ 0 THEN BEGIN
        get_err_no =  1
        get_err_msg =  'No files found'
        RETURN
    ENDIF

;------------------------------------------------------------------
; Read files for the specific product related parameters
;------------------------------------------------------------------
    line = ''
    ifwd = 0 
    num_files   = n_elements(filesfound)
    times       = strarr(num_files * 366 * 1441)
    rtn_x       = fltarr(num_files * 366 * 1441)
    rtn_y       = fltarr(num_files * 366 * 1441)
    rtn_z       = fltarr(num_files * 366 * 1441)
    rtn_t       = fltarr(num_files * 366 * 1441)
    gse_x       = fltarr(num_files * 366 * 1441)
    gse_y       = fltarr(num_files * 366 * 1441)
    gse_z       = fltarr(num_files * 366 * 1441)
    gse_t       = fltarr(num_files * 366 * 1441)
    gsm_x       = fltarr(num_files * 366 * 1441)
    gsm_y       = fltarr(num_files * 366 * 1441)
    gsm_z       = fltarr(num_files * 366 * 1441)
    gsm_t       = fltarr(num_files * 366 * 1441)
    
    kk = 0L

    get_timespan, ts
    start_st = time_struct(ts[0])
    year_i   = start_st.year
    doy_i    = start_st.doy
    hour_i   = start_st.hour
    min_i    = start_st.min
    doy_to_month_date, year_i, doy_i, month_i, date_i
    
    stop_st = time_struct(ts[1])
    stop_year_i   = stop_st.year
    stop_doy_i    = stop_st.doy
    stop_hour_i   = stop_st.hour
    stop_min_i    = stop_st.min

    FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN
        
        IF filesfound(jj) NE '' THEN BEGIN
            
            openr, in_lun, filesfound[jj], /get_lun
            FOR ii = 0, 1 DO BEGIN ; read through header
                readf, in_lun, line
            ENDFOR
            
            readf, in_lun, line
            parts      = strsplit(line, /extract)
            temp_year  = strmid(parts[0],  0, 4)
            temp_month = strmid(parts[0],  5, 2)
            temp_date  = strmid(parts[0],  8, 2)
            temp_hour  = strmid(parts[0], 11, 2)
            temp_min   = strmid(parts[0], 14, 2)

            WHILE eof(in_lun) EQ 0 AND $
              ((temp_year LT year_i) OR $
               (temp_year EQ year_i AND temp_month LT month_i) OR $
               (temp_year EQ year_i AND temp_month EQ month_i AND temp_date LT date_i) OR $
               (temp_year EQ year_i AND temp_month EQ month_i AND temp_date EQ date_i AND temp_hour LT hour_i) OR $
               (temp_year EQ year_i AND temp_month EQ month_i AND temp_date EQ date_i AND temp_hour EQ hour_i AND temp_min LT min_i)) DO BEGIN 
                readf, in_lun, line
                parts      = strsplit(line, /extract)
                temp_year  = strmid(parts[0],  0, 4)
                temp_month = strmid(parts[0],  5, 2)
                temp_date  = strmid(parts[0],  8, 2)
                temp_hour  = strmid(parts[0], 11, 2)
                temp_min   = strmid(parts[0], 14, 2)
            ENDWHILE 
            
            finished_file = 0
            WHILE finished_file EQ 0 DO BEGIN 
                IF ((temp_year LT year_i) OR $
                    (temp_year EQ year_i AND temp_month LT month_i) OR $
                    (temp_year EQ year_i AND temp_month EQ month_i AND temp_date LT date_i) OR $
                    (temp_year EQ year_i AND temp_month EQ month_i AND temp_date EQ date_i AND temp_hour LT hour_i) OR $
                    (temp_year EQ year_i AND temp_month EQ month_i AND temp_date EQ date_i AND temp_hour EQ hour_i AND temp_min LT min_i)) THEN stop

                IF ((temp_year GT year_i) OR $ ; missing data
                    (temp_year EQ year_i AND temp_month GT month_i) OR $
                    (temp_year EQ year_i AND temp_month EQ month_i AND temp_date GT date_i) OR $
                    (temp_year EQ year_i AND temp_month EQ month_i AND temp_date EQ date_i AND temp_hour GT hour_i) OR $
                    (temp_year EQ year_i AND temp_month EQ month_i AND temp_date EQ date_i AND temp_hour EQ hour_i AND temp_min GT min_i)) THEN BEGIN 
                    temp_string = string(year_i, format = '(I4.4)')+'-'+string(month_i, format = '(I2.2)')+'-'+$
                                  string(date_i, format = '(I2.2)')+'/'+string(hour_i,  format = '(I2.2)')+':'+$
                                  string(min_i,  format = '(I2.2)')+':00'
                    rtn_x      [kk] = !values.f_nan
                    rtn_y      [kk] = !values.f_nan
                    rtn_z      [kk] = !values.f_nan
                    rtn_t      [kk] = !values.f_nan
                    gse_x      [kk] = !values.f_nan
                    gse_y      [kk] = !values.f_nan
                    gse_z      [kk] = !values.f_nan
                    gse_t      [kk] = !values.f_nan
                    gsm_x      [kk] = !values.f_nan
                    gsm_y      [kk] = !values.f_nan
                    gsm_z      [kk] = !values.f_nan
                    gsm_t      [kk] = !values.f_nan
                ENDIF ELSE BEGIN 
                    IF temp_year NE year_i OR temp_month NE month_i OR temp_date NE date_i OR $
                      temp_hour NE hour_i OR temp_min   NE min_i THEN stop

                    times      [kk] = parts[0]
                    rtn_x      [kk] = float(parts[01])
                    rtn_y      [kk] = float(parts[02])
                    rtn_z      [kk] = float(parts[03])
                    rtn_t      [kk] = float(parts[04])
                    gse_x      [kk] = float(parts[05])
                    gse_y      [kk] = float(parts[06])
                    gse_z      [kk] = float(parts[07])
                    gse_t      [kk] = float(parts[08])
                    gsm_x      [kk] = float(parts[09])
                    gsm_y      [kk] = float(parts[10])
                    gsm_z      [kk] = float(parts[11])
                    gsm_t      [kk] = float(parts[12])
                    
                    IF eof(in_lun) EQ 0 THEN BEGIN 
                        readf, in_lun, line
                        parts      = strsplit(line, /extract)
                        temp_year  = strmid(parts[0],  0, 4)
                        temp_month = strmid(parts[0],  5, 2)
                        temp_date  = strmid(parts[0],  8, 2)
                        temp_hour  = strmid(parts[0], 11, 2)
                        temp_min   = strmid(parts[0], 14, 2)
                    ENDIF ELSE finished_file = 1
                    
                ENDELSE 

            
                kk = kk + 1
                ifwd =  ifwd + 1
                
                min_i = min_i + 1
                IF min_i EQ 60 THEN BEGIN
                    min_i = 0
                    hour_i = hour_i + 1
                    IF hour_i EQ 24 THEN BEGIN
                        hour_i = 0
                        doy_i = doy_i + 1
                        IF (year_i MOD 4 EQ 0 AND doy_i EQ 367) OR $
                          (year_i MOD 4 NE 0 AND doy_i EQ 366) THEN BEGIN
                            year_i = year_i + 1
                            doy_i  = 1
                        ENDIF
                        doy_to_month_date, year_i, doy_i, month_i, date_i
                    ENDIF 
                ENDIF 

                IF (doy_i GT stop_doy_i) OR $
                  (doy_i EQ stop_doy_i AND hour_i GT stop_hour_i) OR $
                  (doy_i EQ stop_doy_i AND hour_i EQ stop_hour_i AND min_i GT stop_min_i) THEN finished_file = 1
;print, year_i, ' ', doy_i, ' ', stop_doy_i, ' ', hour_i, ' ', min_i, ' ', sat, ' ', finished_file
            ENDWHILE 
            
        ENDIF
        
        close, in_lun
        free_lun, in_lun

    ENDFOR

    times = time_double(times)
; take out times outside range
    get_timespan, timespan
    good_i = where(times GE timespan[0] AND times LE timespan[1], count)
    IF count GT 0 THEN BEGIN
        times       = times      [good_i]
        rtn_x       = rtn_x      [good_i]
        rtn_y       = rtn_y      [good_i]
        rtn_z       = rtn_z      [good_i]
        rtn_t       = rtn_t      [good_i]
        gse_x       = gse_x      [good_i]
        gse_y       = gse_y      [good_i]
        gse_z       = gse_z      [good_i]
        gse_t       = gse_t      [good_i]
        gsm_x       = gsm_x      [good_i]
        gsm_y       = gsm_y      [good_i]
        gsm_z       = gsm_z      [good_i]
        gsm_t       = gsm_t      [good_i]
    ENDIF 

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
    icepoch =  WHERE(times LT (time_double('1958-01-01')) OR $
                     times GT (time_double('2050-01-01')), cicepoch)
    IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
    varstr = 'ST'+sat+'_mag_'

    store_data, varstr+'rtn_x', $
                data = {x:times, y:rtn_x}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LX!N RTN (nT)'}
    store_data, varstr+'rtn_y', $
                data = {x:times, y:rtn_y}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LY!N RTN (nT)'}
    store_data, varstr+'rtn_z', $
                data = {x:times, y:rtn_z}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LZ!N RTN (nT)'}
    store_data, varstr+'rtn_t', $
                data = {x:times, y:rtn_t}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LT!N RTN (nT)'}
    store_data, varstr+'gse_x', $
                data = {x:times, y:gse_x}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LX!N GSE (nT)'}
    store_data, varstr+'gse_y', $
                data = {x:times, y:gse_y}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LY!N GSE (nT)'}
    store_data, varstr+'gse_z', $
                data = {x:times, y:gse_z}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LZ!N GSE (nT)'}
    store_data, varstr+'gse_t', $
                data = {x:times, y:gse_t}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LT!N GSE (nT)'}
    store_data, varstr+'gsm_x', $
                data = {x:times, y:gsm_x}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LX!N GSM (nT)'}
    store_data, varstr+'gsm_y', $
                data = {x:times, y:gsm_y}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LY!N GSM (nT)'}
    store_data, varstr+'gsm_z', $
                data = {x:times, y:gsm_z}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LZ!N GSM (nT)'}
    store_data, varstr+'gsm_t', $
                data = {x:times, y:gsm_t}, $
                dlim = {panel_size:1, $
                        ytitle:'ST'+sat+'!C!C'+'B!LT!N GSM (nT)'}
ENDFOR 
END
