; 08/03/2011 LBE: Created
; 10/14/2011 LBE: Fixed bug in array concatenation.
; 10/17/2011 LBE: Fixed bug in en_max.
; 01/02/2013 LBE: Fix for 20 second cadence.

PRO get_swea_pad, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'swea_pad', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read ASCII files for the specific product related parameters
;------------------------------------------------------------------
line = ''
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        ; set up data arrays
        times_day  = dblarr(4500) ; round up -- expect every 20 seconds
        dur_day    = fltarr(4500) ; duration
        en_min_day = fltarr(16, 4500)
        en_mid_day = fltarr(16, 4500)
        en_max_day = fltarr(16, 4500)
        pad_day    = fltarr(12, 16, 4500) ; 12 PAD, 16 Energy

        openr, in_lun, filesfound[jj], /get_lun
        readf, in_lun, line
        WHILE strmid(line, 0, 10) NE 'DATA_UNTIL' DO BEGIN 
            readf, in_lun, line
        ENDWHILE
        kk   = 0
        WHILE eof(in_lun) EQ 0 DO BEGIN
            readf, in_lun, line
            parts = strsplit(line, ',', /extract)
            temp_time = strmid(parts[00], 0, 19)
            strput, temp_time, '/', 10
            times_day [kk] = time_double(temp_time)
            dur_day   [kk] =       float(parts[03])
            FOR ll = 0, 15 DO BEGIN 
                en_mid_day[ll, kk] = float(parts[ll+4])
            ENDFOR 
            FOR ll = 0, 15 DO BEGIN 
                en_min_day[ll, kk] = float(parts[ll+20])
            ENDFOR 
            FOR ll = 0, 15 DO BEGIN 
                en_max_day[ll, kk] = float(parts[ll+36])
            ENDFOR 
            FOR ll = 0, 11 DO BEGIN
                FOR mm = 0, 15 DO BEGIN
                    pad_day[ll, mm, kk] = float(parts[(ll*16)+mm+52])
                ENDFOR 
            ENDFOR 
            kk = kk+1
        ENDWHILE 

        IF jj EQ 0 THEN BEGIN
            times  = times_day[    0:kk-1]
            dur    = dur_day  [    0:kk-1]
            en_min = en_min_day[*, 0:kk-1]
            en_mid = en_mid_day[*, 0:kk-1]
            en_max = en_max_day[*, 0:kk-1]
            pad    = pad_day[*, *, 0:kk-1]
        ENDIF ELSE BEGIN
            times  = [    times,    times_day[    0:kk-1]]
            dur    = [      dur,    dur_day  [    0:kk-1]]
            en_min = [ [en_min], [ en_min_day[*, 0:kk-1]]]
            en_mid = [ [en_mid], [ en_mid_day[*, 0:kk-1]]]
            en_max = [ [en_max], [ en_max_day[*, 0:kk-1]]]
            pad    = [[[  pad]], [[pad_day[*, *, 0:kk-1]]]]
        ENDELSE 
        close, in_lun
        free_lun, in_lun
    ENDIF 
ENDFOR
en_min = en_mid - en_min
en_max = en_mid + en_max

; check for fill (-1.0E+31)
bad_dur_i    = where(dur    LT -1E30, bad_dur_count)
bad_pad_i    = where(pad    LT -1E30, bad_pad_count)
bad_en_min_i = where(en_min LT -1E30, bad_en_min_count)
bad_en_mid_i = where(en_mid LT -1E30, bad_en_mid_count)
bad_en_max_i = where(en_max LT -1E30, bad_en_max_count)
IF bad_dur_count    GT 0 THEN dur   [bad_dur_i]    = !values.f_nan
IF bad_pad_count    GT 0 THEN pad   [bad_pad_i]    = !values.f_nan
IF bad_en_min_count GT 0 THEN en_min[bad_en_min_i] = !values.f_nan
IF bad_en_mid_count GT 0 THEN en_mid[bad_en_mid_i] = !values.f_nan
IF bad_en_max_count GT 0 THEN en_max[bad_en_max_i] = !values.f_nan

; Angles are set
angles = [7.50, 22.50, 37.50, 52.50, 67.50, 82.50, 97.50, 112.50, 127.50, 142.50, 157.50, 172.50]

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'ST'+sat+'_swea_pad_'

; with error included
get_timespan, tt
store_data, varstr+'Duration', $
            data = {x:times, y:dur}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Duration'}
store_data, varstr+'PAD', $
            data = {x:times, y:pad, v:angles}, $
            dlim = {spec:1, panel_size:1, ylog:1, $
                    ytitle:'PAD'}
store_data, varstr+'energy_min', data = {x:times, y:en_min}
store_data, varstr+'energy_mid', data = {x:times, y:en_mid}
store_data, varstr+'energy_max', data = {x:times, y:en_max}
store_data, varstr+'angles',     data = {x:tt, y:angles   }
END
