; 11/17/2009 LBE: Created
; 11/18/2009 LBE: Different variable for with and without error.
; 01/05/2010 LBE: Properly close file.
; 02/04/2015 LBE: Update for new version of data files.

PRO get_ace_swics_2hr
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, 'A_S', 'ace_swics_2hr', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
line = ''
ifwd = 0 
num_files    = n_elements(filesfound)
times        = strarr(num_files * 366 * 12)
he_den       = fltarr(num_files * 366 * 12)
he_den_err   = fltarr(num_files * 366 * 12)
he_vel       = fltarr(num_files * 366 * 12)
he_vth       = fltarr(num_files * 366 * 12)
he_vel_err   = fltarr(num_files * 366 * 12)
he_vth_err   = fltarr(num_files * 366 * 12)
he_qf        = fltarr(num_files * 366 * 12)
c5_vel       = fltarr(num_files * 366 * 12)
c5_vth       = fltarr(num_files * 366 * 12)
c5_vel_err   = fltarr(num_files * 366 * 12)
c5_vth_err   = fltarr(num_files * 366 * 12)
c5_qf        = fltarr(num_files * 366 * 12)
o6_vel       = fltarr(num_files * 366 * 12)
o6_vth       = fltarr(num_files * 366 * 12)
o6_vel_err   = fltarr(num_files * 366 * 12)
o6_vth_err   = fltarr(num_files * 366 * 12)
o6_qf        = fltarr(num_files * 366 * 12)
fe10_vel     = fltarr(num_files * 366 * 12)
fe10_vth     = fltarr(num_files * 366 * 12)
fe10_vel_err = fltarr(num_files * 366 * 12)
fe10_vth_err = fltarr(num_files * 366 * 12)
fe10_qf      = fltarr(num_files * 366 * 12)
c_6_4        = fltarr(num_files * 366 * 12)
c_6_4_err    = fltarr(num_files * 366 * 12)
c_6_4_qf     = fltarr(num_files * 366 * 12)
c_6_5        = fltarr(num_files * 366 * 12)
c_6_5_err    = fltarr(num_files * 366 * 12)
c_6_5_qf     = fltarr(num_files * 366 * 12)
o_7_6        = fltarr(num_files * 366 * 12)
o_7_6_err    = fltarr(num_files * 366 * 12)
o_7_6_qf     = fltarr(num_files * 366 * 12)
c_av_q       = fltarr(num_files * 366 * 12)
c_av_q_err   = fltarr(num_files * 366 * 12)
c_av_q_qf    = fltarr(num_files * 366 * 12)
o_av_q       = fltarr(num_files * 366 * 12)
o_av_q_err   = fltarr(num_files * 366 * 12)
o_av_q_qf    = fltarr(num_files * 366 * 12)
fe_av_q      = fltarr(num_files * 366 * 12)
fe_av_q_err  = fltarr(num_files * 366 * 12)
fe_av_q_qf   = fltarr(num_files * 366 * 12)
mg_av_q_qf   = fltarr(num_files * 366 * 12)
mg_av_q      = fltarr(num_files * 366 * 12)
mg_av_q_err  = fltarr(num_files * 366 * 12)
si_av_q      = fltarr(num_files * 366 * 12)
si_av_q_err  = fltarr(num_files * 366 * 12)
si_av_q_qf   = fltarr(num_files * 366 * 12)
sw_type      = fltarr(num_files * 366 * 12)
fe_o         = fltarr(num_files * 366 * 12)
fe_o_err     = fltarr(num_files * 366 * 12)
fe_o_qf      = fltarr(num_files * 366 * 12)
he_o         = fltarr(num_files * 366 * 12)
he_o_err     = fltarr(num_files * 366 * 12)
he_o_qf      = fltarr(num_files * 366 * 12)
c_o          = fltarr(num_files * 366 * 12)
c_o_err      = fltarr(num_files * 366 * 12)
c_o_qf       = fltarr(num_files * 366 * 12)
ne_o         = fltarr(num_files * 366 * 12)
ne_o_err     = fltarr(num_files * 366 * 12)
ne_o_qf      = fltarr(num_files * 366 * 12)
mg_o         = fltarr(num_files * 366 * 12)
mg_o_err     = fltarr(num_files * 366 * 12)
mg_o_qf      = fltarr(num_files * 366 * 12)
si_o         = fltarr(num_files * 366 * 12)
si_o_err     = fltarr(num_files * 366 * 12)
si_o_qf      = fltarr(num_files * 366 * 12)

kk = 0L

FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        openr, in_lun, filesfound[jj], /get_lun
        FOR ii = 0, 48 DO BEGIN ; read through header
            readf, in_lun, line
        ENDFOR

        finished_file = 0
        WHILE eof(in_lun) EQ 0 AND finished_file EQ 0 DO BEGIN 
            readf, in_lun, line
            parts = strsplit(line, /extract)
            doy_to_month_date, fix(parts[0]), fix(parts[1]), month, date
            temp_string = parts[0]+'-'+string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+'/'
            IF strlen(parts[2]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + parts[2]+':' ; hour
            IF strlen(parts[3]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + parts[3]+':' ; minute
            temp_parts = strsplit(parts[4], '.', /extract)
            IF strlen(temp_parts[0]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + temp_parts[0]+':' ; second
            times       [kk] = temp_string
            he_den      [kk] = float(parts[08])
            he_den_err  [kk] = float(parts[09])
            he_vel      [kk] = float(parts[10])
            he_vth      [kk] = float(parts[11])
            he_vel_err  [kk] = float(parts[12])
            he_vth_err  [kk] = float(parts[13])
            he_qf       [kk] = float(parts[14])
            c5_vel      [kk] = float(parts[15])
            c5_vth      [kk] = float(parts[16])
            c5_vel_err  [kk] = float(parts[17])
            c5_vth_err  [kk] = float(parts[18])
            c5_qf       [kk] = float(parts[19])
            o6_vel      [kk] = float(parts[20])
            o6_vth      [kk] = float(parts[21])
            o6_vel_err  [kk] = float(parts[22])
            o6_vth_err  [kk] = float(parts[23])
            o6_qf       [kk] = float(parts[24])
            fe10_vel    [kk] = float(parts[25])
            fe10_vth    [kk] = float(parts[26])
            fe10_vel_err[kk] = float(parts[27])
            fe10_vth_err[kk] = float(parts[28])
            fe10_qf     [kk] = float(parts[29])
            c_6_4       [kk] = float(parts[30])
            c_6_4_err   [kk] = float(parts[31])
            c_6_4_qf    [kk] = float(parts[32])
            c_6_5       [kk] = float(parts[33])
            c_6_5_err   [kk] = float(parts[34])
            c_6_5_qf    [kk] = float(parts[35])
            o_7_6       [kk] = float(parts[36])
            o_7_6_err   [kk] = float(parts[37])
            o_7_6_qf    [kk] = float(parts[38])
            c_av_q      [kk] = float(parts[39])
            c_av_q_err  [kk] = float(parts[40])
            c_av_q_qf   [kk] = float(parts[41])
            o_av_q      [kk] = float(parts[42])
            o_av_q_err  [kk] = float(parts[43])
            o_av_q_qf   [kk] = float(parts[44])
            fe_av_q     [kk] = float(parts[45])
            fe_av_q_err [kk] = float(parts[46])
            fe_av_q_qf  [kk] = float(parts[47])
            mg_av_q     [kk] = float(parts[48])
            mg_av_q_err [kk] = float(parts[49])
            mg_av_q_qf  [kk] = float(parts[50])
            si_av_q     [kk] = float(parts[51])
            si_av_q_err [kk] = float(parts[52])
            si_av_q_qf  [kk] = float(parts[53])
            sw_type     [kk] = float(parts[54])
            fe_o        [kk] = float(parts[55])
            fe_o_err    [kk] = float(parts[56])
            fe_o_qf     [kk] = float(parts[57])
            he_o        [kk] = float(parts[58])
            he_o_err    [kk] = float(parts[59])
            he_o_qf     [kk] = float(parts[60])
            c_o         [kk] = float(parts[61])
            c_o_err     [kk] = float(parts[62])
            c_o_qf      [kk] = float(parts[63])
            ne_o        [kk] = float(parts[64])
            ne_o_err    [kk] = float(parts[65])
            ne_o_qf     [kk] = float(parts[66])
            mg_o        [kk] = float(parts[67])
            mg_o_err    [kk] = float(parts[68])
            mg_o_qf     [kk] = float(parts[69])
            si_o        [kk] = float(parts[70])
            si_o_err    [kk] = float(parts[71])
            si_o_qf     [kk] = float(parts[72])

            kk = kk + 1
            ifwd =  ifwd + 1
        ENDWHILE 
    ENDIF
    close, in_lun
    free_lun, in_lun
ENDFOR

; take out empty elements
bad_i = where(times EQ '', bad_count, complement = good_i, ncomplement = good_count)
IF bad_count GT 0 AND good_count GT 0 THEN BEGIN
    times        = times       [good_i]
    he_den       = he_den      [good_i]
    he_den_err   = he_den_err  [good_i]
    he_vel       = he_vel      [good_i]
    he_vth       = he_vth      [good_i]
    he_vel_err   = he_vel_err  [good_i]
    he_vth_err   = he_vth_err  [good_i]
    he_qf        = he_qf       [good_i]
    c5_vel       = c5_vel      [good_i]  
    c5_vth       = c5_vth      [good_i]  
    c5_vel_err   = c5_vel_err  [good_i]  
    c5_vth_err   = c5_vth_err  [good_i]  
    c5_qf        = c5_qf       [good_i]  
    o6_vel       = o6_vel      [good_i]  
    o6_vth       = o6_vth      [good_i]  
    o6_vel_err   = o6_vel_err  [good_i]  
    o6_vth_err   = o6_vth_err  [good_i]  
    o6_qf        = o6_qf       [good_i]  
    fe10_vel     = fe10_vel    [good_i]  
    fe10_vth     = fe10_vth    [good_i]  
    fe10_vel_err = fe10_vel_err[good_i]  
    fe10_vth_err = fe10_vth_err[good_i]  
    fe10_qf      = fe10_qf     [good_i]  
    c_6_4        = c_6_4       [good_i]  
    c_6_4_err    = c_6_4_err   [good_i]  
    c_6_4_qf     = c_6_4_qf    [good_i]  
    c_6_5        = c_6_5       [good_i]  
    c_6_5_err    = c_6_5_err   [good_i]  
    c_6_5_qf     = c_6_5_qf    [good_i]  
    o_7_6        = o_7_6       [good_i]  
    o_7_6_err    = o_7_6_err   [good_i]  
    o_7_6_qf     = o_7_6_qf    [good_i]  
    c_av_q       = c_av_q      [good_i]  
    c_av_q_err   = c_av_q_err  [good_i]  
    c_av_q_qf    = c_av_q_qf   [good_i]  
    o_av_q       = o_av_q      [good_i]  
    o_av_q_err   = o_av_q_err  [good_i]  
    o_av_q_qf    = o_av_q_qf   [good_i]  
    fe_av_q      = fe_av_q     [good_i]  
    fe_av_q_err  = fe_av_q_err [good_i]  
    fe_av_q_qf   = fe_av_q_qf  [good_i]  
    mg_av_q      = mg_av_q     [good_i]  
    mg_av_q_err  = mg_av_q_err [good_i]  
    mg_av_q_qf   = mg_av_q_qf  [good_i]  
    si_av_q      = si_av_q     [good_i]  
    si_av_q_err  = si_av_q_err [good_i]  
    si_av_q_qf   = si_av_q_qf  [good_i]  
    sw_type      = sw_type     [good_i]  
    fe_o         = fe_o        [good_i]  
    fe_o_err     = fe_o_err    [good_i]  
    fe_o_qf      = fe_o_qf     [good_i]  
    he_o         = he_o        [good_i]  
    he_o_err     = he_o_err    [good_i]  
    he_o_qf      = he_o_qf     [good_i]  
    c_o          = c_o         [good_i]  
    c_o_err      = c_o_err     [good_i]  
    c_o_qf       = c_o_qf      [good_i]  
    ne_o         = ne_o        [good_i]  
    ne_o_err     = ne_o_err    [good_i]  
    ne_o_qf      = ne_o_qf     [good_i]  
    mg_o         = mg_o        [good_i]  
    mg_o_err     = mg_o_err    [good_i]  
    mg_o_qf      = mg_o_qf     [good_i]  
    si_o         = si_o        [good_i]  
    si_o_err     = si_o_err    [good_i]  
    si_o_qf      = si_o_qf     [good_i]  
ENDIF 

times = time_double(times)
; take out times outside range
get_timespan, timespan
good_i = where(times GE timespan[0] AND times LE timespan[1], count)
IF count GT 0 THEN BEGIN
    times        = times       [good_i]
    he_den       = he_den      [good_i]
    he_den_err   = he_den_err  [good_i]
    he_vel       = he_vel      [good_i]
    he_vth       = he_vth      [good_i]
    he_vel_err   = he_vel_err  [good_i]
    he_vth_err   = he_vth_err  [good_i]
    he_qf        = he_qf       [good_i]
    c5_vel       = c5_vel      [good_i]  
    c5_vth       = c5_vth      [good_i]  
    c5_vel_err   = c5_vel_err  [good_i]  
    c5_vth_err   = c5_vth_err  [good_i]  
    c5_qf        = c5_qf       [good_i]  
    o6_vel       = o6_vel      [good_i]  
    o6_vth       = o6_vth      [good_i]  
    o6_vel_err   = o6_vel_err  [good_i]  
    o6_vth_err   = o6_vth_err  [good_i]  
    o6_qf        = o6_qf       [good_i]  
    fe10_vel     = fe10_vel    [good_i]  
    fe10_vth     = fe10_vth    [good_i]  
    fe10_vel_err = fe10_vel_err[good_i]  
    fe10_vth_err = fe10_vth_err[good_i]  
    fe10_qf      = fe10_qf     [good_i]  
    c_6_4        = c_6_4       [good_i]  
    c_6_4_err    = c_6_4_err   [good_i]  
    c_6_4_qf     = c_6_4_qf    [good_i]  
    c_6_5        = c_6_5       [good_i]  
    c_6_5_err    = c_6_5_err   [good_i]  
    c_6_5_qf     = c_6_5_qf    [good_i]  
    o_7_6        = o_7_6       [good_i]  
    o_7_6_err    = o_7_6_err   [good_i]  
    o_7_6_qf     = o_7_6_qf    [good_i]  
    c_av_q       = c_av_q      [good_i]  
    c_av_q_err   = c_av_q_err  [good_i]  
    c_av_q_qf    = c_av_q_qf   [good_i]  
    o_av_q       = o_av_q      [good_i]  
    o_av_q_err   = o_av_q_err  [good_i]  
    o_av_q_qf    = o_av_q_qf   [good_i]  
    fe_av_q      = fe_av_q     [good_i]  
    fe_av_q_err  = fe_av_q_err [good_i]  
    fe_av_q_qf   = fe_av_q_qf  [good_i]  
    mg_av_q      = mg_av_q     [good_i]  
    mg_av_q_err  = mg_av_q_err [good_i]  
    mg_av_q_qf   = mg_av_q_qf  [good_i]  
    si_av_q      = si_av_q     [good_i]  
    si_av_q_err  = si_av_q_err [good_i]  
    si_av_q_qf   = si_av_q_qf  [good_i]  
    sw_type      = sw_type     [good_i]  
    fe_o         = fe_o        [good_i]  
    fe_o_err     = fe_o_err    [good_i]  
    fe_o_qf      = fe_o_qf     [good_i]  
    he_o         = he_o        [good_i]  
    he_o_err     = he_o_err    [good_i]  
    he_o_qf      = he_o_qf     [good_i]  
    c_o          = c_o         [good_i]  
    c_o_err      = c_o_err     [good_i]  
    c_o_qf       = c_o_qf      [good_i]  
    ne_o         = ne_o        [good_i]  
    ne_o_err     = ne_o_err    [good_i]  
    ne_o_qf      = ne_o_qf     [good_i]  
    mg_o         = mg_o        [good_i]  
    mg_o_err     = mg_o_err    [good_i]  
    mg_o_qf      = mg_o_qf     [good_i]  
    si_o         = si_o        [good_i]  
    si_o_err     = si_o_err    [good_i]  
    si_o_qf      = si_o_qf     [good_i]  
ENDIF 

; take out times where there is bad data (-9999.9)
bad_he_den_i   = where(he_den   LT -9999.0, bad_he_den_count)
bad_he_vel_i   = where(he_vel   LT -9999.0, bad_he_vel_count)
bad_he_vth_i   = where(he_vth   LT -9999.0, bad_he_vth_count)
bad_c5_vel_i   = where(c5_vel   LT -9999.0, bad_c5_vel_count)  
bad_c5_vth_i   = where(c5_vth   LT -9999.0, bad_c5_vth_count)  
bad_o6_vel_i   = where(o6_vel   LT -9999.0, bad_o6_vel_count)  
bad_o6_vth_i   = where(o6_vth   LT -9999.0, bad_o6_vth_count)  
bad_fe10_vel_i = where(fe10_vel LT -9999.0, bad_fe10_vel_count)  
bad_fe10_vth_i = where(fe10_vth LT -9999.0, bad_fe10_vth_count)  
bad_c_6_4_i    = where(c_6_4    LT -9999.0, bad_c_6_4_count)  
bad_c_6_5_i    = where(c_6_5    LT -9999.0, bad_c_6_5_count)  
bad_o_7_6_i    = where(o_7_6    LT -9999.0, bad_o_7_6_count)  
bad_c_av_q_i   = where(c_av_q   LT -9999.0, bad_c_av_q_count)  
bad_o_av_q_i   = where(o_av_q   LT -9999.0, bad_o_av_q_count)  
bad_fe_av_q_i  = where(fe_av_q  LT -9999.0, bad_fe_av_q_count)  
bad_mg_av_q_i  = where(mg_av_q  LT -9999.0, bad_mg_av_q_count)  
bad_si_av_q_i  = where(si_av_q  LT -9999.0, bad_si_av_q_count)  
bad_sw_type_i  = where(sw_type  LT -9999.0, bad_sw_type_count)  
bad_fe_o_i     = where(fe_o     LT -9999.0, bad_fe_o_count)  
bad_he_o_i     = where(he_o     LT -9999.0, bad_he_o_count)  
bad_c_o_i      = where(c_o      LT -9999.0, bad_c_o_count)  
bad_ne_o_i     = where(ne_o     LT -9999.0, bad_ne_o_count)  
bad_mg_o_i     = where(mg_o     LT -9999.0, bad_mg_o_count)  
bad_si_o_i     = where(si_o     LT -9999.0, bad_si_o_count)  
IF bad_he_den_count   GT 0 THEN he_den   [bad_he_den_i  ] = !values.f_nan
IF bad_he_vel_count   GT 0 THEN he_vel   [bad_he_vel_i  ] = !values.f_nan
IF bad_he_vth_count   GT 0 THEN he_vth   [bad_he_vth_i  ] = !values.f_nan
IF bad_c5_vel_count   GT 0 THEN c5_vel   [bad_c5_vel_i  ] = !values.f_nan  
IF bad_c5_vth_count   GT 0 THEN c5_vth   [bad_c5_vth_i  ] = !values.f_nan  
IF bad_o6_vel_count   GT 0 THEN o6_vel   [bad_o6_vel_i  ] = !values.f_nan  
IF bad_o6_vth_count   GT 0 THEN o6_vth   [bad_o6_vth_i  ] = !values.f_nan  
IF bad_fe10_vel_count GT 0 THEN fe10_vel [bad_fe10_vel_i] = !values.f_nan  
IF bad_fe10_vth_count GT 0 THEN fe10_vth [bad_fe10_vth_i] = !values.f_nan  
IF bad_c_6_4_count    GT 0 THEN c_6_4    [bad_c_6_4_i   ] = !values.f_nan  
IF bad_c_6_5_count    GT 0 THEN c_6_5    [bad_c_6_5_i   ] = !values.f_nan  
IF bad_o_7_6_count    GT 0 THEN o_7_6    [bad_o_7_6_i   ] = !values.f_nan  
IF bad_c_av_q_count   GT 0 THEN c_av_q   [bad_c_av_q_i  ] = !values.f_nan  
IF bad_o_av_q_count   GT 0 THEN o_av_q   [bad_o_av_q_i  ] = !values.f_nan  
IF bad_fe_av_q_count  GT 0 THEN fe_av_q  [bad_fe_av_q_i ] = !values.f_nan  
IF bad_mg_av_q_count  GT 0 THEN mg_av_q  [bad_mg_av_q_i ] = !values.f_nan  
IF bad_si_av_q_count  GT 0 THEN si_av_q  [bad_si_av_q_i ] = !values.f_nan  
IF bad_sw_type_count  GT 0 THEN sw_type  [bad_sw_type_i ] = !values.f_nan  
IF bad_fe_o_count     GT 0 THEN fe_o     [bad_fe_o_i    ] = !values.f_nan  
IF bad_he_o_count     GT 0 THEN he_o     [bad_he_o_i    ] = !values.f_nan  
IF bad_c_o_count      GT 0 THEN c_o      [bad_c_o_i     ] = !values.f_nan  
IF bad_ne_o_count     GT 0 THEN ne_o     [bad_ne_o_i    ] = !values.f_nan  
IF bad_mg_o_count     GT 0 THEN mg_o     [bad_mg_o_i    ] = !values.f_nan  
IF bad_si_o_count     GT 0 THEN si_o     [bad_si_o_i    ] = !values.f_nan  

; make copy for no_err version
he_den_no_err    = he_den      
he_vel_no_err    = he_vel      
he_vth_no_err    = he_vth      
c5_vel_no_err   = c5_vel       
c5_vth_no_err   = c5_vth       
o6_vel_no_err   = o6_vel       
o6_vth_no_err   = o6_vth       
fe10_vel_no_err = fe10_vel     
fe10_vth_no_err = fe10_vth     
c_6_4_no_err    = c_6_4        
c_6_5_no_err    = c_6_5        
o_7_6_no_err    = o_7_6        
c_av_q_no_err   = c_av_q       
o_av_q_no_err   = o_av_q       
fe_av_q_no_err  = fe_av_q      
mg_av_q_no_err  = mg_av_q      
si_av_q_no_err  = si_av_q      
sw_type_no_err  = sw_type      
fe_o_no_err     = fe_o         
he_o_no_err     = he_o         
c_o_no_err      = c_o         
ne_o_no_err     = ne_o         
mg_o_no_err     = mg_o         
si_o_no_err     = si_o         

; take out times with bad quality flag
bad_he_i       = where(he_qf      GT 0, bad_he_count)
bad_c5_i       = where(c5_qf      GT 0, bad_c5_count)  
bad_o6_i       = where(o6_qf      GT 0, bad_o6_count)  
bad_fe10_i     = where(fe10_qf    GT 0, bad_fe10_count)  
bad_c_6_4_i    = where(c_6_4_qf   GT 0, bad_c_6_4_count)  
bad_c_6_5_i    = where(c_6_5_qf   GT 0, bad_c_6_5_count)  
bad_o_7_6_i    = where(o_7_6_qf   GT 0, bad_o_7_6_count)  
bad_c_av_q_i   = where(c_av_q_qf  GT 0, bad_c_av_q_count)  
bad_o_av_q_i   = where(o_av_q_qf  GT 0, bad_o_av_q_count)  
bad_fe_av_q_i  = where(fe_av_q_qf GT 0, bad_fe_av_q_count)  
bad_mg_av_q_i  = where(mg_av_q_qf GT 0, bad_mg_av_q_count)  
bad_si_av_q_i  = where(si_av_q_qf GT 0, bad_si_av_q_count)  
bad_fe_o_i     = where(fe_o_qf    GT 0, bad_fe_o_count)  
bad_he_o_i     = where(he_o_qf    GT 0, bad_he_o_count)  
bad_c_o_i      = where(c_o_qf     GT 0, bad_c_o_count)  
bad_ne_o_i     = where(ne_o_qf    GT 0, bad_ne_o_count)  
bad_mg_o_i     = where(mg_o_qf    GT 0, bad_mg_o_count)  
bad_si_o_i     = where(si_o_qf    GT 0, bad_si_o_count)  
IF bad_he_count    GT 0 THEN BEGIN 
    he_den_no_err   [bad_he_i   ] = !values.f_nan
    he_vel_no_err   [bad_he_i   ] = !values.f_nan
    he_vth_no_err   [bad_he_i   ] = !values.f_nan
ENDIF 
IF bad_c5_count       GT 0 THEN BEGIN 
    c5_vel_no_err  [bad_c5_i  ] = !values.f_nan
    c5_vth_no_err  [bad_c5_i  ] = !values.f_nan
ENDIF 
IF bad_o6_count   GT 0 THEN BEGIN 
    o6_vel_no_err  [bad_o6_i  ] = !values.f_nan
    o6_vth_no_err  [bad_o6_i  ] = !values.f_nan
ENDIF 
IF bad_fe10_count GT 0 THEN BEGIN 
    fe10_vel_no_err[bad_fe10_i] = !values.f_nan
    fe10_vth_no_err[bad_fe10_i] = !values.f_nan
ENDIF 
IF bad_c_6_4_count    GT 0 THEN c_6_4_no_err  [bad_c_6_4_i   ] = !values.f_nan  
IF bad_c_6_5_count    GT 0 THEN c_6_5_no_err  [bad_c_6_5_i   ] = !values.f_nan  
IF bad_o_7_6_count    GT 0 THEN o_7_6_no_err  [bad_o_7_6_i   ] = !values.f_nan  
IF bad_c_av_q_count   GT 0 THEN c_av_q_no_err [bad_c_av_q_i  ] = !values.f_nan  
IF bad_o_av_q_count   GT 0 THEN o_av_q_no_err [bad_o_av_q_i  ] = !values.f_nan  
IF bad_fe_av_q_count  GT 0 THEN fe_av_q_no_err[bad_fe_av_q_i ] = !values.f_nan  
IF bad_mg_av_q_count  GT 0 THEN mg_av_q_no_err[bad_mg_av_q_i ] = !values.f_nan  
IF bad_si_av_q_count  GT 0 THEN si_av_q_no_err[bad_si_av_q_i ] = !values.f_nan  
IF bad_fe_o_count     GT 0 THEN fe_o_no_err   [bad_fe_o_i    ] = !values.f_nan  
IF bad_he_o_count     GT 0 THEN he_o_no_err   [bad_he_o_i    ] = !values.f_nan  
IF bad_c_o_count      GT 0 THEN c_o_no_err    [bad_c_o_i     ] = !values.f_nan  
IF bad_ne_o_count     GT 0 THEN ne_o_no_err   [bad_ne_o_i    ] = !values.f_nan  
IF bad_mg_o_count     GT 0 THEN mg_o_no_err   [bad_mg_o_i    ] = !values.f_nan  
IF bad_si_o_count     GT 0 THEN si_o_no_err   [bad_si_o_i    ] = !values.f_nan  


IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(times LT (time_double('1958-01-01')) OR $
                 times GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'ace_swics_'

; with error included
store_data, varstr+'alpha_density_2hr', $
            data = {x:times, y:he_den}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'alpha!C!Cn (cm!U-3!N)'}
store_data, varstr+'alpha_velocity_2hr', $
            data = {x:times, y:he_vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'alpha_v_therm_2hr', $
            data = {x:times, y:he_vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'c5_vel_2hr', $
            data = {x:times, y:c5_vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon5!C!V (km s!U-1!N)'}
store_data, varstr+'c5_vth_2hr', $
            data = {x:times, y:c5_vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon5!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'o6_vel_2hr', $
            data = {x:times, y:o6_vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen6!C!CV (km s!U-1!N)'}
store_data, varstr+'o6_vth_2hr', $
            data = {x:times, y:o6_vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen6!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'fe10_vel_2hr', $
            data = {x:times, y:fe10_vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron10!C!CV (km s!U-1!N)'}
store_data, varstr+'fe10_vth_2hr', $
            data = {x:times, y:fe10_vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron10!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'c_6_4_2hr', $
            data = {x:times, y:c_6_4}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon 6/4'}
store_data, varstr+'c_6_5_2hr', $
            data = {x:times, y:c_6_5}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon 6/5'}
store_data, varstr+'o_7_6_2hr', $
            data = {x:times, y:o_7_6}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen 7/6'}
store_data, varstr+'c_av_q_2hr', $
            data = {x:times, y:c_av_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon Ave. Q'}
store_data, varstr+'o_av_q_2hr', $
            data = {x:times, y:o_av_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen Ave. Q'}
store_data, varstr+'fe_av_q_2hr', $
            data = {x:times, y:fe_av_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron Ave. Q'}
store_data, varstr+'mg_av_q_2hr', $
            data = {x:times, y:mg_av_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Magnesium Ave. Q'}
store_data, varstr+'si_av_q_2hr', $
            data = {x:times, y:si_av_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Silicon Ave. Q'}
store_data, varstr+'sw_type_2hr', $
            data = {x:times, y:sw_type}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'SW Type'}
store_data, varstr+'fe_o_2hr', $
            data = {x:times, y:fe_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron/Oxygen'}
store_data, varstr+'he_o_2hr', $
            data = {x:times, y:he_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Helium/Oxygen'}
store_data, varstr+'c_o_2hr', $
            data = {x:times, y:c_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon/Oxygen'}
store_data, varstr+'ne_o_2hr', $
            data = {x:times, y:ne_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Neon/Oxygen'}
store_data, varstr+'mg_o_2hr', $
            data = {x:times, y:mg_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Magnesiums/Oxygen'}
store_data, varstr+'si_o_2hr', $
            data = {x:times, y:si_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Silicon/Oxygen'}
; no error included
store_data, varstr+'alpha_density_2hr_no_err', $
            data = {x:times, y:he_den_no_err}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'alpha!C!Cn (cm!U-3!N)'}
store_data, varstr+'alpha_velocity_2hr_no_err', $
            data = {x:times, y:he_vel_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'alpha_v_therm_2hr_no_err', $
            data = {x:times, y:he_vth_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'c5_vel_2hr_no_err', $
            data = {x:times, y:c5_vel_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon5!C!V (km s!U-1!N)'}
store_data, varstr+'c5_vth_2hr_no_err', $
            data = {x:times, y:c5_vth_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon5!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'o6_vel_2hr_no_err', $
            data = {x:times, y:o6_vel_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen6!C!CV (km s!U-1!N)'}
store_data, varstr+'o6_vth_2hr_no_err', $
            data = {x:times, y:o6_vth_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen6!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'fe10_vel_2hr_no_err', $
            data = {x:times, y:fe10_vel_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron10!C!CV (km s!U-1!N)'}
store_data, varstr+'fe10_vth_2hr_no_err', $
            data = {x:times, y:fe10_vth_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron10!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'c_6_4_2hr_no_err', $
            data = {x:times, y:c_6_4_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon 6/4'}
store_data, varstr+'c_6_5_2hr_no_err', $
            data = {x:times, y:c_6_5_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon 6/5'}
store_data, varstr+'o_7_6_2hr_no_err', $
            data = {x:times, y:o_7_6_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen 7/6'}
store_data, varstr+'c_av_q_2hr_no_err', $
            data = {x:times, y:c_av_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon Ave. Q'}
store_data, varstr+'o_av_q_2hr_no_err', $
            data = {x:times, y:o_av_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen Ave. Q'}
store_data, varstr+'fe_av_q_2hr_no_err', $
            data = {x:times, y:fe_av_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron Ave. Q'}
store_data, varstr+'mg_av_q_2hr_no_err', $
            data = {x:times, y:mg_av_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Magnesium Ave. Q'}
store_data, varstr+'si_av_q_2hr_no_err', $
            data = {x:times, y:si_av_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Silicon Ave. Q'}
store_data, varstr+'sw_type_2hr_no_err', $
            data = {x:times, y:sw_type_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'SW Type'}
store_data, varstr+'fe_o_2hr_no_err', $
            data = {x:times, y:fe_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron/Oxygen'}
store_data, varstr+'he_o_2hr_no_err', $
            data = {x:times, y:he_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Helium/Oxygen'}
store_data, varstr+'c_o_2hr_no_err', $
            data = {x:times, y:c_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon/Oxygen'}
store_data, varstr+'ne_o_2hr_no_err', $
            data = {x:times, y:ne_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Neon/Oxygen'}
store_data, varstr+'mg_o_2hr_no_err', $
            data = {x:times, y:mg_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Magnesiums/Oxygen'}
store_data, varstr+'si_o_2hr_no_err', $
            data = {x:times, y:si_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Silicon/Oxygen'}

END
