; Lorna Ellis
; 10/23/2009
; get_ace_ancillary.pro

; This reads the ACE spacecraft position in HS.

; 01/05/2010 LBE Properly close file.

PRO get_ace_ancillary
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

path = getenv('ACEDATA')+'/'
file = path+'ancillary'

found = file_test(file)
IF found EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

get_timespan, ts
ts_st      = time_struct(ts)
start_year = ts_st[0].year
stop_year  = ts_st[1].year
start_doy  = ts_st[0].doy
stop_doy   = ts_st[1].doy

IF start_year EQ stop_year THEN num_days = stop_doy-start_doy+1 ELSE BEGIN
    temp_year = start_year
    IF temp_year EQ 2008 OR temp_year EQ 2012 OR temp_year EQ 2016 OR temp_year EQ 2020 THEN num_days = 366-start_doy+1 $
      ELSE num_days = 365-start_doy+1
    temp_year = temp_year + 1
    WHILE temp_year LT stop_year DO BEGIN
        IF temp_year EQ 2008 OR temp_year EQ 2012 OR temp_year EQ 2016 OR temp_year EQ 2020 THEN num_days = num_days + 366 $
          ELSE num_days = num_days + 365
        temp_year = temp_year + 1
    ENDWHILE
    num_days = num_days + stop_doy
ENDELSE 

ace_x    = dblarr(num_days)
ace_y    = dblarr(num_days)
ace_z    = dblarr(num_days)
ace_d    = dblarr(num_days)
ace_time = strarr(num_days)

line = ''
openr, in_lun, file, /get_lun
FOR ii = 0, 3 DO BEGIN ; header lines
    readf, in_lun, line
ENDFOR 
done      = 0
ii        = 0
temp_doy  = start_doy
temp_year = start_year
WHILE eof(in_lun) EQ 0 AND done EQ 0 DO BEGIN 
    readf, in_lun, line
    parts = strsplit(line, /extract)
    year = fix(strmid(parts[0], 0, 4))
    doy  = fix(strmid(parts[0], 4, 3))
    WHILE temp_year LT year AND done EQ 0 DO BEGIN ; missing data
        ace_x   [ii] = !values.f_nan
        ace_y   [ii] = !values.f_nan
        ace_z   [ii] = !values.f_nan
        ace_d   [ii] = !values.f_nan
        doy_to_month_date, temp_year, temp_doy, month, date
        ace_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                       string(date, format = '(I2.2)')+'/00:00:00'
        IF temp_year EQ stop_year AND temp_doy EQ stop_doy THEN done = 1 ELSE BEGIN
            ii = ii + 1
            temp_doy = temp_doy + 1
        ENDELSE 
        IF (((temp_year EQ 2008  OR temp_year EQ 2012  OR temp_year EQ 2016  OR temp_year EQ 2020) AND doy EQ 367) OR $
            ((temp_year NE 2008 AND temp_year NE 2012 AND temp_year NE 2016 AND temp_year NE 2020) AND doy EQ 366)) THEN BEGIN 
            temp_year = temp_year + 1
            temp_doy  = 1
        ENDIF 
    ENDWHILE
    IF temp_year EQ year AND done EQ 0 THEN BEGIN 
        WHILE temp_doy LT doy AND done EQ 0 DO BEGIN ; missing data
            ace_x   [ii] = !values.f_nan
            ace_y   [ii] = !values.f_nan
            ace_z   [ii] = !values.f_nan
            ace_d   [ii] = !values.f_nan
            doy_to_month_date, temp_year, temp_doy, month, date
            ace_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                           string(date, format = '(I2.2)')+'/00:00:00'
            IF temp_year EQ stop_year AND temp_doy EQ stop_doy THEN done = 1 ELSE BEGIN
                ii = ii + 1
                temp_doy = temp_doy + 1
            ENDELSE 
        ENDWHILE
    ENDIF 
    IF temp_year EQ year AND temp_doy EQ doy AND done EQ 0 THEN BEGIN
        ace_x   [ii] = double(parts[3])
        ace_y   [ii] = double(parts[4])
        ace_z   [ii] = double(parts[5])
        ace_d   [ii] = sqrt((ace_x[ii]^2) + (ace_y[ii]^2) + (ace_z[ii]^2))
        doy_to_month_date, temp_year, temp_doy, month, date
        ace_time[ii] = string(temp_year, format = '(I4.4)')+'-'+string(month, format = '(I2.2)')+'-'+$
                       string(date, format = '(I2.2)')+'/00:00:00'
        IF temp_year EQ stop_year AND temp_doy EQ stop_doy THEN done = 1 ELSE BEGIN
            ii = ii + 1
            temp_doy = temp_doy + 1
            IF (((temp_year EQ 2008  OR temp_year EQ 2012  OR temp_year EQ 2016  OR temp_year EQ 2020) AND temp_doy EQ 367) OR $
                ((temp_year NE 2008 AND temp_year NE 2012 AND temp_year NE 2016 AND temp_year NE 2020) AND temp_doy EQ 366)) THEN BEGIN 
                temp_year = temp_year + 1
                temp_doy  = 1
            ENDIF 
        ENDELSE 
    ENDIF 
ENDWHILE 
close, in_lun
free_lun, in_lun  

IF ii NE num_days-1 THEN stop

time = time_double(ace_time)
store_data, 'ace_sp_x_hs', data = {x:time, y: ace_x}
store_data, 'ace_sp_y_hs', data = {x:time, y: ace_y}
store_data, 'ace_sp_z_hs', data = {x:time, y: ace_z}
store_data, 'ace_sp_d_hs', data = {x:time, y: ace_d}
END

            
