;+
;NAME:  cdf_var_atts
;FUNCTION:   cdf_var_atts(id [,varname[,attname]])
;PURPOSE:
;  Returns a structure that contains the attributes of a variable within
;  a CDF file. If attname is provided then it returns the value of that attribute.
;KEYWORDS:
;  DEFAULT: The default value of the attribute.
;  
;INPUT:
;	id:	CDF file ID or filename.
;CREATED BY:	Davin Larson
;LAST MODIFIED:	@(#)cdf_var_atts.pro	1.2 02/11/01
;-

function  cdf_var_atts,id0,var,attname,default=default,zvar=zvar,names_only=names_only  ;,attributes=att
if size(/type,id0) eq 7 then id=cdf_open(id0) else id=id0
if n_elements(default) eq 0 then default=0
attstr = default
inq = cdf_inquire(id)
if inq.natts eq 0 then goto,done

if keyword_set(attname) then begin
  if cdf_attexists(id,attname,var,zvar=zvar) then cdf_attget,id,attname,var,zvar=zvar,attstr
  goto,done
endif

cdf_control,id,get_numattrs=na   ; ,get_filename=fn
;print,fn
;print,na
;printdat,inq

cdf_control,id,att=0,get_attr_info=ai
att0 = {num:0, name:'',scope:'',maxr:0, maxz:0}
att0 = create_struct(att0,ai)
att = replicate(att0,inq.natts)

for a=0,inq.natts-1 do begin
  cdf_control,id,att=a,get_attr_info=ai
  cdf_attinq,id,a,name,scope,maxrent,maxzent
;  scp = strmid(scope,0,1)
  att0.num = a
  att0.name = name
  att0.scope= strmid(scope,0,1)
  att0.maxr = maxrent
  att0.maxz = maxzent
  struct_assign,ai,att0,/nozero
  att[a] = att0
endfor

if keyword_set(var) then begin
vinq = cdf_varinq(id,var,zvar=zvar)
w = where(att.scope eq 'V',nva)
if nva ne 0 then begin
   vatt=att[w]
   for a=0,nva-1 do begin
      if cdf_attexists(id,vatt[a].num,var) eq 0 then continue
      if keyword_set(names_only) then begin
          if keyword_set(attstr) then attstr=[attstr,vatt[a].name] $
          else attstr=vatt[a].name
      endif else begin
          cdf_attget,id,vatt[a].name,var,value
          if size(/type,value) eq 7 then if  strpos(value,'>$<') ge 1 then $
              value = strsplit(/extract,value,'>$<')
          
          str_element,/add,attstr,vatt[a].name,value
;                   if keyword_set(attstr) then $
;                  attstr = create_struct(attstr,vatt[a].name,value)  $
;                  else attstr = create_struct(vatt[a].name,value)
      endelse
   endfor
endif

endif else begin ;global
w = where(att.scope eq 'G',nga)
if nga ne 0 then begin
   vatt=att[w]
   gentry = 0
;   attstr = {filename:fn}
   for a=0,nga-1 do begin
      if cdf_attexists(id,vatt[a].num,gentry) eq 0 then continue
      if keyword_set(names_only) then begin
          if keyword_set(attstr) then attstr=[attstr,vatt[a].name] else attstr=vatt[w].name
      endif else begin
         cdf_attget,id,vatt[a].name,gentry,value
         if keyword_set(attstr) then $
            attstr = create_struct(attstr,vatt[a].name,value)  $
         else attstr = create_struct(vatt[a].name,value)
      endelse
   endfor
endif


endelse

done:
if size(/type,id0) eq 7 then cdf_close,id
return,attstr
end


