;+
;PROCEDURE: set_plot_attributes_mon_no_eng
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	3 July, 2007:  calls variables from share1_com and com_mon
;-
PRO set_plot_attributes_mon_no_eng, prod_mon, E_step, HZ, sat

COMMON tplot_com1
COMMON share1_mon
COMMON com_mon

q = ' '
IF (HZ EQ 0) THEN q = ' Counts/Accumulation Cycle'
IF (HZ EQ 1) THEN q = ' Counts/Second'

prefix_a = 'A_Monitor_Rate_'
prefix_b = 'B_Monitor_Rate_'
k = ' '
fm = ' '


IF (sat EQ 'A') THEN fm = 'A_'
IF (sat EQ 'B') THEN fm = 'B_'

FOR jj=0,n_elements(E_step)-1 DO BEGIN
	CASE E_step(jj) OF
		0: k = '_0'
		1: k = '_1'
		2: k = '_2'
		3: k = '_3'
		4: k = '_4'
		5: k = '_5'
		6: k = '_6'
		7: k = '_7'
		8: k = '_8'
		9: k = '_9'
		10: k = '_10'
		11: k = '_11'
		12: k = '_12'
		13: k = '_13'
		14: k = '_14'
		15: k = '_15'
		16: k = '_16'
		17: k = '_17'
		18: k = '_18'
		19: k = '_19'
		20: k = '_20'
		21: k = '_21'
		22: k = '_22'
		23: k = '_23'
		24: k = '_24'
		25: k = '_25'
		26: k = '_26'
		27: k = '_27'
		28: k = '_28'
		29: k = '_29'
		30: k = '_30'
		31: k = '_31'
		32: k = '_32'
	ENDCASE



FOR ii = 0, n_elements(prod_mon)-1 DO BEGIN 
	    IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b
	    temp_prod = prod_mon[ii]


CASE temp_prod OF
's_valid': BEGIN
	store_data, fm+'s_valid'+k,data=[prefix+'s_valid_sci'+k]
	options, fm+'s_valid'+k, 'ytitle', sat+' S_VALID'+k
	END

's_e_not_req': BEGIN
	store_data, fm+'s_e_not_req'+k,data=[prefix+'s_e_not_req_sci'+k]
	options, fm+'s_e_not_req'+k, 'ytitle', sat+' S_E_NOT_REQ'+k
	END

's_e_req': BEGIN
	store_data, fm+'s_e_req'+k,data=[prefix+'s_e_req_sci'+k]
	options, fm+'s_e_req'+k, 'ytitle', sat+' S_E_REQ'+k
	END

's_no_pos': BEGIN
	store_data, fm+'s_no_pos'+k,data=[prefix+'s_no_pos_sci'+k]
	options, fm+'s_no_pos'+k, 'ytitle', sat+' S_NO_POS'+k
	END

's_mult_pos': BEGIN
	store_data, fm+'s_mult_pos'+k,data=[prefix+'s_mult_pos_sci'+k]
	options, fm+'s_mult_pos'+k, 'ytitle', sat+' S_MULT_POS'+k
	END

's_no_e': BEGIN
	store_data, fm+'s_no_e'+k,data=[prefix+'s_no_e_sci'+k]
	options, fm+'s_no_e'+k, 'ytitle', sat+' S_NO_E'+k
	END

's_mult_e': BEGIN
	store_data, fm+'s_mult_e'+k,data=[prefix+'s_mult_e_sci'+k]
	options, fm+'s_mult_e'+k, 'ytitle', sat+' S_MULT_E'+k
	END

'ra_sat_a': BEGIN
	store_data, fm+'ra_sat_a'+k,data=[prefix+'ra_sat_a_sci'+k]
	options, fm+'ra_sat_a'+k, 'ytitle', sat+' RA_SAT_A'+k
	END

'ra_sat_b': BEGIN
	store_data, fm+'ra_sat_b'+k,data=[prefix+'ra_sat_b_sci'+k]
	options, fm+'ra_sat_b'+k, 'ytitle', sat+' RA_SAT_B'+k
	END

'ra_sat_both': BEGIN
	store_data, fm+'ra_sat_both'+k,data=[prefix+'ra_sat_both_sci'+k]
	options, fm+'ra_sat_both'+k, 'ytitle', sat+' RA_SAT_BOTH'+k
	END

'ssd_sw': BEGIN
	store_data, fm+'ssd_sw'+k,data=[prefix+'ssd_sw_sci'+k]
	options, fm+'ssd_sw'+k, 'ytitle', sat+' SSD_SW'+k
	END

'ssd_st': BEGIN
	store_data, fm+'ssd_st'+k,data=[prefix+'ssd_st_sci'+k]
	options, fm+'ssd_st'+k, 'ytitle', sat+' SSD_ST'+k
	END

'sf0': BEGIN
	store_data, fm+'sf0'+k,data=[prefix+'sf0_sci'+k]
	options, fm+'sf0'+k, 'ytitle', sat+' SF0'+k
	END

'sfr0': BEGIN
	store_data, fm+'sfr0'+k,data=[prefix+'sfr0_sci'+k]
	options, fm+'sfr0'+k, 'ytitle', sat+' SFR0'+k
	END

'stp0': BEGIN
	store_data, fm+'stp0'+k,data=[prefix+'stp0_sci'+k]
	options, fm+'stp0'+k, 'ytitle', sat+' STP0'+k
	END

'ra_trig': BEGIN
	store_data, fm+'ra_trig'+k,data=[prefix+'ra_trig_sci'+k]
	options, fm+'ra_trig'+k, 'ytitle', sat+' RA_TRIG'+k
	END

'pos1_0': BEGIN
	store_data, fm+'pos1_0'+k,data=[prefix+'pos1_0_sci'+k]
	options, fm+'pos1_0'+k, 'ytitle', sat+' POS1_0'+k
	END

'pos1_1': BEGIN
	store_data, fm+'pos1_1'+k,data=[prefix+'pos1_1_sci'+k]
	options, fm+'pos1_1'+k, 'ytitle', sat+' POS1_1'+k
	END

'w_no_pos':  BEGIN
	store_data, fm+'w_no_pos'+k,data=[prefix+'w_no_pos_sci'+k]
	options, fm+'w_no_pos'+k, 'ytitle', sat+' W_NO_POS'+k
	END

'w_mult_pos': BEGIN
	store_data, fm+'w_mult_pos'+k,data=[prefix+'w_mult_pos_sci'+k]
	options, fm+'w_mult_pos'+k, 'ytitle', sat+' W_MULT_POS'+k
	END

'w_valid': BEGIN
	store_data, fm+'w_valid'+k,data=[prefix+'w_valid_sci'+k]
	options, fm+'w_valid'+k, 'ytitle', sat+' W_VALID'+k
	END

'sf2': BEGIN
	store_data, fm+'sf2'+k,data=[prefix+'sf2_sci'+k]
	options, fm+'sf2'+k, 'ytitle', sat+' SF2'+k
	END

'sfr2': BEGIN
	store_data, fm+'sfr2'+k,data=[prefix+'sfr2_sci'+k]
	options, fm+'sfr2'+k, 'ytitle', sat+' SFR2'+k
	END

'stp2': BEGIN
	store_data, fm+'stp2'+k,data=[prefix+'stp2_sci'+k]
	options, fm+'stp2'+k, 'ytitle', sat+' STP2'+k
	END

'pos2_0': BEGIN
	store_data, fm+'pos2_0'+k,data=[prefix+'pos2_0_sci'+k]
	options, fm+'pos2_0'+k, 'ytitle', sat+' POS2_0'+k
	END

'pos2_1': BEGIN
	store_data, fm+'pos2_1'+k,data=[prefix+'pos2_1_sci'+k]
	options, fm+'pos2_1'+k, 'ytitle', sat+' POS2_1'+k
	END

'pos2_2': BEGIN
	store_data, fm+'pos2_2'+k,data=[prefix+'pos2_2_sci'+k]
	options, fm+'pos2_2'+k, 'ytitle', sat+' POS2_2'+k
	END

'pos2_3': BEGIN
	store_data, fm+'pos2_3'+k,data=[prefix+'pos2_3_sci'+k]
	options, fm+'pos2_3'+k, 'ytitle', sat+' POS2_3'+k
	END

'pos3_0': BEGIN
	store_data, fm+'pos3_0'+k,data=[prefix+'pos3_0_sci'+k]
	options, fm+'pos3_0'+k, 'ytitle', sat+' POS3_0'+k
	END

'pos3_1': BEGIN
	store_data, fm+'pos3_1'+k,data=[prefix+'pos3_1_sci'+k]
	options, fm+'pos3_1'+k, 'ytitle', sat+' POS3_1'+k
	END

'pos3_2': BEGIN
	store_data, fm+'pos3_2'+k,data=[prefix+'pos3_2_sci'+k]
	options, fm+'pos3_2'+k, 'ytitle', sat+' POS3_2'+k
	END

'pos3_3': BEGIN
	store_data, fm+'pos3_3'+k,data=[prefix+'pos3_3_sci'+k]
	options, fm+'pos3_3'+k, 'ytitle', sat+' POS3_3'+k
	END
'pos1': BEGIN
	store_data, fm+'pos1'+k,data=[prefix+'pos1_sci'+k]
	options, fm+'pos1'+k, 'ytitle',sat+' POS1'+k
	END
'pos2': BEGIN
	store_data, fm+'pos2'+k,data=[prefix+'pos2_sci'+k]
	options, fm+'pos2'+k, 'ytitle',sat+' POS2'+k
	END
'pos3': BEGIN
	store_data, fm+'pos3'+k,data=[prefix+'pos3_sci'+k]
	options, fm+'pos3'+k, 'ytitle',sat+' POS3'+k
	END
'stop0': BEGIN
	store_data, fm+'stop0'+k,data=[prefix+'stop0_sci'+k]
	options, fm+'stop0'+k, 'ytitle', sat+' SFR0/SF0'+k
	END

'start0': BEGIN
	store_data, fm+'start0'+k,data=[prefix+'start0_sci'+k]
	options, fm+'start0'+k, 'ytitle', sat+' SFR0/STP0'+k
	END


'stop2': BEGIN
	store_data, fm+'stop2'+k,data=[prefix+'stop2_sci'+k]
	options, fm+'stop2'+k, 'ytitle', sat+' SFR2/SF2'+k
	END

'start2': BEGIN
	store_data, fm+'start2'+k,data=[prefix+'start2_sci'+k]
	options, fm+'start2'+k, 'ytitle', sat+' SFR2/STP2'+k
	END

'sf0ra_trig':  BEGIN
	store_data, fm+'sf0ra_trig'+k,data=[prefix+'sf0ra_trig_sci'+k]
	options, fm+'sf0ra_trig'+k, 'ytitle', sat+' SF0/RA_TRIG'+k
	END
ENDCASE

ENDFOR

ENDFOR

IF (sat EQ 'A') THEN BEGIN
	store_data, 'A_error5_mon',data=[prefix_a+'error5_mon']
		options, 'A_error5_mon', 'ytitle', 'A error5_mon'
		options, 'A_error5_mon','title','A:  POSSIBLE ERRORS'
		ylim, 'A_error5_mon', 0.9, 1.1, 0

ENDIF ELSE BEGIN
	store_data, 'B_error5_mon',data=[prefix_b+'error5_mon']
		options, 'B_error5_mon', 'ytitle', 'B error5_mon'
		options, 'B_error5_mon', 'title', 'B:  POSSIBLE ERRORS'
		ylim, 'B_error5_mon', 0.9, 1.1, 0

ENDELSE

END 
