;+
;PROCEDURE: set_plot_attributes_mon
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 10/13/2006
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	03/07/2007: Energy step '32', that corresponds to the full energy range, is added
;-
PRO set_plot_attributes_mon, prod_mon, E_step, HZ, sat

COMMON tplot_com1
COMMON share1_mon
COMMON com_mon

q = ' '
IF (HZ EQ 0) THEN q = ' Counts/Accumulation Cycle'
IF (HZ EQ 1) THEN q = ' Counts/Second'

prefix_a = 'A_Monitor_Rate_'
prefix_b = 'B_Monitor_Rate_'
k = ' '
fm = ' '


IF (sat EQ 'A') THEN fm = 'A_'
IF (sat EQ 'B') THEN fm = 'B_'

FOR jj=0,n_elements(E_step)-1 DO BEGIN
	CASE E_step(jj) OF
		0: k = '_0'
		1: k = '_1'
		2: k = '_2'
		3: k = '_3'
		4: k = '_4'
		5: k = '_5'
		6: k = '_6'
		7: k = '_7'
		8: k = '_8'
		9: k = '_9'
		10: k = '_10'
		11: k = '_11'
		12: k = '_12'
		13: k = '_13'
		14: k = '_14'
		15: k = '_15'
		16: k = '_16'
		17: k = '_17'
		18: k = '_18'
		19: k = '_19'
		20: k = '_20'
		21: k = '_21'
		22: k = '_22'
		23: k = '_23'
		24: k = '_24'
		25: k = '_25'
		26: k = '_26'
		27: k = '_27'
		28: k = '_28'
		29: k = '_29'
		30: k = '_30'
		31: k = '_31'
		32: k = '_32'
	ENDCASE



FOR ii = 0, n_elements(prod_mon)-1 DO BEGIN 
	    IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b
	    temp_prod = prod_mon[ii]


CASE temp_prod OF
's_valid': BEGIN
	store_data, fm+'s_valid'+k,data=[prefix+'s_valid_sci'+k,prefix+'s_valid_eng'+k]
	options, prefix+'s_valid_eng'+k,'color', 150 ;green
	options, fm+'s_valid'+k, 'ytitle', fm+'s_valid'+k
	END

's_e_not_req': BEGIN
	store_data, fm+'s_e_not_req'+k,data=[prefix+'s_e_not_req_sci'+k, prefix+'s_e_not_req_eng'+k]
	options, prefix+'s_e_not_req_eng'+k,'color', 150 ;green
	options, fm+'s_e_not_req'+k, 'ytitle', fm+'s_e_not_req'+k
	END

's_e_req': BEGIN
	store_data, fm+'s_e_req'+k,data=[prefix+'s_e_req_sci'+k, prefix+'s_e_req_eng'+k]
	options, prefix+'s_e_req_eng'+k,'color', 150 ;green
	options, fm+'s_e_req'+k, 'ytitle', fm+'s_e_req'+k
	END

's_no_pos': BEGIN
	store_data, fm+'s_no_pos'+k,data=[prefix+'s_no_pos_sci'+k, prefix+'s_no_pos_eng'+k]
	options, prefix+'s_no_pos_eng'+k,'color', 150 ;green
	options, fm+'s_no_pos'+k, 'ytitle', fm+'s_no_pos'+k
	END

's_mult_pos': BEGIN
	store_data, fm+'s_mult_pos'+k,data=[prefix+'s_mult_pos_sci'+k, prefix+'s_mult_pos_eng'+k]
	options, prefix+'s_mult_pos_eng'+k,'color', 150 ;green
	options, fm+'s_mult_pos'+k, 'ytitle', fm+'s_mult_pos'+k
	END

's_no_e': BEGIN
	store_data, fm+'s_no_e'+k,data=[prefix+'s_no_e_sci'+k,prefix+'s_no_e_eng'+k]
	options, prefix+'s_no_e_eng'+k,'color', 150 ;green
	options, fm+'s_no_e'+k, 'ytitle', fm+'s_no_e'+k
	END

's_mult_e': BEGIN
	store_data, fm+'s_mult_e'+k,data=[prefix+'s_mult_e_sci'+k, prefix+'s_mult_e_eng'+k]
	options, prefix+'s_mult_e_eng'+k,'color', 150 ;green
	options, fm+'s_mult_e'+k, 'ytitle', fm+'s_mult_e'+k
	END

'ra_sat_a': BEGIN
	store_data, fm+'ra_sat_a'+k,data=[prefix+'ra_sat_a_sci'+k, prefix+'ra_sat_a_eng'+k]
	options, prefix+'ra_sat_a_eng'+k,'color', 150 ;green
	options, fm+'ra_sat_a'+k, 'ytitle', fm+'ra_sat_a'+k
	END

'ra_sat_b': BEGIN
	store_data, fm+'ra_sat_b'+k,data=[prefix+'ra_sat_b_sci'+k, prefix+'ra_sat_b_eng'+k]
	options, prefix+'ra_sat_b_eng'+k,'color', 150 ;green
	options, fm+'ra_sat_b'+k, 'ytitle', fm+'ra_sat_b'+k
	END

'ra_sat_both': BEGIN
	store_data, fm+'ra_sat_both'+k,data=[prefix+'ra_sat_both_sci'+k, prefix+'ra_sat_both_eng'+k]
	options, prefix+'ra_sat_both_eng'+k,'color', 150 ;green
	options, fm+'ra_sat_both'+k, 'ytitle', fm+'ra_sat_both'+k
	END

'ssd_sw': BEGIN
	store_data, fm+'ssd_sw'+k,data=[prefix+'ssd_sw_sci'+k, prefix+'ssd_sw_eng'+k]
	options, prefix+'ssd_sw_eng'+k,'color', 150 ;green
	options, fm+'ssd_sw'+k, 'ytitle', fm+'ssd_sw'+k
	END

'ssd_st': BEGIN
	store_data, fm+'ssd_st'+k,data=[prefix+'ssd_st_sci'+k, prefix+'ssd_st_eng'+k]
	options, prefix+'ssd_st_eng'+k,'color', 150 ;green
	options, fm+'ssd_st'+k, 'ytitle', fm+'ssd_st'+k
	END

'sf0': BEGIN
	store_data, fm+'sf0'+k,data=[prefix+'sf0_sci'+k, prefix+'sf0_eng'+k]
	options, prefix+'sf0_eng'+k,'color', 150 ;green
	options, fm+'sf0'+k, 'ytitle', fm+'sf0'+k
	END

'sfr0': BEGIN
	store_data, fm+'sfr0'+k,data=[prefix+'sfr0_sci'+k, prefix+'sfr0_eng'+k]
	options, prefix+'sfr0_eng'+k,'color', 150 ;green
	options, fm+'sfr0'+k, 'ytitle', fm+'sfr0'+k
	END

'stp0': BEGIN
	store_data, fm+'stp0'+k,data=[prefix+'stp0_sci'+k, prefix+'stp0_eng'+k]
	options, prefix+'stp0_eng'+k,'color', 150 ;green
	options, fm+'stp0'+k, 'ytitle', fm+'stp0'+k
	END

'ra_trig': BEGIN
	store_data, fm+'ra_trig'+k,data=[prefix+'ra_trig_sci'+k, prefix+'ra_trig_eng'+k]
	options, prefix+'ra_trig_eng'+k,'color', 150 ;green
	options, fm+'ra_trig'+k, 'ytitle', fm+'ra_trig'+k
	END

'pos1_0': BEGIN
	store_data, fm+'pos1_0'+k,data=[prefix+'pos1_0_sci'+k, prefix+'pos1_0_eng'+k]
	options, prefix+'pos1_0_eng'+k,'color', 150 ;green
	options, fm+'pos1_0'+k, 'ytitle', fm+'pos1_0'+k
	END

'pos1_1': BEGIN
	store_data, fm+'pos1_1'+k,data=[prefix+'pos1_1_sci'+k, prefix+'pos1_1_eng'+k]
	options, prefix+'pos1_1_eng'+k,'color', 150 ;green
	options, fm+'pos1_1'+k, 'ytitle', fm+'pos1_1'+k
	END

'w_no_pos':  BEGIN
	store_data, fm+'w_no_pos'+k,data=[prefix+'w_no_pos_sci'+k, prefix+'w_no_pos_eng'+k]
	options, prefix+'w_no_pos_eng'+k,'color', 150 ;green
	options, fm+'w_no_pos'+k, 'ytitle', fm+'w_no_pos'+k
	END

'w_mult_pos': BEGIN
	store_data, fm+'w_mult_pos'+k,data=[prefix+'w_mult_pos_sci'+k, prefix+'w_mult_pos_eng'+k]
	options, prefix+'w_mult_pos_eng'+k,'color', 150 ;green
	options, fm+'w_mult_pos'+k, 'ytitle', fm+'w_mult_pos'+k
	END

'w_valid': BEGIN
	store_data, fm+'w_valid'+k,data=[prefix+'w_valid_sci'+k, prefix+'w_valid_eng'+k]
	options, prefix+'w_valid_eng'+k,'color', 150 ;green
	options, fm+'w_valid'+k, 'ytitle', fm+'w_valid'+k
	END

'sf2': BEGIN
	store_data, fm+'sf2'+k,data=[prefix+'sf2_sci'+k, prefix+'sf2_eng'+k]
	options, prefix+'sf2_eng'+k,'color', 150 ;green
	options, fm+'sf2'+k, 'ytitle', fm+'sf2'+k
	END

'sfr2': BEGIN
	store_data, fm+'sfr2'+k,data=[prefix+'sfr2_sci'+k, prefix+'sfr2_eng'+k]
	options, prefix+'sfr2_eng'+k,'color', 150 ;green
	options, fm+'sfr2'+k, 'ytitle', fm+'sfr2'+k
	END

'stp2': BEGIN
	store_data, fm+'stp2'+k,data=[prefix+'stp2_sci'+k,prefix+'stp2_eng'+k]
	options, prefix+'stp2_eng'+k,'color', 150 ;green
	options, fm+'stp2'+k, 'ytitle', fm+'stp2'+k
	END

'pos2_0': BEGIN
	store_data, fm+'pos2_0'+k,data=[prefix+'pos2_0_sci'+k, prefix+'pos2_0_eng'+k]
	options, prefix+'pos2_0_eng'+k,'color', 150 ;green
	options, fm+'pos2_0'+k, 'ytitle', fm+'pos2_0'+k
	END

'pos2_1': BEGIN
	store_data, fm+'pos2_1'+k,data=[prefix+'pos2_1_sci'+k, prefix+'pos2_1_eng'+k]
	options, prefix+'pos2_1_eng'+k,'color', 150 ;green
	options, fm+'pos2_1'+k, 'ytitle', fm+'pos2_1'+k
	END

'pos2_2': BEGIN
	store_data, fm+'pos2_2'+k,data=[prefix+'pos2_2_sci'+k, prefix+'pos2_2_eng'+k]
	options, prefix+'pos2_2_eng'+k,'color', 150 ;green
	options, fm+'pos2_2'+k, 'ytitle', fm+'pos2_2'+k
	END

'pos2_3': BEGIN
	store_data, fm+'pos2_3'+k,data=[prefix+'pos2_3_sci'+k, prefix+'pos2_3_eng'+k]
	options, prefix+'pos2_3_eng'+k,'color', 150 ;green
	options, fm+'pos2_3'+k, 'ytitle', fm+'pos2_3'+k
	END

'pos3_0': BEGIN
	store_data, fm+'pos3_0'+k,data=[prefix+'pos3_0_sci'+k, prefix+'pos3_0_eng'+k]
	options, prefix+'pos3_0_eng'+k,'color', 150 ;green
	options, fm+'pos3_0'+k, 'ytitle', fm+'pos3_0'+k
	END

'pos3_1': BEGIN
	store_data, fm+'pos3_1'+k,data=[prefix+'pos3_1_sci'+k, prefix+'pos3_1_eng'+k]
	options, prefix+'pos3_1_eng'+k,'color', 150 ;green
	options, fm+'pos3_1'+k, 'ytitle', fm+'pos3_1'+k
	END

'pos3_2': BEGIN
	store_data, fm+'pos3_2'+k,data=[prefix+'pos3_2_sci'+k, prefix+'pos3_2_eng'+k]
	options, prefix+'pos3_2_eng'+k,'color', 150 ;green
	options, fm+'pos3_2'+k, 'ytitle', fm+'pos3_2'+k
	END

'pos3_3': BEGIN
	store_data, fm+'pos3_3'+k,data=[prefix+'pos3_3_sci'+k, prefix+'pos3_3_eng'+k]
	options, prefix+'pos3_3_eng'+k,'color', 150 ;green
	options, fm+'pos3_3'+k, 'ytitle', fm+'pos3_3'+k
	END
'pos1': BEGIN
	store_data, fm+'pos1'+k,data=[prefix+'pos1_sci'+k, prefix+'pos1_eng'+k]
	options, prefix+'pos1_eng'+k,'color',150 ;green
	options, fm+'pos1'+k, 'ytitle',sat+' POS1'+k
	END

'pos2': BEGIN
	store_data, fm+'pos2'+k,data=[prefix+'pos2_sci'+k, prefix+'pos2_eng'+k]
	options, prefix+'pos2_eng'+k,'color',150 ;green
	options, fm+'pos2'+k, 'ytitle',sat+' POS2'+k
	END
'pos3': BEGIN
	store_data, fm+'pos3'+k,data=[prefix+'pos3_sci'+k, prefix+'pos3_eng'+k]
	options,prefix+'pos3_eng'+k,'color',150 ;green
	options, fm+'pos3'+k, 'ytitle',sat+' POS3'+k
	END


'stop0': BEGIN
	store_data, fm+'stop0'+k,data=[prefix+'stop0_sci'+k, prefix+'stop0_eng'+k]
	options, prefix+'stop0_eng'+k,'color', 150 ;green
	options, fm+'stop0'+k, 'ytitle', fm+'SFR0/SF0'+k
	END

'start0': BEGIN
	store_data, fm+'start0'+k,data=[prefix+'start0_sci'+k, prefix+'start0_eng'+k]
	options, prefix+'start0_eng'+k,'color', 150 ;green
	options, fm+'start0'+k, 'ytitle', fm+'SFR0/STP0'+k
	END

'stop2': BEGIN
	store_data, fm+'stop2'+k,data=[prefix+'stop2_sci'+k, prefix+'stop2_eng'+k]
	options, prefix+'stop2_eng'+k,'color', 150 ;green
	options, fm+'stop2'+k, 'ytitle', fm+'SFR2/SF2'+k
	END

'start2': BEGIN
	store_data, fm+'start2'+k,data=[prefix+'start2_sci'+k,prefix+'start2_eng'+k]
	options, prefix+'start2_eng'+k,'color', 150 ;green
	options, fm+'start2'+k, 'ytitle', fm+'SFR2/STP2'+k
	END
'sf0ra_trig': BEGIN
	store_data, fm+'sf0ra_trig'+k,data=[prefix+'sf0ra_trig_sci'+k,prefix+'sf0ra_trig_eng'+k]
	options, prefix+'sf0ra_trig_eng'+k,'color', 150 ;green
	options, fm+'sf0ra_trig'+k, 'ytitle', fm+'SF0/RA_TRIG'+k
	END
ENDCASE

ENDFOR

ENDFOR

IF (sat EQ 'A') THEN BEGIN
	store_data, 'A_error5_mon',data=[prefix_a+'error5_mon']
		options, 'A_error5_mon', 'ytitle', 'A_error5_mon'
		ylim, 'A_error5_mon', 0.9, 1.1, 0

	store_data, 'A_error1',data=[prefix_a+'error1']
		options,'A_error1','title', 'AHEAD: POSSIBLE ERRORS'
		options, 'A_error1', 'ytitle', 'A_error1'
		ylim, 'A_error1', 0.9, 1.1, 0

ENDIF ELSE BEGIN
	store_data, 'B_error5_mon',data=[prefix_b+'error5_mon']
		options, 'B_error5_mon', 'ytitle', 'B_error5_mon'
		ylim, 'B_error5_mon', 0.9, 1.1, 0

	store_data, 'B_error1',data=[prefix_b+'error1']
		options,'B_error1','title','BEHIND: POSSIBLE ERRORS '
		options, 'B_error1', 'ytitle', 'B_error1'
		ylim, 'B_error1', 0.9, 1.1, 0
ENDELSE

END 
