;+
;PROCEDURE: set_plot_attributes_hk
;PURPOSE: Set the plot attributes for different products
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 01/18/2007
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;	November 2006	K. Simunac modifies for analog housekeeping
;	18 Jan, 2007	prefixes added for sat A and sat B, labels updated
;-
PRO set_plot_attributes_hk, sat, prod_hk, inst_coord
CASE inst_coord OF
    1: inst_string = 'INST_COORD'
ENDCASE 

FOR ii = 0, n_elements(prod_hk)-1 DO BEGIN 
    CASE prod_hk[ii] OF

	'lrnm_spare': BEGIN
	   yt = 'lrnm_spare'
	   name = 'Analog_HK_lrnm_spare'
	   ylim, name, -1, 1, 0
	END
	'lvc_-12v': BEGIN
	   yt = 'lvc_-12v'
	   name = 'Analog_HK_lvc_-12v'
	   ylim, name, -15, -10, 0
	END
	'lvc_-5v': BEGIN
	   yt = 'lvc_-5v'
	   name = 'Analog_HK_lvc_-5v'
	   ylim, name, -8, 0, 0
	END
	'esa_vm_pos':BEGIN
	   yt = 'esa_vm_pos'
	   name = 'Analog_HK_esa_vm_pos'
	   ylim, name, 0, 60, 0
	END
	'dfl_1_vm': BEGIN
	   yt = 'dfl_1_vm'
	   name = 'Analog_HK_dfl_1_vm'
	   ylim, name, 0, 30, 0
	END
	'dfl_1_tap': BEGIN
	   yt = ' dfl_1_tap'
	   name = 'Analog_HK_dfl_1_tap'
	   ylim, name, 0, 30, 0
	END
	'dfl_2_vm':  BEGIN
	   yt = 'dfl_2_vm'
	   name = 'Analog_HK_dfl_2_vm'
	   ylim, name, 0, 30, 0
	END
	'dfl_2_tap':  BEGIN
	   yt = 'dfl_2_tap'
	   name = 'Analog_HK_dfl_2_tap'
	   ylim, name, 0, 30, 0
	END
	'lvc_+2.5v_b':  BEGIN
	   yt = 'lvc_+2.5v_b'
	   name = 'Analog_HK_lvc_+2.5v_b'
	   ylim, name, 0, 3, 0
	END
	'pac_cm_dc':  BEGIN
	   yt = 'pac_cm_dc'
	   name = 'Analog_HK_pac_cm_dc'
	END
	'lvc_+12v':  BEGIN
	   yt = 'lvc_+12v'
	   name = 'Analog_HK_lvc_+12v'
	   ylim, name, 10, 15, 0
	END
	'lrpm_spare':  BEGIN
	   yt = 'lrpm_spare'
	   name = 'Analog_HK_lrpm_spare'
	   ylim, name, -1, 1, 0
	END
	'lvc_+2.5v_a':  BEGIN
	   yt = 'lvc_+2.5v_a'
	   name = 'Analog_HK_lvc_+2.5v_a'
	   ylim, name, 0, 3, 0
	END
	'lvc_+5v':  BEGIN
	   yt = 'lvc_+5v'
	   name = 'Analog_HK_lvc_+5v'
	   ylim, name, 0, 8, 0
	END
	'adc_avdd':  BEGIN
	   yt = 'adc_avdd'
	   name = 'Analog_HK_adc_avdd'
	END
	'adc_dvdd':  BEGIN
	   yt = 'adc_dvdd'
	   name = 'Analog_HK_adc_dvdd'
	END
	'pac_vm':  BEGIN
	   yt = 'pac_vm'
	   name = 'Analog_HK_pac_vm'
	END
	'cal_vref':  BEGIN
	   yt = 'cal_vref'
	   name = 'Analog_HK_cal_vref'
	   ylim, name, 0, 6, 0
	END
	'pac_cm_ac':  BEGIN
	   yt = 'pac_cm_ac'
	   name = 'Analog_HK_pac_cm_ac'
	END
	'mcp_vm':  BEGIN
	   yt = 'mcp_vm'
	   name = 'Analog_HK_mcp_vm'
	END
	'mcp_cm_dc':  BEGIN
	   yt = 'mcp_cm_dc'
	   name = 'Analog_HK_mcp_cm_dc'
	END
	'mcp_cm_ac':  BEGIN
	   yt = 'mcp_cm_ac'
	   name = 'Analog_HK_mcp_cm_ac'
	END
	'ssd_cm_dc':  BEGIN
	   yt = 'ssd_cm_dc'
	   name = 'Analog_HK_ssd_cm_dc'
	END
	's_ch_vm':  BEGIN
	   yt = 's_ch_vm'
	   name = 'Analog_HK_s_ch_vm'
	END
	's_ch_vm_tap':  BEGIN
	   yt = 's_ch_vm_tap'
	   name = 'Analog_HK_s_ch_vm_tap'
	END
	's_ch_cm_dc':  BEGIN
	   yt = 's_ch_cm_dc'
	   name = 'Analog_HK_s_ch_cm_dc'
	END
	'esa_vm_neg':  BEGIN
	   yt = 'esa_vm_neg'
	   name = 'Analog_HK_esa_vm_neg'
	   ylim, name, -60, 0, 0
	END
	'esa_cm_dc':  BEGIN
	   yt = 'esa_cm_dc'
	   name = 'Analog_HK_esa_cm_dc'
	END
	'dfl_1_cm_dc':  BEGIN
	   yt = 'dfl_1_cm_dc'
	   name = 'Analog_HK_dfl_1_cm_dc'
	END
	'dfl_2_cm_dc':  BEGIN
	   yt = 'dfl_2_cm_dc'
	   name = 'Analog_HK_dfl_2_cm_dc'
	END
	'lvc_+2.5v_b_imon':  BEGIN
	   yt = 'lvc_+2.5v_b_imon  [mA]'
	   name = 'Analog_HK_lvc_+2.5v_b_imon'
	   ylim, name, 0, 600, 0
	END
	'lvc_+12v_imon':  BEGIN
	   yt = 'lvc_+12v_imon  [mA]'
	   name = 'Analog_HK_lvc_+12v_imon'
	   ylim, name, 0, 600, 0
	END
	'lvc_-12v_imon':  BEGIN
	   yt = 'lvc_-12v_imon  [mA]'
	   name = 'Analog_HK_lvc_-12v_imon'
	   ylim, name, 0, 600, 0
	END
	'lvc_+5v_imon':  BEGIN
	   yt = 'lvc_+5v_imon  [mA]'
	   name = 'Analog_HK_lvc_+5v_imon'
	   ylim, name, 0, 600, 0
	END
	'lvc_-5v_imon':  BEGIN
	   yt = 'lvc_-5v_imon  [mA]'
	   name = 'Analog_HK_lvc_-5v_imon'
	   ylim, name, 0, 600, 0
	END
	'lvc_+2.5v_a_imon':  BEGIN
	   yt = 'lvc_+2.5v_a_imon  [mA]'
	   name = 'Analog_HK_lvc_+2.5v_a_imon'
	   ylim, name, 0, 600, 0
	END
	'ssd_vm':  BEGIN
	   yt = 'ssd_vm'
	   name = 'Analog_HK_ssd_vm'
	END
	'adc_lu_flag':  BEGIN
	   yt = 'adc_lu_flag'
	   name = 'Analog_HK_adc_lu_flag'
	   ylim, name, -1,1,0
	END
	'plug_id':  BEGIN
	   yt = 'plug_id'
	   name = 'Analog_HK_plug_id'
	   ylim, name, 0, 20, 0
	END
	'adc_lu_ctr':  BEGIN
	   yt = 'adc_lu_ctr'
	   name = 'Analog_HK_adc_lu_ctr'
	   ylim, name, -1,1,0
	END
	'dac_status':  BEGIN
	   yt = 'dac_status'
	   name = 'Analog_HK_dac_status'
	   ylim, name, -1,1,0
	END
	'adc0_agnd':  BEGIN
	   yt = 'adc0_agnd'
	   name = 'Analog_HK_adc0_agnd'
	   ylim, name, -1, 1, 0
	END
	'adc1_agnd':  BEGIN
	   yt = 'adc1_agnd'
	   name = 'Analog_HK_adc1_agnd'
	   ylim, name, -1, 1, 0
	END
	'ra_e0':  BEGIN
	   yt = 'ra_e0'
	   name = 'Analog_HK_ra_e0'
	END
	'ra_e1':  BEGIN
	   yt = 'ra_e1'
	   name = 'Analog_HK_ra_e1'
	END
	'tac0_tsp':  BEGIN
	   yt = 'tac0_tsp'
	   name = 'Analog_HK_tac0_tsp'
	   ylim, name, -20, 20, 0
	END
	'tac2_tsp':  BEGIN
	   yt = 'tac2_tsp'
	   name = 'Analog_HK_tac2_tsp'
	   ylim, name, -20, 20, 0
	END
	'sb0_tsp':  BEGIN
	   yt = 'sb0_tsp'
	   name = 'Analog_HK_sb0_tsp'
	   ylim, name, -1, 1, 0
	END
	'sb1_tsp':  BEGIN
	   yt = 'sb1_tsp'
	   name = 'Analog_HK_sb1_tsp'
	   ylim, name, -1, 1, 0
	END
	'tof_hv0_tsp':  BEGIN
	   yt = 'tof_hv0_tsp'
	   name = 'Analog_HK_tof_hv0_tsp'
	   ylim, name, -20, 20, 0
	END
	'tof_hv1_tsp':  BEGIN
	   yt = 'tof_hv1_tsp'
	   name = 'Analog_HK_tof_hv1_tsp'
	   ylim, name, -20, 20, 0
	END
	's_c_0_tsp':  BEGIN
	   yt = 's_c_0_tsp'
	   name = 'Analog_HK_s_c_0_tsp'
	   ylim, name, -20, 20, 0
	END
	's_c_1_tsp':  BEGIN
	   yt = 's_c_1_tsp'
	   name = 'Analog_HK_s_c_1_tsp'
	   ylim, name, -20, 20, 0
	END
	'lvc0_tsp':  BEGIN
	   yt = 'lvc0_tsp'
	   name = 'Analog_HK_lvc0_tsp'
	   ylim, name, -20, 20, 0
	END
	'lvc1_tsp':  BEGIN
	   yt = 'lvc1_tsp'
	   name = 'Analog_HK_lvc1_tsp'
	   ylim, name, -20, 20, 0
	END
	'adc0_vref':  BEGIN
	   yt = 'adc0_vref'
	   name = 'Analog_HK_adc0_vref'
	END
	'adc1_vref':  BEGIN
	   yt = 'adc1_vref'
	   name = 'Analog_HK_adc1_vref'
	END
	'ssd_status':  BEGIN
	   yt = 'ssd_status'
	   name = 'Analog_HK_ssd_status'
	   ylim, name, -1, 1, 0
	END
	'ssd_v_pos_analog':  BEGIN
	   yt = 'ssd_v_pos_analog'
	   name = 'Analog_HK_ssd_v_pos_analog'
	END
	'ssd_v_neg_analog':  BEGIN
	   yt = 'ssd_v_neg_analog'
	   name = 'Analog_HK_ssd_v_neg_analog'
	END
	'ssd_hv_bias':  BEGIN
	   yt = 'ssd_hv_bias'
	   name = 'Analog_HK_ssd_hv_bias'
	END
	'ssd_tc0':  BEGIN
	   yt = 'ssd_tc0'
	   name = 'Analog_HK_ssd_tc0'
	END
	'ssd_tc1':  BEGIN
	   yt = 'ssd_tc1'
	   name = 'Analog_HK_ssd_tc1'
	END
	'ssd_tc2':  BEGIN
	   yt = 'ssd_tc2'
	   name = 'Analog_HK_ssd_tc2'
	END
	'ssd_v_pos_dig':  BEGIN
	   yt = 'ssd_v_pos_dig'
	   name = 'Analog_HK_ssd_v_pos_dig'
	END


    ENDCASE
          
    options, name, 'ytitle', yt
          

ENDFOR 

END 
