;+
;PROCEDURE: set_plot_attributes
;PURPOSE: Set the plot attributes for different products
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 09/21/2006
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;-
PRO set_plot_attributes, sat, prod, inst_coord
CASE inst_coord OF
    1: inst_string = 'INST_COORD'
ENDCASE 
FOR ii = 0, n_elements(prod)-1 DO BEGIN 
    CASE prod[ii] OF
        'D': BEGIN 
            yt = 'SC' + sat + '!CH!U+!N!C n (cm!U-3!N)+!C'
            name = sat+'_mom_density'
            ;ylim, name,  1, 1E6, 1
        END
        'VX': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C Vx (km s!U-1!N)+!C'+inst_string
            name = sat+'_mom_velocity_inst_x'
            ;ylim, name, 0, 0, 1
        END
        'VY': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C Vy (km s!U-1!N)+!C'+inst_string
            name = sat+'_mom_velocity_inst_y'
            ;ylim, name, 0, 0, 1
        END
        'VZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C Vz (km s!U-1!N)+!C'+inst_string
            name = sat+'_mom_velocity_inst_z'
            ;ylim, name, 0, 0, 1
        END
        'VT': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C Vt (km s!U-1!N)+!C'+inst_string
            name = sat+'_mom_velocity_total'
            ;ylim, name, 0, 0, 1
            ylim,  name, log = 0
        END
        'VXYZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C V (km s!U-1!N)+!C'+inst_string
            name = 'OBMOM_SC'+sat+'_MTVX'
            ;ylim, name_x, 0, 0, 1
            name_y = 'OBMOM_SC'+sat+'_MTVY'
            ;ylim, name_y, 0, 0, 1
            name_z = 'OBMOM_SC'+sat+'_MTVZ'
            ;ylim, name_z, 0, 0, 1
        END
        'TXX': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C T (eV)'
            name = 'OBMOM_SC'+sat+'_MTTXX'
            ;ylim,    name,  0, 0, 1
        END
        'TXY': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C T (eV)'
            name = 'OBMOM_SC'+sat+'_MTTXY'
            ;ylim,    name,  0, 0, 1
        END
        'TXZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C T (eV)'
            name = 'OBMOM_SC'+sat+'_MTTXZ'
            ;ylim,    name,  0, 0, 1
        END
        'TYY': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C T (eV)'
            name = 'OBMOM_SC'+sat+'_MTTYY'
            ;ylim,    name,  0, 0, 1
        END
        'TYZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C T (eV)'
            name = 'OBMOM_SC'+sat+'_MTTYZ'
            ;ylim,    name,  0, 0, 1
        END
        'TZZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C T (eV)'
            name = 'OBMOM_SC'+sat+'_MTTZZ'
            ylim,    name,  0, 0, 1
        END
        'PXX': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C P (nPa)'
            name = 'OBMOM_SC'+sat+'_MTPXX'
            ;ylim,    name,  0, 0, 1
        END
        'PXY': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C P (nPa)'
            name = 'OBMOM_SC'+sat+'_MTPXY'
            ;ylim,    name,  0, 0, 1
        END
        'PXZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C P (nPa)'
            name = 'OBMOM_SC'+sat+'_MTPXZ'
            ;ylim,    name,  0, 0, 1
        END
        'PYY': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C P (nPa)'
            name = 'OBMOM_SC'+sat+'_MTPYY'
            ;ylim,    name,  0, 0, 1
        END
        'PYZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C P (nPa)'
            name = 'OBMOM_SC'+sat+'_MTPYZ'
            ;ylim,    name,  0, 0, 1
        END
        'PZZ': BEGIN
            yt = 'SC' + sat + '!CH!U+!N!C P (nPa)'
            name = 'OBMOM_SC'+sat+'_MTPZZ'
            ;ylim,    name,  0, 0, 1
        END
    ENDCASE
          
    options, name, 'ytitle', yt
          
ENDFOR 

END 
