;+
;PROCEDURE: plot_mon_full
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	November 2006:  K. Simunac modified for monitor rates
;	18 Jan, 2007:	plot attributes set in separate program
;			set_plot_attributes_mon.pro
;	19 Jan, 2007:	changed tplot names to include A or B
;	3 July, 2007:  calls com_mon and share1_mon variables
;-
PRO plot_mon_full, prod_mon_full, num_files_a, num_files_b, E_step, HZ, sat

;ThisDevice = !D.Name
;SET_PLOT,'PS'
;
;filename = getenv('OUT_DIR')+'full_monitor_rates.ps'
;DEVICE, FILENAME = filename, XSIZE=8.5, YSIZE =11.0, /INCHES, $
;/COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0

LOADCT, 39, NCOLORS=256

COMMON tplot_com1
COMMON share1_mon
COMMON com_mon

q = ' '
IF (HZ EQ 0) THEN q = ' (rates left as Counts/Accumulation Cycle)'
IF (HZ EQ 1) THEN q = ' (rates converted to Counts/Second)'

prefix_a = 'A_Monitor_Rate_Full_'
prefix_b = 'B_Monitor_Rate_Full_'
k = ' '
fm = ' '

IF (sat EQ 'A') THEN fm = 'A_'
IF (sat EQ 'B') THEN fm = 'B_'

tplot_options,'ymargin',[6,6]

FOR jj=0,n_elements(E_step)-1 DO BEGIN
	CASE E_step(jj) OF
		0: k = '_0'
		1: k = '_1'
		2: k = '_2'
		3: k = '_3'
		4: k = '_4'
		5: k = '_5'
		6: k = '_6'
		7: k = '_7'
		8: k = '_8'
		9: k = '_9'
		10: k = '_10'
		11: k = '_11'
		12: k = '_12'
		13: k = '_13'
		14: k = '_14'
		15: k = '_15'
		16: k = '_16'
		17: k = '_17'
		18: k = '_18'
		19: k = '_19'
		20: k = '_20'
		21: k = '_21'
		22: k = '_22'
		23: k = '_23'
		24: k = '_24'
		25: k = '_25'
		26: k = '_26'
		27: k = '_27'
		28: k = '_28'
		29: k = '_29'
		30: k = '_30'
		31: k = '_31'
		32: k = '_32'
		33: k = '_33'
		34: k = '_34'
		35: k = '_35'
		36: k = '_36'
		37: k = '_37'
		38: k = '_38'
		39: k = '_39'
		40: k = '_40'
		41: k = '_41'
		42: k = '_42'
		43: k = '_43'
		44: k = '_44'
		45: k = '_45'
		46: k = '_46'
		47: k = '_47'
		48: k = '_48'
		49: k = '_49'
		50: k = '_50'
		51: k = '_51'
		52: k = '_52'
		53: k = '_53'
		54: k = '_54'
		55: k = '_55'
		56: k = '_56'
		57: k = '_57'
		58: k = '_58'
		59: k = '_59'
		60: k = '_60'
		61: k = '_61'
		62: k = '_62'
		63: k = '_63'
		64: k = '_64'
		65: k = '_65'
		66: k = '_66'
		67: k = '_67'
		68: k = '_68'
		69: k = '_69'
		70: k = '_70'
		71: k = '_71'
		72: k = '_72'
		73: k = '_73'
		74: k = '_74'
		75: k = '_75'
		76: k = '_76'
		77: k = '_77'
		78: k = '_78'
		79: k = '_79'
		80: k = '_80'
		81: k = '_81'
		82: k = '_82'
		83: k = '_83'
		84: k = '_84'
		85: k = '_85'
		86: k = '_86'
		87: k = '_87'
		88: k = '_88'
		89: k = '_89'
		90: k = '_90'
		91: k = '_91'
		92: k = '_92'
		93: k = '_93'
		94: k = '_94'
		95: k = '_95'
		96: k = '_96'
		97: k = '_97'
		98: k = '_98'
		99: k = '_99'
		100: k = '_100'
		101: k = '_101'
		102: k = '_102'
		103: k = '_103'
		104: k = '_104'
		105: k = '_105'
		106: k = '_106'
		107: k = '_107'
		108: k = '_108'
		109: k = '_109'
		110: k = '_110'
		111: k = '_111'
		112: k = '_112'
		113: k = '_113'
		114: k = '_114'
		115: k = '_115'
		116: k = '_116'
		117: k = '_117'
		118: k = '_118'
		119: k = '_119'
		120: k = '_120'
		121: k = '_121'
		122: k = '_122'
		123: k = '_123'
		124: k = '_124'
		125: k = '_125'
		126: k = '_126'
		127: k = '_127'
	ENDCASE

	FOR ii = 0, n_elements(prod_mon_full)-1 DO BEGIN 
	    IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b
	    temp_prod = prod_mon_full[ii]
	    IF n_elements(names) EQ 0 THEN names = [fm+temp_prod+k] ELSE names = [names, fm+temp_prod+k]

	ENDFOR

ENDFOR

tplot_options, 'title', sat+':  FULL RESOLUTION'+q
;tplot_options,'yrange',[0.01,max(y)*10]
tplot, names

CASE sat OF
	'A': BEGIN
	tplot_options,'title',' '
	tplot_options, 'psym',2
	tplot_options, 'symsize',1.5
	IF (TOTAL(error1_full_a, /NAN) GT 0) THEN BEGIN
		WINDOW, /FREE
		tplot,['A_error1']
	ENDIF
	END

	'B': BEGIN
	tplot_options,'title',' '
	tplot_options, 'psym',2
	tplot_options,'symsize',1.5
	IF (TOTAL(error1_full_b, /NAN) GT 0) THEN BEGIN
		WINDOW, /FREE
		tplot,['B_error1']
	ENDIF
	END
ENDCASE
tplot_options, 'psym'
tplot_options, 'symsize'
tplot_options, 'title', ' '

;DEVICE,/Close_File
;SET_PLOT,ThisDevice

END 
