;+
;PROCEDURE: plot_mon
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 01/19/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	November 2006:  K. Simunac modified for monitor rates
;	18 Jan, 2007:	plot attributes set in a separate program
;			set_plot_attributes_mon.pro
;	19 Jan, 2007:	changed tplot names to include A or B
;       03/09/2007:     The input variable HZ is replased by the variable
;                       units.
;       04/02/2007:     The command 'WINDOW, /FREE' is used only when
;                       the 'X' device is used
;-
PRO plot_mon, prod_mon, num_files_a, num_files_b, E_step, HZ, sat, NO_ENG

;ThisDevice = !D.Name
;SET_PLOT,ThisDevice
loadct, 39, ncolors=256

COMMON tplot_com1
COMMON share1_mon
COMMON com_mon

q = ' '
IF (HZ EQ 0) THEN q = ' (rates left as Counts/Accumulation Cycle)'
IF (HZ EQ 1) THEN q = ' (rates converted to Counts/Second)'

k = ' '
fm = ' '

IF (sat EQ 'A') THEN fm = 'A_'
IF (sat EQ 'B') THEN fm = 'B_'

FOR jj=0,n_elements(E_step)-1 DO BEGIN
	CASE E_step(jj) OF
		0: k = '_0'
		1: k = '_1'
		2: k = '_2'
		3: k = '_3'
		4: k = '_4'
		5: k = '_5'
		6: k = '_6'
		7: k = '_7'
		8: k = '_8'
		9: k = '_9'
		10: k = '_10'
		11: k = '_11'
		12: k = '_12'
		13: k = '_13'
		14: k = '_14'
		15: k = '_15'
		16: k = '_16'
		17: k = '_17'
		18: k = '_18'
		19: k = '_19'
		20: k = '_20'
		21: k = '_21'
		22: k = '_22'
		23: k = '_23'
		24: k = '_24'
		25: k = '_25'
		26: k = '_26'
		27: k = '_27'
		28: k = '_28'
		29: k = '_29'
		30: k = '_30'
		31: k = '_31'
		32: k = '_32'
	ENDCASE


	FOR ii = 0, n_elements(prod_mon)-1 DO BEGIN 
	    temp_prod = prod_mon[ii]
	    IF n_elements(names) EQ 0 THEN names = [fm+temp_prod+k] ELSE names = [names, fm+temp_prod+k]
	ENDFOR

ENDFOR

IF (NO_ENG EQ 1) THEN BEGIN
	tplot_options, 'title', sat+q
ENDIF ELSE BEGIN
	tplot_options, 'title', sat+q+' (science mode white, engineering mode green)'
ENDELSE

z = n_elements(names)/5.0
zz = fix(z+0.9)

IF zz GE 2 THEN BEGIN

	FOR y=0, zz-2 DO BEGIN
	IF !D.NAME EQ 'X' THEN WINDOW, /FREE
	tplot, [names(5*y), names(5*y+1), names(5*y+2), names(5*y+3), names(5*y+4)];, window=y
	ENDFOR
	
	bb=ROUND((z-y)*10)

	IF !D.NAME EQ 'X' THEN WINDOW, /FREE
	IF (bb EQ 2) THEN tplot, [names(5*y)];,window=y
	IF (bb EQ 4) THEN tplot, [names(5*y), names(5*y+1)];, window=y
	IF (bb EQ 6) THEN tplot, [names(5*y), names(5*y+1), names(5*y+2)];, window=y
	IF (bb EQ 8) THEN tplot, [names(5*y), names(5*y+1), names(5*y+2), names(5*y+3)];, window=y
	IF (bb EQ 10) THEN tplot, [names(5*y), names(5*y+1), names(5*y+2), names(5*y+3), names(5*y+4)];, window=y

ENDIF ELSE BEGIN

tplot, names 

ENDELSE

CASE sat OF
    'A': BEGIN
        tplot_options, 'title', ' '
        tplot_options, 'psym', 2
        tplot_options, 'symsize', 1.5
        IF (NO_ENG EQ 1) THEN BEGIN
            IF (TOTAL(error5_mon_a, /NAN) GT 0) THEN BEGIN
                IF !D.NAME EQ 'X' THEN WINDOW, /FREE
                tplot, ['A_error5_mon']
            ENDIF
        ENDIF ELSE BEGIN
            IF (TOTAL(error5_mon_a, /NAN) GT 0) OR (TOTAL(error1_a, /NAN) GT 0) THEN BEGIN
                IF !D.NAME EQ 'X' THEN WINDOW, /FREE
                tplot, ['A_error1', 'A_error5_mon']
            ENDIF
        ENDELSE
    END
    
    'B': BEGIN
        tplot_options, 'title', ' '
        tplot_options, 'psym', 2
        tplot_options, 'symsize', 1.5
        IF (NO_ENG EQ 1) THEN BEGIN
            IF (TOTAL(error5_mon_b, /NAN) GT 0) THEN BEGIN
                IF !D.NAME EQ 'X' THEN WINDOW, /FREE
                tplot, ['B_error5_mon']
            ENDIF
        ENDIF ELSE BEGIN
            IF (TOTAL(error5_mon_b, /NAN) GT 0) OR (TOTAL(error1_b, /NAN) GT 0) THEN BEGIN
                IF !D.NAME EQ 'X' THEN WINDOW, /FREE
                tplot, ['B_error1', 'B_error5_mon']
            ENDIF
        ENDELSE
        
    END
ENDCASE
tplot_options, 'psym'
tplot_options, 'symsize'

tplot_options, 'title', ' '
END 
