;+
;PROCEDURE: plot_moments
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 10/13/2006
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;-
PRO plot_moments, prod, num_files_a, num_files_b
COMMON tplot_com1
COMMON share1
FOR ii = 0, n_elements(prod)-1 DO BEGIN 
    IF strmid(prod[ii], 0, 1) EQ 'A' THEN sat = 'A' ELSE sat = 'B'
    temp_prod = strmid(prod[ii], 2, strlen(prod[ii])-2)
    CASE temp_prod OF 
        'D'      : temp_name = sat+'_mom_density'
        'VX'     : temp_name = sat+'_mom_velocity_inst_x'
        'VY'     : temp_name = sat+'_mom_velocity_inst_y'
        'VZ'     : temp_name = sat+'_mom_velocity_inst_z'
        'VXYZ'   : temp_name = sat+'_mom_velocity_inst_xyz'
        'VT'     : temp_name = sat+'_mom_velocity_total'
        'TXX'    : temp_name = sat+'_mom_temp_inst_xx'
        'TYY'    : temp_name = sat+'_mom_temp_inst_yy'
        'TZZ'    : temp_name = sat+'_mom_temp_inst_zz'
        'TXXYYZZ': temp_name = sat+'_mom_temp_inst_xxyyzz'
        'PXX'    : temp_name = sat+'_mom_pressure_inst_xx'
        'PYY'    : temp_name = sat+'_mom_pressure_inst_yy'
        'PZZ'    : temp_name = sat+'_mom_pressure_inst_zz'
        'PXXYYZZ': temp_name = sat+'_mom_pressure_inst_xxyyzz'
        ELSE: print, 'product not found in plot_moments'
    ENDCASE
    IF n_elements(names) EQ 0 THEN names = [temp_name] ELSE names = [names, temp_name]
ENDFOR
IF n_elements(names) GT 0 THEN tplot, names
END 
