;+
;PROCEDURE: plot_hk_daily
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 01/18/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	November 2006:  K. Simunac modifies for analog housekeeping
;	18 Jan, 2007	prefixes modified for sat A and sat B
;-
PRO plot_hk_daily, sat_hk, num_files_a, num_files_b, sat

;ThisDevice = !D.Name
;SET_PLOT,'PS'
;
;filename = getenv('OUT_DIR')+'daily_analog_hk.ps'
;DEVICE, FILENAME = filename, XSIZE=8.5, YSIZE =11.0, /INCHES, $
;/COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0

LOADCT, 39, NCOLORS=256

COMMON tplot_com1
COMMON share1_mon
prefix_a = 'A_Analog_HK_'
prefix_b = 'B_Analog_HK_'


IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b

store_data, 'LVC_voltages', data = [prefix+'lvc_+12v', prefix+'lvc_-12v', $
					prefix+'lvc_+5v',prefix+'lvc_-5v', prefix+'lvc_+2.5v_a',prefix+'lvc_+2.5v_b']
options, 'LVC_voltages','title', 'LVC (black +12V/red -12V/purple +5V/orange -5V/green +2.5Va/cyan +2.5Vb)'
options, 'LVC_voltages','ytitle', sat+' LVC Voltages [V]'
ylim, 'LVC_voltages',-20,20,0
options, 'LVC_voltages','panel_size',3

store_data, 'ESA_voltages', data = [prefix+'esa_vm_pos',prefix+'esa_vm_neg']
options, 'ESA_voltages','title','ESA (black +, red -), DFL(black 1, green 2), and S Channel'
options,'ESA_voltages','ytitle', sat+' ESA Voltages [V]'
options,'ESA_voltages','panel_size',2
ylim, 'ESA_voltages',-10000,10000,0

store_data, 'DFL_vm', data = [prefix+'dfl_1_vm',prefix+'dfl_2_vm']
options, 'DFL_vm', 'ytitle',sat+' DFL Vm [V]'
ylim, 'DFL_vm',0,50,0
options, 'DFL_vm','panel_size',2

store_data, 'DFL_tap', data=[prefix+'dfl_1_tap',prefix+'dfl_2_tap']
options,'DFL_tap','ytitle',sat+' DFL Tap [V]'
ylim,'DFL_tap',0,50,0
options,'DFL_tap','panel_size',2

store_data, 'DFL_cmdc', data = [prefix+'dfl_1_cm_dc', prefix+'dfl_2_cm_dc']
options,'DFL_cmdc','ytitle',sat+' DFL CM_DC [mA]'
ylim, 'DFL_cmdc',0,5,0
options,'DFL_cmdc','panel_size',2

store_data, 'TAC_temps', data = [prefix+'tac0_tsp',prefix+'tac2_tsp']
options, 'TAC_temps','ytitle',sat+' TAC [deg C]'
options, 'TAC_temps', 'title','Temperature Plots (Item_0: Black, Item_1: Red, Item_2: Green)'
ylim,'TAC_temps',-25,50,0
options, 'TAC_temps','panel_size',2

store_data, 'TOF_hv_temps', data=[prefix+'tof_hv0_tsp',prefix+'tof_hv1_tsp']
options, 'TOF_hv_temps','ytitle',sat+' TOF HV [deg C]'
ylim, 'TOF_hv_temps',-25,50,0
options, 'TOF_hv_temps','panel_size',2

store_data, 'SC_temps', data=[prefix+'s_c_0_tsp',prefix,'s_c_1_tsp']
options, 'SC_temps','ytitle',sat+' SC [deg C]'
ylim, 'SC_temps',-25,50,0
options, 'SC_temps','panel_size',2

store_data, 'LVC_temps',data=[prefix+'lvc0_tsp', prefix+'lvc1_tsp']
options, 'LVC_temps', 'ytitle', sat+' LVC [deg C]'
ylim, 'LVC_temps',-25,50,0
options, 'LVC_temps', 'panel_size',2

store_data, 'SSD_temps', data=[prefix+'ssd_tc0', prefix+'ssd_tc1', prefix+'ssd_tc2']
options, 'SSD_temps', 'ytitle',sat+' SSD [deg C]
ylim, 'SSD_temps',-25,50,0
options, 'SSD_temps','panel_size',2

options, prefix+'pac_cm_dc','title','PAC, MCP, and SSD'

options, prefix+'lvc_+12v_imon','color',0 ; black
options, prefix+'lvc_-12v_imon','color',250 ; red
options, prefix+'lvc_+5v_imon','color',50 ; purple blue
options, prefix+'lvc_-5v_imon','color',200 ; orange
options, prefix+'lvc_+2.5v_a_imon','color',150 ; green
options, prefix+'lvc_+2.5v_b_imon','color',100 ; cyan blue

tplot_options,'ymargin',[6,6]
tplot,['LVC_voltages',prefix+'lvc_+12v_imon',prefix+'lvc_-12v_imon',prefix+'lvc_+5v_imon',prefix+'lvc_-5v_imon',prefix+'lvc_+2.5v_a_imon',prefix+'lvc_+2.5v_b_imon']
window, /free
tplot,['ESA_voltages', prefix+'esa_cm_dc','DFL_vm','DFL_tap','DFL_cmdc',prefix+'s_ch_vm',prefix+'s_ch_vm_tap',prefix+'s_ch_cm_dc']
window, /free
tplot,[prefix+'pac_cm_dc',prefix+'mcp_vm',prefix+'mcp_cm_dc',prefix+'ssd_vm',prefix+'ssd_hv_bias',prefix+'ssd_v_pos_analog',prefix+'ssd_v_neg_analog',prefix+'ssd_v_pos_dig']
window, /free
tplot,['TAC_temps','TOF_hv_temps','SC_temps','LVC_temps','SSD_temps']

;DEVICE, /Close_File
;SET_PLOT, ThisDevice

END 
