;+
; PROCEDURE: pla_plot_pos_spec
;
; PURPOSE:
;  To plot plastic energy spectra
;
; INPUT:
;       sat:
;       prod:
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION HISTORY:
;
;-
PRO pla_plot_pos_spec, sprod, units, $
                       energy, phi, $
                       diagn=diagn
  
COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no = 0 & get_err_msg = ''

prod_str = ['h_alpha', 'h+peak', 'he++peak', 'he++tcr', $
            'sw_z>2_h', 'sw_z>2_l', 'wap_ssd_tcr', 'wap_ssd_dcr', $
            'wap_no_ssd_dcr', 'sw_priority', 'wap_priority_ssd', 'wap_priority_no_ssd']

get_input_param, sprod, sat, prod, class

prodtmp = prod_str(prod-1)
prod = prodtmp

; Loop over all sat/product combinations
FOR ii = 0, N_ELEMENTS(prod)-1 DO BEGIN
    
    IF prod(ii) EQ 'h_alpha' OR $
      prod(ii) EQ 'h+peak' OR $
      prod(ii) EQ 'he++peak' OR $
      prod(ii) EQ 'he++tcr' OR $
      prod(ii) EQ 'sw_z>2_h' OR $
      prod(ii) EQ 'sw_z>2_l' OR $
      prod(ii) EQ 'wap_ssd_tcr' OR $
      prod(ii) EQ 'wap_ssd_dcr' OR $
      prod(ii) EQ 'wap_no_ssd_dcr' THEN BEGIN
        
        get_err_no = 0          ; reset error indicator
        
        get_pla_pos_spec, sat(ii), prod(ii), class(ii), $
                          units, energy, phi, diagn = diagn
        
        prodname = 'pla_' + sat(ii) + '_enspec_' + prod(ii)
        
        IF prod(ii) EQ 'sw_z>2_h' OR prod(ii) EQ 'sw_z>2_l' THEN $
          prodname = prodname + '_cl' + STRING(class(ii)+1, FORMAT = '(i2.2)')
        
    ENDIF ELSE BEGIN
        
        err_msg, 'No DEF data for product: ' + prod(ii)
        
    ENDELSE
    
ENDFOR

END
