;+
; PROCEDURE: pla_plot_en_spec_line
;
; PURPOSE:
;  To plot plastic energy spectra
;
; INPUT:
;       sat:
;       prod:
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION HISTORY:
;
;-
PRO pla_plot_en_spec_line, sprod, units, energy, diagn=diagn
  
COMMON get_error, get_err_no, get_err_msg, default_verbose
  
get_err_no = 0 & get_err_msg = ''

IF KEYWORD_SET(HELP) THEN BEGIN
    PRINT, '- sprod: prod identifier string'
    PRINT, '- units: units string'
    PRINT, '- diagn = diagn: create diagnostic plots'
    PRINT, '- help = help: show procedure inputs'
    
    RETURN
ENDIF

; Check for gaps in the stings of the input variables
sprod = STRCOMPRESS(sprod, /REMOVE_ALL)
units = STRCOMPRESS(units, /REMOVE_ALL)

prod_str = ['h_alpha', 'h+peak', 'he++peak', 'he++tcr', $
            'sw_z>2_h', 'sw_z>2_l', 'wap_ssd_tcr', 'wap_ssd_dcr', $
            'wap_no_ssd_dcr', 'sw_priority', 'wap_priority_ssd', 'wap_priority_no_ssd']

; Transform the input string variable SPROD into the variables SAT/PROD/CLASS
get_input_param, sprod, sat, prod, class
IF get_err_no NE 0 THEN RETURN

prodtmp = prod_str(prod-1)
prod = prodtmp

; Loop over all sat/product combinations
FOR ii = 0, N_ELEMENTS(prod)-1 DO BEGIN
    
    get_err_no = 0  & get_err_msg = '' ; reset error indicator
    
    get_pla_en_spec_line, sat(ii), prod(ii), class(ii), units, energy, $
      diagn = diagn
    
    IF get_err_no NE 0 THEN BEGIN
        err_msg, 'No data for product: ' + prod(ii)
    ENDIF

ENDFOR

END
