;+
;PROCEDURE: pl_read_mom_conv
;PURPOSE: Find appropriate calibration files and read in calibration values.
;
;INPUT
;PARAMETERS:  sat: 'A' or 'B'
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 10/12/2006
;
;MODIFICATION HISTORY:
;    10/12/2006 Created
;    03/28/2007 Added check for if no valid epoch.
;-
PRO pl_read_mom_conv, sat
COMMON share1
COMMON com_moment

; find start and end times
IF sat EQ 'A' THEN epoch1 = epoch1_a ELSE epoch1 = epoch1_b
valid_epochs = where(finite(epoch1), count)
IF count GT 0 THEN BEGIN 
    start_time = epoch1[valid_epochs[0]]
    stop_time = epoch1[valid_epochs[count-1]]

; find most recent catalog file
    temp_files = file_search('$PLACAL/*.cal', count = num_files)
    version = 1
    catalog_file = ''
    FOR ii = 0, num_files-1 DO BEGIN 
        temp_file = file_basename(temp_files[ii])
        temp_version = fix(strmid(temp_file, 21, 2))
        IF temp_version GE version THEN BEGIN
            version = temp_version
            catalog_file = temp_files[ii]
        ENDIF 
    ENDFOR 

; find calibration file(s)
    openr, cat_lun, catalog_file, /get_lun
    cat_files_found = 0
    cat_files = ['']
    finished = 0
    line = ''
    mom_cal_start = [-2D]       ; this first element will be removed
    mom_cal_stop = [-2D]        ; this first element will be removed
    WHILE eof(cat_lun) EQ 0 AND finished EQ 0 DO BEGIN ; need this loop to get to MOM
        readf, cat_lun, line
        parts_current = strsplit(line, /extract)
        IF parts_current[0] EQ 'MOM' THEN BEGIN 
            
            WHILE eof(cat_lun) EQ 0 AND finished EQ 0 DO BEGIN 
                readf, cat_lun, line
                parts_next = strsplit(line, /extract)
                IF parts_next[0] NE 'MOM' THEN BEGIN ; finished MOM section
                    finished = 1
                    cat_files_found = cat_files_found + 1
                    cat_files = [cat_files, parts_current[2]]
                    mom_cal_start = [mom_cal_start, time_double(parts_current[1])]
                    mom_cal_stop = [mom_cal_stop, -1D]
                ENDIF ELSE BEGIN ; current and next are both MOM
                ;stop
                    IF start_time GE time_double(parts_next[1]) THEN parts_current = parts_next $ ; skip current file
                    ELSE BEGIN 
                        cat_files_found = cat_files_found + 1
                        cat_files = [cat_files, parts_current[2]]
                        mom_cal_start = [mom_cal_start, time_double(parts_current[1])]
                        IF stop_time LT time_double(parts_next[1]) THEN BEGIN ; skip rest of files
                            finished = 1 
                            mom_cal_stop = [mom_cal_stop, -1D]
                        ENDIF ELSE BEGIN
                            mom_cal_stop = [mom_cal_stop, time_double(parts_next[1])]
                            parts_current = parts_next
                        ENDELSE 
                    ENDELSE 
                ENDELSE 
            ENDWHILE 
        ENDIF 
    ENDWHILE 

    IF cat_files_found GT 0 THEN cat_files = cat_files[1:cat_files_found]
    close, cat_lun
    free_lun, cat_lun
ENDIF ELSE cat_files_found = 0

; read calibration files
IF cat_files_found GT 0 THEN BEGIN 
    step_var = dblarr(cat_files_found)
    table_norm = dblarr(cat_files_found, 4) ; D,V,P,H
    geom = dblarr(cat_files_found, 2) ; M,S
    sw_h_eff = dblarr(cat_files_found, 32, 3)  ; 32 lines, vel, energy, efficiency
    sw_all_eff = dblarr(cat_files_found, 32, 3)
    FOR ii = 0, cat_files_found-1 DO BEGIN 
        filename = '$PLACAL/'+cat_files[ii]
        openr, cal_lun, filename, /get_lun
        found_step = 0
        WHILE eof(cal_lun) EQ 0 AND found_step EQ 0 DO BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] EQ 'step_variable' THEN BEGIN 
                step_var[ii] = double(parts[1])
                found_step = 1
            ENDIF
        ENDWHILE 
        found_table_norm = 0
        WHILE eof(cal_lun) EQ 0 AND found_table_norm EQ 0 DO BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] EQ 'table_norm_values' THEN BEGIN 
                IF parts[1] NE 'D' THEN BEGIN
                    print, 'Error in reading moments calibration'
                    stop
                ENDIF ELSE table_norm[ii, 0] = double(parts[2])
                readf, cal_lun, line
                parts = strsplit(line, /extract)
                IF parts[0] NE 'table_norm_values' OR parts[1] NE 'V' THEN BEGIN
                    print, 'Error in reading moments calibration'
                    stop
                ENDIF ELSE table_norm[ii, 1] = double(parts[2])
                readf, cal_lun, line
                parts = strsplit(line, /extract)
                IF parts[0] NE 'table_norm_values' OR parts[1] NE 'P' THEN BEGIN
                    print, 'Error in reading moments calibration'
                    stop
                ENDIF ELSE table_norm[ii, 2] = double(parts[2])
                readf, cal_lun, line
                parts = strsplit(line, /extract)
                IF parts[0] NE 'table_norm_values' OR parts[1] NE 'H' THEN BEGIN
                    print, 'Error in reading moments calibration'
                    stop
                ENDIF ELSE table_norm[ii, 3] = double(parts[2])
                found_table_norm = 1
            ENDIF
        ENDWHILE 
        found_geom_factor = 0
        WHILE eof(cal_lun) EQ 0 AND found_geom_factor EQ 0 DO BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] EQ 'geom_factor' THEN BEGIN 
                IF parts[1] NE 'S' THEN BEGIN
                    print, 'Error in reading moments calibration'
                    stop
                ENDIF ELSE geom[ii, 1] = double(parts[2])
                readf, cal_lun, line
                parts = strsplit(line, /extract)
                IF parts[0] NE 'geom_factor' OR parts[1] NE 'M' THEN BEGIN
                    print, 'Error in reading moments calibration'
                    stop
                ENDIF ELSE geom[ii, 0] = double(parts[2])
                found_geom_factor = 1
            ENDIF
        ENDWHILE 
        found_sw_h_eff = 0
        WHILE eof(cal_lun) EQ 0 AND found_sw_h_eff EQ 0 DO BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] EQ 'sw_h' THEN BEGIN 
                sw_h_eff[ii, 0, *] = double(parts[1:3])
                FOR jj = 1, 31 DO BEGIN ; 32 lines total
                    readf, cal_lun, line
                    parts = strsplit(line, /extract)
                    IF parts[0] NE  'sw_h' THEN BEGIN 
                        print, "unexpected number of lines"
                        stop
                    ENDIF ELSE sw_h_eff[ii, jj, *] = double(parts[1:3])
                ENDFOR
                found_sw_h_eff = 1
            ENDIF
        ENDWHILE
        found_sw_all_eff = 0
        WHILE eof(cal_lun) EQ 0 AND found_sw_all_eff EQ 0 DO BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            IF parts[0] EQ 'sw_all' THEN BEGIN 
                sw_all_eff[ii, 0, *] = double(parts[1:3])
                FOR jj = 1, 31 DO BEGIN ; 32 lines total
                    readf, cal_lun, line
                    parts = strsplit(line, /extract)
                    IF parts[0] NE  'sw_all' THEN BEGIN 
                        print, "unexpected number of lines"
                        stop
                    ENDIF ELSE sw_all_eff[ii, jj, *] = double(parts[1:3])
                ENDFOR
                found_sw_all_eff = 1
            ENDIF
        ENDWHILE
        close, cal_lun
        free_lun, cal_lun
    ENDFOR
ENDIF 
IF sat EQ 'A' THEN BEGIN
    IF cat_files_found GT 0 THEN BEGIN 
        mom_cal_start_a = mom_cal_start[1:n_elements(mom_cal_start)-1]
        mom_cal_stop_a = mom_cal_stop[1:n_elements(mom_cal_stop)-1]
        step_var_a = step_var
        table_norm_a = table_norm
        geom_a = geom
        sw_h_eff_a = sw_h_eff
        sw_all_eff_a = sw_all_eff
    ENDIF 
ENDIF ELSE BEGIN
    IF cat_files_found GT 0 THEN BEGIN 
        mom_cal_start_b = mom_cal_start[1:n_elements(mom_cal_start)-1]
        mom_cal_stop_b = mom_cal_stop[1:n_elements(mom_cal_stop)-1]
        step_var_b = step_var
        table_norm_b = table_norm
        geom_b = geom
        sw_h_eff_b = sw_h_eff
        sw_all_eff_b = sw_all_eff
    ENDIF 
ENDELSE 

END 
