;+
;PROCEDURE: pl_read_cdf_dig_hk
;PURPOSE:
;  Read data from cdf files.
;
;PARAMETERS:   in:  sat        : 'A' or 'B'
;                   files      : Array of file paths to read from (strings)
;                   products   : Array of Products wanted (strings)
;                   which_epoch: 0(for variable), 1, or 5 minute resolution, 2 (for analog housekeeping, 
;				which can be reported every 2 seconds)
;
;CREATED BY: L. Ellis (pl_read_cdf)
;
;LAST MODIFICATION: 09/18/2006
;
;MODIFICATION HISTORY:
;    09/18/2006: Created
;
;	January 2007 K.Simunac adds digital housekeeping variables
;    05-15-2007: CM
;                Actual maxrec is epochinfo.maxrec+1
;-

PRO read_product_dig_hk, cdf_id, prod_name, data_var, data_index, epoch_maxrec

; prod_name: string with cdf variable name 
; data_var: the common variable in which to put the data
; data_index: the start index for records in the data_var
; epoch_maxrec: number of records we expect 

cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
IF varinfo.maxrec+1 GE epoch_maxrec THEN maxrec = varinfo.maxrec ELSE maxrec = epoch_maxrec
cdf_varget, cdf_id, prod_name, temp_data, rec_count = maxrec, /zvariable
num_dim = size(data_var, /n_dimensions)
CASE num_dim OF 
    1: BEGIN
        temp_index = 0L
        FOR kk = 0L, n_elements(data_index)-1 DO BEGIN 
            data_var[data_index[kk]:(data_index[kk]+data_index[kk+1]-1)] = temp_data[temp_index:(temp_index+data_index[kk+1]-1)]
            temp_index = temp_index+data_index[kk+1]
            kk = kk+1
        ENDFOR 
    END 
    2: BEGIN
        temp_index = 0L
        FOR kk = 0L, n_elements(data_index)-1 DO BEGIN 
            data_var[*, data_index[kk]:(data_index[kk]+data_index[kk+1]-1)] = temp_data[*, temp_index:(temp_index+data_index[kk+1]-1)]
            temp_index = temp_index+data_index[kk+1]
            kk = kk+1
        ENDFOR 
    END 
    3: BEGIN
        temp_index = 0L
        FOR kk = 0L, n_elements(data_index)-1 DO BEGIN 
            data_var[*, *, data_index[kk]:(data_index[kk]+data_index[kk+1]-1)] = temp_data[*, *, temp_index:(temp_index+data_index[kk+1]-1)]
            temp_index = temp_index+data_index[kk+1]
            kk = kk+1
        ENDFOR 
    END 
;   4: BEGIN
;        temp_index = 0L
;        FOR kk = 0L, n_elements(data_index)-1 DO BEGIN 
;            data_var[*, *,*, data_index[kk]:(data_index[kk]+data_index[kk+1]-1)] = temp_data[*, *,*, temp_index:(temp_index+data_index[kk+1]-1)]
;            temp_index = temp_index+data_index[kk+1]
;            kk = kk+1
;        ENDFOR 
;    END
    ELSE: BEGIN 
        print, "Lorna: Add more dimensions"
        stop
    END
ENDCASE 
END 

PRO remove_fill_dig_hk, fill_val, data

; fill_val: fill_value to be replaced by NaN
; data: array of data values
indice = where(data EQ fill_val, count)
FOR ii = 0L, count-1 DO BEGIN
    data[indice[ii]] = !values.d_nan
ENDFOR 
END 


PRO init_dig_hk, sat, num_records1, dig_hk_initialized, products

; initialize all the housekeeping variabales (in com_dig_hk)
COMMON com_dig_hk
CASE sat OF
    'A': BEGIN 

	FOR kk=0,n_elements(products)-1 DO BEGIN
	CASE products[kk] OF
	
	'dpu_sw_version':  BEGIN
		dpu_sw_version_a	= dblarr(num_records1) ; 0
		dpu_sw_version_a[*] = !values.d_nan ; 0
		END
	'cmd_rcvd_cnt':  BEGIN
		cmd_rcvd_cnt_a	= dblarr(num_records1) ; 1
		cmd_rcvd_cnt_a[*] = !values.d_nan ; 1
		END
	'cmd_exec_cnt':  BEGIN
		cmd_exec_cnt_a	= dblarr(num_records1) ; 2
		cmd_exec_cnt_a[*] = !values.d_nan ; 2
		END
	'cmd_total_err_cnt':  BEGIN
		cmd_total_err_cnt_a	= dblarr(num_records1) ; 3
		cmd_total_err_cnt_a[*] = !values.d_nan ; 3
		END
	'cmd_parity_err_cnt':  BEGIN
		cmd_parity_err_cnt_a	= dblarr(num_records1) ; 4
		cmd_parity_err_cnt_a[*] = !values.d_nan ; 4
		END
	'cmd_frame_err_cnt':  BEGIN
		cmd_frame_err_cnt_a	= dblarr(num_records1) ; 5
		cmd_frame_err_cnt_a[*] = !values.d_nan ; 5
		END
	'cmd_illegal_err_cnt':  BEGIN
		cmd_illegal_err_cnt_a	= dblarr(num_records1) ; 6
		cmd_illegal_err_cnt_a[*] = !values.d_nan ; 6
		END
	'ic_status_reg':  BEGIN
		ic_status_reg_a	= dblarr(num_records1) ; 7
		ic_status_reg_a[*] = !values.d_nan ; 7
		END
	'ic_ctl_reg':  BEGIN
		ic_ctl_reg_a	= dblarr(num_records1) ; 8
		ic_ctl_reg_a[*] = !values.d_nan ; 8
		END
	'lbc_reset_ctl':  BEGIN
		lbc_reset_ctl_a	= dblarr(num_records1) ; 9
		lbc_reset_ctl_a[*] = !values.d_nan ; 9
		END
	'lbc_mode_ctl':  BEGIN
		lbc_mode_ctl_a	= dblarr(num_records1) ; 10
		lbc_mode_ctl_a[*] = !values.d_nan ; 10
		END
	'lbc_logic_ctl_a':  BEGIN
		lbc_logic_ctl_a_a	= dblarr(num_records1) ; 11
		lbc_logic_ctl_a_a[*] = !values.d_nan ; 11
		END
	'lbc_logic_ctl_b':  BEGIN
		lbc_logic_ctl_b_a	= dblarr(num_records1) ; 12
		lbc_logic_ctl_b_a[*] = !values.d_nan ; 12
		END
	'lbc_tac_pwr_ctl':  BEGIN
		lbc_tac_pwr_ctl_a	= dblarr(num_records1) ; 13
		lbc_tac_pwr_ctl_a[*] = !values.d_nan ; 13
		END
	'lbc_reg_seq':  BEGIN
		lbc_reg_seq_a	= dblarr(num_records1) ; 14
		lbc_reg_seq_a[*] = !values.d_nan ; 14
		END
	'lbc_event_ctl':  BEGIN
		lbc_event_ctl_a	= dblarr(num_records1) ; 15
		lbc_event_ctl_a[*] = !values.d_nan ; 15
		END
	'lbc_rlim_ch':  BEGIN
		lbc_rlim_ch_a	= dblarr(num_records1) ; 16
		lbc_rlim_ch_a[*] = !values.d_nan ; 16
		END
	'lbc_rlim_hi':  BEGIN
		lbc_rlim_hi_a	= dblarr(num_records1) ; 17
		lbc_rlim_hi_a[*] = !values.d_nan ; 17
		END
	'lbc_rlim_lo':  BEGIN
		lbc_rlim_lo_a	= dblarr(num_records1) ; 18
		lbc_rlim_lo_a[*] = !values.d_nan ; 18
		END
	'lbe_pos_ctrl':  BEGIN
		lbe_pos_ctrl_a	= dblarr(num_records1) ; 19
		lbe_pos_ctrl_a[*] = !values.d_nan ; 19
		END
	'lbe_pos_disable0':  BEGIN
		lbe_pos_disable0_a	= dblarr(num_records1) ; 20
		lbe_pos_disable0_a[*] = !values.d_nan ; 20
		END
	'lbe_pos_disable2':  BEGIN
		lbe_pos_disable2_a	= dblarr(num_records1) ; 21
		lbe_pos_disable2_a[*] = !values.d_nan ; 21
		END
	'lbe_tac0_ctrl':  BEGIN
		lbe_tac0_ctrl_a	= dblarr(num_records1) ; 22
		lbe_tac0_ctrl_a[*] = !values.d_nan ; 22
		END
	'lbe_tac0_dac':  BEGIN
		lbe_tac0_dac_a	= dblarr(num_records1) ; 23
		lbe_tac0_dac_a[*] = !values.d_nan ; 23
		END
	'lbe_tac2_ctrl':  BEGIN
		lbe_tac2_ctrl_a	= dblarr(num_records1) ; 24
		lbe_tac2_ctrl_a[*] = !values.d_nan ; 24
		END
	'lbe_tac2_dac':  BEGIN
		lbe_tac2_dac_a	= dblarr(num_records1) ; 25
		lbe_tac2_dac_a[*] = !values.d_nan ; 25
		END
	'lbe_tac0_under_hi':  BEGIN
		lbe_tac0_under_hi_a	= dblarr(num_records1) ; 26
		lbe_tac0_under_hi_a[*] = !values.d_nan ; 26
		END
	'lbe_tac0_under_lo':  BEGIN
		lbe_tac0_under_lo_a	= dblarr(num_records1) ; 27
		lbe_tac0_under_lo_a[*] = !values.d_nan ; 27
		END
	'lbe_tac0_over_hi':  BEGIN
		lbe_tac0_over_hi_a	= dblarr(num_records1) ; 28
		lbe_tac0_over_hi_a[*] = !values.d_nan ; 28
		END
	'lbe_tac0_over_lo':  BEGIN
		lbe_tac0_over_lo_a	= dblarr(num_records1) ; 29
		lbe_tac0_over_lo_a[*] = !values.d_nan ; 29
		END
	'lbe_tac2_under_hi':  BEGIN
		lbe_tac2_under_hi_a	= dblarr(num_records1) ; 30
		lbe_tac2_under_hi_a[*] = !values.d_nan ; 30
		END
	'lbe_tac2_under_lo':  BEGIN
		lbe_tac2_under_lo_a	= dblarr(num_records1) ; 31
		lbe_tac2_under_lo_a[*] = !values.d_nan ; 31
		END
	'lbe_tac2_over_hi':  BEGIN
		lbe_tac2_over_hi_a	= dblarr(num_records1) ; 32
		lbe_tac2_over_hi_a[*] = !values.d_nan ; 32
		END
	'lbe_tac2_over_lo':  BEGIN
		lbe_tac2_over_lo_a	= dblarr(num_records1) ; 33
		lbe_tac2_over_lo_a[*] = !values.d_nan ; 33
		END
	'lbe_ssd_ctrl':  BEGIN
		lbe_ssd_ctrl_a	= dblarr(num_records1) ; 34
		lbe_ssd_ctrl_a[*] = !values.d_nan ; 34
		END
	'lbe_ssd_cmd_h':  BEGIN
		lbe_ssd_cmd_h_a	= dblarr(num_records1) ; 35
		lbe_ssd_cmd_h_a[*] = !values.d_nan ; 35
		END
	'lbe_ssd_cmd_l':  BEGIN
		lbe_ssd_cmd_l_a	= dblarr(num_records1) ; 36
		lbe_ssd_cmd_l_a[*] = !values.d_nan ; 36
		END
	'lbe_ssd_dis':  BEGIN
		lbe_ssd_dis_a	= dblarr(num_records1) ; 37
		lbe_ssd_dis_a[*] = !values.d_nan ; 37
		END
	'lbe_ssd_under_hi':  BEGIN
		lbe_ssd_under_hi_a	= dblarr(num_records1) ; 38
		lbe_ssd_under_hi_a[*] = !values.d_nan ; 38
		END
	'lbe_ssd_under_lo':  BEGIN
		lbe_ssd_under_lo_a	= dblarr(num_records1) ; 39
		lbe_ssd_under_lo_a[*] = !values.d_nan ; 39
		END
	'lbe_ssd_over_hi':  BEGIN
		lbe_ssd_over_hi_a	= dblarr(num_records1) ; 40
		lbe_ssd_over_hi_a[*] = !values.d_nan ; 40
		END
	'lbe_ssd_over_lo':  BEGIN
		lbe_ssd_over_lo_a	= dblarr(num_records1) ; 41
		lbe_ssd_over_lo_a[*] = !values.d_nan ; 41
		END
	'lbe_sel_ctrl':  BEGIN
		lbe_sel_ctrl_a	= dblarr(num_records1) ; 42
		lbe_sel_ctrl_a[*] = !values.d_nan ; 42
		END
	'lbe_trig_mode':  BEGIN
		lbe_trig_mode_a	= dblarr(num_records1) ; 43
		lbe_trig_mode_a[*] = !values.d_nan ; 43
		END
	'lbe_esa_step':  BEGIN
		lbe_esa_step_a	= dblarr(num_records1) ; 44
		lbe_esa_step_a[*] = !values.d_nan ; 44
		END
	'lbe_defl_step':  BEGIN
		lbe_defl_step_a	= dblarr(num_records1) ; 45
		lbe_defl_step_a[*] = !values.d_nan ; 45
		END
	'lbe_ssd_offset0':  BEGIN
		lbe_ssd_offset0_a	= dblarr(num_records1) ; 46
		lbe_ssd_offset0_a[*] = !values.d_nan ; 46
		END
	'lbe_ssd_offset1':  BEGIN
		lbe_ssd_offset1_a	= dblarr(num_records1) ; 47
		lbe_ssd_offset1_a[*] = !values.d_nan ; 47
		END
	'lbe_ssd_offset2':  BEGIN
		lbe_ssd_offset2_a	= dblarr(num_records1) ; 48
		lbe_ssd_offset2_a[*] = !values.d_nan ; 48
		END
	'lbe_ssd_offset3':  BEGIN
		lbe_ssd_offset3_a	= dblarr(num_records1) ; 49
		lbe_ssd_offset3_a[*] = !values.d_nan ; 49
		END
	'lbe_ssd_offset4':  BEGIN
		lbe_ssd_offset4_a	= dblarr(num_records1) ; 50
		lbe_ssd_offset4_a[*] = !values.d_nan ; 50
		END
	'lbe_ssd_offset5':  BEGIN
		lbe_ssd_offset5_a	= dblarr(num_records1) ; 51
		lbe_ssd_offset5_a[*] = !values.d_nan; 51
		END
	'lbe_ssd_offset6':  BEGIN
		lbe_ssd_offset6_a	= dblarr(num_records1) ; 52
		lbe_ssd_offset6_a[*] = !values.d_nan ; 52
		END
	'lbe_ssd_offset7':  BEGIN
		lbe_ssd_offset7_a	= dblarr(num_records1) ; 53
		lbe_ssd_offset7_a[*] = !values.d_nan ; 53
		END
	'lbe_stim_enable':  BEGIN
		lbe_stim_enable_a	= dblarr(num_records1) ; 54
		lbe_stim_enable_a[*] = !values.d_nan ; 54
		END
	'lbe_stim_freq_hi':  BEGIN
		lbe_stim_freq_hi_a	= dblarr(num_records1) ; 55
		lbe_stim_freq_hi_a[*] = !values.d_nan ; 55
		END
	'lbe_stim_freq_lo':  BEGIN
		lbe_stim_freq_lo_a	= dblarr(num_records1) ; 56
		lbe_stim_freq_lo_a[*] = !values.d_nan ; 56
		END
	'lbe_sel0_window':  BEGIN
		lbe_sel0_window_a	= dblarr(num_records1) ; 57
		lbe_sel0_window_a[*] = !values.d_nan ; 57
		END
	'lbe_sel2_window':  BEGIN
		lbe_sel2_window_a	= dblarr(num_records1) ; 58
		lbe_sel2_window_a[*] = !values.d_nan ; 58
		END
	'lbe_ssd_offset8':  BEGIN
		lbe_ssd_offset8_a	= dblarr(num_records1) ; 59
		lbe_ssd_offset8_a[*] = !values.d_nan ; 59
		END
	'lbe_ssd_offset9':  BEGIN
		lbe_ssd_offset9_a	= dblarr(num_records1) ; 60
		lbe_ssd_offset9_a[*] = !values.d_nan ; 60
		END
	'lbe_ssd_offset10':  BEGIN
		lbe_ssd_offset10_a	= dblarr(num_records1) ; 61
		lbe_ssd_offset10_a[*] = !values.d_nan ; 61
		END
	'lbe_ssd_offset11':  BEGIN
		lbe_ssd_offset11_a	= dblarr(num_records1) ; 62
		lbe_ssd_offset11_a[*] = !values.d_nan ; 62
		END
	'lbe_ssd_offset12':  BEGIN
		lbe_ssd_offset12_a	= dblarr(num_records1) ; 63
		lbe_ssd_offset12_a[*] = !values.d_nan ; 63
		END
	'lbe_ssd_offset13':  BEGIN
		lbe_ssd_offset13_a	= dblarr(num_records1) ; 64
		lbe_ssd_offset13_a[*] = !values.d_nan ; 64
		END
	'lbe_ssd_offset14':  BEGIN
		lbe_ssd_offset14_a	= dblarr(num_records1) ; 65
		lbe_ssd_offset14_a[*] = !values.d_nan ; 65
		END
	'lbe_ssd_offset15':  BEGIN
		lbe_ssd_offset15_a	= dblarr(num_records1) ; 66
		lbe_ssd_offset15_a[*] = !values.d_nan ; 66
		END
	'lbe_pos_ra':  BEGIN
		lbe_pos_ra_a	=	 dblarr(num_records1) ; 67
		lbe_pos_ra_a[*] = !values.d_nan ; 67
		END
	'dacm_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
		dacm_pac_mcp_ssd_ctl_mcp_limit_a	= dblarr(num_records1) ; 68
		dacm_pac_mcp_ssd_ctl_mcp_limit_a[*] = !values.d_nan ; 68
		END
	'dacm_pac_limit':  BEGIN
		dacm_pac_limit_a	= dblarr(num_records1) ; 69
		dacm_pac_limit_a[*] = !values.d_nan ; 69
		END
	'dacm_esa_ctl':  BEGIN
		dacm_esa_ctl_a	=	 dblarr(num_records1) ; 70
		dacm_esa_ctl_a[*] = !values.d_nan ; 70
		END
	'dacm_s_ch_ctl':  BEGIN
		dacm_s_ch_ctl_a	=	 dblarr(num_records1) ; 71
		dacm_s_ch_ctl_a[*] = !values.d_nan ; 71
		END
	'dacm_dfl_1_ctl':  BEGIN
		dacm_dfl_1_ctl_a	= dblarr(num_records1) ; 72
		dacm_dfl_1_ctl_a[*] = !values.d_nan ; 72
		END
	'dacm_dfl_2_ctl':  BEGIN
		dacm_dfl_2_ctl_a	= dblarr(num_records1) ; 73
		dacm_dfl_2_ctl_a[*] = !values.d_nan ; 73
		END
	'dacm_control':  BEGIN
		dacm_control_a	= 	dblarr(num_records1) ; 74
		dacm_control_a[*] = !values.d_nan ; 74
		END
	'dacm_status':  BEGIN
		dacm_status_a	= 	dblarr(num_records1) ; 75
		dacm_status_a[*] = !values.d_nan ; 75
		END
	'dacm_adc_lu_ctr':  BEGIN
		dacm_adc_lu_ctr_a	= dblarr(num_records1) ; 76
		dacm_adc_lu_ctr_a[*] = !values.d_nan ; 76
		END
	'dacm_dfl_1_offset':  BEGIN
		dacm_dfl_1_offset_a	=	 dblarr(num_records1) ; 77
		dacm_dfl_1_offset_a[*] = !values.d_nan ; 77
		END
	'dacm_dfl_2_offset':  BEGIN
		dacm_dfl_2_offset_a	= dblarr(num_records1) ; 78
		dacm_dfl_2_offset_a[*] = !values.d_nan ; 78
		END
	'dacm_pac_coarse':  BEGIN
		dacm_pac_coarse_a	= dblarr(num_records1) ; 79
		dacm_pac_coarse_a[*] = !values.d_nan ; 79
		END
	'dacm_pac_fine':  BEGIN
		dacm_pac_fine_a	=	 dblarr(num_records1) ; 80
		dacm_pac_fine_a[*] = !values.d_nan ; 80
		END
	'dacm_pac_cm_fs_coarse':  BEGIN
		dacm_pac_cm_fs_coarse_a	=	 dblarr(num_records1) ; 81
		dacm_pac_cm_fs_coarse_a[*] = !values.d_nan ; 81
		END
	'dacm_pac_cm_fs_fine':  BEGIN
		dacm_pac_cm_fs_fine_a	= dblarr(num_records1) ; 82
		dacm_pac_cm_fs_fine_a[*] = !values.d_nan ; 82
		END
	'dacm_mcp_coarse':  BEGIN
		dacm_mcp_coarse_a	= dblarr(num_records1) ; 83
		dacm_mcp_coarse_a[*] = !values.d_nan ; 83
		END
	'dacm_mcp_fine':  BEGIN
		dacm_mcp_fine_a	= 	dblarr(num_records1) ; 84
		dacm_mcp_fine_a[*] = !values.d_nan ; 84
		END
	'dacm_mcp_cm_fs_coarse':  BEGIN
		dacm_mcp_cm_fs_coarse_a	= 	dblarr(num_records1) ; 85
		dacm_mcp_cm_fs_coarse_a[*] = !values.d_nan ; 85
		END
	'dacm_mcp_cm_fs_fine':  BEGIN
		dacm_mcp_cm_fs_fine_a	= dblarr(num_records1) ; 86
		dacm_mcp_cm_fs_fine_a[*] = !values.d_nan ; 86
		END
	'dacm_ssd_coarse':  BEGIN
		dacm_ssd_coarse_a	=	dblarr(num_records1) ; 87
		dacm_ssd_coarse_a[*] = !values.d_nan ; 87
		END
	'dacm_ssd_fine':  BEGIN
		dacm_ssd_fine_a	= dblarr(num_records1) ; 88
		dacm_ssd_fine_a[*] = !values.d_nan ; 88
		END
	'dacm_esa_coarse':  BEGIN
		dacm_esa_coarse_a	= dblarr(num_records1) ; 89
		dacm_esa_coarse_a[*] = !values.d_nan ; 89
		END
	'dacm_esa_fine':  BEGIN
		dacm_esa_fine_a	=	 dblarr(num_records1) ; 90
		dacm_esa_fine_a[*] = !values.d_nan ; 90
		END
	'dacm_s_ch_coarse':  BEGIN
		dacm_s_ch_coarse_a	=	 dblarr(num_records1) ; 91
		dacm_s_ch_coarse_a[*] = !values.d_nan ; 91
		END
	'dacm_s_ch_fine':  BEGIN
		dacm_s_ch_fine_a	= dblarr(num_records1) ; 92
		dacm_s_ch_fine_a[*] = !values.d_nan ; 92
		END
	'dacm_s_ch_tap_coarse':  BEGIN
		dacm_s_ch_tap_coarse_a	= dblarr(num_records1) ; 93
		dacm_s_ch_tap_coarse_a[*] = !values.d_nan ; 93
		END
	'dacm_s_ch_tap_fine':  BEGIN
		dacm_s_ch_tap_fine_a	= 	dblarr(num_records1) ; 94
		dacm_s_ch_tap_fine_a[*] = !values.d_nan ; 94
		END
	'dacm_dfl_1_coarse':  BEGIN
		dacm_dfl_1_coarse_a	= 	dblarr(num_records1) ; 95
		dacm_dfl_1_coarse_a[*] = !values.d_nan ; 95
		END
	'dacm_dfl_1_fine':  BEGIN
		dacm_dfl_1_fine_a	= dblarr(num_records1) ; 96
		dacm_dfl_1_fine_a[*] = !values.d_nan ; 96
		END
	'dacm_dfl_1_dfine':  BEGIN
		dacm_dfl_1_dfine_a	=	 dblarr(num_records1) ; 97
		dacm_dfl_1_dfine_a[*] = !values.d_nan ; 97
		END
	'dacm_dfl_2_coarse':  BEGIN
		dacm_dfl_2_coarse_a	= dblarr(num_records1) ; 98
		dacm_dfl_2_coarse_a[*] = !values.d_nan ; 98
		END
	'dacm_dfl_2_fine':  BEGIN
		dacm_dfl_2_fine_a	= dblarr(num_records1) ; 99
		dacm_dfl_2_fine_a[*] = !values.d_nan ; 99
		END
	'dacm_dfl_2_dfine':  BEGIN
		dacm_dfl_2_dfine_a	=	 dblarr(num_records1) ; 100
		dacm_dfl_2_dfine_a[*] = !values.d_nan ; 100
		END
	'dacr_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
		dacr_pac_mcp_ssd_ctl_mcp_limit_a	=	 dblarr(num_records1) ; 101
		dacr_pac_mcp_ssd_ctl_mcp_limit_a[*] = !values.d_nan ; 101
		END
	'dacr_pac_limit':  BEGIN
		dacr_pac_limit_a	= dblarr(num_records1) ; 102
		dacr_pac_limit_a[*] = !values.d_nan ; 102
		END
	'dacr_esa_ctl':  BEGIN
		dacr_esa_ctl_a	= dblarr(num_records1) ; 103
		dacr_esa_ctl_a[*] = !values.d_nan ; 103
		END
	'dacr_s_ch_ctl':  BEGIN
		dacr_s_ch_ctl_a	= 	dblarr(num_records1) ; 104
		dacr_s_ch_ctl_a[*] = !values.d_nan ; 104
		END
	'dacr_dfl_1_ctl':  BEGIN
		dacr_dfl_1_ctl_a	= 	dblarr(num_records1) ; 105
		dacr_dfl_1_ctl_a[*] = !values.d_nan ; 105
		END
	'dacr_dfl_2_ctl':  BEGIN
		dacr_dfl_2_ctl_a	= dblarr(num_records1) ; 106
		dacr_dfl_2_ctl_a[*] = !values.d_nan ; 106
		END
	'dacr_control':  BEGIN
		dacr_control_a	=	 dblarr(num_records1) ; 107
		dacr_control_a[*] = !values.d_nan ; 107
		END
	'dacr_status':  BEGIN
		dacr_status_a	= dblarr(num_records1) ; 108
		dacr_status_a[*] = !values.d_nan ; 108
		END
	'dacr_adc_lu_ctr':  BEGIN
		dacr_adc_lu_ctr_a	= dblarr(num_records1) ; 109
		dacr_adc_lu_ctr_a[*] = !values.d_nan ; 109
		END
	'dacr_dfl_1_offset':  BEGIN
		dacr_dfl_1_offset_a	=	 dblarr(num_records1) ; 110
		dacr_dfl_1_offset_a[*] = !values.d_nan ; 110
		END
	'dacr_dfl_2_offset':  BEGIN
		dacr_dfl_2_offset_a	=	 dblarr(num_records1) ; 111
		dacr_dfl_2_offset_a[*] = !values.d_nan ; 111
		END
	'dacr_c_pac_coarse':  BEGIN
		dacr_c_pac_coarse_a	= dblarr(num_records1) ; 112
		dacr_c_pac_coarse_a[*] = !values.d_nan ; 112
		END
	'dacr_c_pac_fine':  BEGIN
		dacr_c_pac_fine_a	= dblarr(num_records1) ; 113
		dacr_c_pac_fine_a[*] = !values.d_nan ; 113
		END
	'dacr_c_pac_cm_fs_coarse':  BEGIN
		dacr_c_pac_cm_fs_coarse_a	= 	dblarr(num_records1) ; 114
		dacr_c_pac_cm_fs_coarse_a[*] = !values.d_nan ; 114
		END
	'dacr_c_pac_cm_fs_fine':  BEGIN
		dacr_c_pac_cm_fs_fine_a	= 	dblarr(num_records1) ; 115
		dacr_c_pac_cm_fs_fine_a[*] = !values.d_nan ; 115
		END
	'dacr_c_mcp_coarse':  BEGIN
		dacr_c_mcp_coarse_a	= dblarr(num_records1) ; 116
		dacr_c_mcp_coarse_a[*] = !values.d_nan ; 116
		END
	'dacr_c_mcp_fine':  BEGIN
		dacr_c_mcp_fine_a	=	 dblarr(num_records1) ; 117
		dacr_c_mcp_fine_a[*] = !values.d_nan ; 117
		END
	'dacr_c_mcp_cm_fs_coarse':  BEGIN
		dacr_c_mcp_cm_fs_coarse_a	= dblarr(num_records1) ; 118
		dacr_c_mcp_cm_fs_coarse_a[*] = !values.d_nan ; 118
		END
	'dacr_c_mcp_cm_fs_fine':  BEGIN
		dacr_c_mcp_cm_fs_fine_a	= dblarr(num_records1) ; 119
		dacr_c_mcp_cm_fs_fine_a[*] = !values.d_nan ; 119
		END
	'dacr_c_ssd_coarse':  BEGIN
		dacr_c_ssd_coarse_a	=	 dblarr(num_records1) ; 120
		dacr_c_ssd_coarse_a[*] = !values.d_nan ; 120
		END
	'dacr_c_ssd_fine':  BEGIN
		dacr_c_ssd_fine_a	=	 dblarr(num_records1) ; 121
		dacr_c_ssd_fine_a[*] = !values.d_nan ; 121
		END
	'dacr_c_esa_coarse':  BEGIN
		dacr_c_esa_coarse_a	= dblarr(num_records1) ; 122
		dacr_c_esa_coarse_a[*] = !values.d_nan ; 122
		END
	'dacr_c_esa_fine':  BEGIN
		dacr_c_esa_fine_a	= dblarr(num_records1) ; 123
		dacr_c_esa_fine_a[*] = !values.d_nan ; 123
		END
	'dacr_c_s_ch_coarse':  BEGIN
		dacr_c_s_ch_coarse_a	= 	dblarr(num_records1) ; 124
		dacr_c_s_ch_coarse_a[*] = !values.d_nan ; 124
		END
	'dacr_c_s_ch_fine':  BEGIN
		dacr_c_s_ch_fine_a	= 	dblarr(num_records1) ; 125
		dacr_c_s_ch_fine_a[*] = !values.d_nan ; 125
		END
	'dacr_c_s_ch_tap_coarse':  BEGIN
		dacr_c_s_ch_tap_coarse_a	= dblarr(num_records1) ; 126
		dacr_c_s_ch_tap_coarse_a[*] = !values.d_nan ; 126
		END
	'dacr_c_s_ch_tap_fine':  BEGIN
		dacr_c_s_ch_tap_fine_a	=	 dblarr(num_records1) ; 127
		dacr_c_s_ch_tap_fine_a[*] = !values.d_nan ; 127
		END
	'dacr_dfl_1_coarse':  BEGIN
		dacr_dfl_1_coarse_a	= dblarr(num_records1) ; 128
		dacr_dfl_1_coarse_a[*] = !values.d_nan ; 128
		END
	'dacr_dfl_1_fine':  BEGIN
		dacr_dfl_1_fine_a	= dblarr(num_records1) ; 129
		dacr_dfl_1_fine_a[*] = !values.d_nan; 129
		END
	'dacr_dfl_1_dfine':  BEGIN
		dacr_dfl_1_dfine_a	=	 dblarr(num_records1) ; 130
		dacr_dfl_1_dfine_a[*] = !values.d_nan; 130
		END
	'dacr_dfl_2_coarse':  BEGIN
		dacr_dfl_2_coarse_a	=	 dblarr(num_records1) ; 131
		dacr_dfl_2_coarse_a[*] = !values.d_nan ; 131
		END
	'dacr_dfl_2_fine':  BEGIN
		dacr_dfl_2_fine_a	= dblarr(num_records1) ; 132
		dacr_dfl_2_fine_a[*] = !values.d_nan; 132
		END
	'dacr_dfl_2_dfine':  BEGIN
		dacr_dfl_2_dfine_a	= dblarr(num_records1) ; 133
		dacr_dfl_2_dfine_a[*] = !values.d_nan ; 133
		END
	'sw_status1':  BEGIN
		sw_status1_a	= 	dblarr(num_records1) ; 134
		sw_status1_a[*] = !values.d_nan ; 134
		END
	'sw_hv_ramp_status':  BEGIN
		sw_hv_ramp_status_a	= 	dblarr(num_records1) ; 135
		sw_hv_ramp_status_a[*] = !values.d_nan; 135
		END
	'sw_hv_enable_status':  BEGIN
		sw_hv_enable_status_a	= dblarr(num_records1) ; 136
		sw_hv_enable_status_a[*] = !values.d_nan ; 136
		END
	'sw_hv_limit_status':  BEGIN
		sw_hv_limit_status_a	=	 dblarr(num_records1) ; 137
		sw_hv_limit_status_a[*] = !values.d_nan ; 137
		END
	'sw_eepromchksum':  BEGIN
		sw_eepromchksum_a	= dblarr(num_records1) ; 138
		sw_eepromchksum_a[*] = !values.d_nan ; 138
		END
	'hkp_sampletime':  BEGIN
		hkp_sampletime_a	= dblarr(num_records1) ; 139
		hkp_sampletime_a[*] = !values.d_nan ; 139
		END
	'pac_discharge_status':  BEGIN
		pac_discharge_status_a	=	 dblarr(num_records1) ; 140
		pac_discharge_status_a[*] = !values.d_nan ; 140
		END
	'pac_discharge_cnt':  BEGIN
		pac_discharge_cnt_a	=	 dblarr(num_records1) ; 141
		pac_discharge_cnt_a[*] = !values.d_nan ; 141
		END
	'pac_discharge_conseccntr':  BEGIN
		pac_discharge_conseccntr_a	= dblarr(num_records1) ; 142
		pac_discharge_conseccntr_a[*] = !values.d_nan ; 142
		END
	'pac_discharge_safe_att':  BEGIN
		pac_discharge_safe_att_a	= dblarr(num_records1) ; 143
		pac_discharge_safe_att_a[*] = !values.d_nan ; 143
		END
	'analog_limit_status':  BEGIN
		analog_limit_status_a	= 	dblarr(num_records1) ; 144
		analog_limit_status_a[*] = !values.d_nan ; 144
		END
	'analog_lim_pt1_status':  BEGIN
		analog_lim_pt1_status_a	= 	dblarr(num_records1) ; 145
		analog_lim_pt1_status_a[*] = !values.d_nan ; 145
		END
	'analog_lim_pt1_id':  BEGIN
		analog_lim_pt1_id_a	= dblarr(num_records1) ; 146
		analog_lim_pt1_id_a[*] = !values.d_nan ; 146
		END
	'analog_lim_pt1_red':  BEGIN
		analog_lim_pt1_red_a	=	 dblarr(num_records1) ; 147
		analog_lim_pt1_red_a[*] = !values.d_nan ; 147
		END
	'analog_lim_pt2_status':  BEGIN
		analog_lim_pt2_status_a	= dblarr(num_records1) ; 148
		analog_lim_pt2_status_a[*] = !values.d_nan ; 148
		END
	'analog_lim_pt2_id':  BEGIN
		analog_lim_pt2_id_a	= dblarr(num_records1) ; 149
		analog_lim_pt2_id_a[*] = !values.d_nan ; 149
		END
	'analog_lim_pt2_red':  BEGIN
		analog_lim_pt2_red_a	=	 dblarr(num_records1) ; 150
		analog_lim_pt2_red_a[*] = !values.d_nan ; 150
		END
	'analog_lim_pt3_status':  BEGIN
		analog_lim_pt3_status_a	=	 dblarr(num_records1) ; 151
		analog_lim_pt3_status_a[*] = !values.d_nan ; 151
		END
	'analog_lim_pt3_id':  BEGIN
		analog_lim_pt3_id_a	= dblarr(num_records1) ; 152
		analog_lim_pt3_id_a[*] = !values.d_nan ; 152
		END
	'analog_lim_pt3_red':  BEGIN
		analog_lim_pt3_red_a	= dblarr(num_records1) ; 153
		analog_lim_pt3_red_a[*] = !values.d_nan ; 153
		END
	'analog_lim_pt4_status':  BEGIN
		analog_lim_pt4_status_a	= 	dblarr(num_records1) ; 154
		analog_lim_pt4_status_a[*] = !values.d_nan ; 154
		END
	'analog_lim_pt4_id':  BEGIN
		analog_lim_pt4_id_a	= 	dblarr(num_records1) ; 155
		analog_lim_pt4_id_a[*] = !values.d_nan ; 155
		END
	'analog_lim_pt4_red':  BEGIN
		analog_lim_pt4_red_a	= dblarr(num_records1) ; 156
		analog_lim_pt4_red_a[*] = !values.d_nan ; 156
		END
	'analog_lim_pt5_status':  BEGIN
		analog_lim_pt5_status_a	=	 dblarr(num_records1) ; 157
		analog_lim_pt5_status_a[*] = !values.d_nan ; 157
		END
	'analog_lim_pt5_id':  BEGIN
		analog_lim_pt5_id_a	= dblarr(num_records1) ; 158
		analog_lim_pt5_id_a[*] = !values.d_nan ; 158
		END
	'analog_lim_pt5_red':  BEGIN
		analog_lim_pt5_red_a	= dblarr(num_records1) ; 159
		analog_lim_pt5_red_a[*] = !values.d_nan ; 159
		END
	'analog_lim_pt6_status':  BEGIN
		analog_lim_pt6_status_a	=	 dblarr(num_records1) ; 160
		analog_lim_pt6_status_a[*] = !values.d_nan ; 160
		END
	'analog_lim_pt6_id':  BEGIN
		analog_lim_pt6_id_a	=	 dblarr(num_records1) ; 161
		analog_lim_pt6_id_a[*] = !values.d_nan ; 161
		END
	'analog_lim_pt6_red':  BEGIN
		analog_lim_pt6_red_a	= dblarr(num_records1) ; 162
		analog_lim_pt6_red_a[*] = !values.d_nan ; 162
		END
	'analog_lim_pt7_status':  BEGIN
		analog_lim_pt7_status_a	= dblarr(num_records1) ; 163
		analog_lim_pt7_status_a[*] = !values.d_nan ; 163
		END
	'analog_lim_pt7_id':  BEGIN
		analog_lim_pt7_id_a	= 	dblarr(num_records1) ; 164
		analog_lim_pt7_id_a[*] = !values.d_nan ; 164
		END
	'analog_lim_pt7_red':  BEGIN
		analog_lim_pt7_red_a	= 	dblarr(num_records1) ; 165
		analog_lim_pt7_red_a[*] = !values.d_nan ; 165
		END
	'analog_lim_pt8_status':  BEGIN
		analog_lim_pt8_status_a	= dblarr(num_records1) ; 166
		analog_lim_pt8_status_a[*] = !values.d_nan ; 166
		END
	'analog_lim_pt8_id':  BEGIN
		analog_lim_pt8_id_a	=	 dblarr(num_records1) ; 167
		analog_lim_pt8_id_a[*] = !values.d_nan ; 167
		END
	'analog_lim_pt8_red':  BEGIN
		analog_lim_pt8_red_a	= dblarr(num_records1) ; 168
		analog_lim_pt8_red_a[*] = !values.d_nan ; 168
		END
	'analog_lim_pt9_status':  BEGIN
		analog_lim_pt9_status_a	= dblarr(num_records1) ; 169
		analog_lim_pt9_status_a[*] = !values.d_nan ; 169
		END
	'analog_lim_pt9_id':  BEGIN
		analog_lim_pt9_id_a	=	 dblarr(num_records1) ; 170
		analog_lim_pt9_id_a[*] = !values.d_nan ; 170
		END
	'analog_lim_pt9_red':  BEGIN
		analog_lim_pt9_red_a	=	 dblarr(num_records1) ; 171
		analog_lim_pt9_red_a[*] = !values.d_nan ; 171
		END
	'analog_lim_pt10_status':  BEGIN
		analog_lim_pt10_status_a	= dblarr(num_records1) ; 172
		analog_lim_pt10_status_a[*] = !values.d_nan ; 172
		END
	'analog_lim_pt10_id':  BEGIN
		analog_lim_pt10_id_a	= dblarr(num_records1) ; 173
		analog_lim_pt10_id_a[*] = !values.d_nan ; 173
		END
	'analog_lim_pt10_red':  BEGIN
		analog_lim_pt10_red_a	= 	dblarr(num_records1) ; 174
		analog_lim_pt10_red_a[*] = !values.d_nan ; 174
		END
	'analog_lim_pt11_status':  BEGIN
		analog_lim_pt11_status_a	= 	dblarr(num_records1) ; 175
		analog_lim_pt11_status_a[*] = !values.d_nan ; 175
		END
	'analog_lim_pt11_id':  BEGIN
		analog_lim_pt11_id_a	= dblarr(num_records1) ; 176
		analog_lim_pt11_id_a[*] = !values.d_nan ; 176
		END
	'analog_lim_pt11_red':  BEGIN
		analog_lim_pt11_red_a	=	 dblarr(num_records1) ; 177
		analog_lim_pt11_red_a[*] = !values.d_nan ; 177
		END
	'analog_lim_pt12_status':  BEGIN
		analog_lim_pt12_status_a	= dblarr(num_records1) ; 178
		analog_lim_pt12_status_a[*] = !values.d_nan ; 178
		END
	'analog_lim_pt12_id':  BEGIN
		analog_lim_pt12_id_a	= dblarr(num_records1) ; 179
		analog_lim_pt12_id_a[*] = !values.d_nan ; 179
		END
	'analog_lim_pt12_red':  BEGIN
		analog_lim_pt12_red_a	=	 dblarr(num_records1) ; 180
		analog_lim_pt12_red_a[*] = !values.d_nan ; 180
		END
	'analog_lim_pt13_status':  BEGIN
		analog_lim_pt13_status_a	=	 dblarr(num_records1) ; 181
		analog_lim_pt13_status_a[*] = !values.d_nan ; 181
		END
	'analog_lim_pt13_id':  BEGIN
		analog_lim_pt13_id_a	= dblarr(num_records1) ; 182
		analog_lim_pt13_id_a[*] = !values.d_nan ; 182
		END
	'analog_lim_pt13_red':  BEGIN
		analog_lim_pt13_red_a	= dblarr(num_records1) ; 183
		analog_lim_pt13_red_a[*] = !values.d_nan ; 183
		END
	'analog_lim_pt14_status':  BEGIN
		analog_lim_pt14_status_a	= 	dblarr(num_records1) ; 184
		analog_lim_pt14_status_a[*] = !values.d_nan ; 184
		END
	'analog_lim_pt14_id':  BEGIN
		analog_lim_pt14_id_a	= 	dblarr(num_records1) ; 185
		analog_lim_pt14_id_a[*] = !values.d_nan ; 185
		END
	'analog_lim_pt14_red':  BEGIN
		analog_lim_pt14_red_a	= dblarr(num_records1) ; 186
		analog_lim_pt14_red_a[*] = !values.d_nan; 186
		END
	'analog_lim_pt15_status':  BEGIN
		analog_lim_pt15_status_a	=	 dblarr(num_records1) ; 187
		analog_lim_pt15_status_a[*] = !values.d_nan ; 187
		END
	'analog_lim_pt15_id':  BEGIN
		analog_lim_pt15_id_a	= dblarr(num_records1) ; 188
		analog_lim_pt15_id_a[*] = !values.d_nan ; 188
		END
	'analog_lim_pt15_red':  BEGIN
		analog_lim_pt15_red_a	= dblarr(num_records1) ; 189
		analog_lim_pt15_red_a[*] = !values.d_nan ; 189
		END
	'opmode':  BEGIN
		opmode_a	=	 dblarr(num_records1) ; 190
		opmode_a[*] = !values.d_nan ; 190
		END
	'sw_mode':  BEGIN
		sw_mode_a	=	 dblarr(num_records1) ; 191
		sw_mode_a[*] = !values.d_nan ; 191
		END
	'proton_mode':  BEGIN
		proton_mode_a	= dblarr(num_records1) ; 192
		proton_mode_a[*] = !values.d_nan ; 192
		END
	'active_supplyid':  BEGIN
		active_supplyid_a	= dblarr(num_records1) ; 193
		active_supplyid_a[*] = !values.d_nan ; 193
		END
	'supply_coarse_rb':  BEGIN
		supply_coarse_rb_a	= 	dblarr(num_records1) ; 194
		supply_coarse_rb_a[*] = !values.d_nan ; 194
		END
	'supply_fine_rb':  BEGIN
		supply_fine_rb_a	= 	dblarr(num_records1) ; 195
		supply_fine_rb_a[*] = !values.d_nan ; 195
		END
	'swmaint_supplystat':  BEGIN
		swmaint_supplystat_a	= dblarr(num_records1) ; 196
		swmaint_supplystat_a[*] = !values.d_nan ; 196
		END
	'swmaint_pac_coarse':  BEGIN
		swmaint_pac_coarse_a	=	 dblarr(num_records1) ; 197
		swmaint_pac_coarse_a[*] = !values.d_nan ; 197
		END
	'swmaint_pac_fine':  BEGIN
		swmaint_pac_fine_a	= dblarr(num_records1) ; 198		
		swmaint_pac_fine_a[*] = !values.d_nan ; 198
		END
	ENDCASE
	ENDFOR
    	END 
    'B': BEGIN 

	FOR kk=0,n_elements(products)-1 DO BEGIN
	CASE products[kk] OF
	
	'dpu_sw_version':  BEGIN
		dpu_sw_version_b	= dblarr(num_records1) ; 0
		dpu_sw_version_b[*] = !values.d_nan ; 0
		END
	'cmd_rcvd_cnt':  BEGIN
		cmd_rcvd_cnt_b	= dblarr(num_records1) ; 1
		cmd_rcvd_cnt_b[*] = !values.d_nan ; 1
		END
	'cmd_exec_cnt':  BEGIN
		cmd_exec_cnt_b	= dblarr(num_records1) ; 2
		cmd_exec_cnt_b[*] = !values.d_nan ; 2
		END
	'cmd_total_err_cnt':  BEGIN
		cmd_total_err_cnt_b	= dblarr(num_records1) ; 3
		cmd_total_err_cnt_b[*] = !values.d_nan ; 3
		END
	'cmd_parity_err_cnt':  BEGIN
		cmd_parity_err_cnt_b	= dblarr(num_records1) ; 4
		cmd_parity_err_cnt_b[*] = !values.d_nan ; 4
		END
	'cmd_frame_err_cnt':  BEGIN
		cmd_frame_err_cnt_b	= dblarr(num_records1) ; 5
		cmd_frame_err_cnt_b[*] = !values.d_nan ; 5
		END
	'cmd_illegal_err_cnt':  BEGIN
		cmd_illegal_err_cnt_b	= dblarr(num_records1) ; 6
		cmd_illegal_err_cnt_b[*] = !values.d_nan ; 6
		END
	'ic_status_reg':  BEGIN
		ic_status_reg_b	= dblarr(num_records1) ; 7
		ic_status_reg_b[*] = !values.d_nan ; 7
		END
	'ic_ctl_reg':  BEGIN
		ic_ctl_reg_b	= dblarr(num_records1) ; 8
		ic_ctl_reg_b[*] = !values.d_nan ; 8
		END
	'lbc_reset_ctl':  BEGIN
		lbc_reset_ctl_b	= dblarr(num_records1) ; 9
		lbc_reset_ctl_b[*] = !values.d_nan ; 9
		END
	'lbc_mode_ctl':  BEGIN
		lbc_mode_ctl_b	= dblarr(num_records1) ; 10
		lbc_mode_ctl_b[*] = !values.d_nan ; 10
		END
	'lbc_logic_ctl_a':  BEGIN
		lbc_logic_ctl_a_b	= dblarr(num_records1) ; 11
		lbc_logic_ctl_a_b[*] = !values.d_nan ; 11
		END
	'lbc_logic_ctl_b':  BEGIN
		lbc_logic_ctl_b_b	= dblarr(num_records1) ; 12
		lbc_logic_ctl_b_b[*] = !values.d_nan ; 12
		END
	'lbc_tac_pwr_ctl':  BEGIN
		lbc_tac_pwr_ctl_b	= dblarr(num_records1) ; 13
		lbc_tac_pwr_ctl_b[*] = !values.d_nan ; 13
		END
	'lbc_reg_seq':  BEGIN
		lbc_reg_seq_b	= dblarr(num_records1) ; 14
		lbc_reg_seq_b[*] = !values.d_nan ; 14
		END
	'lbc_event_ctl':  BEGIN
		lbc_event_ctl_b	= dblarr(num_records1) ; 15
		lbc_event_ctl_b[*] = !values.d_nan ; 15
		END
	'lbc_rlim_ch':  BEGIN
		lbc_rlim_ch_b	= dblarr(num_records1) ; 16
		lbc_rlim_ch_b[*] = !values.d_nan ; 16
		END
	'lbc_rlim_hi':  BEGIN
		lbc_rlim_hi_b	= dblarr(num_records1) ; 17
		lbc_rlim_hi_b[*] = !values.d_nan ; 17
		END
	'lbc_rlim_lo':  BEGIN
		lbc_rlim_lo_b	= dblarr(num_records1) ; 18
		lbc_rlim_lo_b[*] = !values.d_nan ; 18
		END
	'lbe_pos_ctrl':  BEGIN
		lbe_pos_ctrl_b	= dblarr(num_records1) ; 19
		lbe_pos_ctrl_b[*] = !values.d_nan ; 19
		END
	'lbe_pos_disable0':  BEGIN
		lbe_pos_disable0_b	= dblarr(num_records1) ; 20
		lbe_pos_disable0_b[*] = !values.d_nan ; 20
		END
	'lbe_pos_disable2':  BEGIN
		lbe_pos_disable2_b	= dblarr(num_records1) ; 21
		lbe_pos_disable2_b[*] = !values.d_nan ; 21
		END
	'lbe_tac0_ctrl':  BEGIN
		lbe_tac0_ctrl_b	= dblarr(num_records1) ; 22
		lbe_tac0_ctrl_b[*] = !values.d_nan ; 22
		END
	'lbe_tac0_dac':  BEGIN
		lbe_tac0_dac_b	= dblarr(num_records1) ; 23
		lbe_tac0_dac_b[*] = !values.d_nan ; 23
		END
	'lbe_tac2_ctrl':  BEGIN
		lbe_tac2_ctrl_b	= dblarr(num_records1) ; 24
		lbe_tac2_ctrl_b[*] = !values.d_nan ; 24
		END
	'lbe_tac2_dac':  BEGIN
		lbe_tac2_dac_b	= dblarr(num_records1) ; 25
		lbe_tac2_dac_b[*] = !values.d_nan ; 25
		END
	'lbe_tac0_under_hi':  BEGIN
		lbe_tac0_under_hi_b	= dblarr(num_records1) ; 26
		lbe_tac0_under_hi_b[*] = !values.d_nan ; 26
		END
	'lbe_tac0_under_lo':  BEGIN
		lbe_tac0_under_lo_b	= dblarr(num_records1) ; 27
		lbe_tac0_under_lo_b[*] = !values.d_nan ; 27
		END
	'lbe_tac0_over_hi':  BEGIN
		lbe_tac0_over_hi_b	= dblarr(num_records1) ; 28
		lbe_tac0_over_hi_b[*] = !values.d_nan ; 28
		END
	'lbe_tac0_over_lo':  BEGIN
		lbe_tac0_over_lo_b	= dblarr(num_records1) ; 29
		lbe_tac0_over_lo_b[*] = !values.d_nan ; 29
		END
	'lbe_tac2_under_hi':  BEGIN
		lbe_tac2_under_hi_b	= dblarr(num_records1) ; 30
		lbe_tac2_under_hi_b[*] = !values.d_nan ; 30
		END
	'lbe_tac2_under_lo':  BEGIN
		lbe_tac2_under_lo_b	= dblarr(num_records1) ; 31
		lbe_tac2_under_lo_b[*] = !values.d_nan ; 31
		END
	'lbe_tac2_over_hi':  BEGIN
		lbe_tac2_over_hi_b	= dblarr(num_records1) ; 32
		lbe_tac2_over_hi_b[*] = !values.d_nan ; 32
		END
	'lbe_tac2_over_lo':  BEGIN
		lbe_tac2_over_lo_b	= dblarr(num_records1) ; 33
		lbe_tac2_over_lo_b[*] = !values.d_nan ; 33
		END
	'lbe_ssd_ctrl':  BEGIN
		lbe_ssd_ctrl_b	= dblarr(num_records1) ; 34
		lbe_ssd_ctrl_b[*] = !values.d_nan ; 34
		END
	'lbe_ssd_cmd_h':  BEGIN
		lbe_ssd_cmd_h_b	= dblarr(num_records1) ; 35
		lbe_ssd_cmd_h_b[*] = !values.d_nan ; 35
		END
	'lbe_ssd_cmd_l':  BEGIN
		lbe_ssd_cmd_l_b	= dblarr(num_records1) ; 36
		lbe_ssd_cmd_l_b[*] = !values.d_nan ; 36
		END
	'lbe_ssd_dis':  BEGIN
		lbe_ssd_dis_b	= dblarr(num_records1) ; 37
		lbe_ssd_dis_b[*] = !values.d_nan ; 37
		END
	'lbe_ssd_under_hi':  BEGIN
		lbe_ssd_under_hi_b	= dblarr(num_records1) ; 38
		lbe_ssd_under_hi_b[*] = !values.d_nan ; 38
		END
	'lbe_ssd_under_lo':  BEGIN
		lbe_ssd_under_lo_b	= dblarr(num_records1) ; 39
		lbe_ssd_under_lo_b[*] = !values.d_nan ; 39
		END
	'lbe_ssd_over_hi':  BEGIN
		lbe_ssd_over_hi_b	= dblarr(num_records1) ; 40
		lbe_ssd_over_hi_b[*] = !values.d_nan ; 40
		END
	'lbe_ssd_over_lo':  BEGIN
		lbe_ssd_over_lo_b	= dblarr(num_records1) ; 41
		lbe_ssd_over_lo_b[*] = !values.d_nan ; 41
		END
	'lbe_sel_ctrl':  BEGIN
		lbe_sel_ctrl_b	= dblarr(num_records1) ; 42
		lbe_sel_ctrl_b[*] = !values.d_nan ; 42
		END
	'lbe_trig_mode':  BEGIN
		lbe_trig_mode_b	= dblarr(num_records1) ; 43
		lbe_trig_mode_b[*] = !values.d_nan ; 43
		END
	'lbe_esa_step':  BEGIN
		lbe_esa_step_b	= dblarr(num_records1) ; 44
		lbe_esa_step_b[*] = !values.d_nan ; 44
		END
	'lbe_defl_step':  BEGIN
		lbe_defl_step_b	= dblarr(num_records1) ; 45
		lbe_defl_step_b[*] = !values.d_nan ; 45
		END
	'lbe_ssd_offset0':  BEGIN
		lbe_ssd_offset0_b	= dblarr(num_records1) ; 46
		lbe_ssd_offset0_b[*] = !values.d_nan ; 46
		END
	'lbe_ssd_offset1':  BEGIN
		lbe_ssd_offset1_b	= dblarr(num_records1) ; 47
		lbe_ssd_offset1_b[*] = !values.d_nan ; 47
		END
	'lbe_ssd_offset2':  BEGIN
		lbe_ssd_offset2_b	= dblarr(num_records1) ; 48
		lbe_ssd_offset2_b[*] = !values.d_nan ; 48
		END
	'lbe_ssd_offset3':  BEGIN
		lbe_ssd_offset3_b	= dblarr(num_records1) ; 49
		lbe_ssd_offset3_b[*] = !values.d_nan ; 49
		END
	'lbe_ssd_offset4':  BEGIN
		lbe_ssd_offset4_b	= dblarr(num_records1) ; 50
		lbe_ssd_offset4_b[*] = !values.d_nan ; 50
		END
	'lbe_ssd_offset5':  BEGIN
		lbe_ssd_offset5_b	= dblarr(num_records1) ; 51
		lbe_ssd_offset5_b[*] = !values.d_nan; 51
		END
	'lbe_ssd_offset6':  BEGIN
		lbe_ssd_offset6_b	= dblarr(num_records1) ; 52
		lbe_ssd_offset6_b[*] = !values.d_nan ; 52
		END
	'lbe_ssd_offset7':  BEGIN
		lbe_ssd_offset7_b	= dblarr(num_records1) ; 53
		lbe_ssd_offset7_b[*] = !values.d_nan ; 53
		END
	'lbe_stim_enable':  BEGIN
		lbe_stim_enable_b	= dblarr(num_records1) ; 54
		lbe_stim_enable_b[*] = !values.d_nan ; 54
		END
	'lbe_stim_freq_hi':  BEGIN
		lbe_stim_freq_hi_b	= dblarr(num_records1) ; 55
		lbe_stim_freq_hi_b[*] = !values.d_nan ; 55
		END
	'lbe_stim_freq_lo':  BEGIN
		lbe_stim_freq_lo_b	= dblarr(num_records1) ; 56
		lbe_stim_freq_lo_b[*] = !values.d_nan ; 56
		END
	'lbe_sel0_window':  BEGIN
		lbe_sel0_window_b	= dblarr(num_records1) ; 57
		lbe_sel0_window_b[*] = !values.d_nan ; 57
		END
	'lbe_sel2_window':  BEGIN
		lbe_sel2_window_b	= dblarr(num_records1) ; 58
		lbe_sel2_window_b[*] = !values.d_nan ; 58
		END
	'lbe_ssd_offset8':  BEGIN
		lbe_ssd_offset8_b	= dblarr(num_records1) ; 59
		lbe_ssd_offset8_b[*] = !values.d_nan ; 59
		END
	'lbe_ssd_offset9':  BEGIN
		lbe_ssd_offset9_b	= dblarr(num_records1) ; 60
		lbe_ssd_offset9_b[*] = !values.d_nan ; 60
		END
	'lbe_ssd_offset10':  BEGIN
		lbe_ssd_offset10_b	= dblarr(num_records1) ; 61
		lbe_ssd_offset10_b[*] = !values.d_nan ; 61
		END
	'lbe_ssd_offset11':  BEGIN
		lbe_ssd_offset11_b	= dblarr(num_records1) ; 62
		lbe_ssd_offset11_b[*] = !values.d_nan ; 62
		END
	'lbe_ssd_offset12':  BEGIN
		lbe_ssd_offset12_b	= dblarr(num_records1) ; 63
		lbe_ssd_offset12_b[*] = !values.d_nan ; 63
		END
	'lbe_ssd_offset13':  BEGIN
		lbe_ssd_offset13_b	= dblarr(num_records1) ; 64
		lbe_ssd_offset13_b[*] = !values.d_nan ; 64
		END
	'lbe_ssd_offset14':  BEGIN
		lbe_ssd_offset14_b	= dblarr(num_records1) ; 65
		lbe_ssd_offset14_b[*] = !values.d_nan ; 65
		END
	'lbe_ssd_offset15':  BEGIN
		lbe_ssd_offset15_b	= dblarr(num_records1) ; 66
		lbe_ssd_offset15_b[*] = !values.d_nan ; 66
		END
	'lbe_pos_ra':  BEGIN
		lbe_pos_ra_b	=	 dblarr(num_records1) ; 67
		lbe_pos_ra_b[*] = !values.d_nan ; 67
		END
	'dacm_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
		dacm_pac_mcp_ssd_ctl_mcp_limit_b	= dblarr(num_records1) ; 68
		dacm_pac_mcp_ssd_ctl_mcp_limit_b[*] = !values.d_nan ; 68
		END
	'dacm_pac_limit':  BEGIN
		dacm_pac_limit_b	= dblarr(num_records1) ; 69
		dacm_pac_limit_b[*] = !values.d_nan ; 69
		END
	'dacm_esa_ctl':  BEGIN
		dacm_esa_ctl_b	=	 dblarr(num_records1) ; 70
		dacm_esa_ctl_b[*] = !values.d_nan ; 70
		END
	'dacm_s_ch_ctl':  BEGIN
		dacm_s_ch_ctl_b	=	 dblarr(num_records1) ; 71
		dacm_s_ch_ctl_b[*] = !values.d_nan ; 71
		END
	'dacm_dfl_1_ctl':  BEGIN
		dacm_dfl_1_ctl_b	= dblarr(num_records1) ; 72
		dacm_dfl_1_ctl_b[*] = !values.d_nan ; 72
		END
	'dacm_dfl_2_ctl':  BEGIN
		dacm_dfl_2_ctl_b	= dblarr(num_records1) ; 73
		dacm_dfl_2_ctl_b[*] = !values.d_nan ; 73
		END
	'dacm_control':  BEGIN
		dacm_control_b	= 	dblarr(num_records1) ; 74
		dacm_control_b[*] = !values.d_nan ; 74
		END
	'dacm_status':  BEGIN
		dacm_status_b	= 	dblarr(num_records1) ; 75
		dacm_status_b[*] = !values.d_nan ; 75
		END
	'dacm_adc_lu_ctr':  BEGIN
		dacm_adc_lu_ctr_b	= dblarr(num_records1) ; 76
		dacm_adc_lu_ctr_b[*] = !values.d_nan ; 76
		END
	'dacm_dfl_1_offset':  BEGIN
		dacm_dfl_1_offset_b	=	 dblarr(num_records1) ; 77
		dacm_dfl_1_offset_b[*] = !values.d_nan ; 77
		END
	'dacm_dfl_2_offset':  BEGIN
		dacm_dfl_2_offset_b	= dblarr(num_records1) ; 78
		dacm_dfl_2_offset_b[*] = !values.d_nan ; 78
		END
	'dacm_pac_coarse':  BEGIN
		dacm_pac_coarse_b	= dblarr(num_records1) ; 79
		dacm_pac_coarse_b[*] = !values.d_nan ; 79
		END
	'dacm_pac_fine':  BEGIN
		dacm_pac_fine_b	=	 dblarr(num_records1) ; 80
		dacm_pac_fine_b[*] = !values.d_nan ; 80
		END
	'dacm_pac_cm_fs_coarse':  BEGIN
		dacm_pac_cm_fs_coarse_b	=	 dblarr(num_records1) ; 81
		dacm_pac_cm_fs_coarse_b[*] = !values.d_nan ; 81
		END
	'dacm_pac_cm_fs_fine':  BEGIN
		dacm_pac_cm_fs_fine_b	= dblarr(num_records1) ; 82
		dacm_pac_cm_fs_fine_b[*] = !values.d_nan ; 82
		END
	'dacm_mcp_coarse':  BEGIN
		dacm_mcp_coarse_b	= dblarr(num_records1) ; 83
		dacm_mcp_coarse_b[*] = !values.d_nan ; 83
		END
	'dacm_mcp_fine':  BEGIN
		dacm_mcp_fine_b	= 	dblarr(num_records1) ; 84
		dacm_mcp_fine_b[*] = !values.d_nan ; 84
		END
	'dacm_mcp_cm_fs_coarse':  BEGIN
		dacm_mcp_cm_fs_coarse_b	= 	dblarr(num_records1) ; 85
		dacm_mcp_cm_fs_coarse_b[*] = !values.d_nan ; 85
		END
	'dacm_mcp_cm_fs_fine':  BEGIN
		dacm_mcp_cm_fs_fine_b	= dblarr(num_records1) ; 86
		dacm_mcp_cm_fs_fine_b[*] = !values.d_nan ; 86
		END
	'dacm_ssd_coarse':  BEGIN
		dacm_ssd_coarse_b	=	dblarr(num_records1) ; 87
		dacm_ssd_coarse_b[*] = !values.d_nan ; 87
		END
	'dacm_ssd_fine':  BEGIN
		dacm_ssd_fine_b	= dblarr(num_records1) ; 88
		dacm_ssd_fine_b[*] = !values.d_nan ; 88
		END
	'dacm_esa_coarse':  BEGIN
		dacm_esa_coarse_b	= dblarr(num_records1) ; 89
		dacm_esa_coarse_b[*] = !values.d_nan ; 89
		END
	'dacm_esa_fine':  BEGIN
		dacm_esa_fine_b	=	 dblarr(num_records1) ; 90
		dacm_esa_fine_b[*] = !values.d_nan ; 90
		END
	'dacm_s_ch_coarse':  BEGIN
		dacm_s_ch_coarse_b	=	 dblarr(num_records1) ; 91
		dacm_s_ch_coarse_b[*] = !values.d_nan ; 91
		END
	'dacm_s_ch_fine':  BEGIN
		dacm_s_ch_fine_b	= dblarr(num_records1) ; 92
		dacm_s_ch_fine_b[*] = !values.d_nan ; 92
		END
	'dacm_s_ch_tap_coarse':  BEGIN
		dacm_s_ch_tap_coarse_b	= dblarr(num_records1) ; 93
		dacm_s_ch_tap_coarse_b[*] = !values.d_nan ; 93
		END
	'dacm_s_ch_tap_fine':  BEGIN
		dacm_s_ch_tap_fine_b	= 	dblarr(num_records1) ; 94
		dacm_s_ch_tap_fine_b[*] = !values.d_nan ; 94
		END
	'dacm_dfl_1_coarse':  BEGIN
		dacm_dfl_1_coarse_b	= 	dblarr(num_records1) ; 95
		dacm_dfl_1_coarse_b[*] = !values.d_nan ; 95
		END
	'dacm_dfl_1_fine':  BEGIN
		dacm_dfl_1_fine_b	= dblarr(num_records1) ; 96
		dacm_dfl_1_fine_b[*] = !values.d_nan ; 96
		END
	'dacm_dfl_1_dfine':  BEGIN
		dacm_dfl_1_dfine_b	=	 dblarr(num_records1) ; 97
		dacm_dfl_1_dfine_b[*] = !values.d_nan ; 97
		END
	'dacm_dfl_2_coarse':  BEGIN
		dacm_dfl_2_coarse_b	= dblarr(num_records1) ; 98
		dacm_dfl_2_coarse_b[*] = !values.d_nan ; 98
		END
	'dacm_dfl_2_fine':  BEGIN
		dacm_dfl_2_fine_b	= dblarr(num_records1) ; 99
		dacm_dfl_2_fine_b[*] = !values.d_nan ; 99
		END
	'dacm_dfl_2_dfine':  BEGIN
		dacm_dfl_2_dfine_b	=	 dblarr(num_records1) ; 100
		dacm_dfl_2_dfine_b[*] = !values.d_nan ; 100
		END
	'dacr_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
		dacr_pac_mcp_ssd_ctl_mcp_limit_b	=	 dblarr(num_records1) ; 101
		dacr_pac_mcp_ssd_ctl_mcp_limit_b[*] = !values.d_nan ; 101
		END
	'dacr_pac_limit':  BEGIN
		dacr_pac_limit_b	= dblarr(num_records1) ; 102
		dacr_pac_limit_b[*] = !values.d_nan ; 102
		END
	'dacr_esa_ctl':  BEGIN
		dacr_esa_ctl_b	= dblarr(num_records1) ; 103
		dacr_esa_ctl_b[*] = !values.d_nan ; 103
		END
	'dacr_s_ch_ctl':  BEGIN
		dacr_s_ch_ctl_b	= 	dblarr(num_records1) ; 104
		dacr_s_ch_ctl_b[*] = !values.d_nan ; 104
		END
	'dacr_dfl_1_ctl':  BEGIN
		dacr_dfl_1_ctl_b	= 	dblarr(num_records1) ; 105
		dacr_dfl_1_ctl_b[*] = !values.d_nan ; 105
		END
	'dacr_dfl_2_ctl':  BEGIN
		dacr_dfl_2_ctl_b	= dblarr(num_records1) ; 106
		dacr_dfl_2_ctl_b[*] = !values.d_nan ; 106
		END
	'dacr_control':  BEGIN
		dacr_control_b	=	 dblarr(num_records1) ; 107
		dacr_control_b[*] = !values.d_nan ; 107
		END
	'dacr_status':  BEGIN
		dacr_status_b	= dblarr(num_records1) ; 108
		dacr_status_b[*] = !values.d_nan ; 108
		END
	'dacr_adc_lu_ctr':  BEGIN
		dacr_adc_lu_ctr_b	= dblarr(num_records1) ; 109
		dacr_adc_lu_ctr_b[*] = !values.d_nan ; 109
		END
	'dacr_dfl_1_offset':  BEGIN
		dacr_dfl_1_offset_b	=	 dblarr(num_records1) ; 110
		dacr_dfl_1_offset_b[*] = !values.d_nan ; 110
		END
	'dacr_dfl_2_offset':  BEGIN
		dacr_dfl_2_offset_b	=	 dblarr(num_records1) ; 111
		dacr_dfl_2_offset_b[*] = !values.d_nan ; 111
		END
	'dacr_c_pac_coarse':  BEGIN
		dacr_c_pac_coarse_b	= dblarr(num_records1) ; 112
		dacr_c_pac_coarse_b[*] = !values.d_nan ; 112
		END
	'dacr_c_pac_fine':  BEGIN
		dacr_c_pac_fine_b	= dblarr(num_records1) ; 113
		dacr_c_pac_fine_b[*] = !values.d_nan ; 113
		END
	'dacr_c_pac_cm_fs_coarse':  BEGIN
		dacr_c_pac_cm_fs_coarse_b	= 	dblarr(num_records1) ; 114
		dacr_c_pac_cm_fs_coarse_b[*] = !values.d_nan ; 114
		END
	'dacr_c_pac_cm_fs_fine':  BEGIN
		dacr_c_pac_cm_fs_fine_b	= 	dblarr(num_records1) ; 115
		dacr_c_pac_cm_fs_fine_b[*] = !values.d_nan ; 115
		END
	'dacr_c_mcp_coarse':  BEGIN
		dacr_c_mcp_coarse_b	= dblarr(num_records1) ; 116
		dacr_c_mcp_coarse_b[*] = !values.d_nan ; 116
		END
	'dacr_c_mcp_fine':  BEGIN
		dacr_c_mcp_fine_b	=	 dblarr(num_records1) ; 117
		dacr_c_mcp_fine_b[*] = !values.d_nan ; 117
		END
	'dacr_c_mcp_cm_fs_coarse':  BEGIN
		dacr_c_mcp_cm_fs_coarse_b	= dblarr(num_records1) ; 118
		dacr_c_mcp_cm_fs_coarse_b[*] = !values.d_nan ; 118
		END
	'dacr_c_mcp_cm_fs_fine':  BEGIN
		dacr_c_mcp_cm_fs_fine_b	= dblarr(num_records1) ; 119
		dacr_c_mcp_cm_fs_fine_b[*] = !values.d_nan ; 119
		END
	'dacr_c_ssd_coarse':  BEGIN
		dacr_c_ssd_coarse_b	=	 dblarr(num_records1) ; 120
		dacr_c_ssd_coarse_b[*] = !values.d_nan ; 120
		END
	'dacr_c_ssd_fine':  BEGIN
		dacr_c_ssd_fine_b	=	 dblarr(num_records1) ; 121
		dacr_c_ssd_fine_b[*] = !values.d_nan ; 121
		END
	'dacr_c_esa_coarse':  BEGIN
		dacr_c_esa_coarse_b	= dblarr(num_records1) ; 122
		dacr_c_esa_coarse_b[*] = !values.d_nan ; 122
		END
	'dacr_c_esa_fine':  BEGIN
		dacr_c_esa_fine_b	= dblarr(num_records1) ; 123
		dacr_c_esa_fine_b[*] = !values.d_nan ; 123
		END
	'dacr_c_s_ch_coarse':  BEGIN
		dacr_c_s_ch_coarse_b	= 	dblarr(num_records1) ; 124
		dacr_c_s_ch_coarse_b[*] = !values.d_nan ; 124
		END
	'dacr_c_s_ch_fine':  BEGIN
		dacr_c_s_ch_fine_b	= 	dblarr(num_records1) ; 125
		dacr_c_s_ch_fine_b[*] = !values.d_nan ; 125
		END
	'dacr_c_s_ch_tap_coarse':  BEGIN
		dacr_c_s_ch_tap_coarse_b	= dblarr(num_records1) ; 126
		dacr_c_s_ch_tap_coarse_b[*] = !values.d_nan ; 126
		END
	'dacr_c_s_ch_tap_fine':  BEGIN
		dacr_c_s_ch_tap_fine_b	=	 dblarr(num_records1) ; 127
		dacr_c_s_ch_tap_fine_b[*] = !values.d_nan ; 127
		END
	'dacr_dfl_1_coarse':  BEGIN
		dacr_dfl_1_coarse_b	= dblarr(num_records1) ; 128
		dacr_dfl_1_coarse_b[*] = !values.d_nan ; 128
		END
	'dacr_dfl_1_fine':  BEGIN
		dacr_dfl_1_fine_b	= dblarr(num_records1) ; 129
		dacr_dfl_1_fine_b[*] = !values.d_nan; 129
		END
	'dacr_dfl_1_dfine':  BEGIN
		dacr_dfl_1_dfine_b	=	 dblarr(num_records1) ; 130
		dacr_dfl_1_dfine_b[*] = !values.d_nan; 130
		END
	'dacr_dfl_2_coarse':  BEGIN
		dacr_dfl_2_coarse_b	=	 dblarr(num_records1) ; 131
		dacr_dfl_2_coarse_b[*] = !values.d_nan ; 131
		END
	'dacr_dfl_2_fine':  BEGIN
		dacr_dfl_2_fine_b	= dblarr(num_records1) ; 132
		dacr_dfl_2_fine_b[*] = !values.d_nan; 132
		END
	'dacr_dfl_2_dfine':  BEGIN
		dacr_dfl_2_dfine_b	= dblarr(num_records1) ; 133
		dacr_dfl_2_dfine_b[*] = !values.d_nan ; 133
		END
	'sw_status1':  BEGIN
		sw_status1_b	= 	dblarr(num_records1) ; 134
		sw_status1_b[*] = !values.d_nan ; 134
		END
	'sw_hv_ramp_status':  BEGIN
		sw_hv_ramp_status_b	= 	dblarr(num_records1) ; 135
		sw_hv_ramp_status_b[*] = !values.d_nan; 135
		END
	'sw_hv_enable_status':  BEGIN
		sw_hv_enable_status_b	= dblarr(num_records1) ; 136
		sw_hv_enable_status_b[*] = !values.d_nan ; 136
		END
	'sw_hv_limit_status':  BEGIN
		sw_hv_limit_status_b	=	 dblarr(num_records1) ; 137
		sw_hv_limit_status_b[*] = !values.d_nan ; 137
		END
	'sw_eepromchksum':  BEGIN
		sw_eepromchksum_b	= dblarr(num_records1) ; 138
		sw_eepromchksum_b[*] = !values.d_nan ; 138
		END
	'hkp_sampletime':  BEGIN
		hkp_sampletime_b	= dblarr(num_records1) ; 139
		hkp_sampletime_b[*] = !values.d_nan ; 139
		END
	'pac_discharge_status':  BEGIN
		pac_discharge_status_b	=	 dblarr(num_records1) ; 140
		pac_discharge_status_b[*] = !values.d_nan ; 140
		END
	'pac_discharge_cnt':  BEGIN
		pac_discharge_cnt_b	=	 dblarr(num_records1) ; 141
		pac_discharge_cnt_b[*] = !values.d_nan ; 141
		END
	'pac_discharge_conseccntr':  BEGIN
		pac_discharge_conseccntr_b	= dblarr(num_records1) ; 142
		pac_discharge_conseccntr_b[*] = !values.d_nan ; 142
		END
	'pac_discharge_safe_att':  BEGIN
		pac_discharge_safe_att_b	= dblarr(num_records1) ; 143
		pac_discharge_safe_att_b[*] = !values.d_nan ; 143
		END
	'analog_limit_status':  BEGIN
		analog_limit_status_b	= 	dblarr(num_records1) ; 144
		analog_limit_status_b[*] = !values.d_nan ; 144
		END
	'analog_lim_pt1_status':  BEGIN
		analog_lim_pt1_status_b	= 	dblarr(num_records1) ; 145
		analog_lim_pt1_status_b[*] = !values.d_nan ; 145
		END
	'analog_lim_pt1_id':  BEGIN
		analog_lim_pt1_id_b	= dblarr(num_records1) ; 146
		analog_lim_pt1_id_b[*] = !values.d_nan ; 146
		END
	'analog_lim_pt1_red':  BEGIN
		analog_lim_pt1_red_b	=	 dblarr(num_records1) ; 147
		analog_lim_pt1_red_b[*] = !values.d_nan ; 147
		END
	'analog_lim_pt2_status':  BEGIN
		analog_lim_pt2_status_b	= dblarr(num_records1) ; 148
		analog_lim_pt2_status_b[*] = !values.d_nan ; 148
		END
	'analog_lim_pt2_id':  BEGIN
		analog_lim_pt2_id_b	= dblarr(num_records1) ; 149
		analog_lim_pt2_id_b[*] = !values.d_nan ; 149
		END
	'analog_lim_pt2_red':  BEGIN
		analog_lim_pt2_red_b	=	 dblarr(num_records1) ; 150
		analog_lim_pt2_red_b[*] = !values.d_nan ; 150
		END
	'analog_lim_pt3_status':  BEGIN
		analog_lim_pt3_status_b	=	 dblarr(num_records1) ; 151
		analog_lim_pt3_status_b[*] = !values.d_nan ; 151
		END
	'analog_lim_pt3_id':  BEGIN
		analog_lim_pt3_id_b	= dblarr(num_records1) ; 152
		analog_lim_pt3_id_b[*] = !values.d_nan ; 152
		END
	'analog_lim_pt3_red':  BEGIN
		analog_lim_pt3_red_b	= dblarr(num_records1) ; 153
		analog_lim_pt3_red_b[*] = !values.d_nan ; 153
		END
	'analog_lim_pt4_status':  BEGIN
		analog_lim_pt4_status_b	= 	dblarr(num_records1) ; 154
		analog_lim_pt4_status_b[*] = !values.d_nan ; 154
		END
	'analog_lim_pt4_id':  BEGIN
		analog_lim_pt4_id_b	= 	dblarr(num_records1) ; 155
		analog_lim_pt4_id_b[*] = !values.d_nan ; 155
		END
	'analog_lim_pt4_red':  BEGIN
		analog_lim_pt4_red_b	= dblarr(num_records1) ; 156
		analog_lim_pt4_red_b[*] = !values.d_nan ; 156
		END
	'analog_lim_pt5_status':  BEGIN
		analog_lim_pt5_status_b	=	 dblarr(num_records1) ; 157
		analog_lim_pt5_status_b[*] = !values.d_nan ; 157
		END
	'analog_lim_pt5_id':  BEGIN
		analog_lim_pt5_id_b	= dblarr(num_records1) ; 158
		analog_lim_pt5_id_b[*] = !values.d_nan ; 158
		END
	'analog_lim_pt5_red':  BEGIN
		analog_lim_pt5_red_b	= dblarr(num_records1) ; 159
		analog_lim_pt5_red_b[*] = !values.d_nan ; 159
		END
	'analog_lim_pt6_status':  BEGIN
		analog_lim_pt6_status_b	=	 dblarr(num_records1) ; 160
		analog_lim_pt6_status_b[*] = !values.d_nan ; 160
		END
	'analog_lim_pt6_id':  BEGIN
		analog_lim_pt6_id_b	=	 dblarr(num_records1) ; 161
		analog_lim_pt6_id_b[*] = !values.d_nan ; 161
		END
	'analog_lim_pt6_red':  BEGIN
		analog_lim_pt6_red_b	= dblarr(num_records1) ; 162
		analog_lim_pt6_red_b[*] = !values.d_nan ; 162
		END
	'analog_lim_pt7_status':  BEGIN
		analog_lim_pt7_status_b	= dblarr(num_records1) ; 163
		analog_lim_pt7_status_b[*] = !values.d_nan ; 163
		END
	'analog_lim_pt7_id':  BEGIN
		analog_lim_pt7_id_b	= 	dblarr(num_records1) ; 164
		analog_lim_pt7_id_b[*] = !values.d_nan ; 164
		END
	'analog_lim_pt7_red':  BEGIN
		analog_lim_pt7_red_b	= 	dblarr(num_records1) ; 165
		analog_lim_pt7_red_b[*] = !values.d_nan ; 165
		END
	'analog_lim_pt8_status':  BEGIN
		analog_lim_pt8_status_b	= dblarr(num_records1) ; 166
		analog_lim_pt8_status_b[*] = !values.d_nan ; 166
		END
	'analog_lim_pt8_id':  BEGIN
		analog_lim_pt8_id_b	=	 dblarr(num_records1) ; 167
		analog_lim_pt8_id_b[*] = !values.d_nan ; 167
		END
	'analog_lim_pt8_red':  BEGIN
		analog_lim_pt8_red_b	= dblarr(num_records1) ; 168
		analog_lim_pt8_red_b[*] = !values.d_nan ; 168
		END
	'analog_lim_pt9_status':  BEGIN
		analog_lim_pt9_status_b	= dblarr(num_records1) ; 169
		analog_lim_pt9_status_b[*] = !values.d_nan ; 169
		END
	'analog_lim_pt9_id':  BEGIN
		analog_lim_pt9_id_b	=	 dblarr(num_records1) ; 170
		analog_lim_pt9_id_b[*] = !values.d_nan ; 170
		END
	'analog_lim_pt9_red':  BEGIN
		analog_lim_pt9_red_b	=	 dblarr(num_records1) ; 171
		analog_lim_pt9_red_b[*] = !values.d_nan ; 171
		END
	'analog_lim_pt10_status':  BEGIN
		analog_lim_pt10_status_b	= dblarr(num_records1) ; 172
		analog_lim_pt10_status_b[*] = !values.d_nan ; 172
		END
	'analog_lim_pt10_id':  BEGIN
		analog_lim_pt10_id_b	= dblarr(num_records1) ; 173
		analog_lim_pt10_id_b[*] = !values.d_nan ; 173
		END
	'analog_lim_pt10_red':  BEGIN
		analog_lim_pt10_red_b	= 	dblarr(num_records1) ; 174
		analog_lim_pt10_red_b[*] = !values.d_nan ; 174
		END
	'analog_lim_pt11_status':  BEGIN
		analog_lim_pt11_status_b	= 	dblarr(num_records1) ; 175
		analog_lim_pt11_status_b[*] = !values.d_nan ; 175
		END
	'analog_lim_pt11_id':  BEGIN
		analog_lim_pt11_id_b	= dblarr(num_records1) ; 176
		analog_lim_pt11_id_b[*] = !values.d_nan ; 176
		END
	'analog_lim_pt11_red':  BEGIN
		analog_lim_pt11_red_b	=	 dblarr(num_records1) ; 177
		analog_lim_pt11_red_b[*] = !values.d_nan ; 177
		END
	'analog_lim_pt12_status':  BEGIN
		analog_lim_pt12_status_b	= dblarr(num_records1) ; 178
		analog_lim_pt12_status_b[*] = !values.d_nan ; 178
		END
	'analog_lim_pt12_id':  BEGIN
		analog_lim_pt12_id_b	= dblarr(num_records1) ; 179
		analog_lim_pt12_id_b[*] = !values.d_nan ; 179
		END
	'analog_lim_pt12_red':  BEGIN
		analog_lim_pt12_red_b	=	 dblarr(num_records1) ; 180
		analog_lim_pt12_red_b[*] = !values.d_nan ; 180
		END
	'analog_lim_pt13_status':  BEGIN
		analog_lim_pt13_status_b	=	 dblarr(num_records1) ; 181
		analog_lim_pt13_status_b[*] = !values.d_nan ; 181
		END
	'analog_lim_pt13_id':  BEGIN
		analog_lim_pt13_id_b	= dblarr(num_records1) ; 182
		analog_lim_pt13_id_b[*] = !values.d_nan ; 182
		END
	'analog_lim_pt13_red':  BEGIN
		analog_lim_pt13_red_b	= dblarr(num_records1) ; 183
		analog_lim_pt13_red_b[*] = !values.d_nan ; 183
		END
	'analog_lim_pt14_status':  BEGIN
		analog_lim_pt14_status_b	= 	dblarr(num_records1) ; 184
		analog_lim_pt14_status_b[*] = !values.d_nan ; 184
		END
	'analog_lim_pt14_id':  BEGIN
		analog_lim_pt14_id_b	= 	dblarr(num_records1) ; 185
		analog_lim_pt14_id_b[*] = !values.d_nan ; 185
		END
	'analog_lim_pt14_red':  BEGIN
		analog_lim_pt14_red_b	= dblarr(num_records1) ; 186
		analog_lim_pt14_red_b[*] = !values.d_nan; 186
		END
	'analog_lim_pt15_status':  BEGIN
		analog_lim_pt15_status_b	=	 dblarr(num_records1) ; 187
		analog_lim_pt15_status_b[*] = !values.d_nan ; 187
		END
	'analog_lim_pt15_id':  BEGIN
		analog_lim_pt15_id_b	= dblarr(num_records1) ; 188
		analog_lim_pt15_id_b[*] = !values.d_nan ; 188
		END
	'analog_lim_pt15_red':  BEGIN
		analog_lim_pt15_red_b	= dblarr(num_records1) ; 189
		analog_lim_pt15_red_b[*] = !values.d_nan ; 189
		END
	'opmode':  BEGIN
		opmode_b	=	 dblarr(num_records1) ; 190
		opmode_b[*] = !values.d_nan ; 190
		END
	'sw_mode':  BEGIN
		sw_mode_b	=	 dblarr(num_records1) ; 191
		sw_mode_b[*] = !values.d_nan ; 191
		END
	'proton_mode':  BEGIN
		proton_mode_b	= dblarr(num_records1) ; 192
		proton_mode_b[*] = !values.d_nan ; 192
		END
	'active_supplyid':  BEGIN
		active_supplyid_b	= dblarr(num_records1) ; 193
		active_supplyid_b[*] = !values.d_nan ; 193
		END
	'supply_coarse_rb':  BEGIN
		supply_coarse_rb_b	= 	dblarr(num_records1) ; 194
		supply_coarse_rb_b[*] = !values.d_nan ; 194
		END
	'supply_fine_rb':  BEGIN
		supply_fine_rb_b	= 	dblarr(num_records1) ; 195
		supply_fine_rb_b[*] = !values.d_nan ; 195
		END
	'swmaint_supplystat':  BEGIN
		swmaint_supplystat_b	= dblarr(num_records1) ; 196
		swmaint_supplystat_b[*] = !values.d_nan ; 196
		END
	'swmaint_pac_coarse':  BEGIN
		swmaint_pac_coarse_b	=	 dblarr(num_records1) ; 197
		swmaint_pac_coarse_b[*] = !values.d_nan ; 197
		END
	'swmaint_pac_fine':  BEGIN
		swmaint_pac_fine_b	= dblarr(num_records1) ; 198		
		swmaint_pac_fine_b[*] = !values.d_nan ; 198
		END
	ENDCASE
	ENDFOR
    	END 
ENDCASE 
dig_hk_initialized = 1

END 

PRO read_dig_hk, cdf_id, sat, dig_hk_read, data1_index, epoch1maxrec, products

COMMON com_dig_hk
CASE sat OF 
    'A': BEGIN
	
	FOR ii = 0, n_elements(products)-1 DO BEGIN 
		CASE products[ii] OF
	
		'dpu_sw_version':  BEGIN
			read_product_dig_hk, cdf_id, 'dpu_sw_version', dpu_sw_version_a, data1_index, epoch1maxrec ; 0
			remove_fill_dig_hk, -1, dpu_sw_version_a; 0
			END
		'cmd_rcvd_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_rcvd_cnt', cmd_rcvd_cnt_a, data1_index, epoch1maxrec  ; 1
			remove_fill_dig_hk, -1, cmd_rcvd_cnt_a ; 1
			END
		'cmd_exec_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_exec_cnt', cmd_exec_cnt_a, data1_index, epoch1maxrec ; 2
			remove_fill_dig_hk, -1, cmd_exec_cnt_a ; 2
			END
		'cmd_total_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_total_err_cnt', cmd_total_err_cnt_a, data1_index, epoch1maxrec ; 3
			remove_fill_dig_hk, -1, cmd_total_err_cnt_a ; 3
			END
		'cmd_parity_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_parity_err_cnt', cmd_parity_err_cnt_a,  data1_index, epoch1maxrec ; 4
			remove_fill_dig_hk, -1, cmd_parity_err_cnt_a ; 4
			END
		'cmd_frame_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_frame_err_cnt', cmd_frame_err_cnt_a, data1_index, epoch1maxrec ; 5
			remove_fill_dig_hk, -1, cmd_frame_err_cnt_a ; 5
			END
		'cmd_illegal_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_illegal_err_cnt', cmd_illegal_err_cnt_a, data1_index, epoch1maxrec ; 6
			remove_fill_dig_hk, -1, cmd_illegal_err_cnt_a ; 6
			END
		'ic_status_reg':  BEGIN
			read_product_dig_hk, cdf_id, 'ic_status_reg', ic_status_reg_a, data1_index, epoch1maxrec ; 7
			remove_fill_dig_hk, -1, ic_status_reg_a ; 7
			END
		'ic_ctl_reg':  BEGIN
			read_product_dig_hk, cdf_id, 'ic_ctl_reg', ic_ctl_reg_a, data1_index, epoch1maxrec ; 8
			remove_fill_dig_hk, -1, ic_ctl_reg_a ; 8
			END
		'lbc_reset_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_reset_ctl', lbc_reset_ctl_a, data1_index, epoch1maxrec ; 9
			remove_fill_dig_hk, -1, lbc_reset_ctl_a ; 9
			END
		'lbc_mode_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_mode_ctl', lbc_mode_ctl_a, data1_index, epoch1maxrec ; 10
			remove_fill_dig_hk, -1, lbc_mode_ctl_a ; 10
			END
		'lbc_logic_ctl_a':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_logic_ctl_a', lbc_logic_ctl_a_a, data1_index, epoch1maxrec ; 11
			remove_fill_dig_hk, -1, lbc_logic_ctl_a_a ; 11
			END
		'lbc_logic_ctl_b':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_logic_ctl_b', lbc_logic_ctl_b_a, data1_index, epoch1maxrec ; 12
			remove_fill_dig_hk, -1, lbc_logic_ctl_b_a ; 12
			END
		'lbc_tac_pwr_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_tac_pwr_ctl', lbc_tac_pwr_ctl_a, data1_index, epoch1maxrec ; 13
			remove_fill_dig_hk, -1, lbc_tac_pwr_ctl_a ; 13
			END
		'lbc_reg_seq':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_reg_seq', lbc_reg_seq_a, data1_index, epoch1maxrec ; 14
			remove_fill_dig_hk, -1, lbc_reg_seq_a ; 14
			END
		'lbc_event_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_event_ctl', lbc_event_ctl_a, data1_index, epoch1maxrec ; 15
			remove_fill_dig_hk, -1, lbc_event_ctl_a ; 15
			END
		'lbc_rlim_ch':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_rlim_ch', lbc_rlim_ch_a, data1_index, epoch1maxrec ; 16
			remove_fill_dig_hk, -1, lbc_rlim_ch_a ; 16
			END
		'lbc_rlim_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_rlim_hi', lbc_rlim_hi_a, data1_index, epoch1maxrec ; 17
			remove_fill_dig_hk, -1, lbc_rlim_hi_a ; 17
			END
		'lbc_rlim_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_rlim_lo', lbc_rlim_lo_a, data1_index, epoch1maxrec ; 18
			remove_fill_dig_hk, -1, lbc_rlim_lo_a ; 18
			END
		'lbe_pos_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_ctrl', lbe_pos_ctrl_a, data1_index, epoch1maxrec ; 19
			remove_fill_dig_hk, -1, lbe_pos_ctrl_a ; 19
			END
		'lbe_pos_disable0':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_disable0', lbe_pos_disable0_a, data1_index, epoch1maxrec ; 20
			remove_fill_dig_hk, -1, lbe_pos_disable0_a ; 20
			END
		'lbe_pos_disable2':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_disable2', lbe_pos_disable2_a, data1_index, epoch1maxrec ; 21
			remove_fill_dig_hk, -1, lbe_pos_disable2_a ; 21
			END
		'lbe_tac0_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_ctrl', lbe_tac0_ctrl_a, data1_index, epoch1maxrec ; 22
			remove_fill_dig_hk, -1, lbe_tac0_ctrl_a ; 22
			END
		'lbe_tac0_dac':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_dac', lbe_tac0_dac_a, data1_index, epoch1maxrec ; 23
			remove_fill_dig_hk, -1, lbe_tac0_dac_a ; 23
			END
		'lbe_tac2_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_ctrl', lbe_tac2_ctrl_a, data1_index, epoch1maxrec ; 24
			remove_fill_dig_hk, -1, lbe_tac2_ctrl_a ; 24
			END
		'lbe_tac2_dac':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_dac', lbe_tac2_dac_a, data1_index, epoch1maxrec ; 25
			remove_fill_dig_hk, -1, lbe_tac2_dac_a ; 25
			END
		'lbe_tac0_under_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_under_hi', lbe_tac0_under_hi_a, data1_index, epoch1maxrec ; 26
			remove_fill_dig_hk, -1, lbe_tac0_under_hi_a ; 26
			END
		'lbe_tac0_under_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_under_lo', lbe_tac0_under_lo_a, data1_index, epoch1maxrec ; 27
			remove_fill_dig_hk, -1, lbe_tac0_under_lo_a ; 27
			END
		'lbe_tac0_over_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_over_hi', lbe_tac0_over_hi_a, data1_index, epoch1maxrec ; 28
			remove_fill_dig_hk, -1, lbe_tac0_over_hi_a ; 28
			END
		'lbe_tac0_over_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_over_lo', lbe_tac0_over_lo_a, data1_index, epoch1maxrec ; 29
			remove_fill_dig_hk, -1, lbe_tac0_over_lo_a ; 29
			END
		'lbe_tac2_under_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_under_hi', lbe_tac2_under_hi_a, data1_index, epoch1maxrec ; 30
			remove_fill_dig_hk, -1, lbe_tac2_under_hi_a ; 30
			END
		'lbe_tac2_under_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_under_lo', lbe_tac2_under_lo_a, data1_index, epoch1maxrec ; 31
			remove_fill_dig_hk, -1, lbe_tac2_under_lo_a ; 31
			END
		'lbe_tac2_over_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_over_hi', lbe_tac2_over_hi_a, data1_index, epoch1maxrec ; 32
			remove_fill_dig_hk, -1, lbe_tac2_over_hi_a ; 32
			END
		'lbe_tac2_over_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_over_lo', lbe_tac2_over_lo_a, data1_index, epoch1maxrec ; 33
			remove_fill_dig_hk, -1, lbe_tac2_over_lo_a ; 33
			END
		'lbe_ssd_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_ctrl', lbe_ssd_ctrl_a, data1_index, epoch1maxrec ; 34
			remove_fill_dig_hk, -1, lbe_ssd_ctrl_a ; 34
			END
		'lbe_ssd_cmd_h':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_cmd_h', lbe_ssd_cmd_h_a, data1_index, epoch1maxrec ; 35
			remove_fill_dig_hk, -1, lbe_ssd_cmd_h_a ; 35
			END
		'lbe_ssd_cmd_l':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_cmd_l', lbe_ssd_cmd_l_a, data1_index, epoch1maxrec ; 36
			remove_fill_dig_hk, -1, lbe_ssd_cmd_l_a ; 36
			END
		'lbe_ssd_dis':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_dis', lbe_ssd_dis_a, data1_index, epoch1maxrec ; 37
			remove_fill_dig_hk, -1, lbe_ssd_dis_a ; 37
			END
		'lbe_ssd_under_hi':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_under_hi', lbe_ssd_under_hi_a, data1_index, epoch1maxrec ; 38
			remove_fill_dig_hk, -1, lbe_ssd_under_hi_a ; 38
			END
		'lbe_ssd_under_lo':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_under_lo', lbe_ssd_under_lo_a, data1_index, epoch1maxrec ; 39
			remove_fill_dig_hk, -1, lbe_ssd_under_lo_a ; 39
			END
		'lbe_ssd_over_hi':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_over_hi', lbe_ssd_over_hi_a, data1_index, epoch1maxrec ; 40
			remove_fill_dig_hk, -1, lbe_ssd_over_hi_a ; 40
			END
		'lbe_ssd_over_lo':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_over_lo', lbe_ssd_over_lo_a, data1_index, epoch1maxrec ; 41
			remove_fill_dig_hk, -1, lbe_ssd_over_lo_a ; 41
			END
		'lbe_sel_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_sel_ctrl', lbe_sel_ctrl_a, data1_index, epoch1maxrec ; 42
			remove_fill_dig_hk, -1, lbe_sel_ctrl_a ; 42
			END
		'lbe_trig_mode':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_trig_mode', lbe_trig_mode_a, data1_index, epoch1maxrec ; 43
			remove_fill_dig_hk, -1, lbe_trig_mode_a ; 43
			END
		'lbe_esa_step':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_esa_step', lbe_esa_step_a, data1_index, epoch1maxrec ; 44
			remove_fill_dig_hk, -1, lbe_esa_step_a ; 44
			END
		'lbe_defl_step':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_defl_step', lbe_defl_step_a, data1_index, epoch1maxrec ; 45
			remove_fill_dig_hk, -1, lbe_defl_step_a ; 45
			END
		'lbe_ssd_offset0':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset0', lbe_ssd_offset0_a, data1_index, epoch1maxrec ; 46
			remove_fill_dig_hk, -1, lbe_ssd_offset0_a ; 46
			END
		'lbe_ssd_offset1':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset1', lbe_ssd_offset1_a, data1_index, epoch1maxrec ; 47
			remove_fill_dig_hk, -1, lbe_ssd_offset1_a ; 47
			END
		'lbe_ssd_offset2':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset2', lbe_ssd_offset2_a, data1_index, epoch1maxrec ; 48
			remove_fill_dig_hk, -1, lbe_ssd_offset2_a ; 48
			END
		'lbe_ssd_offset3':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset3', lbe_ssd_offset3_a, data1_index, epoch1maxrec ; 49
			remove_fill_dig_hk, -1, lbe_ssd_offset3_a ; 49
			END
		'lbe_ssd_offset4':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset4', lbe_ssd_offset4_a, data1_index, epoch1maxrec ; 50
			remove_fill_dig_hk, -1, lbe_ssd_offset4_a ; 50
			END
		'lbe_ssd_offset5':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset5', lbe_ssd_offset5_a, data1_index, epoch1maxrec ; 51
			remove_fill_dig_hk, -1, lbe_ssd_offset5_a ; 51
			END
		'lbe_ssd_offset6':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset6', lbe_ssd_offset6_a, data1_index, epoch1maxrec ; 52
			remove_fill_dig_hk, -1, lbe_ssd_offset6_a ; 52
			END
		'lbe_ssd_offset7':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset7', lbe_ssd_offset7_a, data1_index, epoch1maxrec ; 53
			remove_fill_dig_hk, -1, lbe_ssd_offset7_a ; 53
			END
		'lbe_stim_enable':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_stim_enable', lbe_stim_enable_a, data1_index, epoch1maxrec ; 54
			remove_fill_dig_hk, -1, lbe_stim_enable_a ; 54
			END
		'lbe_stim_freq_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_stim_freq_hi', lbe_stim_freq_hi_a, data1_index, epoch1maxrec ; 55
			remove_fill_dig_hk, -1, lbe_stim_freq_hi_a ; 55
			END
		'lbe_stim_freq_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_stim_freq_lo', lbe_stim_freq_lo_a, data1_index, epoch1maxrec ; 56
			remove_fill_dig_hk, -1, lbe_stim_freq_lo_a ; 56
			END
		'lbe_sel0_window':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_sel0_window', lbe_sel0_window_a, data1_index, epoch1maxrec ; 57
			remove_fill_dig_hk, -1, lbe_sel0_window_a ; 57
			END
		'lbe_sel2_window':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_sel2_window', lbe_sel2_window_a, data1_index, epoch1maxrec ; 58
			remove_fill_dig_hk, -1, lbe_sel2_window_a ; 58
			END
		'lbe_ssd_offset8':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset8', lbe_ssd_offset8_a, data1_index, epoch1maxrec ; 59
			remove_fill_dig_hk, -1, lbe_ssd_offset8_a ; 59
			END
		'lbe_ssd_offset9':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset9', lbe_ssd_offset9_a, data1_index, epoch1maxrec ; 60
			remove_fill_dig_hk, -1, lbe_ssd_offset9_a ; 60
			END
		'lbe_ssd_offset10':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset10', lbe_ssd_offset10_a, data1_index, epoch1maxrec ; 61
			remove_fill_dig_hk, -1, lbe_ssd_offset10_a ; 61
			END
		'lbe_ssd_offset11':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset11', lbe_ssd_offset11_a, data1_index, epoch1maxrec ; 62
			remove_fill_dig_hk, -1, lbe_ssd_offset11_a ; 62
			END
		'lbe_ssd_offset12':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset12', lbe_ssd_offset12_a, data1_index, epoch1maxrec ; 63
			remove_fill_dig_hk, -1, lbe_ssd_offset12_a ; 63
			END
		'lbe_ssd_offset13':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset13', lbe_ssd_offset13_a, data1_index, epoch1maxrec ; 64
			remove_fill_dig_hk, -1, lbe_ssd_offset13_a ; 64
			END
		'lbe_ssd_offset14':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset14', lbe_ssd_offset14_a, data1_index, epoch1maxrec ; 65
			remove_fill_dig_hk, -1, lbe_ssd_offset14_a ; 65
			END
		'lbe_ssd_offset15':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset15', lbe_ssd_offset15_a, data1_index, epoch1maxrec ; 66
			remove_fill_dig_hk, -1, lbe_ssd_offset15_a ; 66
			END
		'lbe_pos_ra':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_ra', lbe_pos_ra_a, data1_index, epoch1maxrec ; 67
			remove_fill_dig_hk, -1, lbe_pos_ra_a ; 67
			END
		'dacm_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_mcp_ssd_ctl_mcp_limit', dacm_pac_mcp_ssd_ctl_mcp_limit_a, data1_index, epoch1maxrec ; 68
			remove_fill_dig_hk, -1, dacm_pac_mcp_ssd_ctl_mcp_limit_a ; 68
			END
		'dacm_pac_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_limit', dacm_pac_limit_a, data1_index, epoch1maxrec ; 69
			remove_fill_dig_hk, -1, dacm_pac_limit_a ; 69
			END
		'dacm_esa_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_esa_ctl', dacm_esa_ctl_a, data1_index, epoch1maxrec ; 70
			remove_fill_dig_hk, -1, dacm_esa_ctl_a ; 70
			END
		'dacm_s_ch_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_ctl', dacm_s_ch_ctl_a, data1_index, epoch1maxrec ; 71
			remove_fill_dig_hk, -1, dacm_s_ch_ctl_a ; 71
			END
		'dacm_dfl_1_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_ctl', dacm_dfl_1_ctl_a, data1_index, epoch1maxrec ; 72
			remove_fill_dig_hk, -1, dacm_dfl_1_ctl_a ; 72
			END
		'dacm_dfl_2_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_ctl', dacm_dfl_2_ctl_a, data1_index, epoch1maxrec ; 73
			remove_fill_dig_hk, -1, dacm_dfl_2_ctl_a ; 73
			END
		'dacm_control':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_control', dacm_control_a, data1_index, epoch1maxrec ; 74
			remove_fill_dig_hk, -1, dacm_control_a ; 74
			END
		'dacm_status':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_status', dacm_status_a, data1_index, epoch1maxrec ; 75
			remove_fill_dig_hk, -1, dacm_status_a ; 75
			END
		'dacm_adc_lu_ctr':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_adc_lu_ctr', dacm_adc_lu_ctr_a, data1_index, epoch1maxrec ;76
			remove_fill_dig_hk, -1, dacm_adc_lu_ctr_a ; 76
			END
		'dacm_dfl_1_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_offset', dacm_dfl_1_offset_a, data1_index, epoch1maxrec ; 77
			remove_fill_dig_hk, -1, dacm_dfl_1_offset_a ; 77
			END
		'dacm_dfl_2_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_offset', dacm_dfl_2_offset_a, data1_index, epoch1maxrec ; 78
			remove_fill_dig_hk, -1, dacm_dfl_2_offset_a ; 78
			END
		'dacm_pac_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_coarse', dacm_pac_coarse_a, data1_index, epoch1maxrec ; 79
			remove_fill_dig_hk, -1, dacm_pac_coarse_a ; 79
			END
		'dacm_pac_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_fine', dacm_pac_fine_a, data1_index, epoch1maxrec ; 80
			remove_fill_dig_hk, -1, dacm_pac_fine_a ; 80
			END
		'dacm_pac_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_cm_fs_coarse', dacm_pac_cm_fs_coarse_a, data1_index, epoch1maxrec ; 81
			remove_fill_dig_hk, -1, dacm_pac_cm_fs_coarse_a ; 81
			END
		'dacm_pac_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_cm_fs_fine', dacm_pac_cm_fs_fine_a, data1_index, epoch1maxrec ; 82
			remove_fill_dig_hk, -1, dacm_pac_cm_fs_fine_a ; 82
			END
		'dacm_mcp_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_coarse', dacm_mcp_coarse_a, data1_index, epoch1maxrec ; 83
			remove_fill_dig_hk, -1, dacm_mcp_coarse_a ; 83
			END
		'dacm_mcp_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_fine', dacm_mcp_fine_a, data1_index, epoch1maxrec ; 84
			remove_fill_dig_hk, -1, dacm_mcp_fine_a ; 84
			END
		'dacm_mcp_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_cm_fs_coarse', dacm_mcp_cm_fs_coarse_a, data1_index, epoch1maxrec ; 85
			remove_fill_dig_hk, -1, dacm_mcp_cm_fs_coarse_a ; 85
			END
		'dacm_mcp_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_cm_fs_fine', dacm_mcp_cm_fs_fine_a, data1_index, epoch1maxrec ; 86
			remove_fill_dig_hk, -1, dacm_mcp_cm_fs_fine_a ; 86
			END
		'dacm_ssd_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_ssd_coarse', dacm_ssd_coarse_a, data1_index, epoch1maxrec ; 87
			remove_fill_dig_hk, -1, dacm_ssd_coarse_a ; 87
			END
		'dacm_ssd_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_ssd_fine', dacm_ssd_fine_a, data1_index, epoch1maxrec ; 88
			remove_fill_dig_hk, -1, dacm_ssd_fine_a ; 88
			END
		'dacm_esa_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_esa_coarse', dacm_esa_coarse_a, data1_index, epoch1maxrec ; 89
			remove_fill_dig_hk, -1, dacm_esa_coarse_a ; 89
			END
		'dacm_esa_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_esa_fine', dacm_esa_fine_a, data1_index, epoch1maxrec ; 90
			remove_fill_dig_hk, -1, dacm_esa_fine_a ; 90
			END
		'dacm_s_ch_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_coarse', dacm_s_ch_coarse_a, data1_index, epoch1maxrec ; 91
			remove_fill_dig_hk, -1, dacm_s_ch_coarse_a ; 91
			END
		'dacm_s_ch_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_fine', dacm_s_ch_fine_a, data1_index, epoch1maxrec ; 92
			remove_fill_dig_hk, -1, dacm_s_ch_fine_a ; 92
			END
		'dacm_s_ch_tap_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_tap_coarse', dacm_s_ch_tap_coarse_a, data1_index, epoch1maxrec ; 93
			remove_fill_dig_hk, -1, dacm_s_ch_tap_coarse_a ; 93
			END
		'dacm_s_ch_tap_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_tap_fine', dacm_s_ch_tap_fine_a, data1_index, epoch1maxrec ; 94
			remove_fill_dig_hk, -1, dacm_s_ch_tap_fine_a ; 94
			END
		'dacm_dfl_1_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_coarse', dacm_dfl_1_coarse_a, data1_index, epoch1maxrec ; 95
			remove_fill_dig_hk, -1, dacm_dfl_1_coarse_a ; 95
			END
		'dacm_dfl_1_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_fine', dacm_dfl_1_fine_a, data1_index, epoch1maxrec ; 96
			remove_fill_dig_hk, -1, dacm_dfl_1_fine_a ; 96
			END
		'dacm_dfl_1_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_dfine', dacm_dfl_1_dfine_a, data1_index, epoch1maxrec ; 97
			remove_fill_dig_hk, -1, dacm_dfl_1_dfine_a ; 97
			END
		'dacm_dfl_2_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_coarse', dacm_dfl_2_coarse_a, data1_index, epoch1maxrec ; 98
			remove_fill_dig_hk, -1, dacm_dfl_2_coarse_a ; 98
			END
		'dacm_dfl_2_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_fine', dacm_dfl_2_fine_a, data1_index, epoch1maxrec ; 99
			remove_fill_dig_hk, -1, dacm_dfl_2_fine_a ; 99
			END
		'dacm_dfl_2_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_dfine', dacm_dfl_2_dfine_a, data1_index, epoch1maxrec ; 100
			remove_fill_dig_hk, -1, dacm_dfl_2_dfine_a ; 100
			END
		'dacr_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_pac_mcp_ssd_ctl_mcp_limit', dacr_pac_mcp_ssd_ctl_mcp_limit_a, data1_index, epoch1maxrec ; 101
			remove_fill_dig_hk, -1, dacr_pac_mcp_ssd_ctl_mcp_limit_a ; 101
			END
		'dacr_pac_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_pac_limit', dacr_pac_limit_a, data1_index, epoch1maxrec ; 102
			remove_fill_dig_hk, -1, dacr_pac_limit_a ; 102
			END
		'dacr_esa_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_esa_ctl', dacr_esa_ctl_a, data1_index, epoch1maxrec ; 103
			remove_fill_dig_hk, -1, dacr_esa_ctl_a ; 103
			END
		'dacr_s_ch_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_s_ch_ctl', dacr_s_ch_ctl_a, data1_index, epoch1maxrec  ; 104
			remove_fill_dig_hk, -1, dacr_s_ch_ctl_a ; 104
			END
		'dacr_dfl_1_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_ctl', dacr_dfl_1_ctl_a, data1_index, epoch1maxrec ; 105
			remove_fill_dig_hk, -1, dacr_dfl_1_ctl_a ; 105
			END
		'dacr_dfl_2_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_ctl', dacr_dfl_2_ctl_a, data1_index, epoch1maxrec ; 106
			remove_fill_dig_hk, -1, dacr_dfl_2_ctl_a ; 106
			END
		'dacr_control':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_control', dacr_control_a, data1_index, epoch1maxrec ; 107
			remove_fill_dig_hk, -1, dacr_control_a ; 107
			END
		'dacr_status':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_status', dacr_status_a, data1_index, epoch1maxrec ; 108
			remove_fill_dig_hk, -1, dacr_status_a ; 108
			END
		'dacr_adc_lu_ctr':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_adc_lu_ctr', dacr_adc_lu_ctr_a, data1_index, epoch1maxrec  ; 109
			remove_fill_dig_hk, -1, dacr_adc_lu_ctr_a ; 109
			END
		'dacr_dfl_1_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_offset', dacr_dfl_1_offset_a, data1_index, epoch1maxrec ; 110
			remove_fill_dig_hk, -1, dacr_dfl_1_offset_a ; 110
			END
		'dacr_dfl_2_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_offset', dacr_dfl_2_offset_a, data1_index, epoch1maxrec ; 111
			remove_fill_dig_hk, -1, dacr_dfl_2_offset_a ; 111
			END
		'dacr_c_pac_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_coarse', dacr_c_pac_coarse_a, data1_index, epoch1maxrec ; 112
			remove_fill_dig_hk, -1, dacr_c_pac_coarse_a ; 112
			END
		'dacr_c_pac_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_fine', dacr_c_pac_fine_a, data1_index, epoch1maxrec ; 113
			remove_fill_dig_hk, -1, dacr_c_pac_fine_a ; 113
			END
		'dacr_c_pac_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_cm_fs_coarse', dacr_c_pac_cm_fs_coarse_a, data1_index, epoch1maxrec ; 114
			remove_fill_dig_hk, -1, dacr_c_pac_cm_fs_coarse_a ; 114
			END
		'dacr_c_pac_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_cm_fs_fine', dacr_c_pac_cm_fs_fine_a, data1_index, epoch1maxrec ; 115
			remove_fill_dig_hk, -1, dacr_c_pac_cm_fs_fine_a ; 115
			END
		'dacr_c_mcp_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_coarse', dacr_c_mcp_coarse_a, data1_index, epoch1maxrec  ; 116
			remove_fill_dig_hk, -1, dacr_c_mcp_coarse_a ; 116
			END
		'dacr_c_mcp_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_fine', dacr_c_mcp_fine_a, data1_index, epoch1maxrec ; 117
			remove_fill_dig_hk, -1, dacr_c_mcp_fine_a ; 117
			END
		'dacr_c_mcp_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_cm_fs_coarse', dacr_c_mcp_cm_fs_coarse_a, data1_index, epoch1maxrec ; 118
			remove_fill_dig_hk, -1, dacr_c_mcp_cm_fs_coarse_a ; 118
			END
		'dacr_c_mcp_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_cm_fs_fine', dacr_c_mcp_cm_fs_fine_a, data1_index, epoch1maxrec ; 119
			remove_fill_dig_hk, -1, dacr_c_mcp_cm_fs_fine_a ; 119
			END
		'dacr_c_ssd_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_ssd_coarse', dacr_c_ssd_coarse_a, data1_index, epoch1maxrec ; 120
			remove_fill_dig_hk, -1, dacr_c_ssd_coarse_a ; 120
			END
		'dacr_c_ssd_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_ssd_fine', dacr_c_ssd_fine_a, data1_index, epoch1maxrec ; 121
			remove_fill_dig_hk, -1, dacr_c_ssd_fine_a ; 121
			END
		'dacr_c_esa_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_esa_coarse', dacr_c_esa_coarse_a, data1_index, epoch1maxrec ; 122
			remove_fill_dig_hk, -1, dacr_c_esa_coarse_a ; 122
			END
		'dacr_c_esa_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_esa_fine', dacr_c_esa_fine_a, data1_index, epoch1maxrec ; 123
			remove_fill_dig_hk, -1, dacr_c_esa_fine_a ; 123
			END
		'dacr_c_s_ch_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_coarse', dacr_c_s_ch_coarse_a, data1_index, epoch1maxrec ; 124
			remove_fill_dig_hk, -1, dacr_c_s_ch_coarse_a ; 124
			END
		'dacr_c_s_ch_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_fine', dacr_c_s_ch_fine_a, data1_index, epoch1maxrec ; 125
			remove_fill_dig_hk, -1, dacr_c_s_ch_fine_a ; 125
			END
		'dacr_c_s_ch_tap_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_tap_coarse', dacr_c_s_ch_tap_coarse_a, data1_index, epoch1maxrec ; 126
			remove_fill_dig_hk, -1, dacr_c_s_ch_tap_coarse_a ; 126
			END
		'dacr_c_s_ch_tap_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_tap_fine', dacr_c_s_ch_tap_fine_a, data1_index, epoch1maxrec ; 127
			remove_fill_dig_hk, -1, dacr_c_s_ch_tap_fine_a ; 127
			END
		'dacr_dfl_1_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_coarse', dacr_dfl_1_coarse_a, data1_index, epoch1maxrec ; 128
			remove_fill_dig_hk, -1, dacr_dfl_1_coarse_a ; 128
			END
		'dacr_dfl_1_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_fine', dacr_dfl_1_fine_a, data1_index, epoch1maxrec ; 129
			remove_fill_dig_hk, -1, dacr_dfl_1_fine_a ; 129
			END
		'dacr_dfl_1_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_dfine', dacr_dfl_1_dfine_a, data1_index, epoch1maxrec  ; 130
			remove_fill_dig_hk, -1, dacr_dfl_1_dfine_a ; 130
			END
		'dacr_dfl_2_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_coarse', dacr_dfl_2_coarse_a, data1_index, epoch1maxrec  ; 131
			remove_fill_dig_hk, -1, dacr_dfl_2_coarse_a ; 131
			END
		'dacr_dfl_2_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_fine', dacr_dfl_2_fine_a, data1_index, epoch1maxrec ; 132
			remove_fill_dig_hk, -1, dacr_dfl_2_fine_a ; 132
			END
		'dacr_dfl_2_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_dfine', dacr_dfl_2_dfine_a, data1_index, epoch1maxrec ; 133
			remove_fill_dig_hk, -1, dacr_dfl_2_dfine_a ; 133
			END
		'sw_status1':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_status1', sw_status1_a, data1_index, epoch1maxrec ; 134
			remove_fill_dig_hk, -1, sw_status1_a ; 134
			END
		'sw_hv_ramp_status':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_hv_ramp_status', sw_hv_ramp_status_a, data1_index, epoch1maxrec ; 135
			remove_fill_dig_hk, -1, sw_hv_ramp_status_a ; 135
			END
		'sw_hv_enable_status':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_hv_enable_status', sw_hv_enable_status_a, data1_index, epoch1maxrec ; 136
			remove_fill_dig_hk, -1, sw_hv_enable_status_a ; 136
			END
		'sw_hv_limit_status':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_hv_limit_status', sw_hv_limit_status_a, data1_index, epoch1maxrec ; 137
			remove_fill_dig_hk, -1, sw_hv_limit_status_a ; 137
			END
		'sw_eepromchksum':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_eepromchksum', sw_eepromchksum_a, data1_index, epoch1maxrec ; 138
			remove_fill_dig_hk, -1, sw_eepromchksum_a ; 138
			END
		'hkp_sampletime':  BEGIN
			read_product_dig_hk, cdf_id, 'hkp_sampletime', hkp_sampletime_a, data1_index, epoch1maxrec ; 139
			remove_fill_dig_hk, -1, hkp_sampletime_a ; 139
			END
		'pac_discharge_status':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_status', pac_discharge_status_a, data1_index, epoch1maxrec ; 140
			remove_fill_dig_hk, -1, pac_discharge_status_a ; 140
			END
		'pac_discharge_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_cnt', pac_discharge_cnt_a, data1_index, epoch1maxrec ; 141
			remove_fill_dig_hk, -1, pac_discharge_cnt_a ; 141
			END
		'pac_discharge_conseccntr':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_conseccntr', pac_discharge_conseccntr_a, data1_index, epoch1maxrec ; 142
			remove_fill_dig_hk, -1, pac_discharge_conseccntr_a ; 142
			END
		'pac_discharge_safe_att':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_safe_att', pac_discharge_safe_att_a, data1_index, epoch1maxrec ; 143
			remove_fill_dig_hk, -1, pac_discharge_safe_att_a ; 143
			END
		'analog_limit_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_limit_status', analog_limit_status_a, data1_index, epoch1maxrec ; 144
			remove_fill_dig_hk, -1, analog_limit_status_a ; 144
			END
		'analog_lim_pt1_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt1_status', analog_lim_pt1_status_a, data1_index, epoch1maxrec ; 145
			remove_fill_dig_hk, -1, analog_lim_pt1_status_a ; 145
			END
		'analog_lim_pt1_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt1_id', analog_lim_pt1_id_a, data1_index, epoch1maxrec ; 146
			remove_fill_dig_hk, -1, analog_lim_pt1_id_a ; 146
			END
		'analog_lim_pt1_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt1_red', analog_lim_pt1_red_a, data1_index, epoch1maxrec ; 147
			remove_fill_dig_hk, -1, analog_lim_pt1_red_a ; 147
			END
		'analog_lim_pt2_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt2_status', analog_lim_pt2_status_a, data1_index, epoch1maxrec ; 148
			remove_fill_dig_hk, -1, analog_lim_pt2_status_a ; 148
			END
		'analog_lim_pt2_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt2_id', analog_lim_pt2_id_a, data1_index, epoch1maxrec ; 149
			remove_fill_dig_hk, -1, analog_lim_pt2_id_a ; 149
			END
		'analog_lim_pt2_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt2_red', analog_lim_pt2_red_a, data1_index, epoch1maxrec ; 150
			remove_fill_dig_hk, -1, analog_lim_pt2_red_a ; 150
			END
		'analog_lim_pt3_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt3_status', analog_lim_pt3_status_a, data1_index, epoch1maxrec ; 151
			remove_fill_dig_hk, -1, analog_lim_pt3_status_a ; 151
			END
		'analog_lim_pt3_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt3_id', analog_lim_pt3_id_a, data1_index, epoch1maxrec ; 152
			remove_fill_dig_hk, -1, analog_lim_pt3_id_a ; 152
			END
		'analog_lim_pt3_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt3_red', analog_lim_pt3_red_a, data1_index, epoch1maxrec ; 153
			remove_fill_dig_hk, -1, analog_lim_pt3_red_a ; 153
			END
		'analog_lim_pt4_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt4_status', analog_lim_pt4_status_a, data1_index, epoch1maxrec ; 154
			remove_fill_dig_hk, -1, analog_lim_pt4_status_a ; 154
			END
		'analog_lim_pt4_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt4_id', analog_lim_pt4_id_a, data1_index, epoch1maxrec ; 155
			remove_fill_dig_hk, -1, analog_lim_pt4_id_a ; 155
			END
		'analog_lim_pt4_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt4_red', analog_lim_pt4_red_a, data1_index, epoch1maxrec ; 156
			remove_fill_dig_hk, -1, analog_lim_pt4_red_a ; 156
			END
		'analog_lim_pt5_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt5_status', analog_lim_pt5_status_a, data1_index, epoch1maxrec ; 157
			remove_fill_dig_hk, -1, analog_lim_pt5_status_a ; 157
			END
		'analog_lim_pt5_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt5_id', analog_lim_pt5_id_a, data1_index, epoch1maxrec ; 158
			remove_fill_dig_hk, -1, analog_lim_pt5_id_a ; 158
			END
		'analog_lim_pt5_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt5_red', analog_lim_pt5_red_a, data1_index, epoch1maxrec ; 159
			remove_fill_dig_hk, -1, analog_lim_pt5_red_a ; 159
			END
		'analog_lim_pt6_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt6_status', analog_lim_pt6_status_a, data1_index, epoch1maxrec ; 160
			remove_fill_dig_hk, -1, analog_lim_pt6_status_a ; 160
			END
		'analog_lim_pt6_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt6_id', analog_lim_pt6_id_a, data1_index, epoch1maxrec ; 161
			remove_fill_dig_hk, -1, analog_lim_pt6_id_a ; 161
			END
		'analog_lim_pt6_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt6_red', analog_lim_pt6_red_a, data1_index, epoch1maxrec ; 162
			remove_fill_dig_hk, -1, analog_lim_pt6_red_a ; 162
			END
		'analog_lim_pt7_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt7_status', analog_lim_pt7_status_a, data1_index, epoch1maxrec ; 163
			remove_fill_dig_hk, -1, analog_lim_pt7_status_a ; 163
			END
		'analog_lim_pt7_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt7_id', analog_lim_pt7_id_a, data1_index, epoch1maxrec ; 164
			remove_fill_dig_hk, -1, analog_lim_pt7_id_a ; 164
			END
		'analog_lim_pt7_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt7_red', analog_lim_pt7_red_a, data1_index, epoch1maxrec ; 165
			remove_fill_dig_hk, -1, analog_lim_pt7_red_a ; 165
			END
		'analog_lim_pt8_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt8_status', analog_lim_pt8_status_a, data1_index, epoch1maxrec ; 166
			remove_fill_dig_hk, -1, analog_lim_pt8_status_a ; 166
			END
		'analog_lim_pt8_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt8_id', analog_lim_pt8_id_a, data1_index, epoch1maxrec ; 167
			remove_fill_dig_hk, -1, analog_lim_pt8_id_a ; 167
			END
		'analog_lim_pt8_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt8_red', analog_lim_pt8_red_a, data1_index, epoch1maxrec ; 168
			remove_fill_dig_hk, -1, analog_lim_pt8_red_a ; 168
			END
		'analog_lim_pt9_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt9_status', analog_lim_pt9_status_a, data1_index, epoch1maxrec ; 169
			remove_fill_dig_hk, -1, analog_lim_pt9_status_a ; 169
			END
		'analog_lim_pt9_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt9_id', analog_lim_pt9_id_a, data1_index, epoch1maxrec ; 170
			remove_fill_dig_hk, -1, analog_lim_pt9_id_a ; 170
			END
		'analog_lim_pt9_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt9_red', analog_lim_pt9_red_a, data1_index, epoch1maxrec ; 171
			remove_fill_dig_hk, -1, analog_lim_pt9_red_a ; 171
			END
		'analog_lim_pt10_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt10_status', analog_lim_pt10_status_a, data1_index, epoch1maxrec ; 172
			remove_fill_dig_hk, -1, analog_lim_pt10_status_a ; 172
			END
		'analog_lim_pt10_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt10_id', analog_lim_pt10_id_a, data1_index, epoch1maxrec ; 173
			remove_fill_dig_hk, -1, analog_lim_pt10_id_a ; 173
			END
		'analog_lim_pt10_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt10_red', analog_lim_pt10_red_a, data1_index, epoch1maxrec ; 174
			remove_fill_dig_hk, -1, analog_lim_pt10_red_a ; 174
			END
		'analog_lim_pt11_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt11_status', analog_lim_pt11_status_a, data1_index, epoch1maxrec ; 175
			remove_fill_dig_hk, -1, analog_lim_pt11_status_a ; 175
			END
		'analog_lim_pt11_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt11_id', analog_lim_pt11_id_a, data1_index, epoch1maxrec ; 176
			remove_fill_dig_hk, -1, analog_lim_pt11_id_a ; 176
			END
		'analog_lim_pt11_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt11_red', analog_lim_pt11_red_a, data1_index, epoch1maxrec ; 177
			remove_fill_dig_hk, -1, analog_lim_pt11_red_a ; 177
			END
		'analog_lim_pt12_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt12_status', analog_lim_pt12_status_a, data1_index, epoch1maxrec ; 178
			remove_fill_dig_hk, -1, analog_lim_pt12_status_a ; 178
			END
		'analog_lim_pt12_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt12_id', analog_lim_pt12_id_a, data1_index, epoch1maxrec ; 179
			remove_fill_dig_hk, -1, analog_lim_pt12_id_a ; 179
			END
		'analog_lim_pt12_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt12_red', analog_lim_pt12_red_a, data1_index, epoch1maxrec ; 180
			remove_fill_dig_hk, -1, analog_lim_pt12_red_a ; 180
			END
		'analog_lim_pt13_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt13_status', analog_lim_pt13_status_a, data1_index, epoch1maxrec ; 181
			remove_fill_dig_hk, -1, analog_lim_pt13_status_a ; 181
			END
		'analog_lim_pt13_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt13_id', analog_lim_pt13_id_a, data1_index, epoch1maxrec ; 182
			remove_fill_dig_hk, -1, analog_lim_pt13_id_a ; 182
			END
		'analog_lim_pt13_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt13_red', analog_lim_pt13_red_a, data1_index, epoch1maxrec ; 183
			remove_fill_dig_hk, -1, analog_lim_pt13_red_a ; 183
			END
		'analog_lim_pt14_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt14_status', analog_lim_pt14_status_a, data1_index, epoch1maxrec ; 184
			remove_fill_dig_hk, -1, analog_lim_pt14_status_a ; 184
			END
		'analog_lim_pt14_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt14_id', analog_lim_pt14_id_a, data1_index, epoch1maxrec ; 185
			remove_fill_dig_hk, -1, analog_lim_pt14_id_a ; 185
			END
		'analog_lim_pt14_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt14_red', analog_lim_pt14_red_a, data1_index, epoch1maxrec ; 186
			remove_fill_dig_hk, -1, analog_lim_pt14_red_a ; 186
			END
		'analog_lim_pt15_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt15_status', analog_lim_pt15_status_a, data1_index, epoch1maxrec ; 187
			remove_fill_dig_hk, -1, analog_lim_pt15_status_a ; 187
			END
		'analog_lim_pt15_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt15_id', analog_lim_pt15_id_a, data1_index, epoch1maxrec  ; 188
			remove_fill_dig_hk, -1, analog_lim_pt15_id_a ; 188
			END
		'analog_lim_pt15_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt15_red', analog_lim_pt15_red_a, data1_index, epoch1maxrec  ; 189
			remove_fill_dig_hk, -1, analog_lim_pt15_red_a ; 189
			END
		'opmode':  BEGIN
			read_product_dig_hk, cdf_id, 'opmode', opmode_a, data1_index, epoch1maxrec  ; 190
			remove_fill_dig_hk, -1, opmode_a ; 190
			END
		'sw_mode':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_mode', sw_mode_a, data1_index, epoch1maxrec ; 191
			remove_fill_dig_hk, -1, sw_mode_a ; 191
			END
		'proton_mode':  BEGIN
			read_product_dig_hk, cdf_id, 'proton_mode', proton_mode_a, data1_index, epoch1maxrec ; 192
			remove_fill_dig_hk, -1, proton_mode_a ; 192
			END
		'active_supplyid':  BEGIN
			read_product_dig_hk, cdf_id, 'active_supplyid', active_supplyid_a, data1_index, epoch1maxrec ; 193
			remove_fill_dig_hk, -1, active_supplyid_a ; 193
			END
		'supply_coarse_rb':  BEGIN
			read_product_dig_hk, cdf_id, 'supply_coarse_rb', supply_coarse_rb_a, data1_index, epoch1maxrec ; 194
			remove_fill_dig_hk, -1, supply_coarse_rb_a ; 194
			END
		'supply_fine_rb':  BEGIN
			read_product_dig_hk, cdf_id, 'supply_fine_rb', supply_fine_rb_a, data1_index, epoch1maxrec ; 195
			remove_fill_dig_hk, -1, supply_fine_rb_a ; 195
			END
		'swmaint_supplystat':  BEGIN
			read_product_dig_hk, cdf_id, 'swmaint_supplystat', swmaint_supplystat_a, data1_index, epoch1maxrec ; 196
			remove_fill_dig_hk, -1, swmaint_supplystat_a ; 196
			END
		'swmaint_pac_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'swmaint_pac_coarse', swmaint_pac_coarse_a, data1_index, epoch1maxrec ; 197
			remove_fill_dig_hk, -1, swmaint_pac_coarse_a ; 197
			END
		'swmaint_pac_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'swmaint_pac_fine', swmaint_pac_fine_a, data1_index, epoch1maxrec ; 198		
			remove_fill_dig_hk, -1, swmaint_pac_fine_a ; 198
			END


		ENDCASE
	ENDFOR

    END
    'B': BEGIN
	FOR ii = 0, n_elements(products)-1 DO BEGIN 
		CASE products[ii] OF

		'dpu_sw_version':  BEGIN
			read_product_dig_hk, cdf_id, 'dpu_sw_version', dpu_sw_version_b, data1_index, epoch1maxrec ; 0
			remove_fill,_dig_hk -1, dpu_sw_version_b; 0
			END
		'cmd_rcvd_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_rcvd_cnt', cmd_rcvd_cnt_b, data1_index, epoch1maxrec  ; 1
			remove_fill_dig_hk, -1, cmd_rcvd_cnt_b ; 1
			END
		'cmd_exec_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_exec_cnt', cmd_exec_cnt_b, data1_index, epoch1maxrec ; 2
			remove_fill_dig_hk, -1, cmd_exec_cnt_b ; 2
			END
		'cmd_total_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_total_err_cnt', cmd_total_err_cnt_b, data1_index, epoch1maxrec ; 3
			remove_fill_dig_hk, -1, cmd_total_err_cnt_b ; 3
			END
		'cmd_parity_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_parity_err_cnt', cmd_parity_err_cnt_b,  data1_index, epoch1maxrec ; 4
			remove_fill_dig_hk, -1, cmd_parity_err_cnt_b ; 4
			END
		'cmd_frame_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_frame_err_cnt', cmd_frame_err_cnt_b, data1_index, epoch1maxrec ; 5
			remove_fill_dig_hk, -1, cmd_frame_err_cnt_b ; 5
			END
		'cmd_illegal_err_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'cmd_illegal_err_cnt', cmd_illegal_err_cnt_b, data1_index, epoch1maxrec ; 6
			remove_fill_dig_hk, -1, cmd_illegal_err_cnt_b ; 6
			END
		'ic_status_reg':  BEGIN
			read_product_dig_hk, cdf_id, 'ic_status_reg', ic_status_reg_b, data1_index, epoch1maxrec ; 7
			remove_fill_dig_hk, -1, ic_status_reg_b ; 7
			END
		'ic_ctl_reg':  BEGIN
			read_product_dig_hk, cdf_id, 'ic_ctl_reg', ic_ctl_reg_b, data1_index, epoch1maxrec ; 8
			remove_fill_dig_hk, -1, ic_ctl_reg_b ; 8
			END
		'lbc_reset_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_reset_ctl', lbc_reset_ctl_b, data1_index, epoch1maxrec ; 9
			remove_fill_dig_hk, -1, lbc_reset_ctl_b ; 9
			END
		'lbc_mode_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_mode_ctl', lbc_mode_ctl_b, data1_index, epoch1maxrec ; 10
			remove_fill_dig_hk, -1, lbc_mode_ctl_b ; 10
			END
		'lbc_logic_ctl_a':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_logic_ctl_a', lbc_logic_ctl_a_b, data1_index, epoch1maxrec ; 11
			remove_fill_dig_hk, -1, lbc_logic_ctl_a_b ; 11
			END
		'lbc_logic_ctl_b':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_logic_ctl_b', lbc_logic_ctl_b_b, data1_index, epoch1maxrec ; 12
			remove_fill_dig_hk, -1, lbc_logic_ctl_b_b ; 12
			END
		'lbc_tac_pwr_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_tac_pwr_ctl', lbc_tac_pwr_ctl_b, data1_index, epoch1maxrec ; 13
			remove_fill_dig_hk, -1, lbc_tac_pwr_ctl_b ; 13
			END
		'lbc_reg_seq':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_reg_seq', lbc_reg_seq_b, data1_index, epoch1maxrec ; 14
			remove_fill_dig_hk, -1, lbc_reg_seq_b ; 14
			END
		'lbc_event_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_event_ctl', lbc_event_ctl_b, data1_index, epoch1maxrec ; 15
			remove_fill_dig_hk, -1, lbc_event_ctl_b ; 15
			END
		'lbc_rlim_ch':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_rlim_ch', lbc_rlim_ch_b, data1_index, epoch1maxrec ; 16
			remove_fill_dig_hk, -1, lbc_rlim_ch_b ; 16
			END
		'lbc_rlim_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_rlim_hi', lbc_rlim_hi_b, data1_index, epoch1maxrec ; 17
			remove_fill_dig_hk, -1, lbc_rlim_hi_b ; 17
			END
		'lbc_rlim_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbc_rlim_lo', lbc_rlim_lo_b, data1_index, epoch1maxrec ; 18
			remove_fill_dig_hk, -1, lbc_rlim_lo_b ; 18
			END
		'lbe_pos_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_ctrl', lbe_pos_ctrl_b, data1_index, epoch1maxrec ; 19
			remove_fill_dig_hk, -1, lbe_pos_ctrl_b ; 19
			END
		'lbe_pos_disable0':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_disable0', lbe_pos_disable0_b, data1_index, epoch1maxrec ; 20
			remove_fill_dig_hk, -1, lbe_pos_disable0_b ; 20
			END
		'lbe_pos_disable2':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_disable2', lbe_pos_disable2_b, data1_index, epoch1maxrec ; 21
			remove_fill_dig_hk, -1, lbe_pos_disable2_b ; 21
			END
		'lbe_tac0_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_ctrl', lbe_tac0_ctrl_b, data1_index, epoch1maxrec ; 22
			remove_fill_dig_hk, -1, lbe_tac0_ctrl_b ; 22
			END
		'lbe_tac0_dac':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_dac', lbe_tac0_dac_b, data1_index, epoch1maxrec ; 23
			remove_fill_dig_hk, -1, lbe_tac0_dac_b ; 23
			END
		'lbe_tac2_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_ctrl', lbe_tac2_ctrl_b, data1_index, epoch1maxrec ; 24
			remove_fill_dig_hk, -1, lbe_tac2_ctrl_b ; 24
			END
		'lbe_tac2_dac':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_dac', lbe_tac2_dac_b, data1_index, epoch1maxrec ; 25
			remove_fill_dig_hk, -1, lbe_tac2_dac_b ; 25
			END
		'lbe_tac0_under_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_under_hi', lbe_tac0_under_hi_b, data1_index, epoch1maxrec ; 26
			remove_fill_dig_hk, -1, lbe_tac0_under_hi_b ; 26
			END
		'lbe_tac0_under_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_under_lo', lbe_tac0_under_lo_b, data1_index, epoch1maxrec ; 27
			remove_fill_dig_hk, -1, lbe_tac0_under_lo_b ; 27
			END
		'lbe_tac0_over_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_over_hi', lbe_tac0_over_hi_b, data1_index, epoch1maxrec ; 28
			remove_fill_dig_hk, -1, lbe_tac0_over_hi_b ; 28
			END
		'lbe_tac0_over_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac0_over_lo', lbe_tac0_over_lo_b, data1_index, epoch1maxrec ; 29
			remove_fill_dig_hk, -1, lbe_tac0_over_lo_b ; 29
			END
		'lbe_tac2_under_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_under_hi', lbe_tac2_under_hi_b, data1_index, epoch1maxrec ; 30
			remove_fill_dig_hk, -1, lbe_tac2_under_hi_b ; 30
			END
		'lbe_tac2_under_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_under_lo', lbe_tac2_under_lo_b, data1_index, epoch1maxrec ; 31
			remove_fill_dig_hk, -1, lbe_tac2_under_lo_b ; 31
			END
		'lbe_tac2_over_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_over_hi', lbe_tac2_over_hi_b, data1_index, epoch1maxrec ; 32
			remove_fill_dig_hk, -1, lbe_tac2_over_hi_b ; 32
			END
		'lbe_tac2_over_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_tac2_over_lo', lbe_tac2_over_lo_b, data1_index, epoch1maxrec ; 33
			remove_fill_dig_hk, -1, lbe_tac2_over_lo_b ; 33
			END
		'lbe_ssd_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_ctrl', lbe_ssd_ctrl_b, data1_index, epoch1maxrec ; 34
			remove_fill_dig_hk, -1, lbe_ssd_ctrl_b ; 34
			END
		'lbe_ssd_cmd_h':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_cmd_h', lbe_ssd_cmd_h_b, data1_index, epoch1maxrec ; 35
			remove_fill_dig_hk, -1, lbe_ssd_cmd_h_b ; 35
			END
		'lbe_ssd_cmd_l':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_cmd_l', lbe_ssd_cmd_l_b, data1_index, epoch1maxrec ; 36
			remove_fill_dig_hk, -1, lbe_ssd_cmd_l_b ; 36
			END
		'lbe_ssd_dis':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_dis', lbe_ssd_dis_b, data1_index, epoch1maxrec ; 37
			remove_fill_dig_hk, -1, lbe_ssd_dis_b ; 37
			END
		'lbe_ssd_under_hi':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_under_hi', lbe_ssd_under_hi_b, data1_index, epoch1maxrec ; 38
			remove_fill_dig_hk, -1, lbe_ssd_under_hi_b ; 38
			END
		'lbe_ssd_under_lo':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_under_lo', lbe_ssd_under_lo_b, data1_index, epoch1maxrec ; 39
			remove_fill_dig_hk, -1, lbe_ssd_under_lo_b ; 39
			END
		'lbe_ssd_over_hi':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_over_hi', lbe_ssd_over_hi_b, data1_index, epoch1maxrec ; 40
			remove_fill_dig_hk, -1, lbe_ssd_over_hi_b ; 40
			END
		'lbe_ssd_over_lo':  BEGIN
			read_product_dig_hk, cdf_id,'lbe_ssd_over_lo', lbe_ssd_over_lo_b, data1_index, epoch1maxrec ; 41
			remove_fill_dig_hk, -1, lbe_ssd_over_lo_b ; 41
			END
		'lbe_sel_ctrl':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_sel_ctrl', lbe_sel_ctrl_b, data1_index, epoch1maxrec ; 42
			remove_fill_dig_hk, -1, lbe_sel_ctrl_b ; 42
			END
		'lbe_trig_mode':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_trig_mode', lbe_trig_mode_b, data1_index, epoch1maxrec ; 43
			remove_fill_dig_hk, -1, lbe_trig_mode_b ; 43
			END
		'lbe_esa_step':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_esa_step', lbe_esa_step_b, data1_index, epoch1maxrec ; 44
			remove_fill_dig_hk, -1, lbe_esa_step_b ; 44
			END
		'lbe_defl_step':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_defl_step', lbe_defl_step_b, data1_index, epoch1maxrec ; 45
			remove_fill_dig_hk, -1, lbe_defl_step_b ; 45
			END
		'lbe_ssd_offset0':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset0', lbe_ssd_offset0_b, data1_index, epoch1maxrec ; 46
			remove_fill_dig_hk, -1, lbe_ssd_offset0_b ; 46
			END
		'lbe_ssd_offset1':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset1', lbe_ssd_offset1_b, data1_index, epoch1maxrec ; 47
			remove_fill_dig_hk, -1, lbe_ssd_offset1_b ; 47
			END
		'lbe_ssd_offset2':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset2', lbe_ssd_offset2_b, data1_index, epoch1maxrec ; 48
			remove_fill_dig_hk, -1, lbe_ssd_offset2_b ; 48
			END
		'lbe_ssd_offset3':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset3', lbe_ssd_offset3_b, data1_index, epoch1maxrec ; 49
			remove_fill_dig_hk, -1, lbe_ssd_offset3_b ; 49
			END
		'lbe_ssd_offset4':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset4', lbe_ssd_offset4_b, data1_index, epoch1maxrec ; 50
			remove_fill_dig_hk, -1, lbe_ssd_offset4_b ; 50
			END
		'lbe_ssd_offset5':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset5', lbe_ssd_offset5_b, data1_index, epoch1maxrec ; 51
			remove_fill_dig_hk, -1, lbe_ssd_offset5_b ; 51
			END
		'lbe_ssd_offset6':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset6', lbe_ssd_offset6_b, data1_index, epoch1maxrec ; 52
			remove_fill_dig_hk, -1, lbe_ssd_offset6_b ; 52
			END
		'lbe_ssd_offset7':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset7', lbe_ssd_offset7_b, data1_index, epoch1maxrec ; 53
			remove_fill_dig_hk, -1, lbe_ssd_offset7_b ; 53
			END
		'lbe_stim_enable':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_stim_enable', lbe_stim_enable_b, data1_index, epoch1maxrec ; 54
			remove_fill_dig_hk, -1, lbe_stim_enable_b ; 54
			END
		'lbe_stim_freq_hi':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_stim_freq_hi', lbe_stim_freq_hi_b, data1_index, epoch1maxrec ; 55
			remove_fill_dig_hk, -1, lbe_stim_freq_hi_b ; 55
			END
		'lbe_stim_freq_lo':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_stim_freq_lo', lbe_stim_freq_lo_b, data1_index, epoch1maxrec ; 56
			remove_fill_dig_hk, -1, lbe_stim_freq_lo_b ; 56
			END
		'lbe_sel0_window':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_sel0_window', lbe_sel0_window_b, data1_index, epoch1maxrec ; 57
			remove_fill_dig_hk, -1, lbe_sel0_window_b ; 57
			END
		'lbe_sel2_window':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_sel2_window', lbe_sel2_window_b, data1_index, epoch1maxrec ; 58
			remove_fill_dig_hk, -1, lbe_sel2_window_b ; 58
			END
		'lbe_ssd_offset8':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset8', lbe_ssd_offset8_b, data1_index, epoch1maxrec ; 59
			remove_fill_dig_hk, -1, lbe_ssd_offset8_b ; 59
			END
		'lbe_ssd_offset9':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset9', lbe_ssd_offset9_b, data1_index, epoch1maxrec ; 60
			remove_fill_dig_hk, -1, lbe_ssd_offset9_b ; 60
			END
		'lbe_ssd_offset10':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset10', lbe_ssd_offset10_b, data1_index, epoch1maxrec ; 61
			remove_fill_dig_hk, -1, lbe_ssd_offset10_b ; 61
			END
		'lbe_ssd_offset11':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset11', lbe_ssd_offset11_b, data1_index, epoch1maxrec ; 62
			remove_fill_dig_hk, -1, lbe_ssd_offset11_b ; 62
			END
		'lbe_ssd_offset12':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset12', lbe_ssd_offset12_a, data1_index, epoch1maxrec ; 63
			remove_fill_dig_hk, -1, lbe_ssd_offset12_a ; 63
			END
		'lbe_ssd_offset13':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset13', lbe_ssd_offset13_a, data1_index, epoch1maxrec ; 64
			remove_fill_dig_hk, -1, lbe_ssd_offset13_a ; 64
			END
		'lbe_ssd_offset14':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset14', lbe_ssd_offset14_a, data1_index, epoch1maxrec ; 65
			remove_fill_dig_hk, -1, lbe_ssd_offset14_a ; 65
			END
		'lbe_ssd_offset15':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_ssd_offset15', lbe_ssd_offset15_a, data1_index, epoch1maxrec ; 66
			remove_fill_dig_hk, -1, lbe_ssd_offset15_a ; 66
			END
		'lbe_pos_ra':  BEGIN
			read_product_dig_hk, cdf_id, 'lbe_pos_ra', lbe_pos_ra_a, data1_index, epoch1maxrec ; 67
			remove_fill_dig_hk, -1, lbe_pos_ra_a ; 67
			END
		'dacm_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_mcp_ssd_ctl_mcp_limit', dacm_pac_mcp_ssd_ctl_mcp_limit_a, data1_index, epoch1maxrec ; 68
			remove_fill_dig_hk, -1, dacm_pac_mcp_ssd_ctl_mcp_limit_a ; 68
			END
		'dacm_pac_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_limit', dacm_pac_limit_b, data1_index, epoch1maxrec ; 69
			remove_fill_dig_hk, -1, dacm_pac_limit_b ; 69
			END
		'dacm_esa_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_esa_ctl', dacm_esa_ctl_b, data1_index, epoch1maxrec ; 70
			remove_fill_dig_hk, -1, dacm_esa_ctl_b ; 70
			END
		'dacm_s_ch_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_ctl', dacm_s_ch_ctl_b, data1_index, epoch1maxrec ; 71
			remove_fill_dig_hk, -1, dacm_s_ch_ctl_b ; 71
			END
		'dacm_dfl_1_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_ctl', dacm_dfl_1_ctl_b, data1_index, epoch1maxrec ; 72
			remove_fill_dig_hk, -1, dacm_dfl_1_ctl_b ; 72
			END
		'dacm_dfl_2_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_ctl', dacm_dfl_2_ctl_b, data1_index, epoch1maxrec ; 73
			remove_fill_dig_hk, -1, dacm_dfl_2_ctl_b ; 73
			END
		'dacm_control':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_control', dacm_control_b, data1_index, epoch1maxrec ; 74
			remove_fill_dig_hk, -1, dacm_control_b ; 74
			END
		'dacm_status':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_status', dacm_status_b, data1_index, epoch1maxrec ; 75
			remove_fill_dig_hk, -1, dacm_status_b ; 75
			END
		'dacm_adc_lu_ctr':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_adc_lu_ctr', dacm_adc_lu_ctr_b, data1_index, epoch1maxrec ;76
			remove_fill_dig_hk, -1, dacm_adc_lu_ctr_b ; 76
			END
		'dacm_dfl_1_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_offset', dacm_dfl_1_offset_b, data1_index, epoch1maxrec ; 77
			remove_fill_dig_hk, -1, dacm_dfl_1_offset_b ; 77
			END
		'dacm_dfl_2_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_offset', dacm_dfl_2_offset_b, data1_index, epoch1maxrec ; 78
			remove_fill_dig_hk, -1, dacm_dfl_2_offset_b ; 78
			END
		'dacm_pac_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_coarse', dacm_pac_coarse_b, data1_index, epoch1maxrec ; 79
			remove_fill_dig_hk, -1, dacm_pac_coarse_b ; 79
			END
		'dacm_pac_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_fine', dacm_pac_fine_b, data1_index, epoch1maxrec ; 80
			remove_fill_dig_hk, -1, dacm_pac_fine_b ; 80
			END
		'dacm_pac_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_cm_fs_coarse', dacm_pac_cm_fs_coarse_b, data1_index, epoch1maxrec ; 81
			remove_fill_dig_hk, -1, dacm_pac_cm_fs_coarse_b ; 81
			END
		'dacm_pac_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_pac_cm_fs_fine', dacm_pac_cm_fs_fine_b, data1_index, epoch1maxrec ; 82
			remove_fill_dig_hk, -1, dacm_pac_cm_fs_fine_b ; 82
			END
		'dacm_mcp_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_coarse', dacm_mcp_coarse_b, data1_index, epoch1maxrec ; 83
			remove_fill_dig_hk, -1, dacm_mcp_coarse_b ; 83
			END
		'dacm_mcp_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_fine', dacm_mcp_fine_b, data1_index, epoch1maxrec ; 84
			remove_fill_dig_hk, -1, dacm_mcp_fine_b ; 84
			END
		'dacm_mcp_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_cm_fs_coarse', dacm_mcp_cm_fs_coarse_b, data1_index, epoch1maxrec ; 85
			remove_fill_dig_hk, -1, dacm_mcp_cm_fs_coarse_b ; 85
			END
		'dacm_mcp_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_mcp_cm_fs_fine', dacm_mcp_cm_fs_fine_b, data1_index, epoch1maxrec ; 86
			remove_fill_dig_hk, -1, dacm_mcp_cm_fs_fine_b ; 86
			END
		'dacm_ssd_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_ssd_coarse', dacm_ssd_coarse_b, data1_index, epoch1maxrec ; 87
			remove_fill_dig_hk, -1, dacm_ssd_coarse_b ; 87
			END
		'dacm_ssd_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_ssd_fine', dacm_ssd_fine_b, data1_index, epoch1maxrec ; 88
			remove_fill_dig_hk, -1, dacm_ssd_fine_b ; 88
			END
		'dacm_esa_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_esa_coarse', dacm_esa_coarse_b, data1_index, epoch1maxrec ; 89
			remove_fill_dig_hk, -1, dacm_esa_coarse_b ; 89
			END
		'dacm_esa_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_esa_fine', dacm_esa_fine_b, data1_index, epoch1maxrec ; 90
			remove_fill_dig_hk, -1, dacm_esa_fine_b ; 90
			END
		'dacm_s_ch_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_coarse', dacm_s_ch_coarse_b, data1_index, epoch1maxrec ; 91
			remove_fill_dig_hk, -1, dacm_s_ch_coarse_b ; 91
			END
		'dacm_s_ch_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_fine', dacm_s_ch_fine_b, data1_index, epoch1maxrec ; 92
			remove_fill_dig_hk, -1, dacm_s_ch_fine_b ; 92
			END
		'dacm_s_ch_tap_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_tap_coarse', dacm_s_ch_tap_coarse_b, data1_index, epoch1maxrec ; 93
			remove_fill_dig_hk, -1, dacm_s_ch_tap_coarse_b ; 93
			END
		'dacm_s_ch_tap_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_s_ch_tap_fine', dacm_s_ch_tap_fine_b, data1_index, epoch1maxrec ; 94
			remove_fill_dig_hk, -1, dacm_s_ch_tap_fine_b ; 94
			END
		'dacm_dfl_1_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_coarse', dacm_dfl_1_coarse_b, data1_index, epoch1maxrec ; 95
			remove_fill_dig_hk, -1, dacm_dfl_1_coarse_b ; 95
			END
		'dacm_dfl_1_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_fine', dacm_dfl_1_fine_b, data1_index, epoch1maxrec ; 96
			remove_fill_dig_hk, -1, dacm_dfl_1_fine_b ; 96
			END
		'dacm_dfl_1_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_1_dfine', dacm_dfl_1_dfine_b, data1_index, epoch1maxrec ; 97
			remove_fill_dig_hk, -1, dacm_dfl_1_dfine_b ; 97
			END
		'dacm_dfl_2_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_coarse', dacm_dfl_2_coarse_b, data1_index, epoch1maxrec ; 98
			remove_fill_dig_hk, -1, dacm_dfl_2_coarse_b ; 98
			END
		'dacm_dfl_2_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_fine', dacm_dfl_2_fine_b, data1_index, epoch1maxrec ; 99
			remove_fill_dig_hk, -1, dacm_dfl_2_fine_b ; 99
			END
		'dacm_dfl_2_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacm_dfl_2_dfine', dacm_dfl_2_dfine_b, data1_index, epoch1maxrec ; 100
			remove_fill_dig_hk, -1, dacm_dfl_2_dfine_b ; 100
			END
		'dacr_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_pac_mcp_ssd_ctl_mcp_limit', dacr_pac_mcp_ssd_ctl_mcp_limit_b, data1_index, epoch1maxrec ; 101
			remove_fill_dig_hk, -1, dacr_pac_mcp_ssd_ctl_mcp_limit_b ; 101
			END
		'dacr_pac_limit':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_pac_limit', dacr_pac_limit_b, data1_index, epoch1maxrec ; 102
			remove_fill_dig_hk, -1, dacr_pac_limit_b ; 102
			END
		'dacr_esa_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_esa_ctl', dacr_esa_ctl_b, data1_index, epoch1maxrec ; 103
			remove_fill_dig_hk, -1, dacr_esa_ctl_b ; 103
			END
		'dacr_s_ch_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_s_ch_ctl', dacr_s_ch_ctl_b, data1_index, epoch1maxrec  ; 104
			remove_fill_dig_hk, -1, dacr_s_ch_ctl_b ; 104
			END
		'dacr_dfl_1_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_ctl', dacr_dfl_1_ctl_b, data1_index, epoch1maxrec ; 105
			remove_fill_dig_hk, -1, dacr_dfl_1_ctl_b ; 105
			END
		'dacr_dfl_2_ctl':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_ctl', dacr_dfl_2_ctl_b, data1_index, epoch1maxrec ; 106
			remove_fill_dig_hk, -1, dacr_dfl_2_ctl_b ; 106
			END
		'dacr_control':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_control', dacr_control_b, data1_index, epoch1maxrec ; 107
			remove_fill_dig_hk, -1, dacr_control_b ; 107
			END
		'dacr_status':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_status', dacr_status_b, data1_index, epoch1maxrec ; 108
			remove_fill_dig_hk, -1, dacr_status_b ; 108
			END
		'dacr_adc_lu_ctr':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_adc_lu_ctr', dacr_adc_lu_ctr_b, data1_index, epoch1maxrec  ; 109
			remove_fill_dig_hk, -1, dacr_adc_lu_ctr_b ; 109
			END
		'dacr_dfl_1_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_offset', dacr_dfl_1_offset_b, data1_index, epoch1maxrec ; 110
			remove_fill_dig_hk, -1, dacr_dfl_1_offset_b ; 110
			END
		'dacr_dfl_2_offset':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_offset', dacr_dfl_2_offset_b, data1_index, epoch1maxrec ; 111
			remove_fill_dig_hk, -1, dacr_dfl_2_offset_b ; 111
			END
		'dacr_c_pac_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_coarse', dacr_c_pac_coarse_b, data1_index, epoch1maxrec ; 112
			remove_fill_dig_hk, -1, dacr_c_pac_coarse_b ; 112
			END
		'dacr_c_pac_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_fine', dacr_c_pac_fine_b, data1_index, epoch1maxrec ; 113
			remove_fill_dig_hk, -1, dacr_c_pac_fine_b ; 113
			END
		'dacr_c_pac_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_cm_fs_coarse', dacr_c_pac_cm_fs_coarse_b, data1_index, epoch1maxrec ; 114
			remove_fill_dig_hk, -1, dacr_c_pac_cm_fs_coarse_b ; 114
			END
		'dacr_c_pac_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_pac_cm_fs_fine', dacr_c_pac_cm_fs_fine_b, data1_index, epoch1maxrec ; 115
			remove_fill_dig_hk, -1, dacr_c_pac_cm_fs_fine_b ; 115
			END
		'dacr_c_mcp_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_coarse', dacr_c_mcp_coarse_b, data1_index, epoch1maxrec  ; 116
			remove_fill_dig_hk, -1, dacr_c_mcp_coarse_b ; 116
			END
		'dacr_c_mcp_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_fine', dacr_c_mcp_fine_b, data1_index, epoch1maxrec ; 117
			remove_fill_dig_hk, -1, dacr_c_mcp_fine_b ; 117
			END
		'dacr_c_mcp_cm_fs_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_cm_fs_coarse', dacr_c_mcp_cm_fs_coarse_b, data1_index, epoch1maxrec ; 118
			remove_fill_dig_hk, -1, dacr_c_mcp_cm_fs_coarse_b ; 118
			END
		'dacr_c_mcp_cm_fs_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_mcp_cm_fs_fine', dacr_c_mcp_cm_fs_fine_b, data1_index, epoch1maxrec ; 119
			remove_fill_dig_hk, -1, dacr_c_mcp_cm_fs_fine_b ; 119
			END
		'dacr_c_ssd_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_ssd_coarse', dacr_c_ssd_coarse_b, data1_index, epoch1maxrec ; 120
			remove_fill_dig_hk, -1, dacr_c_ssd_coarse_b ; 120
			END
		'dacr_c_ssd_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_ssd_fine', dacr_c_ssd_fine_b, data1_index, epoch1maxrec ; 121
			remove_fill_dig_hk, -1, dacr_c_ssd_fine_b ; 121
			END
		'dacr_c_esa_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_esa_coarse', dacr_c_esa_coarse_b, data1_index, epoch1maxrec ; 122
			remove_fill_dig_hk, -1, dacr_c_esa_coarse_b ; 122
			END
		'dacr_c_esa_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_esa_fine', dacr_c_esa_fine_b, data1_index, epoch1maxrec ; 123
			remove_fill_dig_hk, -1, dacr_c_esa_fine_b ; 123
			END
		'dacr_c_s_ch_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_coarse', dacr_c_s_ch_coarse_b, data1_index, epoch1maxrec ; 124
			remove_fill_dig_hk, -1, dacr_c_s_ch_coarse_b ; 124
			END
		'dacr_c_s_ch_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_fine', dacr_c_s_ch_fine_b, data1_index, epoch1maxrec ; 125
			remove_fill_dig_hk, -1, dacr_c_s_ch_fine_b ; 125
			END
		'dacr_c_s_ch_tap_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_tap_coarse', dacr_c_s_ch_tap_coarse_b, data1_index, epoch1maxrec ; 126
			remove_fill_dig_hk, -1, dacr_c_s_ch_tap_coarse_b ; 126
			END
		'dacr_c_s_ch_tap_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_c_s_ch_tap_fine', dacr_c_s_ch_tap_fine_b, data1_index, epoch1maxrec ; 127
			remove_fill_dig_hk, -1, dacr_c_s_ch_tap_fine_b ; 127
			END
		'dacr_dfl_1_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_coarse', dacr_dfl_1_coarse_b, data1_index, epoch1maxrec ; 128
			remove_fill_dig_hk, -1, dacr_dfl_1_coarse_b ; 128
			END
		'dacr_dfl_1_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_fine', dacr_dfl_1_fine_b, data1_index, epoch1maxrec ; 129
			remove_fill_dig_hk, -1, dacr_dfl_1_fine_b ; 129
			END
		'dacr_dfl_1_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_1_dfine', dacr_dfl_1_dfine_b, data1_index, epoch1maxrec  ; 130
			remove_fill_dig_hk, -1, dacr_dfl_1_dfine_b ; 130
			END
		'dacr_dfl_2_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_coarse', dacr_dfl_2_coarse_b, data1_index, epoch1maxrec  ; 131
			remove_fill_dig_hk, -1, dacr_dfl_2_coarse_b ; 131
			END
		'dacr_dfl_2_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_fine', dacr_dfl_2_fine_b, data1_index, epoch1maxrec ; 132
			remove_fill_dig_hk, -1, dacr_dfl_2_fine_b ; 132
			END
		'dacr_dfl_2_dfine':  BEGIN
			read_product_dig_hk, cdf_id, 'dacr_dfl_2_dfine', dacr_dfl_2_dfine_b, data1_index, epoch1maxrec ; 133
			remove_fill_dig_hk, -1, dacr_dfl_2_dfine_b ; 133
			END
		'sw_status1':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_status1', sw_status1_b, data1_index, epoch1maxrec ; 134
			remove_fill_dig_hk, -1, sw_status1_b ; 134
			END
		'sw_hv_ramp_status':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_hv_ramp_status', sw_hv_ramp_status_b, data1_index, epoch1maxrec ; 135
			remove_fill_dig_hk, -1, sw_hv_ramp_status_b ; 135
			END
		'sw_hv_enable_status':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_hv_enable_status', sw_hv_enable_status_b, data1_index, epoch1maxrec ; 136
			remove_fill_dig_hk, -1, sw_hv_enable_status_b ; 136
			END
		'sw_hv_limit_status':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_hv_limit_status', sw_hv_limit_status_b, data1_index, epoch1maxrec ; 137
			remove_fill_dig_hk, -1, sw_hv_limit_status_b ; 137
			END
		'sw_eepromchksum':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_eepromchksum', sw_eepromchksum_b, data1_index, epoch1maxrec ; 138
			remove_fill_dig_hk, -1, sw_eepromchksum_b ; 138
			END
		'hkp_sampletime':  BEGIN
			read_product_dig_hk, cdf_id, 'hkp_sampletime', hkp_sampletime_b, data1_index, epoch1maxrec ; 139
			remove_fill_dig_hk, -1, hkp_sampletime_b ; 139
			END
		'pac_discharge_status':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_status', pac_discharge_status_b, data1_index, epoch1maxrec ; 140
			remove_fill_dig_hk, -1, pac_discharge_status_b ; 140
			END
		'pac_discharge_cnt':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_cnt', pac_discharge_cnt_b, data1_index, epoch1maxrec ; 141
			remove_fill_dig_hk, -1, pac_discharge_cnt_b ; 141
			END
		'pac_discharge_conseccntr':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_conseccntr', pac_discharge_conseccntr_b, data1_index, epoch1maxrec ; 142
			remove_fill_dig_hk, -1, pac_discharge_conseccntr_b ; 142
			END
		'pac_discharge_safe_att':  BEGIN
			read_product_dig_hk, cdf_id, 'pac_discharge_safe_att', pac_discharge_safe_att_b, data1_index, epoch1maxrec ; 143
			remove_fill_dig_hk, -1, pac_discharge_safe_att_b ; 143
			END
		'analog_limit_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_limit_status', analog_limit_status_b, data1_index, epoch1maxrec ; 144
			remove_fill_dig_hk, -1, analog_limit_status_b ; 144
			END
		'analog_lim_pt1_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt1_status', analog_lim_pt1_status_b, data1_index, epoch1maxrec ; 145
			remove_fill_dig_hk, -1, analog_lim_pt1_status_b ; 145
			END
		'analog_lim_pt1_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt1_id', analog_lim_pt1_id_b, data1_index, epoch1maxrec ; 146
			remove_fill_dig_hk, -1, analog_lim_pt1_id_b ; 146
			END
		'analog_lim_pt1_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt1_red', analog_lim_pt1_red_b, data1_index, epoch1maxrec ; 147
			remove_fill_dig_hk, -1, analog_lim_pt1_red_b ; 147
			END
		'analog_lim_pt2_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt2_status', analog_lim_pt2_status_b, data1_index, epoch1maxrec ; 148
			remove_fill_dig_hk, -1, analog_lim_pt2_status_b ; 148
			END
		'analog_lim_pt2_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt2_id', analog_lim_pt2_id_b, data1_index, epoch1maxrec ; 149
			remove_fill_dig_hk, -1, analog_lim_pt2_id_b ; 149
			END
		'analog_lim_pt2_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt2_red', analog_lim_pt2_red_b, data1_index, epoch1maxrec ; 150
			remove_fill_dig_hk, -1, analog_lim_pt2_red_b ; 150
			END
		'analog_lim_pt3_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt3_status', analog_lim_pt3_status_b, data1_index, epoch1maxrec ; 151
			remove_fill_dig_hk, -1, analog_lim_pt3_status_b ; 151
			END
		'analog_lim_pt3_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt3_id', analog_lim_pt3_id_b, data1_index, epoch1maxrec ; 152
			remove_fill_dig_hk, -1, analog_lim_pt3_id_b ; 152
			END
		'analog_lim_pt3_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt3_red', analog_lim_pt3_red_b, data1_index, epoch1maxrec ; 153
			remove_fill_dig_hk, -1, analog_lim_pt3_red_b ; 153
			END
		'analog_lim_pt4_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt4_status', analog_lim_pt4_status_b, data1_index, epoch1maxrec ; 154
			remove_fill_dig_hk, -1, analog_lim_pt4_status_b ; 154
			END
		'analog_lim_pt4_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt4_id', analog_lim_pt4_id_b, data1_index, epoch1maxrec ; 155
			remove_fill_dig_hk, -1, analog_lim_pt4_id_b ; 155
			END
		'analog_lim_pt4_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt4_red', analog_lim_pt4_red_b, data1_index, epoch1maxrec ; 156
			remove_fill_dig_hk, -1, analog_lim_pt4_red_b ; 156
			END
		'analog_lim_pt5_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt5_status', analog_lim_pt5_status_b, data1_index, epoch1maxrec ; 157
			remove_fill_dig_hk, -1, analog_lim_pt5_status_b ; 157
			END
		'analog_lim_pt5_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt5_id', analog_lim_pt5_id_b, data1_index, epoch1maxrec ; 158
			remove_fill_dig_hk, -1, analog_lim_pt5_id_b ; 158
			END
		'analog_lim_pt5_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt5_red', analog_lim_pt5_red_b, data1_index, epoch1maxrec ; 159
			remove_fill_dig_hk, -1, analog_lim_pt5_red_b ; 159
			END
		'analog_lim_pt6_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt6_status', analog_lim_pt6_status_b, data1_index, epoch1maxrec ; 160
			remove_fill_dig_hk, -1, analog_lim_pt6_status_b ; 160
			END
		'analog_lim_pt6_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt6_id', analog_lim_pt6_id_b, data1_index, epoch1maxrec ; 161
			remove_fill_dig_hk, -1, analog_lim_pt6_id_b ; 161
			END
		'analog_lim_pt6_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt6_red', analog_lim_pt6_red_b, data1_index, epoch1maxrec ; 162
			remove_fill_dig_hk, -1, analog_lim_pt6_red_b ; 162
			END
		'analog_lim_pt7_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt7_status', analog_lim_pt7_status_b, data1_index, epoch1maxrec ; 163
			remove_fill_dig_hk, -1, analog_lim_pt7_status_b ; 163
			END
		'analog_lim_pt7_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt7_id', analog_lim_pt7_id_b, data1_index, epoch1maxrec ; 164
			remove_fill_dig_hk, -1, analog_lim_pt7_id_b ; 164
			END
		'analog_lim_pt7_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt7_red', analog_lim_pt7_red_b, data1_index, epoch1maxrec ; 165
			remove_fill_dig_hk, -1, analog_lim_pt7_red_b ; 165
			END
		'analog_lim_pt8_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt8_status', analog_lim_pt8_status_b, data1_index, epoch1maxrec ; 166
			remove_fill_dig_hk, -1, analog_lim_pt8_status_b ; 166
			END
		'analog_lim_pt8_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt8_id', analog_lim_pt8_id_b, data1_index, epoch1maxrec ; 167
			remove_fill_dig_hk, -1, analog_lim_pt8_id_b ; 167
			END
		'analog_lim_pt8_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt8_red', analog_lim_pt8_red_b, data1_index, epoch1maxrec ; 168
			remove_fill_dig_hk, -1, analog_lim_pt8_red_b ; 168
			END
		'analog_lim_pt9_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt9_status', analog_lim_pt9_status_b, data1_index, epoch1maxrec ; 169
			remove_fill_dig_hk, -1, analog_lim_pt9_status_b ; 169
			END
		'analog_lim_pt9_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt9_id', analog_lim_pt9_id_b, data1_index, epoch1maxrec ; 170
			remove_fill_dig_hk, -1, analog_lim_pt9_id_b ; 170
			END
		'analog_lim_pt9_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt9_red', analog_lim_pt9_red_b, data1_index, epoch1maxrec ; 171
			remove_fill_dig_hk, -1, analog_lim_pt9_red_b ; 171
			END
		'analog_lim_pt10_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt10_status', analog_lim_pt10_status_b, data1_index, epoch1maxrec ; 172
			remove_fill_dig_hk, -1, analog_lim_pt10_status_b ; 172
			END
		'analog_lim_pt10_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt10_id', analog_lim_pt10_id_b, data1_index, epoch1maxrec ; 173
			remove_fill_dig_hk, -1, analog_lim_pt10_id_b ; 173
			END
		'analog_lim_pt10_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt10_red', analog_lim_pt10_red_b, data1_index, epoch1maxrec ; 174
			remove_fill_dig_hk, -1, analog_lim_pt10_red_b ; 174
			END
		'analog_lim_pt11_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt11_status', analog_lim_pt11_status_b, data1_index, epoch1maxrec ; 175
			remove_fill_dig_hk, -1, analog_lim_pt11_status_b ; 175
			END
		'analog_lim_pt11_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt11_id', analog_lim_pt11_id_b, data1_index, epoch1maxrec ; 176
			remove_fill_dig_hk, -1, analog_lim_pt11_id_b ; 176
			END
		'analog_lim_pt11_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt11_red', analog_lim_pt11_red_b, data1_index, epoch1maxrec ; 177
			remove_fill_dig_hk, -1, analog_lim_pt11_red_b ; 177
			END
		'analog_lim_pt12_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt12_status', analog_lim_pt12_status_b, data1_index, epoch1maxrec ; 178
			remove_fill_dig_hk, -1, analog_lim_pt12_status_b ; 178
			END
		'analog_lim_pt12_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt12_id', analog_lim_pt12_id_b, data1_index, epoch1maxrec ; 179
			remove_fill_dig_hk, -1, analog_lim_pt12_id_b ; 179
			END
		'analog_lim_pt12_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt12_red', analog_lim_pt12_red_b, data1_index, epoch1maxrec ; 180
			remove_fill_dig_hk, -1, analog_lim_pt12_red_b ; 180
			END
		'analog_lim_pt13_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt13_status', analog_lim_pt13_status_b, data1_index, epoch1maxrec ; 181
			remove_fill_dig_hk, -1, analog_lim_pt13_status_b ; 181
			END
		'analog_lim_pt13_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt13_id', analog_lim_pt13_id_b, data1_index, epoch1maxrec ; 182
			remove_fill_dig_hk, -1, analog_lim_pt13_id_b ; 182
			END
		'analog_lim_pt13_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt13_red', analog_lim_pt13_red_b, data1_index, epoch1maxrec ; 183
			remove_fill_dig_hk, -1, analog_lim_pt13_red_b ; 183
			END
		'analog_lim_pt14_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt14_status', analog_lim_pt14_status_b, data1_index, epoch1maxrec ; 184
			remove_fill_dig_hk, -1, analog_lim_pt14_status_b ; 184
			END
		'analog_lim_pt14_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt14_id', analog_lim_pt14_id_b, data1_index, epoch1maxrec ; 185
			remove_fill_dig_hk, -1, analog_lim_pt14_id_b ; 185
			END
		'analog_lim_pt14_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt14_red', analog_lim_pt14_red_b, data1_index, epoch1maxrec ; 186
			remove_fill_dig_hk, -1, analog_lim_pt14_red_b ; 186
			END
		'analog_lim_pt15_status':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt15_status', analog_lim_pt15_status_b, data1_index, epoch1maxrec ; 187
			remove_fill_dig_hk, -1, analog_lim_pt15_status_b ; 187
			END
		'analog_lim_pt15_id':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt15_id', analog_lim_pt15_id_b, data1_index, epoch1maxrec  ; 188
			remove_fill_dig_hk, -1, analog_lim_pt15_id_b ; 188
			END
		'analog_lim_pt15_red':  BEGIN
			read_product_dig_hk, cdf_id, 'analog_lim_pt15_red', analog_lim_pt15_red_b, data1_index, epoch1maxrec  ; 189
			remove_fill_dig_hk, -1, analog_lim_pt15_red_b ; 189
			END
		'opmode':  BEGIN
			read_product_dig_hk, cdf_id, 'opmode', opmode_b, data1_index, epoch1maxrec  ; 190
			remove_fill_dig_hk, -1, opmode_b ; 190
			END
		'sw_mode':  BEGIN
			read_product_dig_hk, cdf_id, 'sw_mode', sw_mode_b, data1_index, epoch1maxrec ; 191
			remove_fill_dig_hk, -1, sw_mode_b ; 191
			END
		'proton_mode':  BEGIN
			read_product_dig_hk, cdf_id, 'proton_mode', proton_mode_b, data1_index, epoch1maxrec ; 192
			remove_fill_dig_hk, -1, proton_mode_b ; 192
			END
		'active_supplyid':  BEGIN
			read_product_dig_hk, cdf_id, 'active_supplyid', active_supplyid_b, data1_index, epoch1maxrec ; 193
			remove_fill_dig_hk, -1, active_supplyid_b ; 193
			END
		'supply_coarse_rb':  BEGIN
			read_product_dig_hk, cdf_id, 'supply_coarse_rb', supply_coarse_rb_b, data1_index, epoch1maxrec ; 194
			remove_fill_dig_hk, -1, supply_coarse_rb_b ; 194
			END
		'supply_fine_rb':  BEGIN
			read_product_dig_hk, cdf_id, 'supply_fine_rb', supply_fine_rb_b, data1_index, epoch1maxrec ; 195
			remove_fill_dig_hk, -1, supply_fine_rb_b ; 195
			END
		'swmaint_supplystat':  BEGIN
			read_product_dig_hk, cdf_id, 'swmaint_supplystat', swmaint_supplystat_b, data1_index, epoch1maxrec ; 196
			remove_fill_dig_hk, -1, swmaint_supplystat_b ; 196
			END
		'swmaint_pac_coarse':  BEGIN
			read_product_dig_hk, cdf_id, 'swmaint_pac_coarse', swmaint_pac_coarse_b, data1_index, epoch1maxrec ; 197
			remove_fill_dig_hk, -1, swmaint_pac_coarse_b ; 197
			END
		'swmaint_pac_fine':  BEGIN
			read_product_dig_hk, cdf_id, 'swmaint_pac_fine', swmaint_pac_fine_b, data1_index, epoch1maxrec ; 198		
			remove_fill_dig_hk, -1, swmaint_pac_fine_b ; 198
			END

		ENDCASE
	ENDFOR
    END
ENDCASE
dig_hk_read = 1
END 

PRO check_indices_dig_hk, index, epoch, resolution, file_num
; checks for missing records from the cdf epoch variable
; index: array of pairs [start_index,num_records] (could be [0,10,15,2] for times 0-9,15-16)
; epoch: array of time values read from cdf (and converted)
; resolution: 1,5, or 2 depending on epoch (may need to add variable)
; file_num: index of this file in the file array
first_index=0L
first_index = file_num*(1440/resolution)
num_records = 0L
in_valid_area = 0
ii = 0L
index = [-1L]
CASE resolution OF 
    1: BEGIN 
        FOR hour = 0, 23 DO BEGIN 
            FOR min = 0, 59 DO BEGIN 
                IF ii LT n_elements(epoch) THEN BEGIN 
                    time = time_struct(epoch[ii])
                    IF hour EQ time.hour AND min EQ time.min THEN BEGIN 
                        IF in_valid_area EQ 0 THEN BEGIN
                            start_index = first_index+(hour*60)+min
                            num_records = 1
                            in_valid_area = 1
                        ENDIF ELSE BEGIN ; already in valid area
                            num_records = num_records+1
                        ENDELSE 
                        ii = ii+1
                    ENDIF ELSE BEGIN
                        IF in_valid_area EQ 1 THEN BEGIN
                            in_valid_area = 0
                            IF index[0] EQ -1 THEN index = [start_index, num_records] $
                            ELSE index = [index, start_index, num_records]
                        ENDIF 
                    ENDELSE 
                ENDIF ELSE BEGIN 
                    IF in_valid_area EQ 1 THEN BEGIN
                        in_valid_area = 0
                        IF index[0] EQ -1 THEN index = [start_index, num_records] $
                        ELSE index = [index, start_index, num_records]                
                    ENDIF 
                ENDELSE 
            ENDFOR 
        ENDFOR 
    END
    5: BEGIN 
        FOR hour = 0, 23 DO BEGIN 
            FOR min = 0, 11 DO BEGIN 
                IF ii LT n_elements(epoch) THEN BEGIN 
                    time = time_struct(epoch[ii])
                    IF (hour EQ time.hour AND time.min GE (min*5) AND time.min LT (min*5+5)) OR $
                      (time.hour EQ hour+1 AND time.min LE 4 AND min EQ 11) THEN BEGIN 
                        IF in_valid_area EQ 0 THEN BEGIN
                            start_index = first_index+(hour*12)+min
                            num_records = 1
                            in_valid_area = 1
                        ENDIF ELSE BEGIN ; already in valid area
                            num_records = num_records+1
                        ENDELSE 
                        ii = ii+1
                    ENDIF ELSE BEGIN
                        IF in_valid_area EQ 1 THEN BEGIN
                            in_valid_area = 0
                            IF index[0] EQ -1 THEN index = [start_index, num_records] $
                            ELSE index = [index, start_index, num_records]
                        ENDIF 
                    ENDELSE 
                ENDIF ELSE BEGIN 
                    IF in_valid_area EQ 1 THEN BEGIN
                        in_valid_area = 0
                        IF index[0] EQ -1 THEN index = [start_index, num_records] $
                        ELSE index = [index, start_index, num_records]
                    ENDIF 
                ENDELSE 
            ENDFOR 
        ENDFOR 
    END
    ELSE: BEGIN
        print, "Lorna -- add variable resolution"
        stop
    END 
ENDCASE 
END 


PRO pl_read_cdf_dig_hk, sat, files, products, which_epoch

COMMON share1_dig_hk
COMMON com_dig_hk
; check if there are any files to read
IF n_elements(products) GT 0 AND n_elements(files) EQ 0 THEN print, "No Data Files in this Time Range for Satellite ", sat

; initialize output variables (from common block)
need_epoch1 = 0
need_epoch5 = 0

FOR ii = 0L, n_elements(which_epoch)-1 DO BEGIN 
    CASE which_epoch[ii] OF 
        1: BEGIN 
            num_records1 = n_elements(files)*1441
            epoch1 = dblarr(num_records1)
            epoch1(*) = !values.f_nan
            need_epoch1 = 1
        END 
        5: BEGIN 
            num_records5 = n_elements(files)*289
            epoch5 = dblarr(num_records5)
            epoch5(*) = !values.f_nan
            need_epoch5 = 5
        END 
        0: BEGIN 
            print, "Lorna: add variable epoch"
            stop
        END 
        ELSE: BEGIN
            print, "Invalid indication of which epoch is needed: ", which_epoch
            stop
        END
    ENDCASE 
ENDFOR 
dig_hk_initialized = 0
FOR ii = 0, n_elements(products)-1 DO BEGIN 
    SWITCH products[ii] OF 
	   'dpu_sw_version':                  ; 0 
           'cmd_rcvd_cnt':                    ; 1
           'cmd_exec_cnt':                    ; 2
           'cmd_total_err_cnt':               ; 3
           'cmd_parity_err_cnt':              ; 4
           'cmd_frame_err_cnt':               ; 5
           'cmd_illegal_err_cnt':             ; 6
           'ic_status_reg':                   ; 7
           'ic_ctl_reg':                      ; 8
           'lbc_reset_ctl':                   ; 9
           'lbc_mode_ctl':                    ; 10
           'lbc_logic_ctl_a':                 ; 11
           'lbc_logic_ctl_b':                 ; 12
           'lbc_tac_pwr_ctl':                 ; 13
           'lbc_reg_seq':                     ; 14
           'lbc_event_ctl':                   ; 15
           'lbc_rlim_ch':                     ; 16
           'lbc_rlim_hi':                     ; 17
           'lbc_rlim_lo':                     ; 18
           'lbe_pos_ctrl':                    ; 19
           'lbe_pos_disable0':                ; 20
           'lbe_pos_disable2':                ; 21
           'lbe_tac0_ctrl':                   ; 22
           'lbe_tac0_dac':                    ; 23
           'lbe_tac2_ctrl':                   ; 24
           'lbe_tac2_dac':                    ; 25
           'lbe_tac0_under_hi':               ; 26
           'lbe_tac0_under_lo':               ; 27
           'lbe_tac0_over_hi':                ; 28
           'lbe_tac0_over_lo':                ; 29
           'lbe_tac2_under_hi':               ; 30
           'lbe_tac2_under_lo':               ; 31
           'lbe_tac2_over_hi':                ; 32
           'lbe_tac2_over_lo':                ; 33
           'lbe_ssd_ctrl':                    ; 34
           'lbe_ssd_cmd_h':                   ; 35
           'lbe_ssd_cmd_l':                   ; 36
           'lbe_ssd_dis':                     ; 37
           'lbe_ssd_under_hi':                ; 38
           'lbe_ssd_under_lo':                ; 39
           'lbe_ssd_over_hi':                 ; 40
           'lbe_ssd_over_lo':                 ; 41
           'lbe_sel_ctrl':                    ; 42
           'lbe_trig_mode':                   ; 43
           'lbe_esa_step':                    ; 44
           'lbe_defl_step':                   ; 45
           'lbe_ssd_offset0':                 ; 46
           'lbe_ssd_offset1':                 ; 47
           'lbe_ssd_offset2':                 ; 48
           'lbe_ssd_offset3':                 ; 49
           'lbe_ssd_offset4':                 ; 50
           'lbe_ssd_offset5':                 ; 51
           'lbe_ssd_offset6':                 ; 52
           'lbe_ssd_offset7':                 ; 53
           'lbe_stim_enable':                 ; 54
           'lbe_stim_freq_hi':                ; 55
           'lbe_stim_freq_lo':                ; 56
           'lbe_sel0_window':                 ; 57
           'lbe_sel2_window':                 ; 58
           'lbe_ssd_offset8':                 ; 59
           'lbe_ssd_offset9':                 ; 60
           'lbe_ssd_offset10':                ; 61
           'lbe_ssd_offset11':                ; 62
           'lbe_ssd_offset12':                ; 63
           'lbe_ssd_offset13':                ; 64
           'lbe_ssd_offset14':                ; 65
           'lbe_ssd_offset15':                ; 66
           'lbe_pos_ra':                      ; 67
           'dacm_pac_mcp_ssd_ctl_mcp_limit':  ; 68
           'dacm_pac_limit':                  ; 69
           'dacm_esa_ctl':                    ; 70
           'dacm_s_ch_ctl':                   ; 71
           'dacm_dfl_1_ctl':                  ; 72
           'dacm_dfl_2_ctl':                  ; 73
           'dacm_control':                    ; 74
           'dacm_status':                     ; 75
           'dacm_adc_lu_ctr':                 ; 76
           'dacm_dfl_1_offset':               ; 77
           'dacm_dfl_2_offset':               ; 78
           'dacm_pac_coarse':                 ; 79
           'dacm_pac_fine':                   ; 80
           'dacm_pac_cm_fs_coarse':           ; 81
           'dacm_pac_cm_fs_fine':             ; 82
           'dacm_mcp_coarse':                 ; 83
           'dacm_mcp_fine':                   ; 84
           'dacm_mcp_cm_fs_coarse':           ; 85
           'dacm_mcp_cm_fs_fine':             ; 86
           'dacm_ssd_coarse':                 ; 87
           'dacm_ssd_fine':                   ; 88
           'dacm_esa_coarse':                 ; 89
           'dacm_esa_fine':                   ; 90
           'dacm_s_ch_coarse':                ; 91
           'dacm_s_ch_fine':                  ; 92
           'dacm_s_ch_tap_coarse':            ; 93
           'dacm_s_ch_tap_fine':              ; 94
           'dacm_dfl_1_coarse':               ; 95
           'dacm_dfl_1_fine':                 ; 96
           'dacm_dfl_1_dfine':                ; 97
           'dacm_dfl_2_coarse':               ; 98
           'dacm_dfl_2_fine':                 ; 99
           'dacm_dfl_2_dfine':                ; 100
           'dacr_pac_mcp_ssd_ctl_mcp_limit':  ; 101
           'dacr_pac_limit':                  ; 102
           'dacr_esa_ctl':                    ; 103
           'dacr_s_ch_ctl':                   ; 104
           'dacr_dfl_1_ctl':                  ; 105
           'dacr_dfl_2_ctl':                  ; 106
           'dacr_control':                    ; 107
           'dacr_status':                     ; 108
           'dacr_adc_lu_ctr':                 ; 109
           'dacr_dfl_1_offset':               ; 110
           'dacr_dfl_2_offset':               ; 111
           'dacr_c_pac_coarse':               ; 112
           'dacr_c_pac_fine':                 ; 113
           'dacr_c_pac_cm_fs_coarse':         ; 114
           'dacr_c_pac_cm_fs_fine':           ; 115
           'dacr_c_mcp_coarse':               ; 116
           'dacr_c_mcp_fine':                 ; 117
           'dacr_c_mcp_cm_fs_coarse':         ; 118
           'dacr_c_mcp_cm_fs_fine':           ; 119
           'dacr_c_ssd_coarse':               ; 120
           'dacr_c_ssd_fine':                 ; 121
           'dacr_c_esa_coarse':               ; 122
           'dacr_c_esa_fine':                 ; 123
           'dacr_c_s_ch_coarse':              ; 124
           'dacr_c_s_ch_fine':                ; 125
           'dacr_c_s_ch_tap_coarse':          ; 126
           'dacr_c_s_ch_tap_fine':            ; 127
           'dacr_dfl_1_coarse':               ; 128
           'dacr_dfl_1_fine':                 ; 129
           'dacr_dfl_1_dfine':                ; 130
           'dacr_dfl_2_coarse':               ; 131
           'dacr_dfl_2_fine':                 ; 132
           'dacr_dfl_2_dfine':                ; 133
           'sw_status1':                      ; 134
           'sw_hv_ramp_status':               ; 135
           'sw_hv_enable_status':             ; 136
           'sw_hv_limit_status':              ; 137
           'sw_eepromchksum':                 ; 138
           'hkp_sampletime':                  ; 139
           'pac_discharge_status':            ; 140
           'pac_discharge_cnt':               ; 141
           'pac_discharge_conseccntr':        ; 142
           'pac_discharge_safe_att':          ; 143
           'analog_limit_status':             ; 144
           'analog_lim_pt1_status':           ; 145
           'analog_lim_pt1_id':               ; 146
           'analog_lim_pt1_red':              ; 147
           'analog_lim_pt2_status':           ; 148
           'analog_lim_pt2_id':               ; 149
           'analog_lim_pt2_red':              ; 150
           'analog_lim_pt3_status':           ; 151
           'analog_lim_pt3_id':               ; 152
           'analog_lim_pt3_red':              ; 153
           'analog_lim_pt4_status':           ; 154
           'analog_lim_pt4_id':               ; 155
           'analog_lim_pt4_red':              ; 156
           'analog_lim_pt5_status':           ; 157
           'analog_lim_pt5_id':               ; 158
           'analog_lim_pt5_red':              ; 159
           'analog_lim_pt6_status':           ; 160
           'analog_lim_pt6_id':               ; 161
           'analog_lim_pt6_red':              ; 162
           'analog_lim_pt7_status':           ; 163
           'analog_lim_pt7_id':               ; 164
           'analog_lim_pt7_red':              ; 165
           'analog_lim_pt8_status':           ; 166
           'analog_lim_pt8_id':               ; 167
           'analog_lim_pt8_red':              ; 168
           'analog_lim_pt9_status':           ; 169
           'analog_lim_pt9_id':               ; 170
           'analog_lim_pt9_red':              ; 171
           'analog_lim_pt10_status':          ; 172
           'analog_lim_pt10_id':              ; 173
           'analog_lim_pt10_red':             ; 174
           'analog_lim_pt11_status':          ; 175
           'analog_lim_pt11_id':              ; 176
           'analog_lim_pt11_red':             ; 177
           'analog_lim_pt12_status':          ; 178
           'analog_lim_pt12_id':              ; 179
           'analog_lim_pt12_red':             ; 180
           'analog_lim_pt13_status':          ; 181
           'analog_lim_pt13_id':              ; 182
           'analog_lim_pt13_red':             ; 183
           'analog_lim_pt14_status':          ; 184
           'analog_lim_pt14_id':              ; 185
           'analog_lim_pt14_red':             ; 186
           'analog_lim_pt15_status':          ; 187
           'analog_lim_pt15_id':              ; 188
           'analog_lim_pt15_red':             ; 189
           'opmode':                          ; 190
           'sw_mode':                         ; 191
           'proton_mode':                     ; 192
           'active_supplyid':                 ; 193
           'supply_coarse_rb':                ; 194
           'supply_fine_rb':                  ; 195
           'swmaint_supplystat':              ; 196
           'swmaint_pac_coarse':              ; 197
           'swmaint_pac_fine': $              ; 198
	IF dig_hk_initialized EQ 0 THEN init_dig_hk, sat, num_records1, dig_hk_initialized, products
    ENDSWITCH 
ENDFOR 
    
; read data
FOR ii = 0, n_elements(files)-1 DO BEGIN 
    IF strcmp(files[ii], '') NE 1 THEN BEGIN 
        cdf_id = cdf_open(files[ii])
                                ; get epochs
        FOR jj = 0L, n_elements(which_epoch)-1 DO BEGIN 
            CASE which_epoch[jj] OF 
                1: BEGIN 
                    cdf_control, cdf_id, get_var_info = epoch1info, var = 'epoch_digital', /zvariable
                    IF epoch1info.maxrec GE 0 THEN BEGIN 
                        cdf_varget, cdf_id, 'epoch_digital', temp_epoch, rec_count = epoch1info.maxrec+1, /zvariable
                        converted_epoch = time_double(temp_epoch, /epoch)
                        check_indices_dig_hk, data1_index, converted_epoch, which_epoch, ii
                        converted_index = 0
                        FOR kk = 0, n_elements(data1_index)-1 DO BEGIN 
                            epoch1[data1_index[kk]:(data1_index[kk]+data1_index[kk+1]-1)] = $
                              converted_epoch[converted_index:(converted_index+data1_index[kk+1]-1)]
                            converted_index = converted_index+data1_index[kk+1]
                            kk = kk+1
                        ENDFOR 
                    ENDIF
                END 
;                5: BEGIN 
;                    cdf_control, cdf_id, get_var_info = epoch5info, var = 'epoch5', /zvariable
;                    IF epoch5info.maxrec GE 0 THEN BEGIN 
;                        cdf_varget, cdf_id, 'epoch5', temp_epoch, rec_count = epoch5info.maxrec+1, /zvariable
;                        converted_epoch = time_double(temp_epoch, /epoch)
;                        check_indices_dig_hk, data5_index, converted_epoch, which_epoch, ii
;                        converted_index = 0
;                        FOR kk = 0, n_elements(data5_index)-1 DO BEGIN 
;                            epoch5[data5_index[kk]:(data5_index[kk]+data5_index[kk+1]-1)] = $
;                              converted_epoch[converted_index:(converted_index+data5_index[kk+1]-1)]
;                            converted_index = converted_index+data5_index[kk+1]
;                            kk = kk+1
;                        ENDFOR 
;                    ENDIF 
;                END 
                0: BEGIN 
                    print, "Lorna: add variable epoch"
                    stop
                END 
                ELSE: BEGIN
                    print, "Invalid indication of which epoch is needed: ", which_epoch
                    stop
                END
            ENDCASE 
        ENDFOR 
        IF sat EQ 'A' THEN BEGIN 
            IF need_epoch1 EQ 1 THEN epoch1_a = epoch1 
            IF need_epoch5 EQ 5 THEN epoch5_a = epoch5
        ENDIF ELSE BEGIN 
            IF need_epoch1 EQ 1 THEN epoch1_b = epoch1 
            IF need_epoch5 EQ 5 THEN epoch5_b = epoch5 
        ENDELSE 

 ; get other data
        dig_hk_read = 0
        FOR jj = 0, n_elements(products)-1 DO BEGIN 
            SWITCH products[jj] OF
   	   'dpu_sw_version':                  ; 0 
           'cmd_rcvd_cnt':                    ; 1
           'cmd_exec_cnt':                    ; 2
           'cmd_total_err_cnt':               ; 3
           'cmd_parity_err_cnt':              ; 4
           'cmd_frame_err_cnt':               ; 5
           'cmd_illegal_err_cnt':             ; 6
           'ic_status_reg':                   ; 7
           'ic_ctl_reg':                      ; 8
           'lbc_reset_ctl':                   ; 9
           'lbc_mode_ctl':                    ; 10
           'lbc_logic_ctl_a':                 ; 11
           'lbc_logic_ctl_b':                 ; 12
           'lbc_tac_pwr_ctl':                 ; 13
           'lbc_reg_seq':                     ; 14
           'lbc_event_ctl':                   ; 15
           'lbc_rlim_ch':                     ; 16
           'lbc_rlim_hi':                     ; 17
           'lbc_rlim_lo':                     ; 18
           'lbe_pos_ctrl':                    ; 19
           'lbe_pos_disable0':                ; 20
           'lbe_pos_disable2':                ; 21
           'lbe_tac0_ctrl':                   ; 22
           'lbe_tac0_dac':                    ; 23
           'lbe_tac2_ctrl':                   ; 24
           'lbe_tac2_dac':                    ; 25
           'lbe_tac0_under_hi':               ; 26
           'lbe_tac0_under_lo':               ; 27
           'lbe_tac0_over_hi':                ; 28
           'lbe_tac0_over_lo':                ; 29
           'lbe_tac2_under_hi':               ; 30
           'lbe_tac2_under_lo':               ; 31
           'lbe_tac2_over_hi':                ; 32
           'lbe_tac2_over_lo':                ; 33
           'lbe_ssd_ctrl':                    ; 34
           'lbe_ssd_cmd_h':                   ; 35
           'lbe_ssd_cmd_l':                   ; 36
           'lbe_ssd_dis':                     ; 37
           'lbe_ssd_under_hi':                ; 38
           'lbe_ssd_under_lo':                ; 39
           'lbe_ssd_over_hi':                 ; 40
           'lbe_ssd_over_lo':                 ; 41
           'lbe_sel_ctrl':                    ; 42
           'lbe_trig_mode':                   ; 43
           'lbe_esa_step':                    ; 44
           'lbe_defl_step':                   ; 45
           'lbe_ssd_offset0':                 ; 46
           'lbe_ssd_offset1':                 ; 47
           'lbe_ssd_offset2':                 ; 48
           'lbe_ssd_offset3':                 ; 49
           'lbe_ssd_offset4':                 ; 50
           'lbe_ssd_offset5':                 ; 51
           'lbe_ssd_offset6':                 ; 52
           'lbe_ssd_offset7':                 ; 53
           'lbe_stim_enable':                 ; 54
           'lbe_stim_freq_hi':                ; 55
           'lbe_stim_freq_lo':                ; 56
           'lbe_sel0_window':                 ; 57
           'lbe_sel2_window':                 ; 58
           'lbe_ssd_offset8':                 ; 59
           'lbe_ssd_offset9':                 ; 60
           'lbe_ssd_offset10':                ; 61
           'lbe_ssd_offset11':                ; 62
           'lbe_ssd_offset12':                ; 63
           'lbe_ssd_offset13':                ; 64
           'lbe_ssd_offset14':                ; 65
           'lbe_ssd_offset15':                ; 66
           'lbe_pos_ra':                      ; 67
           'dacm_pac_mcp_ssd_ctl_mcp_limit':  ; 68
           'dacm_pac_limit':                  ; 69
           'dacm_esa_ctl':                    ; 70
           'dacm_s_ch_ctl':                   ; 71
           'dacm_dfl_1_ctl':                  ; 72
           'dacm_dfl_2_ctl':                  ; 73
           'dacm_control':                    ; 74
           'dacm_status':                     ; 75
           'dacm_adc_lu_ctr':                 ; 76
           'dacm_dfl_1_offset':               ; 77
           'dacm_dfl_2_offset':               ; 78
           'dacm_pac_coarse':                 ; 79
           'dacm_pac_fine':                   ; 80
           'dacm_pac_cm_fs_coarse':           ; 81
           'dacm_pac_cm_fs_fine':             ; 82
           'dacm_mcp_coarse':                 ; 83
           'dacm_mcp_fine':                   ; 84
           'dacm_mcp_cm_fs_coarse':           ; 85
           'dacm_mcp_cm_fs_fine':             ; 86
           'dacm_ssd_coarse':                 ; 87
           'dacm_ssd_fine':                   ; 88
           'dacm_esa_coarse':                 ; 89
           'dacm_esa_fine':                   ; 90
           'dacm_s_ch_coarse':                ; 91
           'dacm_s_ch_fine':                  ; 92
           'dacm_s_ch_tap_coarse':            ; 93
           'dacm_s_ch_tap_fine':              ; 94
           'dacm_dfl_1_coarse':               ; 95
           'dacm_dfl_1_fine':                 ; 96
           'dacm_dfl_1_dfine':                ; 97
           'dacm_dfl_2_coarse':               ; 98
           'dacm_dfl_2_fine':                 ; 99
           'dacm_dfl_2_dfine':                ; 100
           'dacr_pac_mcp_ssd_ctl_mcp_limit':  ; 101
           'dacr_pac_limit':                  ; 102
           'dacr_esa_ctl':                    ; 103
           'dacr_s_ch_ctl':                   ; 104
           'dacr_dfl_1_ctl':                  ; 105
           'dacr_dfl_2_ctl':                  ; 106
           'dacr_control':                    ; 107
           'dacr_status':                     ; 108
           'dacr_adc_lu_ctr':                 ; 109
           'dacr_dfl_1_offset':               ; 110
           'dacr_dfl_2_offset':               ; 111
           'dacr_c_pac_coarse':               ; 112
           'dacr_c_pac_fine':                 ; 113
           'dacr_c_pac_cm_fs_coarse':         ; 114
           'dacr_c_pac_cm_fs_fine':           ; 115
           'dacr_c_mcp_coarse':               ; 116
           'dacr_c_mcp_fine':                 ; 117
           'dacr_c_mcp_cm_fs_coarse':         ; 118
           'dacr_c_mcp_cm_fs_fine':           ; 119
           'dacr_c_ssd_coarse':               ; 120
           'dacr_c_ssd_fine':                 ; 121
           'dacr_c_esa_coarse':               ; 122
           'dacr_c_esa_fine':                 ; 123
           'dacr_c_s_ch_coarse':              ; 124
           'dacr_c_s_ch_fine':                ; 125
           'dacr_c_s_ch_tap_coarse':          ; 126
           'dacr_c_s_ch_tap_fine':            ; 127
           'dacr_dfl_1_coarse':               ; 128
           'dacr_dfl_1_fine':                 ; 129
           'dacr_dfl_1_dfine':                ; 130
           'dacr_dfl_2_coarse':               ; 131
           'dacr_dfl_2_fine':                 ; 132
           'dacr_dfl_2_dfine':                ; 133
           'sw_status1':                      ; 134
           'sw_hv_ramp_status':               ; 135
           'sw_hv_enable_status':             ; 136
           'sw_hv_limit_status':              ; 137
           'sw_eepromchksum':                 ; 138
           'hkp_sampletime':                  ; 139
           'pac_discharge_status':            ; 140
           'pac_discharge_cnt':               ; 141
           'pac_discharge_conseccntr':        ; 142
           'pac_discharge_safe_att':          ; 143
           'analog_limit_status':             ; 144
           'analog_lim_pt1_status':           ; 145
           'analog_lim_pt1_id':               ; 146
           'analog_lim_pt1_red':              ; 147
           'analog_lim_pt2_status':           ; 148
           'analog_lim_pt2_id':               ; 149
           'analog_lim_pt2_red':              ; 150
           'analog_lim_pt3_status':           ; 151
           'analog_lim_pt3_id':               ; 152
           'analog_lim_pt3_red':              ; 153
           'analog_lim_pt4_status':           ; 154
           'analog_lim_pt4_id':               ; 155
           'analog_lim_pt4_red':              ; 156
           'analog_lim_pt5_status':           ; 157
           'analog_lim_pt5_id':               ; 158
           'analog_lim_pt5_red':              ; 159
           'analog_lim_pt6_status':           ; 160
           'analog_lim_pt6_id':               ; 161
           'analog_lim_pt6_red':              ; 162
           'analog_lim_pt7_status':           ; 163
           'analog_lim_pt7_id':               ; 164
           'analog_lim_pt7_red':              ; 165
           'analog_lim_pt8_status':           ; 166
           'analog_lim_pt8_id':               ; 167
           'analog_lim_pt8_red':              ; 168
           'analog_lim_pt9_status':           ; 169
           'analog_lim_pt9_id':               ; 170
           'analog_lim_pt9_red':              ; 171
           'analog_lim_pt10_status':          ; 172
           'analog_lim_pt10_id':              ; 173
           'analog_lim_pt10_red':             ; 174
           'analog_lim_pt11_status':          ; 175
           'analog_lim_pt11_id':              ; 176
           'analog_lim_pt11_red':             ; 177
           'analog_lim_pt12_status':          ; 178
           'analog_lim_pt12_id':              ; 179
           'analog_lim_pt12_red':             ; 180
           'analog_lim_pt13_status':          ; 181
           'analog_lim_pt13_id':              ; 182
           'analog_lim_pt13_red':             ; 183
           'analog_lim_pt14_status':          ; 184
           'analog_lim_pt14_id':              ; 185
           'analog_lim_pt14_red':             ; 186
           'analog_lim_pt15_status':          ; 187
           'analog_lim_pt15_id':              ; 188
           'analog_lim_pt15_red':             ; 189
           'opmode':                          ; 190
           'sw_mode':                         ; 191
           'proton_mode':                     ; 192
           'active_supplyid':                 ; 193
           'supply_coarse_rb':                ; 194
           'supply_fine_rb':                  ; 195
           'swmaint_supplystat':              ; 196
           'swmaint_pac_coarse':              ; 197
           'swmaint_pac_fine': $              ; 198		
	IF dig_hk_read EQ 0 THEN read_dig_hk, cdf_id, sat, dig_hk_read, data1_index, epoch1info.maxrec+1, products
                ELSE: BREAK 
            ENDSWITCH 
        ENDFOR 
    ENDIF 
ENDFOR 
IF sat EQ 'A' THEN BEGIN 
    IF need_epoch1 EQ 1 THEN data1_index_a = data1_index 
;    IF need_epoch5 EQ 5 THEN data5_index_a = data5_index
ENDIF ELSE BEGIN
    IF need_epoch1 EQ 1 THEN data1_index_b = data1_index
;    IF need_epoch5 EQ 5 THEN data5_index_b = data5_index
ENDELSE 

END 
