;+
;PROCEDURE: pl_plot_sc_hk_from_crib
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic analog housekeeping using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_hk: Array of housekeeping variables wanted for sat A
;              sat_b_hk: Array of housekeeping variables wanted for sat B
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    09/11/2006 Adjusted from C. Mouikis's plot_obmom_from_crib
;
;	January 2007:  K. Simunac adjusts to plot spacecraft housekeeping products
;	12 January, 2007:  variable and program names modified to avoid confusion
;	3 July, 2007:  calls "pl_read_cdf_general" instead of "pl_read_cdf_sc_hk"
;-

PRO check_prod_sc_hk, prod_sc_hk
; in: string with product abbreviation
SWITCH prod_sc_hk OF 
	'pl_ebox_tmp':	;0
	'pl_inst_msg_pwr_dwn_req':	;1
	'pl_pwr_cur':	;2
	'pl_pwr_tt':	;3
	'pl_surv_pwr_cur':	;4 
	'pl_surv_pwr_tt':	;5
	'pl_tof_tmp':	;6
	'pl_pwr_vt':	;7
	'pl_surv_pwr_vt': $	;8
	 BREAK 
    ELSE: BEGIN 
        print, 'Invalid element in sc hk array: ', prod
        stop
    ENDELSE
ENDSWITCH
END 


PRO check_sc_hk_array, sc_hk_array, a_sc_hk_array, b_sc_hk_array, sat

print, 'check_sc_hk_array called'

; in: sc_hk_array -- array from crib sheet
; out: a_sc_hkarray, b_sc_hk_array -- same as hk array, but divided by satellite

prod_sc_hk = ' '

FOR ii = 0, N_ELEMENTS(sc_hk_array)-1 DO BEGIN
	CASE sc_hk_array(ii) OF
	
	1: prod_sc_hk = 'pl_ebox_tmp'
	2: prod_sc_hk = 'pl_inst_msg_pwr_dwn_req'
	3: prod_sc_hk = 'pl_pwr_cur'
	4: prod_sc_hk = 'pl_pwr_tt'
	5: prod_sc_hk = 'pl_surv_pwr_cur'
	6: prod_sc_hk = 'pl_surv_pwr_tt'
	7: prod_sc_hk = 'pl_tof_tmp'
	8: prod_sc_hk = 'pl_pwr_vt'
	9: prod_sc_hk = 'pl_surv_pwr_vt'

	ENDCASE

    IF sat EQ 'A' THEN BEGIN 
        IF n_elements(a_sc_hk_array) EQ 0 THEN a_sc_hk_array = [prod_sc_hk] ELSE a_sc_hk_array = [a_sc_hk_array, prod_sc_hk]
        check_prod_sc_hk, prod_sc_hk
    ENDIF ELSE BEGIN 
        IF sat EQ 'B' THEN BEGIN 
            IF n_elements(b_sc_hk_array) EQ 0 THEN b_sc_hk_array = [prod_sc_hk] ELSE b_sc_hk_array = [b_sc_hk_array, prod_sc_hk]
            check_prod_sc_hk, prod_sc_hk
        ENDIF ELSE BEGIN 
            print, 'sat must be A or B'
            stop
        ENDELSE   
    ENDELSE 
ENDFOR  
END


PRO pl_plot_sc_hk_from_crib, sat_sc_hk, sat, $
                          INST_COORD=INST_COORD
print, 'pl_plot_sc_hk_from_crib called'

  COMMON get_error, get_err_no, get_err_msg, default_verbose


  check_sc_hk_array, sat_sc_hk, sat_a_sc_hk, sat_b_sc_hk, sat

  ; Figure out which files we need to read from
  seek_files, 'A', 'sc', files_a
  seek_files, 'B', 'sc', files_b
  dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
  dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  IF num_a_valid_files EQ 0 AND n_elements(sat_a_sc_hk) GT 0 THEN print, "No files found for spacecraft A"
  IF num_b_valid_files EQ 0 AND n_elements(sat_b_sc_hk) GT 0 THEN print, "No files found for spacecraft B"


 ; Read data
  IF num_a_valid_files GT 0 AND n_elements(sat_a_sc_hk) GT 0 THEN pl_read_cdf_general, 'A', files_a, sat_a_sc_hk, 3, 0, 'sc_hk', 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_sc_hk) GT 0 THEN pl_read_cdf_general, 'B', files_b, sat_b_sc_hk, 3, 0, 'sc_hk', 1

 ; Put in tplot structures
  IF num_a_valid_files GT 0 AND n_elements(sat_a_sc_hk) GT 0 THEN make_tplot_struct_sc_hk, 'A', sat_a_sc_hk
  IF num_b_valid_files GT 0 AND n_elements(sat_b_sc_hk) GT 0 THEN make_tplot_struct_sc_hk, 'B', sat_b_sc_hk

  ; Set plot attributes
 ; IF num_a_valid_files GT 0 AND n_elements(sat_a_sc_hk) GT 0 THEN set_plot_attributes_hk, 'A', sat_a_hk, 1
 ; IF num_b_valid_files GT 0 AND n_elements(sat_b_sc_hk) GT 0 THEN set_plot_attributes_hk, 'B', sat_b_hk, 1

  ; Make the plots
  IF (num_a_valid_files GT 0 AND n_elements(sat_a_sc_hk) GT 0) $
    OR (num_b_valid_files GT 0 AND n_elements(sat_b_sc_hk) GT 0) THEN $
	plot_sc_hk, sat_sc_hk, num_a_valid_files, num_b_valid_files, sat

END
