;+
;PROCEDURE: pl_plot_obmom_from_crib
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic OB moments using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_mom: Array of moments wanted for sat A
;              sat_b_mom: Array of moments wanted for sat B
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 09/11/2006
;
;MODIFICATION HISTORY:
;    09/11/2006 Adjusted from C. Mouikis's plot_obmom_from_crib
;    02/09/2007 Changed set_plot_attributes to set_plot_attributes_mom
;
;    02/28/2007: The PS output option is taken out (C. Mouikis)	
;    03/28/2007: Added check for empty files (LBE)
;-
PRO check_prod, prod
; in: string with product abbreviation
SWITCH prod OF 
    'D':
    'VX':
    'VY':
    'VZ':
    'VXYZ':
    'VT': 
    'TXX':
    'TYY':
    'TZZ':
    'TXXYYZZ':
    'PXX':
    'PYY':
    'PZZ':
    'PXXYYZZ': BREAK 
    ELSE: BEGIN 
        print, 'Invalid element in moment array: ', prod
        stop
    ENDELSE
ENDSWITCH
END 


PRO check_moment_array, moment_array, a_array, b_array
; in: moment_array -- array from crib sheet
; out: a_array,b_array -- same as moment array, but divided by satellite
FOR ii = 0, N_ELEMENTS(moment_array)-1 DO BEGIN
    temp_st = moment_array[ii]
    IF strmid(temp_st, 0, 1) EQ 'A' THEN BEGIN 
        prod = strmid(temp_st, 2, strlen(temp_st)-2)
        IF n_elements(a_array) EQ 0 THEN a_array = [prod] ELSE a_array = [a_array, prod]
        check_prod, prod
    ENDIF ELSE BEGIN 
        IF strmid(temp_st, 0, 1) EQ 'B' THEN BEGIN 
            prod = strmid(temp_st, 2, strlen(temp_st)-2)
            IF n_elements(b_array) EQ 0 THEN b_array = [prod] ELSE b_array = [b_array, prod]
            check_prod, prod
        ENDIF ELSE BEGIN 
            print, 'Invalid element in moment array: ', moment_array[ii]
            stop
        ENDELSE   
    ENDELSE 
ENDFOR  
END


PRO pl_plot_obmom_from_crib, sat_moment, $
                          INST_COORD=INST_COORD

  COMMON get_error, get_err_no, get_err_msg, default_verbose

  specie_str = 'H!U+!N'

  check_moment_array, sat_moment, sat_a_mom, sat_b_mom

  ; Figure out which files we need to read from
  IF n_elements(sat_a_mom) GT 0 THEN seek_files, 'A', 'science', files_a ELSE files_a = ['']
  IF n_elements(sat_b_mom) GT 0 THEN seek_files, 'B', 'science', files_b ELSE files_b = ['']
  dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
  dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  IF num_a_valid_files EQ 0 AND n_elements(sat_a_mom) GT 0 THEN print, "No files found for spacecraft A"
  IF num_b_valid_files EQ 0 AND n_elements(sat_b_mom) GT 0 THEN print, "No files found for spacecraft B"

  ; Read data
  IF num_a_valid_files GT 0 AND n_elements(sat_a_mom) GT 0 THEN pl_read_cdf_mom, 'A', files_a, sat_a_mom, 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_mom) GT 0 THEN pl_read_cdf_mom, 'B', files_b, sat_b_mom, 1

  ; Check for empty files
  IF num_a_valid_files GT 0 THEN BEGIN 
      dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
      IF num_a_valid_files EQ 0 AND n_elements(sat_a_mom) GT 0 THEN print, "Only empty files found for spacecraft A"
  ENDIF 
  IF num_b_valid_files GT 0 THEN BEGIN 
      dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
      IF num_b_valid_files EQ 0 AND n_elements(sat_b_mom) GT 0 THEN print, "Only empty found for spacecraft B"
  ENDIF 

  ; Read conversion factor
  IF num_a_valid_files GT 0 AND n_elements(sat_a_mom) GT 0 THEN pl_read_mom_conv, 'A'
  IF num_b_valid_files GT 0 AND n_elements(sat_b_mom) GT 0 THEN pl_read_mom_conv, 'B'

  ; Put in tplot structures
  IF num_a_valid_files GT 0 AND n_elements(sat_a_mom) GT 0 THEN make_moment_struct, 'A'
  IF num_b_valid_files GT 0 AND n_elements(sat_b_mom) GT 0 THEN make_moment_struct, 'B'

  ; Set plot attributes
  IF num_a_valid_files GT 0 AND n_elements(sat_a_mom) GT 0 THEN set_plot_attributes_mom, 'A', sat_a_mom, inst_coord
  IF num_b_valid_files GT 0 AND n_elements(sat_b_mom) GT 0 THEN set_plot_attributes_mom, 'B', sat_b_mom, inst_coord
  
  ; Make the plots
  IF (num_a_valid_files GT 0 AND n_elements(sat_a_mom) GT 0) $
    OR (num_b_valid_files GT 0 AND n_elements(sat_b_mom) GT 0) THEN $
      plot_moments, sat_moment, num_a_valid_files, num_b_valid_files

END
