;+
;PROCEDURE: pl_plot_hk_from_crib
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic analog housekeeping using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_hk: Array of housekeeping variables wanted for sat A
;              sat_b_hk: Array of housekeeping variables wanted for sat B
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    09/11/2006 Adjusted from C. Mouikis's plot_obmom_from_crib
;
;	November 2006:  K. Simunac adjusted to plot analog housekeeping products
;	12 Jan, 2007:  modified variable names to avoid confusion
;		prod -> prod_hk
;		share1 -> share1_hk
;		moments_finished -> hk_finished
;		check_prod -> check_prod_hk
;		a_array -> a_hk_array
;		b_array -> b_hk_array
;	02/28/2007: The PS output option is taken out (C. Mouikis)
;	3 July, 2007: calls "pl_read_cdf_general" instead of "pl_read_cdf_hk_1min"
;-

PRO check_prod_hk, prod_hk
; in: string with product abbreviation
SWITCH prod_hk OF 
	'lrnm_spare':	;0
	'lvc_-12v':	;1
	'lvc_-5v':	;2
	'esa_vm_pos':	;3
	'dfl_1_vm':	;4 
	'dfl_1_tap':	;5
	'dfl_2_vm':	;6
	'dfl_2_tap':	;7
	'lvc_+2.5v_b':	;8
	'pac_cm_dc':	;9
	'lvc_+12v':	;10
	'lrpm_spare':	;11
	'lvc_+2.5v_a':	;12
	'lvc_+5v':	;13
	'adc_avdd':	;14
	'adc_dvdd':	;15
	'pac_vm':	;16
	'cal_vref':	;17
	'pac_cm_ac':	;18
	'mcp_vm':	;19
	'mcp_cm_dc':	;20
	'mcp_cm_ac':	;21
	'ssd_cm_dc':	;22
	's_ch_vm':	;23
	's_ch_vm_tap':	;24
	's_ch_cm_dc':	;25
	'esa_vm_neg':	;26
	'esa_cm_dc':	;27
	'dfl_1_cm_dc':	;28
	'dfl_2_cm_dc':	;29
	'lvc_+2.5v_b_imon':	;30
	'lvc_+12v_imon':	;31
	'lvc_-12v_imon':	;32
	'lvc_+5v_imon':	;33
	'lvc_-5v_imon':	;34
	'lvc_+2.5v_a_imon':	;35
	'ssd_vm':	;36
	'adc_lu_flag':	;37
	'plug_id':	;38
	'adc_lu_ctr':	;39
	'dac_status':	;40
	'adc0_agnd':	;41
	'adc1_agnd':	;42
	'ra_e0':	;43
	'ra_e1':	;44
	'tac0_tsp':	;45
	'tac2_tsp':	;46
	'sb0_tsp':	;47
	'sb1_tsp':	;48
	'tof_hv0_tsp':	;49
	'tof_hv1_tsp':	;50
	's_c_0_tsp':	;51
	's_c_1_tsp':	;52
	'lvc0_tsp':	;53
	'lvc1_tsp':	;54
	'adc0_vref':	;55
	'adc1_vref':	;56
	'ssd_status':	;57
	'ssd_v_pos_analog':	;58
	'ssd_v_neg_analog':	;59
	'ssd_hv_bias':	;60
	'ssd_tc0':	;61
	'ssd_tc1':	;62
	'ssd_tc2':	;63
	'ssd_v_pos_dig':  BREAK 
    ELSE: BEGIN 
        print, 'Invalid element in hk array: ', prod_hk
        stop
    ENDELSE
ENDSWITCH
END 


PRO check_hk_array, hk_array, a_hk_array, b_hk_array, sat

; in: hk_array -- array from crib sheet
; out: a_hk_array,b_hk_array -- same as hk array, but divided by satellite

prod_hk = ' '

FOR ii = 0, N_ELEMENTS(hk_array)-1 DO BEGIN
	CASE hk_array(ii) OF
	
	1: prod_hk = 'lrnm_spare'
	2: prod_hk = 'lvc_-12v'
	3: prod_hk = 'lvc_-5v'
	4: prod_hk = 'esa_vm_pos'
	5: prod_hk = 'dfl_1_vm'
	6: prod_hk = 'dfl_1_tap'
	7: prod_hk = 'dfl_2_vm'
	8: prod_hk = 'dfl_2_tap'
	9: prod_hk = 'lvc_+2.5v_b'
	10: prod_hk = 'pac_cm_dc'
	11: prod_hk = 'lvc_+12v'
	12: prod_hk = 'lrpm_spare'
	13: prod_hk = 'lvc_+2.5v_a'
	14: prod_hk = 'lvc_+5v'
	15: prod_hk = 'adc_avdd'
	16: prod_hk = 'adc_dvdd'
	17: prod_hk = 'pac_vm'
	18: prod_hk = 'cal_vref'
	19: prod_hk = 'pac_cm_ac'
	20: prod_hk = 'mcp_vm'
	21: prod_hk = 'mcp_cm_dc'
	22: prod_hk = 'mcp_cm_ac'
	23: prod_hk = 'ssd_cm_dc'
	24: prod_hk = 's_ch_vm'
	25: prod_hk = 's_ch_vm_tap'
	26: prod_hk = 's_ch_cm_dc'
	27: prod_hk = 'esa_vm_neg'
	28: prod_hk = 'esa_cm_dc'
	29: prod_hk = 'dfl_1_cm_dc'
	30: prod_hk = 'dfl_2_cm_dc'
	31: prod_hk = 'lvc_+2.5v_b_imon'
	32: prod_hk = 'lvc_+12v_imon'
	33: prod_hk = 'lvc_-12v_imon'
	34: prod_hk = 'lvc_+5v_imon'
	35: prod_hk = 'lvc_-5v_imon'
	36: prod_hk = 'lvc_+2.5v_a_imon'
	37: prod_hk = 'ssd_vm'
	38: prod_hk = 'adc_lu_flag'
	39: prod_hk = 'plug_id'
	40: prod_hk = 'adc_lu_ctr'
	41: prod_hk = 'dac_status'
	42: prod_hk = 'adc0_agnd'
	43: prod_hk = 'adc1_agnd'
	44: prod_hk = 'ra_e0'
	45: prod_hk = 'ra_e1'
	46: prod_hk = 'tac0_tsp'
	47: prod_hk = 'tac2_tsp'
	48: prod_hk = 'sb0_tsp'
	49: prod_hk = 'sb1_tsp'
	50: prod_hk = 'tof_hv0_tsp'
	51: prod_hk = 'tof_hv1_tsp'
	52: prod_hk = 's_c_0_tsp'
	53: prod_hk = 's_c_1_tsp'
	54: prod_hk = 'lvc0_tsp'
	55: prod_hk = 'lvc1_tsp'
	56: prod_hk = 'adc0_vref'
	57: prod_hk = 'adc1_vref'
	58: prod_hk = 'ssd_status'
	59: prod_hk = 'ssd_v_pos_analog'
	60: prod_hk = 'ssd_v_neg_analog'
	61: prod_hk = 'ssd_hv_bias'
	62: prod_hk = 'ssd_tc0'
	63: prod_hk = 'ssd_tc1'
	64: prod_hk = 'ssd_tc2'
	65: prod_hk = 'ssd_v_pos_dig'

	ENDCASE

    IF sat EQ 'A' THEN BEGIN 
        IF n_elements(a_hk_array) EQ 0 THEN a_hk_array = [prod_hk] ELSE a_hk_array = [a_hk_array, prod_hk]
        check_prod_hk, prod_hk
    ENDIF ELSE BEGIN 
        IF sat EQ 'B' THEN BEGIN 
            IF n_elements(b_hk_array) EQ 0 THEN b_hk_array = [prod_hk] ELSE b_hk_array = [b_hk_array, prod_hk]
            check_prod_hk, prod_hk
        ENDIF ELSE BEGIN 
            print, 'sat must be A or B'
            stop
        ENDELSE   
    ENDELSE 
ENDFOR  
END


PRO pl_plot_hk_from_crib, sat_hk, sat, $
                          INST_COORD=INST_COORD

  COMMON get_error, get_err_no, get_err_msg, default_verbose


  check_hk_array, sat_hk, sat_a_hk, sat_b_hk, sat

  ; Figure out which files we need to read from
  seek_files, 'A', 'hk', files_a
  seek_files, 'B', 'hk', files_b
  dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
  dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  IF num_a_valid_files EQ 0 AND n_elements(sat_a_hk) GT 0 THEN print, "No files found for spacecraft A"
  IF num_b_valid_files EQ 0 AND n_elements(sat_b_hk) GT 0 THEN print, "No files found for spacecraft B"

 ; Read data
  IF num_a_valid_files GT 0 AND n_elements(sat_a_hk) GT 0 THEN pl_read_cdf_general, 'A', files_a, sat_a_hk, 1, 0, 'analog_hk', 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_hk) GT 0 THEN pl_read_cdf_general, 'B', files_b, sat_b_hk, 1, 0, 'analog_hk', 1

 ; Put in tplot structures
  IF num_a_valid_files GT 0 AND n_elements(sat_a_hk) GT 0 THEN make_tplot_struct_hk_1min, 'A', sat_a_hk
  IF num_b_valid_files GT 0 AND n_elements(sat_b_hk) GT 0 THEN make_tplot_struct_hk_1min, 'B', sat_b_hk

  ; Set plot attributes
  IF num_a_valid_files GT 0 AND n_elements(sat_a_hk) GT 0 THEN set_plot_attributes_hk, 'A', sat_a_hk, 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_hk) GT 0 THEN set_plot_attributes_hk, 'B', sat_b_hk, 1

  ; Make the plots
  IF (num_a_valid_files GT 0 AND n_elements(sat_a_hk) GT 0) $
    OR (num_b_valid_files GT 0 AND n_elements(sat_b_hk) GT 0) THEN $
    	plot_hk, sat_hk, num_a_valid_files, num_b_valid_files, sat

END
