;+
;PROCEDURE: pl_plot_dig_hk_from_crib
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic analog housekeeping using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_dig_hk: Array of housekeeping variables wanted
;	       sat:  which spacecraft ('A' or 'B')
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    09/11/2006 Adjusted from C. Mouikis's plot_obmom_from_crib
;
;	November 2006:  K. Simunac adjusted to plot analog housekeeping products
;	3 July, 2007:  calls "pl_read_cdf_general" instead of "pl_read_cdf_dig_hk" 
;-

PRO check_prod_dig_hk, prod_dig_hk
; in: string with product abbreviation
SWITCH prod_dig_hk OF 
	   'dpu_sw_version':                  ; 0 
           'cmd_rcvd_cnt':                    ; 1
           'cmd_exec_cnt':                    ; 2
           'cmd_total_err_cnt':               ; 3
           'cmd_parity_err_cnt':              ; 4
           'cmd_frame_err_cnt':               ; 5
           'cmd_illegal_err_cnt':             ; 6
           'ic_status_reg':                   ; 7
           'ic_ctl_reg':                      ; 8
           'lbc_reset_ctl':                   ; 9
           'lbc_mode_ctl':                    ; 10
           'lbc_logic_ctl_a':                 ; 11
           'lbc_logic_ctl_b':                 ; 12
           'lbc_tac_pwr_ctl':                 ; 13
           'lbc_reg_seq':                     ; 14
           'lbc_event_ctl':                   ; 15
           'lbc_rlim_ch':                     ; 16
           'lbc_rlim_hi':                     ; 17
           'lbc_rlim_lo':                     ; 18
           'lbe_pos_ctrl':                    ; 19
           'lbe_pos_disable0':                ; 20
           'lbe_pos_disable2':                ; 21
           'lbe_tac0_ctrl':                   ; 22
           'lbe_tac0_dac':                    ; 23
           'lbe_tac2_ctrl':                   ; 24
           'lbe_tac2_dac':                    ; 25
           'lbe_tac0_under_hi':               ; 26
           'lbe_tac0_under_lo':               ; 27
           'lbe_tac0_over_hi':                ; 28
           'lbe_tac0_over_lo':                ; 29
           'lbe_tac2_under_hi':               ; 30
           'lbe_tac2_under_lo':               ; 31
           'lbe_tac2_over_hi':                ; 32
           'lbe_tac2_over_lo':                ; 33
           'lbe_ssd_ctrl':                    ; 34
           'lbe_ssd_cmd_h':                   ; 35
           'lbe_ssd_cmd_l':                   ; 36
           'lbe_ssd_dis':                     ; 37
           'lbe_ssd_under_hi':                ; 38
           'lbe_ssd_under_lo':                ; 39
           'lbe_ssd_over_hi':                 ; 40
           'lbe_ssd_over_lo':                 ; 41
           'lbe_sel_ctrl':                    ; 42
           'lbe_trig_mode':                   ; 43
           'lbe_esa_step':                    ; 44
           'lbe_defl_step':                   ; 45
           'lbe_ssd_offset0':                 ; 46
           'lbe_ssd_offset1':                 ; 47
           'lbe_ssd_offset2':                 ; 48
           'lbe_ssd_offset3':                 ; 49
           'lbe_ssd_offset4':                 ; 50
           'lbe_ssd_offset5':                 ; 51
           'lbe_ssd_offset6':                 ; 52
           'lbe_ssd_offset7':                 ; 53
           'lbe_stim_enable':                 ; 54
           'lbe_stim_freq_hi':                ; 55
           'lbe_stim_freq_lo':                ; 56
           'lbe_sel0_window':                 ; 57
           'lbe_sel2_window':                 ; 58
           'lbe_ssd_offset8':                 ; 59
           'lbe_ssd_offset9':                 ; 60
           'lbe_ssd_offset10':                ; 61
           'lbe_ssd_offset11':                ; 62
           'lbe_ssd_offset12':                ; 63
           'lbe_ssd_offset13':                ; 64
           'lbe_ssd_offset14':                ; 65
           'lbe_ssd_offset15':                ; 66
           'lbe_pos_ra':                      ; 67
           'dacm_pac_mcp_ssd_ctl_mcp_limit':  ; 68
           'dacm_pac_limit':                  ; 69
           'dacm_esa_ctl':                    ; 70
           'dacm_s_ch_ctl':                   ; 71
           'dacm_dfl_1_ctl':                  ; 72
           'dacm_dfl_2_ctl':                  ; 73
           'dacm_control':                    ; 74
           'dacm_status':                     ; 75
           'dacm_adc_lu_ctr':                 ; 76
           'dacm_dfl_1_offset':               ; 77
           'dacm_dfl_2_offset':               ; 78
           'dacm_pac_coarse':                 ; 79
           'dacm_pac_fine':                   ; 80
           'dacm_pac_cm_fs_coarse':           ; 81
           'dacm_pac_cm_fs_fine':             ; 82
           'dacm_mcp_coarse':                 ; 83
           'dacm_mcp_fine':                   ; 84
           'dacm_mcp_cm_fs_coarse':           ; 85
           'dacm_mcp_cm_fs_fine':             ; 86
           'dacm_ssd_coarse':                 ; 87
           'dacm_ssd_fine':                   ; 88
           'dacm_esa_coarse':                 ; 89
           'dacm_esa_fine':                   ; 90
           'dacm_s_ch_coarse':                ; 91
           'dacm_s_ch_fine':                  ; 92
           'dacm_s_ch_tap_coarse':            ; 93
           'dacm_s_ch_tap_fine':              ; 94
           'dacm_dfl_1_coarse':               ; 95
           'dacm_dfl_1_fine':                 ; 96
           'dacm_dfl_1_dfine':                ; 97
           'dacm_dfl_2_coarse':               ; 98
           'dacm_dfl_2_fine':                 ; 99
           'dacm_dfl_2_dfine':                ; 100
           'dacr_pac_mcp_ssd_ctl_mcp_limit':  ; 101
           'dacr_pac_limit':                  ; 102
           'dacr_esa_ctl':                    ; 103
           'dacr_s_ch_ctl':                   ; 104
           'dacr_dfl_1_ctl':                  ; 105
           'dacr_dfl_2_ctl':                  ; 106
           'dacr_control':                    ; 107
           'dacr_status':                     ; 108
           'dacr_adc_lu_ctr':                 ; 109
           'dacr_dfl_1_offset':               ; 110
           'dacr_dfl_2_offset':               ; 111
           'dacr_c_pac_coarse':               ; 112
           'dacr_c_pac_fine':                 ; 113
           'dacr_c_pac_cm_fs_coarse':         ; 114
           'dacr_c_pac_cm_fs_fine':           ; 115
           'dacr_c_mcp_coarse':               ; 116
           'dacr_c_mcp_fine':                 ; 117
           'dacr_c_mcp_cm_fs_coarse':         ; 118
           'dacr_c_mcp_cm_fs_fine':           ; 119
           'dacr_c_ssd_coarse':               ; 120
           'dacr_c_ssd_fine':                 ; 121
           'dacr_c_esa_coarse':               ; 122
           'dacr_c_esa_fine':                 ; 123
           'dacr_c_s_ch_coarse':              ; 124
           'dacr_c_s_ch_fine':                ; 125
           'dacr_c_s_ch_tap_coarse':          ; 126
           'dacr_c_s_ch_tap_fine':            ; 127
           'dacr_dfl_1_coarse':               ; 128
           'dacr_dfl_1_fine':                 ; 129
           'dacr_dfl_1_dfine':                ; 130
           'dacr_dfl_2_coarse':               ; 131
           'dacr_dfl_2_fine':                 ; 132
           'dacr_dfl_2_dfine':                ; 133
           'sw_status1':                      ; 134
           'sw_hv_ramp_status':               ; 135
           'sw_hv_enable_status':             ; 136
           'sw_hv_limit_status':              ; 137
           'sw_eepromchksum':                 ; 138
           'hkp_sampletime':                  ; 139
           'pac_discharge_status':            ; 140
           'pac_discharge_cnt':               ; 141
           'pac_discharge_conseccntr':        ; 142
           'pac_discharge_safe_att':          ; 143
           'analog_limit_status':             ; 144
           'analog_lim_pt1_status':           ; 145
           'analog_lim_pt1_id':               ; 146
           'analog_lim_pt1_red':              ; 147
           'analog_lim_pt2_status':           ; 148
           'analog_lim_pt2_id':               ; 149
           'analog_lim_pt2_red':              ; 150
           'analog_lim_pt3_status':           ; 151
           'analog_lim_pt3_id':               ; 152
           'analog_lim_pt3_red':              ; 153
           'analog_lim_pt4_status':           ; 154
           'analog_lim_pt4_id':               ; 155
           'analog_lim_pt4_red':              ; 156
           'analog_lim_pt5_status':           ; 157
           'analog_lim_pt5_id':               ; 158
           'analog_lim_pt5_red':              ; 159
           'analog_lim_pt6_status':           ; 160
           'analog_lim_pt6_id':               ; 161
           'analog_lim_pt6_red':              ; 162
           'analog_lim_pt7_status':           ; 163
           'analog_lim_pt7_id':               ; 164
           'analog_lim_pt7_red':              ; 165
           'analog_lim_pt8_status':           ; 166
           'analog_lim_pt8_id':               ; 167
           'analog_lim_pt8_red':              ; 168
           'analog_lim_pt9_status':           ; 169
           'analog_lim_pt9_id':               ; 170
           'analog_lim_pt9_red':              ; 171
           'analog_lim_pt10_status':          ; 172
           'analog_lim_pt10_id':              ; 173
           'analog_lim_pt10_red':             ; 174
           'analog_lim_pt11_status':          ; 175
           'analog_lim_pt11_id':              ; 176
           'analog_lim_pt11_red':             ; 177
           'analog_lim_pt12_status':          ; 178
           'analog_lim_pt12_id':              ; 179
           'analog_lim_pt12_red':             ; 180
           'analog_lim_pt13_status':          ; 181
           'analog_lim_pt13_id':              ; 182
           'analog_lim_pt13_red':             ; 183
           'analog_lim_pt14_status':          ; 184
           'analog_lim_pt14_id':              ; 185
           'analog_lim_pt14_red':             ; 186
           'analog_lim_pt15_status':          ; 187
           'analog_lim_pt15_id':              ; 188
           'analog_lim_pt15_red':             ; 189
           'opmode':                          ; 190
           'sw_mode':                         ; 191
           'proton_mode':                     ; 192
           'active_supplyid':                 ; 193
           'supply_coarse_rb':                ; 194
           'supply_fine_rb':                  ; 195
           'swmaint_supplystat':              ; 196
           'swmaint_pac_coarse':              ; 197
           'swmaint_pac_fine': BREAK          ; 198
    ELSE: BEGIN 
        print, 'Invalid element in hk array: ', prod_hk
        stop
    ENDELSE
ENDSWITCH
END 


PRO check_dig_hk_array, dig_hk_array, a_dig_hk_array, b_dig_hk_array, sat

; in: dig_hk_array -- array from crib sheet
; out: a_dig_hk_array, b_dig_hk_array -- same as hk array, but divided by satellite

prod_dig_hk = ' '

FOR ii = 0, N_ELEMENTS(dig_hk_array)-1 DO BEGIN
	CASE dig_hk_array(ii) OF
	
	 1:  prod_dig_hk = 'dpu_sw_version'                  ; 0 
         2:  prod_dig_hk = 'cmd_rcvd_cnt'                    ; 1
         3:  prod_dig_hk = 'cmd_exec_cnt'                    ; 2
         4:  prod_dig_hk = 'cmd_total_err_cnt'               ; 3
         5:  prod_dig_hk = 'cmd_parity_err_cnt'              ; 4
         6:  prod_dig_hk = 'cmd_frame_err_cnt'               ; 5
         7:  prod_dig_hk = 'cmd_illegal_err_cnt'             ; 6
         8:  prod_dig_hk = 'ic_status_reg'                   ; 7
         9:  prod_dig_hk = 'ic_ctl_reg'                      ; 8
         10:   prod_dig_hk = 'lbc_reset_ctl'                   ; 9
         11:   prod_dig_hk = 'lbc_mode_ctl'                    ; 10
         12:   prod_dig_hk =  'lbc_logic_ctl_a'                ; 11
         13:   prod_dig_hk = 'lbc_logic_ctl_b'                 ; 12
         14:   prod_dig_hk = 'lbc_tac_pwr_ctl'                 ; 13
         15:   prod_dig_hk = 'lbc_reg_seq'                     ; 14
         16:   prod_dig_hk = 'lbc_event_ctl'                   ; 15
         17:   prod_dig_hk = 'lbc_rlim_ch'                     ; 16
         18:   prod_dig_hk = 'lbc_rlim_hi'                     ; 17
         19:   prod_dig_hk = 'lbc_rlim_lo'                     ; 18
         20:   prod_dig_hk =  'lbe_pos_ctrl'                   ; 19
         21:   prod_dig_hk =  'lbe_pos_disable0'               ; 20
         22:   prod_dig_hk = 'lbe_pos_disable2'                ; 21
         23:   prod_dig_hk = 'lbe_tac0_ctrl'                   ; 22
         24:   prod_dig_hk = 'lbe_tac0_dac'                    ; 23
         25:   prod_dig_hk = 'lbe_tac2_ctrl'                   ; 24
         26:   prod_dig_hk = 'lbe_tac2_dac'                    ; 25
         27:   prod_dig_hk = 'lbe_tac0_under_hi'               ; 26
         28:   prod_dig_hk = 'lbe_tac0_under_lo'               ; 27
         29:   prod_dig_hk = 'lbe_tac0_over_hi'                ; 28
         30:   prod_dig_hk = 'lbe_tac0_over_lo'                ; 29
         31:   prod_dig_hk = 'lbe_tac2_under_hi'               ; 30
         32:   prod_dig_hk = 'lbe_tac2_under_lo'               ; 31
         33:   prod_dig_hk = 'lbe_tac2_over_hi'                ; 32
         34:   prod_dig_hk = 'lbe_tac2_over_lo'                ; 33
         35:   prod_dig_hk = 'lbe_ssd_ctrl'                    ; 34
         36:   prod_dig_hk = 'lbe_ssd_cmd_h'                   ; 35
         37:   prod_dig_hk = 'lbe_ssd_cmd_l'                   ; 36
         38:   prod_dig_hk = 'lbe_ssd_dis'                     ; 37
         39:   prod_dig_hk = 'lbe_ssd_under_hi'                ; 38
         40:   prod_dig_hk = 'lbe_ssd_under_lo'                ; 39
         41:   prod_dig_hk = 'lbe_ssd_over_hi'                 ; 40
         42:   prod_dig_hk = 'lbe_ssd_over_lo'                 ; 41
         43:   prod_dig_hk = 'lbe_sel_ctrl'                    ; 42
         44:   prod_dig_hk = 'lbe_trig_mode'                   ; 43
         45:   prod_dig_hk = 'lbe_esa_step'                    ; 44
         46:   prod_dig_hk = 'lbe_defl_step'                   ; 45
         47:   prod_dig_hk = 'lbe_ssd_offset0'                 ; 46
         48:   prod_dig_hk = 'lbe_ssd_offset1'                 ; 47
         49:   prod_dig_hk = 'lbe_ssd_offset2'                 ; 48
         50:   prod_dig_hk = 'lbe_ssd_offset3'                 ; 49
         51:   prod_dig_hk = 'lbe_ssd_offset4'                 ; 50
         52:   prod_dig_hk = 'lbe_ssd_offset5'                 ; 51
         53:   prod_dig_hk = 'lbe_ssd_offset6'                 ; 52
         54:   prod_dig_hk = 'lbe_ssd_offset7'                 ; 53
         55:   prod_dig_hk = 'lbe_stim_enable'                 ; 54
         56:   prod_dig_hk = 'lbe_stim_freq_hi'                ; 55
         57:   prod_dig_hk = 'lbe_stim_freq_lo'                ; 56
         58:   prod_dig_hk = 'lbe_sel0_window'                 ; 57
         59:   prod_dig_hk = 'lbe_sel2_window'                 ; 58
         60:   prod_dig_hk = 'lbe_ssd_offset8'                 ; 59
         61:   prod_dig_hk = 'lbe_ssd_offset9'                 ; 60
         62:   prod_dig_hk = 'lbe_ssd_offset10'                ; 61
         63:   prod_dig_hk = 'lbe_ssd_offset11'                ; 62
         64:   prod_dig_hk = 'lbe_ssd_offset12'                ; 63
         65:   prod_dig_hk = 'lbe_ssd_offset13'                ; 64
         66:   prod_dig_hk = 'lbe_ssd_offset14'                ; 65
         67:   prod_dig_hk = 'lbe_ssd_offset15'                ; 66
         68:   prod_dig_hk = 'lbe_pos_ra'                      ; 67
         69:   prod_dig_hk = 'dacm_pac_mcp_ssd_ctl_mcp_limit'  ; 68
         70:   prod_dig_hk = 'dacm_pac_limit'                  ; 69
         71:   prod_dig_hk = 'dacm_esa_ctl'                    ; 70
         72:   prod_dig_hk = 'dacm_s_ch_ctl'                   ; 71
         73:   prod_dig_hk = 'dacm_dfl_1_ctl'                  ; 72
         74:   prod_dig_hk = 'dacm_dfl_2_ctl'                  ; 73
         75:   prod_dig_hk = 'dacm_control'                    ; 74
         76:   prod_dig_hk = 'dacm_status'                     ; 75
         77:   prod_dig_hk = 'dacm_adc_lu_ctr'                 ; 76
         78:   prod_dig_hk = 'dacm_dfl_1_offset'               ; 77
         79:   prod_dig_hk = 'dacm_dfl_2_offset'               ; 78
         80:   prod_dig_hk = 'dacm_pac_coarse'                 ; 79
         81:   prod_dig_hk = 'dacm_pac_fine'                   ; 80
         82:   prod_dig_hk = 'dacm_pac_cm_fs_coarse'           ; 81
         83:   prod_dig_hk = 'dacm_pac_cm_fs_fine'             ; 82
         84:   prod_dig_hk = 'dacm_mcp_coarse'                 ; 83
         85:   prod_dig_hk = 'dacm_mcp_fine'                   ; 84
         86:   prod_dig_hk = 'dacm_mcp_cm_fs_coarse'           ; 85
         87:   prod_dig_hk = 'dacm_mcp_cm_fs_fine'             ; 86
         88:   prod_dig_hk = 'dacm_ssd_coarse'                 ; 87
         89:   prod_dig_hk = 'dacm_ssd_fine'                   ; 88
         90:   prod_dig_hk = 'dacm_esa_coarse'                 ; 89
         91:   prod_dig_hk = 'dacm_esa_fine'                   ; 90
         92:   prod_dig_hk = 'dacm_s_ch_coarse'                ; 91
         93:   prod_dig_hk = 'dacm_s_ch_fine'                  ; 92
         94:   prod_dig_hk = 'dacm_s_ch_tap_coarse'            ; 93
         95:   prod_dig_hk = 'dacm_s_ch_tap_fine'              ; 94
         96:   prod_dig_hk = 'dacm_dfl_1_coarse'               ; 95
         97:   prod_dig_hk = 'dacm_dfl_1_fine'                 ; 96
         98:   prod_dig_hk = 'dacm_dfl_1_dfine'                ; 97
         99:   prod_dig_hk = 'dacm_dfl_2_coarse'               ; 98
         100:   prod_dig_hk = 'dacm_dfl_2_fine'                 ; 99
         101:   prod_dig_hk = 'dacm_dfl_2_dfine'                ; 100
         102:   prod_dig_hk = 'dacr_pac_mcp_ssd_ctl_mcp_limit'  ; 101
         103:   prod_dig_hk = 'dacr_pac_limit'                  ; 102
         104:   prod_dig_hk = 'dacr_esa_ctl'                    ; 103
         105:   prod_dig_hk = 'dacr_s_ch_ctl'                   ; 104
         106:   prod_dig_hk = 'dacr_dfl_1_ctl'                  ; 105
         107:   prod_dig_hk = 'dacr_dfl_2_ctl'                  ; 106
         108:   prod_dig_hk = 'dacr_control'                    ; 107
         109:   prod_dig_hk = 'dacr_status'                     ; 108
         110:   prod_dig_hk = 'dacr_adc_lu_ctr'                 ; 109
         111:   prod_dig_hk = 'dacr_dfl_1_offset'               ; 110
         112:   prod_dig_hk = 'dacr_dfl_2_offset'               ; 111
         113:   prod_dig_hk = 'dacr_c_pac_coarse'               ; 112
         114:   prod_dig_hk = 'dacr_c_pac_fine'                 ; 113
         115:   prod_dig_hk = 'dacr_c_pac_cm_fs_coarse'         ; 114
         116:   prod_dig_hk = 'dacr_c_pac_cm_fs_fine'           ; 115
         117:   prod_dig_hk = 'dacr_c_mcp_coarse'               ; 116
         118:   prod_dig_hk = 'dacr_c_mcp_fine'                 ; 117
         119:   prod_dig_hk = 'dacr_c_mcp_cm_fs_coarse'         ; 118
         120:   prod_dig_hk = 'dacr_c_mcp_cm_fs_fine'           ; 119
         121:   prod_dig_hk = 'dacr_c_ssd_coarse'               ; 120
         122:   prod_dig_hk = 'dacr_c_ssd_fine'                 ; 121
         123:   prod_dig_hk = 'dacr_c_esa_coarse'               ; 122
         124:   prod_dig_hk = 'dacr_c_esa_fine'                 ; 123
         125:   prod_dig_hk = 'dacr_c_s_ch_coarse'              ; 124
         126:   prod_dig_hk = 'dacr_c_s_ch_fine'                ; 125
         127:   prod_dig_hk = 'dacr_c_s_ch_tap_coarse'          ; 126
         128:   prod_dig_hk = 'dacr_c_s_ch_tap_fine'            ; 127
         129:   prod_dig_hk = 'dacr_dfl_1_coarse'               ; 128
         130:   prod_dig_hk = 'dacr_dfl_1_fine'                 ; 129
         131:   prod_dig_hk = 'dacr_dfl_1_dfine'                ; 130
         132:   prod_dig_hk = 'dacr_dfl_2_coarse'               ; 131
         133:   prod_dig_hk = 'dacr_dfl_2_fine'                 ; 132
         134:   prod_dig_hk = 'dacr_dfl_2_dfine'                ; 133
         135:   prod_dig_hk = 'sw_status1'                      ; 134
         136:   prod_dig_hk = 'sw_hv_ramp_status'               ; 135
         137:   prod_dig_hk = 'sw_hv_enable_status'             ; 136
         138:   prod_dig_hk = 'sw_hv_limit_status'              ; 137
         139:   prod_dig_hk = 'sw_eepromchksum'                 ; 138
         140:   prod_dig_hk = 'hkp_sampletime'                  ; 139
         141:   prod_dig_hk = 'pac_discharge_status'            ; 140
         142:   prod_dig_hk = 'pac_discharge_cnt'               ; 141
         143:   prod_dig_hk = 'pac_discharge_conseccntr'        ; 142
         144:   prod_dig_hk = 'pac_discharge_safe_att'          ; 143
         145:   prod_dig_hk = 'analog_limit_status'             ; 144
         146:   prod_dig_hk = 'analog_lim_pt1_status'           ; 145
         147:   prod_dig_hk = 'analog_lim_pt1_id'               ; 146
         148:   prod_dig_hk = 'analog_lim_pt1_red'              ; 147
         149:   prod_dig_hk = 'analog_lim_pt2_status'           ; 148
         150:   prod_dig_hk = 'analog_lim_pt2_id'               ; 149
         151:   prod_dig_hk = 'analog_lim_pt2_red'              ; 150
         152:   prod_dig_hk = 'analog_lim_pt3_status'           ; 151
         153:   prod_dig_hk = 'analog_lim_pt3_id'               ; 152
         154:   prod_dig_hk = 'analog_lim_pt3_red'              ; 153
         155:   prod_dig_hk = 'analog_lim_pt4_status'           ; 154
         156:   prod_dig_hk = 'analog_lim_pt4_id'               ; 155
         157:   prod_dig_hk = 'analog_lim_pt4_red'              ; 156
         158:   prod_dig_hk = 'analog_lim_pt5_status'           ; 157
         159:   prod_dig_hk = 'analog_lim_pt5_id'               ; 158
         160:   prod_dig_hk = 'analog_lim_pt5_red'              ; 159
         161:   prod_dig_hk = 'analog_lim_pt6_status'           ; 160
         162:   prod_dig_hk = 'analog_lim_pt6_id'               ; 161
         163:   prod_dig_hk = 'analog_lim_pt6_red'              ; 162
         164:   prod_dig_hk = 'analog_lim_pt7_status'           ; 163
         165:   prod_dig_hk = 'analog_lim_pt7_id'               ; 164
         166:   prod_dig_hk = 'analog_lim_pt7_red'              ; 165
         167:   prod_dig_hk = 'analog_lim_pt8_status'           ; 166
         168:   prod_dig_hk = 'analog_lim_pt8_id'               ; 167
         169:   prod_dig_hk = 'analog_lim_pt8_red'              ; 168
         170:   prod_dig_hk = 'analog_lim_pt9_status'           ; 169
         171:   prod_dig_hk = 'analog_lim_pt9_id'               ; 170
         172:   prod_dig_hk = 'analog_lim_pt9_red'              ; 171
         173:   prod_dig_hk = 'analog_lim_pt10_status'          ; 172
         174:   prod_dig_hk = 'analog_lim_pt10_id'              ; 173
         175:   prod_dig_hk = 'analog_lim_pt10_red'             ; 174
         176:   prod_dig_hk = 'analog_lim_pt11_status'          ; 175
         177:   prod_dig_hk = 'analog_lim_pt11_id'              ; 176
         178:   prod_dig_hk = 'analog_lim_pt11_red'             ; 177
         179:   prod_dig_hk = 'analog_lim_pt12_status'          ; 178
         180:   prod_dig_hk = 'analog_lim_pt12_id'              ; 179
         181:   prod_dig_hk = 'analog_lim_pt12_red'             ; 180
         182:   prod_dig_hk = 'analog_lim_pt13_status'          ; 181
         183:   prod_dig_hk = 'analog_lim_pt13_id'              ; 182
         184:   prod_dig_hk = 'analog_lim_pt13_red'             ; 183
         185:   prod_dig_hk = 'analog_lim_pt14_status'          ; 184
         186:   prod_dig_hk = 'analog_lim_pt14_id'              ; 185
         187:   prod_dig_hk = 'analog_lim_pt14_red'             ; 186
         188:   prod_dig_hk = 'analog_lim_pt15_status'          ; 187
         189:   prod_dig_hk = 'analog_lim_pt15_id'              ; 188
         190:   prod_dig_hk = 'analog_lim_pt15_red'             ; 189
         191:   prod_dig_hk = 'opmode'                          ; 190
         192:   prod_dig_hk = 'sw_mode'                         ; 191
         193:   prod_dig_hk = 'proton_mode'                     ; 192
         194:   prod_dig_hk = 'active_supplyid'                 ; 193
         195:   prod_dig_hk = 'supply_coarse_rb'                ; 194
         196:   prod_dig_hk = 'supply_fine_rb'                  ; 195
         197:   prod_dig_hk = 'swmaint_supplystat'              ; 196
         198:   prod_dig_hk = 'swmaint_pac_coarse'              ; 197
         199:   prod_dig_hk = 'swmaint_pac_fine'                ; 198

	ENDCASE

    IF sat EQ 'A' THEN BEGIN 
        IF n_elements(a_dig_hk_array) EQ 0 THEN a_dig_hk_array = [prod_dig_hk] ELSE a_dig_hk_array = [a_dig_hk_array, prod_dig_hk]
        check_prod_dig_hk, prod_dig_hk
    ENDIF ELSE BEGIN 
        IF sat EQ 'B' THEN BEGIN 
            IF n_elements(b_dig_hk_array) EQ 0 THEN b_dig_hk_array = [prod_dig_hk] ELSE b_dig_hk_array = [b_dig_hk_array, prod_dig_hk]
            check_prod_dig_hk, prod_dig_hk
        ENDIF ELSE BEGIN 
            print, 'sat must be A or B'
            stop
        ENDELSE   
    ENDELSE 
ENDFOR  
END


PRO pl_plot_dig_hk_from_crib, sat_dig_hk, sat, $
                          INST_COORD=INST_COORD

  COMMON get_error, get_err_no, get_err_msg, default_verbose


  check_dig_hk_array, sat_dig_hk, sat_a_dig_hk, sat_b_dig_hk, sat

  ; Figure out which files we need to read from
  seek_files, 'A', 'hk', files_a
  seek_files, 'B', 'hk', files_b
  dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
  dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  IF num_a_valid_files EQ 0 AND n_elements(sat_a_dig_hk) GT 0 THEN print, "No files found for spacecraft A"
  IF num_b_valid_files EQ 0 AND n_elements(sat_b_dig_hk) GT 0 THEN print, "No files found for spacecraft B"

 ; Read data
  IF num_a_valid_files GT 0 AND n_elements(sat_a_dig_hk) GT 0 THEN pl_read_cdf_general, 'A', files_a, sat_a_dig_hk, 1, 0, 'digital_hk', 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_dig_hk) GT 0 THEN pl_read_cdf_general, 'B', files_b, sat_b_dig_hk, 1, 0, 'digital_hk', 1

 ; Put in tplot structures
  IF num_a_valid_files GT 0 AND n_elements(sat_a_dig_hk) GT 0 THEN make_tplot_struct_dig_hk, 'A', sat_a_dig_hk
  IF num_b_valid_files GT 0 AND n_elements(sat_b_dig_hk) GT 0 THEN make_tplot_struct_dig_hk, 'B', sat_b_dig_hk

  ; Set plot attributes
  IF num_a_valid_files GT 0 AND n_elements(sat_a_dig_hk) GT 0 THEN set_plot_attributes_dig_hk, 'A', sat_dig_hk, 1
  IF num_b_valid_files GT 0 AND n_elements(sat_b_dig_hk) GT 0 THEN set_plot_attributes_dig_hk, 'B', sat_dig_hk, 1

  ; Make the plots
  IF (num_a_valid_files GT 0 AND n_elements(sat_a_dig_hk) GT 0) $
    OR (num_b_valid_files GT 0 AND n_elements(sat_b_dig_hk) GT 0) THEN $
    		plot_dig_hk, sat_dig_hk, num_a_valid_files, num_b_valid_files, sat
END
