;+
;PROCEDURE: make_tplot_struct_hk
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod_hk: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 01/12/2007
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;	November 2006 K. Simunac modifies for housekeeping data
;	12 Jan, 2007 variable names modified to avoid confusion
;-
PRO make_tplot_struct_hk_1min, sat, prod_hk
COMMON tplot_com1
hk_finished = 0
FOR ii = 0, n_elements(prod_hk)-1 DO BEGIN 
    SWITCH prod_hk[ii] OF 

	'lrnm_spare':	;0
	'lvc_-12v':	;1
	'lvc_-5v':	;2
	'esa_vm_pos':	;3
	'dfl_1_vm':	;4
	'dfl_1_tap':	;5
	'dfl_2_vm':	;6
	'dfl_2_tap':	;7
	'lvc_+2.5v_b':	;8
	'pac_cm_dc':	;9
	'lvc_+12v':	;10
	'lrpm_spare':	;11
	'lvc_+2.5v_a':	;12
	'lvc_+5v':	;13
	'adc_avdd':	;14
	'adc_dvdd':	;15
	'pac_vm':	;16
	'cal_vref':	;17
	'pac_cm_ac':	;18
	'mcp_vm':	;19
	'mcp_cm_dc':	;20
	'mcp_cm_ac':	;21
	'ssd_cm_dc':	;22
	's_ch_vm':	;23
	's_ch_vm_tap':	;24
	's_ch_cm_dc':	;25
	'esa_vm_neg':	;26
	'esa_cm_dc':	;27
	'dfl_1_cm_dc':	;28
	'dfl_2_cm_dc':	;29
	'lvc_+2.5v_b_imon':	;30
	'lvc_+12v_imon':	;31
	'lvc_-12v_imon':	;32
	'lvc_+5v_imon':	;33
	'lvc_-5v_imon':	;34
	'lvc_+2.5v_a_imon':	;35
	'ssd_vm':	;36
	'adc_lu_flag':	;37
	'plug_id':	;38
	'adc_lu_ctr':	;39
	'dac_status':	;40
	'adc0_agnd':	;41
	'adc1_agnd':	;42
	'ra_e0':	;43
	'ra_e1':	;44
	'tac0_tsp':	;45
	'tac2_tsp':	;46
	'sb0_tsp':	;47
	'sb1_tsp':	;48
	'tof_hv0_tsp':	;49
	'tof_hv1_tsp':	;50
	's_c_0_tsp':	;51
	's_c_1_tsp':	;52
	'lvc0_tsp':	;53
	'lvc1_tsp':	;54
	'adc0_vref':	;55
	'adc1_vref':	;56
	'ssd_status':	;57
	'ssd_v_pos_analog':	;58
	'ssd_v_neg_analog':	;59
	'ssd_hv_bias':	;60
	'ssd_tc0':	;61
	'ssd_tc1':	;62
	'ssd_tc2':	;63
	'ssd_v_pos_dig':  BEGIN 
            IF hk_finished EQ 0 THEN BEGIN 
                make_hk_struct_1min, sat, prod_hk
                hk_finished = 1
            ENDIF 
            BREAK 
        END 
    ENDSWITCH 
ENDFOR 
END 
