;+
;PROCEDURE: make_tplot_struct
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 09/21/2006
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;-
PRO make_tplot_struct, sat, prod
COMMON tplot_com1
moments_finished = 0
FOR ii = 0, n_elements(prod)-1 DO BEGIN 
    SWITCH prod[ii] OF 
        'D': 
        'VX':
        'VY':
        'VZ':
        'VXYZ':
        'VT': 
        'TXX'   : 
        'TXY'   : 
        'TXZ'   : 
        'TYY'   : 
        'TYZ'   : 
        'TZZ'   : 
        'PXX'   : 
        'PXY'   : 
        'PXZ'   : 
        'PYY'   : 
        'PYZ'   : 
        'PZZ'   : 
        'EX'   : 
        'EY'   : 
        'EZ'   : 
        'HX'   : 
        'HY'   : 
        'HZ'   : BEGIN 
            IF moments_finished EQ 0 THEN BEGIN 
                make_moment_struct, sat
                moments_finished = 1
            ENDIF 
            BREAK 
        END 
    ENDSWITCH 
ENDFOR 
END 
