;+
;PROCEDURE: make_sc_hk_struct
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;
;CREATED BY: L. Ellis (make_moment_struct)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;
;   November 2006 modified by K. Simunac for housekeeping data
;	12 Jan, 2007:  modified variable and program names to avoid confusion
;	3 July, 2007	calls com_mon and share1_mon variables
;-

PRO make_sc_hk_struct, sat, prod_sc_hk
COMMON share1_mon
COMMON com_mon
IF sat EQ 'A' THEN BEGIN 
	epoch3 = epoch3_sc_hk_a
	pl_ebox_tmp = pl_ebox_tmp_a	;0
	pl_inst_msg_pwr_dwn_req = pl_inst_msg_pwr_dwn_req_a	;1
	pl_pwr_cur = pl_pwr_cur_a	;2
	pl_pwr_tt = pl_pwr_tt_a	;3
	pl_surv_pwr_cur = pl_surv_pwr_cur_a	;4 
	pl_surv_pwr_tt = pl_surv_pwr_tt_a	;5
	pl_tof_tmp = pl_tof_tmp_a	;6
	pl_pwr_vt = pl_pwr_vt_a	;7
	pl_surv_pwr_vt = pl_surv_pwr_vt_a 	;8

;for jj=0,99 DO BEGIN
;print, jj, epoch3_sc_hk_a[jj], pl_ebox_tmp[jj]
;endfor
;stop


ENDIF ELSE BEGIN 
	epoch3 = epoch3_sc_hk_b
	pl_ebox_tmp = pl_ebox_tmp_b	;0
	pl_inst_msg_pwr_dwn_req = pl_inst_msg_pwr_dwn_req_b	;1
	pl_pwr_cur = pl_pwr_cur_b	;2
	pl_pwr_tt = pl_pwr_tt_b	;3
	pl_surv_pwr_cur = pl_surv_pwr_cur_b	;4 
	pl_surv_pwr_tt = pl_surv_pwr_tt_b	;5
	pl_tof_tmp = pl_tof_tmp_b	;6
	pl_pwr_vt = pl_pwr_vt_b	;7
	pl_surv_pwr_vt = pl_surv_pwr_vt_b 	;8
;for jj=0,99 DO BEGIN
;print, jj, epoch3_sc_hk_b[jj], pl_ebox_tmp_b[jj]
;endfor
;stop


     
ENDELSE 

labels = ' '

FOR i=0, n_elements(prod_sc_hk)-1 DO BEGIN
	CASE prod_sc_hk(i) OF
	'pl_ebox_tmp': store_data, 'SC_HK_pl_ebox_tmp', data = {x:epoch3, y:pl_ebox_tmp}, dlim = {ylog:0, labels:labels, panel_size:2.}	;0
	'pl_inst_msg_pwr_dwn_req': store_data, 'SC_HK_pl_inst_msg_pwr_dwn_req', data = {x:epoch3, y:pl_inst_msg_pwr_dwn_req}, dlim = {ylog:0, labels:labels, panel_size:2.}	;1
	'pl_pwr_cur': store_data, 'SC_HK_pl_pwr_cur', data = {x:epoch3, y:pl_pwr_cur}, dlim = {ylog:0, labels:labels, panel_size:2.}	;2
	'pl_pwr_tt': store_data, 'SC_HK_pl_pwr_tt', data = {x:epoch3, y:pl_pwr_tt}, dlim = {ylog:0, labels:labels, panel_size:2.}	;3
	'pl_surv_pwr_cur': store_data, 'SC_HK_pl_surv_pwr_cur', data = {x:epoch3, y:pl_surv_pwr_cur}, dlim = {ylog:0, labels:labels, panel_size:2.}	;4 
	'pl_surv_pwr_tt': store_data, 'SC_HK_pl_surv_pwr_tt', data = {x:epoch3, y:pl_surv_pwr_tt}, dlim = {ylog:0, labels:labels, panel_size:2.}	;5
	'pl_tof_tmp': store_data, 'SC_HK_pl_tof_tmp', data = {x:epoch3, y:pl_tof_tmp}, dlim = {ylog:0, labels:labels, panel_size:2.}	;6
	'pl_pwr_vt': store_data, 'SC_HK_pl_pwr_vt', data = {x:epoch3, y:pl_pwr_vt}, dlim = {ylog:0, labels:labels, panel_size:2.}	;7
	'pl_surv_pwr_vt': store_data, 'SC_HK_pl_surv_pwr_vt', data = {x:epoch3, y:pl_surv_pwr_vt}, dlim = {ylog:0, labels:labels, panel_size:2.}	;8

	ENDCASE
ENDFOR

END 
