;+
;PROCEDURE: make_moment_struct
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 10/14/2006
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;    01/23/2007 LBE added diagonalization
;    02/01/2007 LBE fixed bug in density
;
;-
PRO make_moment_struct, sat
COMMON share1
COMMON com_moment

IF sat EQ 'A' THEN BEGIN 
    epoch1 = epoch1_a 
    error1 = error1_a 
    mom_meta = mom_meta_a
    velocity  = mom_velocity_main_a  ; just need size; data filled in below
    velocity_main  = mom_velocity_main_a   
    velocity_s = mom_velocity_s_a      
    density  = mom_density_main_a
    density_main  = mom_density_main_a
    density_s = mom_density_s_a 
    heat_flux  = mom_heat_flux_main_a
    heat_flux_main  = mom_heat_flux_main_a
    heat_flux_s = mom_heat_flux_s_a 
    pressure_6  = mom_temperature_main_a
    temperature_main  = mom_temperature_main_a
    temperature_s = mom_temperature_s_a 
    step_var = step_var_a
    table_norm = table_norm_a
    geom = geom_a
    sw_h_eff = sw_h_eff_a
    sw_all_eff = sw_all_eff_a
    mom_cal_start = mom_cal_start_a
    mom_cal_stop = mom_cal_stop_a
ENDIF ELSE BEGIN 
    epoch1 = epoch1_b
    error1 = error1_b
    mom_meta = mom_meta_b
    velocity  = mom_velocity_main_b 
    velocity_main = mom_velocity_main_b 
    velocity_s = mom_velocity_s_b
    density  = mom_density_main_b
    density_main = mom_density_main_b 
    density_s = mom_density_s_b
    heat_flux  = mom_heat_flux_main_b
    heat_flux_main  = mom_heat_flux_main_b
    heat_flux_s = mom_heat_flux_s_b 
    pressure_6  = mom_temperature_main_b
    temperature_main  = mom_temperature_main_b
    temperature_s = mom_temperature_s_b 
    step_var = step_var_b
    table_norm = table_norm_b
    geom = geom_b
    sw_h_eff = sw_h_eff_b
    sw_all_eff = sw_all_eff_b
    mom_cal_start = mom_cal_start_b
    mom_cal_stop = mom_cal_stop_b
ENDELSE 

find_cal_indices, epoch1, density_s, mom_cal_start, mom_cal_stop, data_indices, cal_file_index

; errors
labels = ''
name = sat+'_error1'
datastr = {x:epoch1, y:error1}
store_data, name, data = datastr, dlim = {ylog:0, labels:labels, panel_size:2.} 
; do actual calibration
;velocity
name = sat+'_mom_velocity' ; name of TPLOT structure (V for Velocity)
FOR ii = 0, n_elements(data_indices)-1 DO BEGIN 
    i_cal = cal_file_index[ii]
    i_time = data_indices[ii]
    prefix = table_norm[i_cal, 1]/table_norm[i_cal, 0] ; Bv/Bd in Lynn's document
    denom = (density_s[i_time]/geom[i_cal, 1]) + $ ; Ds/Gs + Dm/Gm
            (density_main[i_time]/geom[i_cal, 0]) 
    FOR jj = 0, 2 DO BEGIN      ; x,y,z
        numer = (velocity_s[jj, i_time]/geom[i_cal, 1]) + $ ; Vx,y,zs/Gs + Vx,y,zm/Gm
                (velocity_main[jj, i_time]/geom[i_cal, 0]) 
        velocity[jj, i_time] = prefix * numer / denom
    ENDFOR
ENDFOR
; instrument coordinates
name_inst = name+'_inst'
name_x = name_inst+'_x'
velocity_x = reform(velocity[0, *])
datastr_x = {x:epoch1, y:velocity_x}
store_data, name_x, data = datastr_x, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_y = name_inst+'_y'
velocity_y = reform(velocity[1, *])
datastr_y = {x:epoch1, y:velocity_y}
labels = ''
store_data, name_y, data = datastr_y, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_z = name_inst+'_z'
velocity_z = reform(velocity[2, *])
datastr_z = {x:epoch1, y:velocity_z}
labels = ''
store_data, name_z, data = datastr_z, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_xyz = name_inst+'_xyz'
temp_size = n_elements(velocity_x)
velocity_xyz = dblarr(temp_size, 3)
velocity_xyz[*, 0] = velocity_x
velocity_xyz[*, 1] = velocity_y
velocity_xyz[*, 2] = velocity_z
datastr_xyz = {x:epoch1, y:velocity_xyz}
labels = ''
store_data, name_xyz, data = datastr_xyz, dlim = {ylog:0, labels:labels, panel_size:2.} 
; spacecraft coordinates
name_inst = name+'_spcrft'
name_x = name_inst+'_x'
velocity_x = -1 * reform(velocity[0, *]) ; multiplying by Lynn's matrix
datastr_x = {x:epoch1, y:velocity_x}
labels = ''
store_data, name_x, data = datastr_x, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_y = name_inst+'_y'
velocity_y = reform(velocity[2, *])
datastr_y = {x:epoch1, y:velocity_y}
labels = ''
store_data, name_y, data = datastr_y, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_z = name_inst+'_z'
velocity_z = -1 * reform(velocity[1, *])
datastr_z = {x:epoch1, y:velocity_z}
labels = ''
store_data, name_z, data = datastr_z, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_xyz = name_inst+'_xyz'
temp_size = n_elements(velocity_x)
velocity_xyz = dblarr(temp_size, 3)
velocity_xyz[*, 0] = velocity_x
velocity_xyz[*, 1] = velocity_y
velocity_xyz[*, 2] = velocity_z
datastr_xyz = {x:epoch1, y:velocity_xyz}
labels = ''
store_data, name_xyz, data = datastr_xyz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_t = name+'_total'
velocity_t = sqrt((velocity_x^2)+(velocity_y^2)+(velocity_z^2))
datastr_t = {x:epoch1, y:velocity_t}
labels = ''
store_data, name_t, data = datastr_t, dlim = {ylog:0, labels:labels, panel_size:2.} 
; GSE coordinates 
;name_gse = name+'_gse'
;name_x = name_gse+'_x'
;velocity_x = reform(velocity[0, *])
;datastr_x = {x:epoch1, y:velocity_x}
;labels = ''
;store_data, name_x, data = datastr_x, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_y = name_gse+'_y'
;velocity_y = reform(velocity[1, *])
;datastr_y = {x:epoch1, y:velocity_y}
;labels = ''
;store_data, name_y, data = datastr_y, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_z = name_gse+'_z'
;velocity_z = reform(velocity[2, *])
;datastr_z = {x:epoch1, y:velocity_z}
;labels = ''
;store_data, name_z, data = datastr_z, dlim = {ylog:0, labels:labels, panel_size:2.} 
;cmat_gse = get_stereo_cmat(timestamp, sat, system = gse) ; get conversion matrix for velocity
;velocity_gse = reform(cmat_gse ## velocity)
; HGRTN coordinates 
;cmat_hgrtn = get_stereo_cmat(timestamp, sat, system = hgrtn)
;velocity_hgrtn = reform(cmat_hgrtn ## velocity)
;name_hgrtn = name+'_hgrtn'
;name_x = name_hgrtn+'_x'
;velocity_x = reform(velocity[0, *])
;datastr_x = {x:epoch1, y:velocity_x}
;labels = ''
;store_data, name_x, data = datastr_x, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_y = name_hgrtn+'_y'
;velocity_y = reform(velocity[1, *])
;datastr_y = {x:epoch1, y:velocity_y}
;labels = ''
;store_data, name_y, data = datastr_y, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_z = name_hgrtn+'_z'
;velocity_z = reform(velocity[2, *])
;datastr_z = {x:epoch1, y:velocity_z}
;labels = ''
;store_data, name_z, data = datastr_z, dlim = {ylog:0, labels:labels, panel_size:2.} 
velocity_finished = 1

; fill in efficiency
efficiencies = dblarr(n_elements(density_main))
efficiencies[*] = !values.f_nan
FOR ii = 0, n_elements(data_indices)-1 DO BEGIN 
    i_cal = cal_file_index[ii]
    i_time = data_indices[ii]
    IF mom_meta[3, i_time] EQ 0 THEN eff_table = sw_all_eff ELSE eff_table = sw_h_eff
    found = 0
    jj = 0
    temp_velocity = velocity_t[i_time]
    WHILE jj LT 32 AND found EQ 0 DO BEGIN  ; this takes the lower value
        IF temp_velocity GT eff_table[i_cal, jj, 0] THEN BEGIN
            efficiencies[i_time] = double(eff_table[i_cal, jj, 2])
            found = 1
        ENDIF ELSE jj = jj + 1
    ENDWHILE 
    IF found EQ 0 THEN efficiencies[i_time] = double(eff_table[i_cal, 31, 2])
ENDFOR 

; the rest
pi = pressure_6 ; just needed for size
energy_flux = velocity_main ; just needed for size
FOR ii = 0, n_elements(data_indices)-1 DO BEGIN 
    i_cal = cal_file_index[ii]
    i_time = data_indices[ii]
    ; density
    density_main[i_time] = density_main[i_time] * step_var[i_cal] * $
      table_norm[i_cal, 0] / (geom[i_cal, 0] * efficiencies[i_time])
    density_s[i_time] = density_s[i_time] * step_var[i_cal] * $
                        table_norm[i_cal, 0] / (geom[i_cal, 1] * efficiencies[i_time])
    density[i_time] = density_main[i_time] + density_s[i_time]
    ; pressure & temperature
    k = 1.38E-23 ; Boltzmann constant J/deg
    a_bp_e = step_var[i_cal] * table_norm[i_cal, 2] / efficiencies[i_time]
    mn = 1.67E-27 * density[i_time] * (10 ^ 6D)
    FOR jj = 0, 5 DO BEGIN ; xx,xy,xz,yy,yz,zz
        IF jj LT 3 THEN vel1 = velocity[0, i_time] ELSE IF jj LT 5 THEN $
          vel1 = velocity[1, i_time] ELSE vel1 = velocity[2, i_time] 
        IF jj EQ 0 THEN vel2 = velocity[0, i_time] ELSE IF (jj EQ 1 OR jj EQ 3) THEN $
          vel2 = velocity[1, i_time] ELSE vel2 = velocity[2, i_time]
        vel1 = vel1 * 1000
        vel2 = vel2 * 1000
        sum = (temperature_s[jj, i_time] / geom[i_cal, 1]) + $
              (temperature_main[jj, i_time] / geom[i_cal, 0]) 
        pi[jj, i_time] = a_bp_e * sum
        pressure_6[jj, i_time] = pi[jj, i_time] - (mn * vel1 * vel2)
    ENDFOR
    ; energy flux density and heat flux
    a_bh_e = step_var[i_cal] * table_norm[i_cal, 3] / efficiencies[i_time]
    sum = (heat_flux_main[i_time]/geom[i_cal, 0]) + (heat_flux_s[i_time]/geom[i_cal, 1])
    energy_flux[*, i_time] = a_bh_e * sum
ENDFOR
; density
name = sat+'_mom_density' ; name of TPLOT structure
datastr = {x:epoch1, y:density}
store_data, name, data = datastr, dlim = {ylog:1, labels:labels, panel_size:2.}
; pressure
name_pressure = sat+'_mom_pressure'
;pressure = dblarr(3, n_elements(reform(pressure_6[0, *])))
;FOR ii = 0, n_elements(reform(pressure_6[0, *]))-1 DO BEGIN 
;    IF finite(pressure_6[0, ii]) EQ 1 THEN BEGIN ; DANGER -- only checking one value to be finite
;        mat_diag, reform(pressure_6[*, ii]), EIG_VAL = temp_pressure, EIG_VEC = vec
;        pressure[*, ii] = temp_pressure
;    ENDIF 
;ENDFOR 
; Inst coordinates
name_pressure_inst = name_pressure+'_inst'
name_pressure_xx = name_pressure_inst+'_xx'
pressure_xx = reform(pressure_6[0, *])
datastr_xx = {x:epoch1, y:pressure_xx}
store_data, name_pressure_xx, data = datastr_xx, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_pressure_xy = name_pressure_inst+'_xy'
pressure_xy = reform(pressure_6[1, *])
datastr_xy = {x:epoch1, y:pressure_xy}
store_data, name_pressure_xy, data = datastr_xy, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_pressure_xz = name_pressure_inst+'_xz'
pressure_xz = reform(pressure_6[2, *])
datastr_xz = {x:epoch1, y:pressure_xz}
store_data, name_pressure_xz, data = datastr_xz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_pressure_yy = name_pressure_inst+'_yy'
pressure_yy = reform(pressure_6[3, *])
datastr_yy = {x:epoch1, y:pressure_yy}
store_data, name_pressure_yy, data = datastr_yy, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_pressure_yz = name_pressure_inst+'_yz'
pressure_yz = reform(pressure_6[4, *])
datastr_yz = {x:epoch1, y:pressure_yz}
store_data, name_pressure_yz, data = datastr_yz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_pressure_zz = name_pressure_inst+'_zz'
pressure_zz = reform(pressure_6[5, *])
datastr_zz = {x:epoch1, y:pressure_zz}
store_data, name_pressure_zz, data = datastr_zz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_xxyyzz = name_pressure_inst+'_xxyyzz'
temp_size = n_elements(pressure_xx)
pressure_xxyyzz = dblarr(temp_size, 3)
pressure_xxyyzz[*, 0] = pressure_xx
pressure_xxyyzz[*, 1] = pressure_yy
pressure_xxyyzz[*, 2] = pressure_zz
datastr_xxyyzz = {x:epoch1, y:pressure_xxyyzz}
store_data, name_xxyyzz, data = datastr_xxyyzz, dlim = {ylog:0, labels:labels, panel_size:2.} 
; Diagonalized
;name_pressure_diag = name_pressure+'_diag'
;name_pressure_x = name_pressure_diag+'_x'
;pressure_x = reform(pressure[0, *])
;datastr_x = {x:epoch1, y:pressure_x}
;store_data, name_pressure_x, data = datastr_x, dlim = {ylog:0, labels:labels, panel_size:2.} 
;name_pressure_y = name_pressure_diag+'_y'
;pressure_y = reform(pressure[1, *])
;datastr_y = {x:epoch1, y:pressure_y}
;store_data, name_pressure_y, data = datastr_y, dlim = {ylog:0, labels:labels, panel_size:2.} 
;name_pressure_z = name_pressure_diag+'_z'
;pressure_z = reform(pressure[2, *])
;datastr_z = {x:epoch1, y:pressure_z}
;store_data, name_pressure_z, data = datastr_z, dlim = {ylog:0, labels:labels, panel_size:2.} 
; temperature
name_temp = sat+'_mom_temp'
; Inst coordinates
temperature_6 = dblarr(6, temp_size)
FOR ii = 0, 5 DO BEGIN 
    temperature_6[ii, *]= pressure_6[ii, *]/(density * (10 ^ 6D) * k)  ; 10^6 to convert to 1/m3 for density
ENDFOR 
name_temp_inst = name_temp+'_inst'
name_temp_xx = name_temp_inst+'_xx'
temperature_xx = reform(temperature_6[0, *])
datastr_xx = {x:epoch1, y:temperature_xx}
store_data, name_temp_xx, data = datastr_xx, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_temp_xy = name_temp_inst+'_xy'
temperature_xy = reform(temperature_6[1, *])
datastr_xy = {x:epoch1, y:temperature_xy}
store_data, name_temp_xy, data = datastr_xy, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_temp_xz = name_temp_inst+'_xz'
temperature_xz = reform(temperature_6[2, *])
datastr_xz = {x:epoch1, y:temperature_xz}
store_data, name_temp_xz, data = datastr_xz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_temp_yy = name_temp_inst+'_yy'
temperature_yy = reform(temperature_6[3, *])
datastr_yy = {x:epoch1, y:temperature_yy}
store_data, name_temp_yy, data = datastr_yy, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_temp_yz = name_temp_inst+'_yz'
temperature_yz = reform(temperature_6[4, *])
datastr_yz = {x:epoch1, y:temperature_yz}
store_data, name_temp_yz, data = datastr_yz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_temp_zz = name_temp_inst+'_zz'
temperature_zz = reform(temperature_6[5, *])
datastr_zz = {x:epoch1, y:temperature_zz}
store_data, name_temp_zz, data = datastr_zz, dlim = {ylog:0, labels:labels, panel_size:2.} 
name_xxyyzz = name_temp_inst+'_xxyyzz'
temp_size = n_elements(temperature_xx)
temperature_xxyyzz = dblarr(temp_size, 3)
temperature_xxyyzz[*, 0] = temperature_xx
temperature_xxyyzz[*, 1] = temperature_yy
temperature_xxyyzz[*, 2] = temperature_zz
datastr_xxyyzz = {x:epoch1, y:temperature_xxyyzz}
store_data, name_xxyyzz, data = datastr_xxyyzz, dlim = {ylog:0, labels:labels, panel_size:2.} 
; Diagonalized
;temperature = dblarr(3, temp_size)
;FOR ii = 0, 2 DO BEGIN 
;    temperature[ii, *]= pressure[ii, *]/(density * (10 ^ 6D) * k)
;ENDFOR 
;name_temperature_diag = name_temp+'_diag'
;name_temperature_x = name_temperature_diag+'_x'
;temperature_x = reform(temperature[0, *])
;datastr_x = {x:epoch1, y:temperature_x}
;store_data, name_temperature_x, data = datastr_x, dlim = {ylog:0, labels:labels, panel_size:2.} 
;name_temperature_y = name_temperature_diag+'_y'
;temperature_y = reform(temperature[1, *])
;datastr_y = {x:epoch1, y:temperature_y}
;store_data, name_temperature_y, data = datastr_y, dlim = {ylog:0, labels:labels, panel_size:2.} 
;name_temperature_z = name_temperature_diag+'_z'
;temperature_z = reform(temperature[2, *])
;datastr_z = {x:epoch1, y:temperature_z}
;store_data, name_temperature_z, data = datastr_z, dlim = {ylog:0, labels:labels, panel_size:2.} 
; energy flux
name_energy_flux = sat+'_energy_flux'
; instrument coordinates
name_energy_flux_inst = name_energy_flux+'_inst'
name_energy_flux_x = name_energy_flux_inst+'_x'
energy_flux_x = reform(energy_flux[0, *])
datastr_x = {x:epoch1, y:energy_flux_x}
store_data, name_energy_flux_x, data = datastr_x, dlim = {ylog:1, labels:labels, panel_size:2.} 
name_energy_flux_y = name_energy_flux_inst+'_y'
energy_flux_y = reform(energy_flux[1, *])
datastr_y = {x:epoch1, y:energy_flux_y}
store_data, name_energy_flux_y, data = datastr_y, dlim = {ylog:1, labels:labels, panel_size:2.} 
name_energy_flux_z = name_energy_flux_inst+'_z'
energy_flux_z = reform(energy_flux[2, *])
datastr_z = {x:epoch1, y:energy_flux_z}
store_data, name_energy_flux_z, data = datastr_z, dlim = {ylog:1, labels:labels, panel_size:2.} 
; GSE coordinates
;energy_flux_gse = reform(cmat_gse ## energy_flux)
;name_energy_flux_gse = name_energy_flux+'_gse'
;name_energy_flux_x = name_energy_flux_gse+'x'
;energy_flux_x = reform(energy_flux_gse[0, *])
;datastr_x = {x:epoch1, y:energy_flux_x}
;store_data, name_energy_flux_x, data = datastr_x, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_energy_flux_y = name_energy_flux_gse+'y'
;energy_flux_y = reform(energy_flux_gse[1, *])
;datastr_y = {x:epoch1, y:energy_flux_y}
;store_data, name_energy_flux_y, data = datastr_y, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_energy_flux_z = name_energy_flux_gse+'z'
;energy_flux_z = reform(energy_flux_gse[2, *])
;datastr_z = {x:epoch1, y:energy_flux_z}
;store_data, name_energy_flux_z, data = datastr_z, dlim = {ylog:1, labels:labels, panel_size:2.} 
; HGRTN coordinates
;energy_flux_hgrtn = reform(cmat_hgrtn ## energy_flux)
;name_energy_flux_hgrtn = name_energy_flux+'_hgrtn'
;name_energy_flux_x = name_energy_flux_hgrtn+'x'
;energy_flux_x = reform(energy_flux_hgrtn[0, *])
;datastr_x = {x:epoch1, y:energy_flux_x}
;store_data, name_energy_flux_x, data = datastr_x, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_energy_flux_y = name_energy_flux_hgrtn+'y'
;energy_flux_y = reform(energy_flux_hgrtn[1, *])
;datastr_y = {x:epoch1, y:energy_flux_y}
;store_data, name_energy_flux_y, data = datastr_y, dlim = {ylog:1, labels:labels, panel_size:2.} 
;name_energy_flux_z = name_energy_flux_hgrtn+'z'
;energy_flux_z = reform(energy_flux_hgrtn[2, *])
;datastr_z = {x:epoch1, y:energy_flux_z}
;store_data, name_energy_flux_z, data = datastr_z, dlim = {ylog:1, labels:labels, panel_size:2.} 
END 
