;+
;PROCEDURE: make_hk_struct
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;
;CREATED BY: L. Ellis (make_moment_struct)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;
;   November 2006 modified by K. Simunac for housekeeping data
;	12 Jan, 2007	modified variable names to avoid confusion
;	18 Jan, 2007	modified tplot names so they are different for
;			 sat A and sat B
;	02/27/2007 - C. Mouikis: The S/C string is included in the tplot variable name
;	02/27/2007 - C. Mouikis: The ytitle is explicitly set
;	3 July, 2007	calls com_mon and share1_mon variables
;			added empty set so overplot in color can be done with black axis system
;-

PRO make_hk_struct_1min, sat, prod_hk
COMMON share1_mon
COMMON com_mon

;prefix = ' '
;IF (sat EQ 'A') THEN prefix = 'A_Analog_HK_'
;IF (sat EQ 'B') THEN prefix = 'B_Analog_HK_'

IF sat EQ 'A' THEN BEGIN 
	epoch1 = epoch1_hk_a
	lrnm_spare = lrnm_spare_a ;0
	lvc_neg12v = lvc_neg12v_a ;1
	lvc_neg5v = lvc_neg5v_a ;2
	esa_vm_pos = esa_vm_pos_a ;3
	dfl_1_vm = dfl_1_vm_a ;4
	dfl_1_tap = dfl_1_tap_a ;5
	dfl_2_vm = dfl_2_vm_a ;6
	dfl_2_tap = dfl_2_tap_a ;7
	lvc_pos2point5v_b = lvc_pos2point5v_b_a ;8
	pac_cm_dc = pac_cm_dc_a ;9
	lvc_pos12v = lvc_pos12v_a ;10
	lrpm_spare = lrpm_spare_a ;11
	lvc_pos2point5v_a = lvc_pos2point5v_a_a ;12
	lvc_pos5v = lvc_pos5v_a ;13
	adc_avdd = adc_avdd_a ;14
	adc_dvdd = adc_dvdd_a ;15
	pac_vm = pac_vm_a ;16
	cal_vref = cal_vref_a ;17
	pac_cm_ac = pac_cm_ac_a ;18
	mcp_vm = mcp_vm_a ;19
	mcp_cm_dc = mcp_cm_dc_a ;20
	mcp_cm_ac = mcp_cm_ac_a ;21
	ssd_cm_dc = ssd_cm_dc_a ;22
	s_ch_vm = s_ch_vm_a ;23
	s_ch_vm_tap = s_ch_vm_tap_a ;24
	s_ch_cm_dc = s_ch_cm_dc_a ;25
	esa_vm_neg = esa_vm_neg_a ;26
	esa_cm_dc = esa_cm_dc_a ;27
	dfl_1_cm_dc = dfl_1_cm_dc_a ;28
	dfl_2_cm_dc = dfl_2_cm_dc_a ;29
	lvc_pos2point5v_b_imon = lvc_pos2point5v_b_imon_a ;30
	lvc_pos12v_imon = lvc_pos12v_imon_a ;31
	lvc_neg12v_imon = lvc_neg12v_imon_a ;32
	lvc_pos5v_imon = lvc_pos5v_imon_a ;33
	lvc_neg5v_imon = lvc_neg5v_imon_a ;34
	lvc_pos2point5v_a_imon = lvc_pos2point5v_a_imon_a ;35
	ssd_vm = ssd_vm_a ;36
	adc_lu_flag = adc_lu_flag_a ;37
	plug_id = plug_id_a ;38
	adc_lu_ctr = adc_lu_ctr_a ;39
	dac_status = dac_status_a ;40
	adc0_agnd = adc0_agnd_a ;41
	adc1_agnd = adc1_agnd_a ;42
	ra_e0 = ra_e0_a ;43
	ra_e1 = ra_e1_a ;44
	tac0_tsp = tac0_tsp_a ;45
	tac2_tsp = tac2_tsp_a ;46
	sb0_tsp = sb0_tsp_a ;47
	sb1_tsp = sb1_tsp_a ;48
	tof_hv0_tsp = tof_hv0_tsp_a ;49
	tof_hv1_tsp = tof_hv1_tsp_a ;50
	s_c_0_tsp = s_c_0_tsp_a ;51
	s_c_1_tsp = s_c_1_tsp_a ;52
	lvc0_tsp = lvc0_tsp_a ;53
	lvc1_tsp = lvc1_tsp_a ;54
	adc0_vref = adc0_vref_a ;55
	adc1_vref = adc1_vref_a ;56
	ssd_status = ssd_status_a ;57
	ssd_v_pos_analog = ssd_v_pos_analog_a ;58
	ssd_v_neg_analog = ssd_v_neg_analog_a ;59
	ssd_hv_bias = ssd_hv_bias_a ;60
	ssd_tc0 = ssd_tc0_a ;61
	ssd_tc1 = ssd_tc1_a ;62
	ssd_tc2 = ssd_tc2_a ;63
	ssd_v_pos_dig = ssd_v_pos_dig_a ;64
   

ENDIF ELSE BEGIN 
	epoch1 = epoch1_hk_b
	lrnm_spare = lrnm_spare_b ;0
	lvc_neg12v = lvc_neg12v_b ;1
	lvc_neg5v = lvc_neg5v_b ;2
	esa_vm_pos = esa_vm_pos_b ;3
	dfl_1_vm = dfl_1_vm_b ;4
	dfl_1_tap = dfl_1_tap_b ;5
	dfl_2_vm = dfl_2_vm_b ;6
	dfl_2_tap = dfl_2_tap_b ;7
	lvc_pos2point5v_b = lvc_pos2point5v_b_b ;8
	pac_cm_dc = pac_cm_dc_b ;9
	lvc_pos12v = lvc_pos12v_b ;10
	lrpm_spare = lrpm_spare_b ;11
	lvc_pos2point5v_a = lvc_pos2point5v_a_b ;12
	lvc_pos5v = lvc_pos5v_b ;13
	adc_avdd = adc_avdd_b ;14
	adc_dvdd = adc_dvdd_b ;15
	pac_vm = pac_vm_b ;16
	cal_vref = cal_vref_b ;17
	pac_cm_ac = pac_cm_ac_b ;18
	mcp_vm = mcp_vm_b ;19
	mcp_cm_dc = mcp_cm_dc_b ;20
	mcp_cm_ac = mcp_cm_ac_b ;21
	ssd_cm_dc = ssd_cm_dc_b ;22
	s_ch_vm = s_ch_vm_b ;23
	s_ch_vm_tap = s_ch_vm_tap_b ;24
	s_ch_cm_dc = s_ch_cm_dc_b ;25
	esa_vm_neg = esa_vm_neg_b ;26
	esa_cm_dc = esa_cm_dc_b ;27
	dfl_1_cm_dc = dfl_1_cm_dc_b ;28
	dfl_2_cm_dc = dfl_2_cm_dc_b ;29
	lvc_pos2point5v_b_imon = lvc_pos2point5v_b_imon_b ;30
	lvc_pos12v_imon = lvc_pos12v_imon_b ;31
	lvc_neg12v_imon = lvc_neg12v_imon_b ;32
	lvc_pos5v_imon = lvc_pos5v_imon_b ;33
	lvc_neg5v_imon = lvc_neg5v_imon_b ;34
	lvc_pos2point5v_a_imon = lvc_pos2point5v_a_imon_b ;35
	ssd_vm = ssd_vm_b ;36
	adc_lu_flag = adc_lu_flag_b ;37
	plug_id = plug_id_b ;38
	adc_lu_ctr = adc_lu_ctr_b ;39
	dac_status = dac_status_b ;40
	adc0_agnd = adc0_agnd_b ;41
	adc1_agnd = adc1_agnd_b ;42
	ra_e0 = ra_e0_b ;43
	ra_e1 = ra_e1_b ;44
	tac0_tsp = tac0_tsp_b ;45
	tac2_tsp = tac2_tsp_b ;46
	sb0_tsp = sb0_tsp_b ;47
	sb1_tsp = sb1_tsp_b ;48
	tof_hv0_tsp = tof_hv0_tsp_b ;49
	tof_hv1_tsp = tof_hv1_tsp_b ;50
	s_c_0_tsp = s_c_0_tsp_b ;51
	s_c_1_tsp = s_c_1_tsp_b ;52
	lvc0_tsp = lvc0_tsp_b ;53
	lvc1_tsp = lvc1_tsp_b ;54
	adc0_vref = adc0_vref_b ;55
	adc1_vref = adc1_vref_b ;56
	ssd_status = ssd_status_b ;57
	ssd_v_pos_analog = ssd_v_pos_analog_b ;58
	ssd_v_neg_analog = ssd_v_neg_analog_b ;59
	ssd_hv_bias = ssd_hv_bias_b ;60
	ssd_tc0 = ssd_tc0_b ;61
	ssd_tc1 = ssd_tc1_b ;62
	ssd_tc2 = ssd_tc2_b ;63
	ssd_v_pos_dig = ssd_v_pos_dig_b ;64
     
ENDELSE 

labels = ' '
satstr = 'ST' + sat + '_'

empty = fltarr(n_elements(epoch1)) ; empty set for overplotting color on black axis
empty(*) = !values.f_nan

store_data, 'empty',data={x:epoch1,y:empty},dlim = {ylog:0, labels:labels, panel_size:2.}

FOR i=0, n_elements(prod_hk)-1 DO BEGIN
	CASE prod_hk(i) OF
		'lrnm_spare':	store_data, satstr + 'Analog_HK_lrnm_spare', data = {x:epoch1, y:lrnm_spare}, dlim = {ytitle:satstr + 'Analog!C!CHK_lrnm_spare', ylog:0, labels:labels, panel_size:2.} ;0
		'lvc_-12v':	store_data, satstr + 'Analog_HK_lvc_-12v', data = {ytitle:satstr + 'Analog_HK!C!Clvc_-12v', x:epoch1, y:lvc_neg12v}, dlim = {ylog:0, labels:labels, panel_size:2.} ;1
		'lvc_-5v':	store_data, satstr + 'Analog_HK_lvc_-5v', data = {ytitle:satstr + 'Analog_HK!C!Clvc_-5v', x:epoch1, y:lvc_neg5v}, dlim = {ylog:0, labels:labels, panel_size:2.} ;2
		'esa_vm_pos':	store_data, satstr + 'Analog_HK_esa_vm_pos', data = {ytitle:satstr + 'Analog_HK!C!Cesa_vm_pos', x:epoch1, y:esa_vm_pos}, dlim = {ylog:0, labels:labels, panel_size:2.} ;3
		'dfl_1_vm':	store_data, satstr + 'Analog_HK_dfl_1_vm', data = {ytitle:satstr + 'Analog_HK!C!Cdfl_1_vm', x:epoch1, y:dfl_1_vm}, dlim = {ylog:0, labels:labels, panel_size:2.} ;4
		'dfl_1_tap':	store_data, satstr + 'Analog_HK_dfl_1_tap', data = {ytitle:satstr + 'Analog_HK!C!Cdfl_1_tap', x:epoch1, y:dfl_1_tap}, dlim = {ylog:0, labels:labels, panel_size:2.} ;5
		'dfl_2_vm':	store_data, satstr + 'Analog_HK_dfl_2_vm', data = {ytitle:satstr + 'Analog_HK!C!Cdfl_2_vm', x:epoch1, y:dfl_2_vm}, dlim = {ylog:0, labels:labels, panel_size:2.} ;6
		'dfl_2_tap':	store_data, satstr + 'Analog_HK_dfl_2_tap', data = {ytitle:satstr + 'Analog_HK!C!Cdfl_2_tap', x:epoch1, y:dfl_2_tap}, dlim = {ylog:0, labels:labels, panel_size:2.} ;7
		'lvc_+2.5v_b':	store_data, satstr + 'Analog_HK_lvc_+2.5v_b', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+2.5v_b', x:epoch1, y:lvc_pos2point5v_b}, dlim = {ylog:0, labels:labels, panel_size:2.} ;8
		'pac_cm_dc':	store_data, satstr + 'Analog_HK_pac_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cpac_cm_dc', x:epoch1, y:pac_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;9
		'lvc_+12v':	store_data, satstr + 'Analog_HK_lvc_+12v', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+12v', x:epoch1, y:lvc_pos12v}, dlim = {ylog:0, labels:labels, panel_size:2.} ;10
		'lrpm_spare':	store_data, satstr + 'Analog_HK_lrpm_spare', data = {ytitle:satstr + 'Analog_HK!C!Clrpm_spare', x:epoch1, y:lrpm_spare}, dlim = {ylog:0, labels:labels, panel_size:2.} ;11
		'lvc_+2.5v_a':	store_data, satstr + 'Analog_HK_lvc_+2.5v_a', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+2.5v_a', x:epoch1, y:lvc_pos2point5v_a}, dlim = {ylog:0, labels:labels, panel_size:2.} ;12
		'lvc_+5v':	store_data, satstr + 'Analog_HK_lvc_+5v', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+5v', x:epoch1, y:lvc_pos5v}, dlim = {ylog:0, labels:labels, panel_size:2.} ;13
		'adc_avdd':	store_data, satstr + 'Analog_HK_adc_avdd', data = {ytitle:satstr + 'Analog_HK!C!Cadc_avdd', x:epoch1, y:adc_avdd}, dlim = {ylog:0, labels:labels, panel_size:2.} ;14
		'adc_dvdd':	store_data, satstr + 'Analog_HK_adc_dvdd', data = {ytitle:satstr + 'Analog_HK!C!Cadc_dvdd', x:epoch1, y:adc_dvdd}, dlim = {ylog:0, labels:labels, panel_size:2.} ;15
		'pac_vm':	store_data, satstr + 'Analog_HK_pac_vm', data = {ytitle:satstr + 'Analog_HK!C!Cpac_vm', x:epoch1, y:pac_vm}, dlim = {ylog:0, labels:labels, panel_size:2.} ;16
		'cal_vref':	store_data, satstr + 'Analog_HK_cal_vref', data = {ytitle:satstr + 'Analog_HK!C!Ccal_vref', x:epoch1, y:cal_vref}, dlim = {ylog:0, labels:labels, panel_size:2.} ;17
		'pac_cm_ac':	store_data, satstr + 'Analog_HK_pac_cm_ac', data = {ytitle:satstr + 'Analog_HK!C!Cpac_cm_ac', x:epoch1, y:pac_cm_ac}, dlim = {ylog:0, labels:labels, panel_size:2.} ;18
		'mcp_vm':	store_data, satstr + 'Analog_HK_mcp_vm', data = {ytitle:satstr + 'Analog_HK!C!Cmcp_vm', x:epoch1, y:mcp_vm}, dlim = {ylog:0, labels:labels, panel_size:2.} ;19
		'mcp_cm_dc':	store_data, satstr + 'Analog_HK_mcp_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cmcp_cm_dc', x:epoch1, y:mcp_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;20
		'mcp_cm_ac':	store_data, satstr + 'Analog_HK_mcp_cm_ac', data = {ytitle:satstr + 'Analog_HK!C!Cmcp_cm_ac', x:epoch1, y:mcp_cm_ac}, dlim = {ylog:0, labels:labels, panel_size:2.} ;21
		'ssd_cm_dc':	store_data, satstr + 'Analog_HK_ssd_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cssd_cm_dc', x:epoch1, y:ssd_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;22
		's_ch_vm':	store_data, satstr + 'Analog_HK_s_ch_vm', data = {ytitle:satstr + 'Analog_HK!C!Cs_ch_vm', x:epoch1, y:s_ch_vm}, dlim = {ylog:0, labels:labels, panel_size:2.} ;23
		's_ch_vm_tap':	store_data, satstr + 'Analog_HK_s_ch_vm_tap', data = {ytitle:satstr + 'Analog_HK!C!Cs_ch_vm_tap', x:epoch1, y:s_ch_vm_tap}, dlim = {ylog:0, labels:labels, panel_size:2.} ;24
		's_ch_cm_dc':	store_data, satstr + 'Analog_HK_s_ch_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cs_ch_cm_dc', x:epoch1, y:s_ch_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;25
		'esa_vm_neg':	store_data, satstr + 'Analog_HK_esa_vm_neg', data = {ytitle:satstr + 'Analog_HK!C!Cesa_vm_neg', x:epoch1, y:esa_vm_neg}, dlim = {ylog:0, labels:labels, panel_size:2.} ;26
		'esa_cm_dc':	store_data, satstr + 'Analog_HK_esa_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cesa_cm_dc', x:epoch1, y:esa_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;27
		'dfl_1_cm_dc':	store_data, satstr + 'Analog_HK_dfl_1_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cdfl_1_cm_dc', x:epoch1, y:dfl_1_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;28
		'dfl_2_cm_dc':	store_data, satstr + 'Analog_HK_dfl_2_cm_dc', data = {ytitle:satstr + 'Analog_HK!C!Cdfl_2_cm_dc', x:epoch1, y:dfl_2_cm_dc}, dlim = {ylog:0, labels:labels, panel_size:2.} ;29
		'lvc_+2.5v_b_imon':	store_data, satstr + 'Analog_HK_lvc_+2.5v_b_imon', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+2.5v_b_imon', x:epoch1, y:lvc_pos2point5v_b_imon}, dlim = {ylog:0, labels:labels, panel_size:2.} ;30
		'lvc_+12v_imon':	store_data, satstr + 'Analog_HK_lvc_+12v_imon', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+12v_imon', x:epoch1, y:lvc_pos12v_imon}, dlim = {ylog:0, labels:labels, panel_size:2.} ;31
		'lvc_-12v_imon':	store_data, satstr + 'Analog_HK_lvc_-12v_imon', data = {ytitle:satstr + 'Analog_HK!C!Clvc_-12v_imon', x:epoch1, y:lvc_neg12v_imon}, dlim = {ylog:0, labels:labels, panel_size:2.} ;32
		'lvc_+5v_imon':	store_data, satstr + 'Analog_HK_lvc_+5v_imon', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+5v_imon', x:epoch1, y:lvc_pos5v_imon}, dlim = {ylog:0, labels:labels, panel_size:2.} ;33
		'lvc_-5v_imon':	store_data, satstr + 'Analog_HK_lvc_-5v_imon', data = {ytitle:satstr + 'Analog_HK!C!Clvc_-5v_imon', x:epoch1, y:lvc_neg5v_imon}, dlim = {ylog:0, labels:labels, panel_size:2.} ;34
		'lvc_+2.5v_a_imon':	store_data, satstr + 'Analog_HK_lvc_+2.5v_a_imon', data = {ytitle:satstr + 'Analog_HK!C!Clvc_+2.5v_a_imon', x:epoch1, y:lvc_pos2point5v_a_imon}, dlim = {ylog:0, labels:labels, panel_size:2.} ;35
		'ssd_vm':	store_data, satstr + 'Analog_HK_ssd_vm', data = {ytitle:satstr + 'Analog_HK!C!Cssd_vm', x:epoch1, y:ssd_vm}, dlim = {ylog:0, labels:labels, panel_size:2.} ;36
		'adc_lu_flag':	store_data, satstr + 'Analog_HK_adc_lu_flag', data = {ytitle:satstr + 'Analog_HK!C!Cadc_lu_flag', x:epoch1, y:adc_lu_flag}, dlim = {ylog:0, labels:labels, panel_size:2.} ;37
		'plug_id':	store_data, satstr + 'Analog_HK_plug_id', data = {ytitle:satstr + 'Analog_HK!C!Cplug_id', x:epoch1, y:plug_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ;38
		'adc_lu_ctr':	store_data, satstr + 'Analog_HK_adc_lu_ctr', data = {ytitle:satstr + 'Analog_HK!C!Cadc_lu_ctr', x:epoch1, y:adc_lu_ctr}, dlim = {ylog:0, labels:labels, panel_size:2.} ;39
		'dac_status':	store_data, satstr + 'Analog_HK_dac_status', data = {ytitle:satstr + 'Analog_HK!C!Cdac_status', x:epoch1, y:dac_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ;40
		'adc0_agnd':	store_data, satstr + 'Analog_HK_adc0_agnd', data = {ytitle:satstr + 'Analog_HK!C!Cadc0_agnd', x:epoch1, y:adc0_agnd}, dlim = {ylog:0, labels:labels, panel_size:2.} ;41
		'adc1_agnd':	store_data, satstr + 'Analog_HK_adc1_agnd', data = {ytitle:satstr + 'Analog_HK!C!Cadc1_agnd', x:epoch1, y:adc1_agnd}, dlim = {ylog:0, labels:labels, panel_size:2.} ;42
		'ra_e0':	store_data, satstr + 'Analog_HK_ra_e0', data = {ytitle:satstr + 'Analog_HK!C!Cra_e0', x:epoch1, y:ra_e0}, dlim = {ylog:0, labels:labels, panel_size:2.} ;43
		'ra_e1':	store_data, satstr + 'Analog_HK_ra_e1', data = {ytitle:satstr + 'Analog_HK!C!Cra_e1', x:epoch1, y:ra_e1}, dlim = {ylog:0, labels:labels, panel_size:2.} ;44
		'tac0_tsp':	store_data, satstr + 'Analog_HK_tac0_tsp', data = {ytitle:satstr + 'Analog_HK!C!Ctac0_tsp', x:epoch1, y:tac0_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;45
		'tac2_tsp':	store_data, satstr + 'Analog_HK_tac2_tsp', data = {ytitle:satstr + 'Analog_HK!C!Ctac2_tsp', x:epoch1, y:tac2_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;46
		'sb0_tsp':	store_data, satstr + 'Analog_HK_sb0_tsp', data = {ytitle:satstr + 'Analog_HK!C!Csb0_tsp', x:epoch1, y:sb0_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;47
		'sb1_tsp':	store_data, satstr + 'Analog_HK_sb1_tsp', data = {ytitle:satstr + 'Analog_HK!C!Csb1_tsp', x:epoch1, y:sb1_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;48
		'tof_hv0_tsp':	store_data, satstr + 'Analog_HK_tof_hv0_tsp', data = {ytitle:satstr + 'Analog_HK!C!Ctof_hv0_tsp', x:epoch1, y:tof_hv0_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;49
		'tof_hv1_tsp':	store_data, satstr + 'Analog_HK_tof_hv1_tsp', data = {ytitle:satstr + 'Analog_HK!C!Ctof_hv1_tsp', x:epoch1, y:tof_hv1_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;50
		's_c_0_tsp':	store_data, satstr + 'Analog_HK_s_c_0_tsp', data = {ytitle:satstr + 'Analog_HK!C!Cs_c_0_tsp', x:epoch1, y:s_c_0_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;51
		's_c_1_tsp':	store_data, satstr + 'Analog_HK_s_c_1_tsp', data = {ytitle:satstr + 'Analog_HK!C!Cs_c_1_tsp', x:epoch1, y:s_c_1_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;52
		'lvc0_tsp':	store_data, satstr + 'Analog_HK_lvc0_tsp', data = {ytitle:satstr + 'Analog_HK!C!Clvc0_tsp', x:epoch1, y:lvc0_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;53
		'lvc1_tsp':	store_data, satstr + 'Analog_HK_lvc1_tsp', data = {ytitle:satstr + 'Analog_HK!C!Clvc1_tsp', x:epoch1, y:lvc1_tsp}, dlim = {ylog:0, labels:labels, panel_size:2.} ;54
		'adc0_vref':	store_data, satstr + 'Analog_HK_adc0_vref', data = {ytitle:satstr + 'Analog_HK!C!Cadc0_vref', x:epoch1, y:adc0_vref}, dlim = {ylog:0, labels:labels, panel_size:2.} ;55
		'adc1_vref':	store_data, satstr + 'Analog_HK_adc1_vref', data = {ytitle:satstr + 'Analog_HK!C!Cadc1_vref', x:epoch1, y:adc1_vref}, dlim = {ylog:0, labels:labels, panel_size:2.} ;56
		'ssd_status':	store_data, satstr + 'Analog_HK_ssd_status', data = {ytitle:satstr + 'Analog_HK!C!Cstatus', x:epoch1, y:ssd_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ;57
		'ssd_v_pos_analog':	store_data, satstr + 'Analog_HK_ssd_v_pos_analog', data = {ytitle:satstr + 'Analog_HK!C!Cssd_v_pos_analog', x:epoch1, y:ssd_v_pos_analog}, dlim = {ylog:0, labels:labels, panel_size:2.} ;58
		'ssd_v_neg_analog':	store_data, satstr + 'Analog_HK_ssd_v_neg_analog', data = {ytitle:satstr + 'Analog_HK!C!Cssd_v_neg_analog', x:epoch1, y:ssd_v_neg_analog}, dlim = {ylog:0, labels:labels, panel_size:2.} ;59
		'ssd_hv_bias':	store_data, satstr + 'Analog_HK_ssd_hv_bias', data = {ytitle:satstr + 'Analo_HKg!C!Cssd_hv_bias', x:epoch1, y:ssd_hv_bias}, dlim = {ylog:0, labels:labels, panel_size:2.} ;60
		'ssd_tc0':	store_data, satstr + 'Analog_HK_ssd_tc0', data = {ytitle:satstr + 'Analog_HK!C!Cssd_tc0', x:epoch1, y:ssd_tc0}, dlim = {ylog:0, labels:labels, panel_size:2.} ;61
		'ssd_tc1':	store_data, satstr + 'Analog_HK_ssd_tc1', data = {ytitle:satstr + 'Analog_HK!C!Cssd_tc1', x:epoch1, y:ssd_tc1}, dlim = {ylog:0, labels:labels, panel_size:2.} ;62
		'ssd_tc2':	store_data, satstr + 'Analog_HK_ssd_tc2', data = {ytitle:satstr + 'Analog_HK!C!Cssd_tc2', x:epoch1, y:ssd_tc2}, dlim = {ylog:0, labels:labels, panel_size:2.} ;63
		'ssd_v_pos_dig':	store_data, satstr + 'Analog_HK_ssd_v_pos_dig', data = {ytitle:satstr + 'Analog_HK!C!C', x:epoch1, y:ssd_v_pos_dig}, dlim = {ylog:0, labels:labels, panel_size:2.} ;64
	ENDCASE
ENDFOR


END 
