;+
; PROCEDURE: get_pla_pos_spec
;
; PURPOSE:
;
; INPUT:
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;   05-14-2007: CM
;               Even if the energy range for a particular time step does not
;               have data, all time steps are checked instead of
;               exiting. The time steps with no data in the energy
;               range are filled with NaN
;
;-
PRO get_pla_pos_spec, sat, prod, class, units, energy, phi, diagn = diagn


COMMON get_error, get_err_no, get_err_msg, default_verbose


dat = get_pla_data(sat, prod, class)
IF get_err_no NE 0 THEN RETURN

;------------------------------------------------------------------
; Convert Units
;------------------------------------------------------------------
IF units NE 'Counts' THEN BEGIN
    dat = convert_pla_units(dat, units)
ENDIF
;------------------------------------------------------------------

ytitle = 'ST' + STRUPCASE(sat) +'/PLA' + '!C!C'

IF dat.units_name EQ 'Counts' THEN norm = 1. ELSE norm =  dat.nposition * dat.ndeflection

; The enegry range is the actual energy range
get_pla_energies, sat, esa_step
esa_step =  esa_step * 1e3
ien = WHERE(esa_step GE energy(0) AND esa_step LE energy(1), cien)
IF cien GT 0 THEN BEGIN
    elow  = esa_step(ien(cien-1)) * (1.0-0.0489)
    ehigh = esa_step(ien(0)) * (1.0+0.0489)
    erangestr = STRING(elow,  FORMAT = '(i5.5)') + '_' + STRING(ehigh,  FORMAT = '(i5.5)')
ENDIF ELSE BEGIN
    erangestr = '*****'
ENDELSE

prodname = 'ST' + sat + '_PLA_POSSPEC_' + erangestr + '_' + STRUPCASE(units) + '_' + STRUPCASE(prod)

IF prod EQ 'h_alpha' OR $
  prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR $
  prod EQ 'he++tcr' THEN BEGIN
    
    zdata = FLTARR(N_ELEMENTS(dat.time), dat.nposition)
    
    FOR ii = 0, N_ELEMENTS(dat.time)-1 DO BEGIN
        
        en = REFORM(dat.energy(ii, *))*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN
            
            IF cien EQ 1 THEN BEGIN
                zdata(ii, *) = REFORM(TOTAL(dat.data(ii, *, *, ien), 2, /NaN))
            ENDIF ELSE BEGIN
                zdata(ii, *) = REFORM(TOTAL(TOTAL(dat.data(ii, *, *, ien), 2, /NaN), 3, /NaN))
            ENDELSE
            
        ENDIF ELSE BEGIN

            err_msg,  'Energy range not available'
            zdata(ii, *) = !values.F_NAN
            ;RETURN
            
        ENDELSE
        
    ENDFOR
    
    ytitle =  ytitle + prod

ENDIF

IF prod EQ 'sw_z>2_h' THEN BEGIN
    
    zdata = FLTARR(N_ELEMENTS(dat.time), dat.nposition)
    FOR ii = 0, N_ELEMENTS(dat.time)-1 DO BEGIN

        en = REFORM(dat.energy(ii, *))*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN
            IF cien EQ 1 THEN BEGIN
                zdata(ii, *) = REFORM(TOTAL(dat.data(ii, *, *, ien), 2, /NaN))
            ENDIF ELSE BEGIN
                zdata(ii, *) = REFORM(TOTAL(TOTAL(dat.data(ii, *, *, ien), 2, /NaN), 3, /NaN))
            ENDELSE
            
        ENDIF ELSE BEGIN
            
            err_msg,  'Energy range not available'
            zdata(ii, *) = !values.F_NAN
            ;RETURN
            
        ENDELSE
        
    ENDFOR
    
    ytitle =  ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
    prodname = 'pla_' + sat + '_enspec_' + prod + '_cl' + STRING(class, FORMAT = '(i2.2)')
    
ENDIF

IF prod EQ 'sw_z>2_l' THEN BEGIN
    
    zdata = FLTARR(N_ELEMENTS(dat.time), dat.nposition)
    FOR ii = 0, N_ELEMENTS(dat.time)-1 DO BEGIN

        en = REFORM(dat.energy(ii, *))*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN
            IF cien EQ 1 THEN BEGIN
                zdata(ii, *) = REFORM(dat.data(ii, *, ien))
            ENDIF ELSE BEGIN
                zdata(ii, *) = REFORM(TOTAL(dat.data(ii, *, ien), 3, /NaN))
            ENDELSE
            
        ENDIF ELSE BEGIN
            
            err_msg,  'Energy range not available'
            zdata(ii, *) = !values.F_NAN
            ;RETURN
            
        ENDELSE
        
    ENDFOR
    
    ytitle =  ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
    prodname = 'pla_' + sat + '_enspec_' +  prod + '_cl' + STRING(class, FORMAT = '(i2.2)')
    
ENDIF

IF prod EQ 'wap_ssd_tcr' OR prod EQ 'wap_ssd_dcr' OR prod EQ 'wap_no_ssd_dcr' THEN BEGIN
    
    zdata = FLTARR(N_ELEMENTS(dat.time), dat.nposition)
    FOR ii = 0, N_ELEMENTS(dat.time)-1 DO BEGIN

        en = REFORM(dat.energy(ii, *))*1.e3
        ien = WHERE(en GE energy(0) AND en LE energy(1), cien)
        IF cien GT 0 THEN BEGIN
            IF cien EQ 1 THEN BEGIN
                zdata(ii, *) = REFORM(dat.data(ii, *, ien))
            ENDIF ELSE BEGIN
                zdata(ii, *) = REFORM(TOTAL(dat.data(ii, *, ien), 3, /NaN))
            ENDELSE
            
        ENDIF ELSE BEGIN
            
            err_msg,  'Energy range not available'
            zdata(ii, *) = !values.F_NAN
            ;RETURN
            
        ENDELSE
        
    ENDFOR
    
    ytitle =  ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
    prodname = 'pla_' + sat + '_enspec_' +  prod + '_cl' + STRING(class, FORMAT = '(i2.2)')
    
ENDIF

;------------------------------------------------------------------
; Save spectra in tplot variables
;------------------------------------------------------------------
erangestr = STRING(elow/1e3,  FORMAT = '(f5.2)') + '-' + STRING(ehigh/1e3,  FORMAT = '(f5.2)')
ytitle1 = ytitle + '!C!C' + erangestr + ' (keV)!C!CPos. Angle (deg)'
ztitle = STRUPCASE(dat.units_name)


store_data, prodname, data = {x:REFORM(dat.time), y:zdata, v:dat.position}, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:0, $
                    zlog:1, $
                    zrange:[0.1, 1000], $
                    ytitle:ytitle1, $
                    ztitle:ztitle $
                   }

IF KEYWORD_SET(diagn) THEN BEGIN
    
    ;IF prod EQ 'h_alpha' OR $
    ;  prod EQ 'h+peak' OR $
    ;  prod EQ 'he++peak' OR $
    ;  prod EQ 'he++tcr' THEN BEGIN
    
    ytitle2 =  ytitle + '!C!C S-Channel (keV)'
    store_data, prodname+'_s_chan', data = {x:REFORM(dat.time), y:dat.s_chan}, $
                dlim = {panel_size:1, $
                        ylog:1, $
                        yrange:[0.1, 10], $
                        ytitle:ytitle2}
    
    avg_phi =  TOTAL((zdata * dat.position), 2) / TOTAL(zdata, 2)
    ytitle3 =  ytitle + '!C!C' + erangestr + ' (keV)!C!CAvg. Pos. Angle (deg)'
    store_data, prodname+'_av_phi', data = {x:REFORM(dat.time), y:avg_phi}, $
                dlim = {panel_size:1, $
                        ylog:0, $
                        yrange:[-25,  25], $
                        ytitle:ytitle3}
    
        
    ;ENDIF
    
ENDIF


END
