;+
; PROCEDURE:     get_pla_phi_angles, sat, prod, phi_step
;
; PURPOSE:   Get STEREO/PLASTIC position angles
;
; INPUT:  sat: S/C id - 'A' or 'B'
;         prod: the product string
;
; OUTPUT: phi_step: position angle values
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:  
;
; MODIFICATION HISTORY:
;
;-
PRO get_pla_phi_angles, sat, prod, phi_step
  
phi_step = 0.

IF prod EQ 'h_alpha' OR $
  prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR $
  prod EQ 'he++tcr' THEN BEGIN
    
    phi_step = [-19.6875, -14.0625, -8.43750, -2.81250, 2.81250, 8.43750, 14.0625, 19.6875]
                                       
ENDIF
  
IF prod EQ 'wap_ssd_tcr'  OR prod EQ 'wap_ssd_dcr' THEN BEGIN

    ;phi_step = [-33.750, 33.75, 56.25, 78.75]
    phi_step = [0, 1, 2, 3]
ENDIF
  
IF prod EQ 'wap_no_ssd_dcr' THEN BEGIN

    phi_step = [146.25, 168.75, 191.25, 213.75, 236.25, 258.75, 281.25, 303.75]

ENDIF
  
  
END
