;+
; PROCEDURE: get_pla_en_spec
;
; PURPOSE: to get the product related data and create the
;          corresponding  tplot variable
;
; INPUT: sat   - S/C id - 'A' or 'B'
;        prod  - product
;        class - classification
;        units - units
;
; KEYWORDS: diagn - if set extra diagnostic tplot variables are created
;
; OUTPUT: the output is provided via the tplot variables.
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;
;-
PRO get_pla_en_spec, sat, prod, class, units, diagn=diagn
  
  
COMMON get_error, get_err_no, get_err_msg, default_verbose

@tplot_com

dat = get_pla_data(sat, prod, class)
IF get_err_no NE 0 THEN RETURN

;------------------------------------------------------------------
; Convert Units
;------------------------------------------------------------------
IF STRUPCASE(units) NE 'COUNTS' THEN BEGIN
    dat = convert_plastic_units(dat, units)
ENDIF
;------------------------------------------------------------------
  
ytitle = 'ST' + STRUPCASE(sat) +'/PLA' + '!C!C'

; !!!! Be carefull: NaN data when totaled give zero.
    
IF dat.units_name EQ 'Counts' THEN norm = 1. ELSE norm =  dat.nposition * dat.ndeflection

prodname = 'ST' + sat + '_PLA_ENSPEC_' + STRUPCASE(units) + '_' + STRUPCASE(prod)
IF prod EQ 'h_alpha' OR $
  prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR $
  prod EQ 'he++tcr' THEN BEGIN

    zdata = TOTAL(TOTAL(dat.data, 2, /NaN), 2, /NaN) / norm
    ytitle = ytitle + prod

ENDIF

IF prod EQ 'sw_z>2_h' THEN BEGIN

    zdata = TOTAL(TOTAL(dat.data(*, *, *, *), 2, /NaN), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')
    
ENDIF

IF prod EQ 'sw_z>2_l' THEN BEGIN
    
    zdata = TOTAL(REFORM(dat.data(*, *, *)), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF
  
IF prod EQ 'sw_priority' THEN BEGIN

    zdata = TOTAL(REFORM(dat.data(*, *, *)), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF

IF prod EQ 'wap_ssd_tcr' OR prod EQ 'wap_ssd_dcr' OR prod EQ 'wap_no_ssd_dcr' THEN BEGIN

    zdata = TOTAL(REFORM(dat.data(*, *, *)), 2, /NaN) / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF

IF prod EQ 'wap_priority_ssd' OR prod EQ 'wap_priority_no_ssd' THEN BEGIN

    zdata = dat.data / norm
    prodname = prodname + '_' + STRING(class, FORMAT = '(i2.2)')
    ytitle = ytitle + prod + '_' + STRING(class, FORMAT = '(i2.2)')

ENDIF

IF prod EQ 'class' THEN BEGIN
    
    zdata =   TOTAL(TOTAL(dat.data, 2, /NaN), 2, /NaN) / norm
    ytitle = ytitle + prod + '!C!CEnergy (keV)'

ENDIF

;------------------------------------------------------------------
; Save spectra in tplot variables
;------------------------------------------------------------------
ytitle = ytitle + '!C!CE/q (keV/q)'
ztitle = STRUPCASE(dat.units_name)


store_data, prodname, data = {x:REFORM(dat.time), y:zdata, v:dat.energy}, $
            dlim = {panel_size:1, $
                    spec:1, $
                    x_no_interp:1, $
                    y_no_interp:1, $
                    ylog:1, $
                    zlog:1, $
                    yrange:[0.2, 100], $
                    zrange:[0.1, 1000], $
                    ytitle:ytitle, $
                    ztitle:ztitle $
                   }

tplot_var = prodname
tplot, tplot_var,  add_var = 999 ; add panel to the bottom of the plot

IF KEYWORD_SET(diagn) THEN BEGIN
    
    ;IF prod EQ 'h_alpha' OR $
    ;  prod EQ 'h+peak' OR $
    ;  prod EQ 'he++peak' OR $
    ;  prod EQ 'he++tcr' THEN BEGIN

        store_data, prodname+'_s_chan', data = {x:REFORM(dat.time), y:dat.s_chan}, $
                    dlim = {panel_size:1, $
                            ylog:1, $
                            yrange:[0.1, 10], $
                            ytitle:'S-Chan (keV)'}

    ;ENDIF
    
ENDIF


END
