;+
; FUNCTION: get_pla_data
;
; PURPOSE:to call the relevant product reading function
;
; INPPUT: sat  -  S/C id - 'A' or 'B'
;         prod - 
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;
;
FUNCTION get_pla_data, sat, prod, class

COMMON get_error, get_err_no, get_err_msg, default_verbose

CASE prod OF

    'h_alpha':             RETURN, get_pla_h1_alpha(sat)
    'h+peak':              RETURN, get_pla_h1_peak(sat)
    'he++peak':            RETURN, get_pla_he2_peak(sat)
    'he++tcr':             RETURN, get_pla_he2_tcr(sat)
    'sw_z>2_h':            RETURN, get_pla_sw_z2_h(sat, class)
    'sw_z>2_l':            RETURN, get_pla_sw_z2_l(sat, class)
    'wap_ssd_tcr':         RETURN, get_pla_wap_ssd_tcr(sat, class)
    'wap_ssd_dcr':         RETURN, get_pla_wap_ssd_dcr(sat, class)
    'wap_no_ssd_dcr':      RETURN, get_pla_wap_no_ssd_dcr(sat, class)
    'sw_priority':         RETURN, get_pla_sw_priority(sat, class)   
    'wap_priority_ssd':    RETURN, get_pla_wap_priority_ssd(sat, class)
    'wap_priority_no_ssd': RETURN, get_pla_wap_priority_no_ssd(sat, class)
    'class':               RETURN, get_class(sat)
    ELSE: BEGIN
        err_msg, 'No product found matching: ' + prod
        get_err_no =  1
    END

ENDCASE
    

RETURN, 0

END
