;+
; PROCEDURE: get_input_param
;
; PURPOSE: to extract/translate the input parameters from the input
;          string sprod
;
; INPUT:  sprod - the crib sheet input string
;
; OUTPUT: sat/prod/class three separate arrays with the sat, prod,
;         class information 
;
; CREATED BY: C. Mouikis
;
; LAST MODIFIED:
;
; MODIFICATION HISTORY:
;
;-
PRO get_input_param, sprod, sat, prod, class

COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no =  1 ; Inverse error flag. Only if the procedure exits 
                ; without encountering any problems the error flag 
                ; is set to 0

; Check input
; Identify S/C in input string
sat = STRMID(sprod, 0, 1)
isat = WHERE(sat NE 'A' AND sat NE 'B', cisat)
IF cisat GT 0 THEN BEGIN
    PRINT, 'Crib S/C DESCRIPTION IS WRONG'
    RETURN
ENDIF

; Identify product in input string
; The following possible products are assumed:

;      SOURCE ARRAY             REDUCED ARRAY
;
;  01: SW-all                 : h_alpha
;  02: SW-H(D)                : h+peak
;  03: SW-alpha(D)            : he++peak
;  04: SW-alpha(T)            : he++trc
;  05: SW Z>2                 : sw_z>2_h              class:0-1
;  06: SW Z>2                 : sw_z>2_l              class:0-12
;  07: WIDE ANGLE             : wap_ssd_tcr           class:0-14
;  08: WIDE ANGLE(D)          : wap_ssd_dcr           class:0-6
;  09: WIDE ANGLE(D)          : wap_no_ssd_dcr        class:0-6
;  10: SW PHA PRIORITY RATES  : sw_priority           class:0-3
;  11: WAP PHA PRIORITY RATES : wap_priority_ssd      class:0-1
;  12: wap_priority_no_ssd   class:0-1
;  13: class

sat = '' & prod = 0 & class = 0
FOR jj = 0, N_ELEMENTS(sprod)-1 DO BEGIN ; check every ellement of input array
    
    IF STRLEN(sprod(jj)) GT 3 THEN BEGIN ; Class. Case
        
        fsl = STRPOS(sprod(jj), '/')
        IF fsl EQ -1 THEN BEGIN
            err_msg, 'WRONG DESCRIPTION OF INPUT STRING: ' + sprod(jj)
            RETURN
        ENDIF

        satid = STRMID(sprod(jj), 0, 1)
        prodid = FIX(STRMID(sprod(jj), 1, fsl-1))
        IF prodid GT 13 OR prodid LT 1 THEN BEGIN
            err_msg, 'WRONG DESCRIPTION OF INPUT STRING: ' + sprod(jj)
            RETURN
        ENDIF
        
        clastr = STRMID(sprod(jj), fsl+1, STRLEN(sprod(jj))-fsl-1) ; Classification string
        
        commaflag = 1
        WHILE commaflag EQ 1 DO BEGIN ; Separate commas / dashes
            
            fcom = STRPOS(clastr, ',')
            IF fcom NE -1 THEN BEGIN
                class1 = STRMID(clastr, 0, fcom) ; new string up to comma
                clastr = STRMID(clastr, fcom+1, STRLEN(clastr)-fcom-1)
            ENDIF ELSE BEGIN
                class1 = clastr
                commaflag = 0
            ENDELSE
            
            fdas = STRPOS(class1, '-')
            IF fdas NE -1 THEN BEGIN
                class2 = FIX(STRMID(class1, 0, fdas))
                class3 = FIX(STRMID(class1, fdas+1, STRLEN(class1)-fdas-1))
                
                IF class2 EQ class3 THEN BEGIN
                    sat   = [sat,   satid]
                    prod  = [prod,  prodid]
                    class = [class, class2]
                ENDIF ELSE BEGIN
                    
                    IF class2 GT class3 THEN BEGIN
                        tmpclass = class3
                        class3 = class2
                        class2 = tmpclass
                    ENDIF
                    FOR icl = class2, class3 DO BEGIN 
                        sat   = [sat, satid]
                        prod  = [prod, prodid]
                        class = [class, icl]
                    ENDFOR
                    
                ENDELSE
                
            ENDIF ELSE BEGIN
                sat   = [sat, satid]
                prod  = [prod, prodid]
                class = [class, FIX(class1)]
            ENDELSE
            
        ENDWHILE                ; Separate commas / dashes
        
    ENDIF ELSE BEGIN            ; No class. case
        
        satid = STRMID(sprod(jj), 0, 1)
        prodid  = FIX(STRMID(sprod(jj), 1, STRLEN(sprod(jj))-1))
        IF prodid GT 13 OR prodid LT 1 THEN BEGIN
            err_msg, 'WRONG DESCRIPTION OF INPUT STRING: ' + sprod(jj)
            RETURN
        ENDIF
        sat   = [sat, satid]
        prod  = [prod, prodid]
        class = [class, 0]
        
    ENDELSE
    
ENDFOR

sat   = sat(1:*)
prod  = prod(1:*)
class = class(1:*) > 0

get_err_no =  0

END
