#**********************************************************************
#PATHS TO SPLAT SOFTWARE
#**********************************************************************

setenv SOFT $HOME                                                   # <-- edit

#path to splat directory
#-------------------------
setenv SPLAT $SOFT/splat/splat_v1.0

#path to splat_user directory
#-------------------------
setenv SPLAT_USER $SOFT/splat/splat_user

#update idl path (assumes that idl_path is already set)
#------------------------------------------------------
setenv IDL_PATH $IDL_PATH':'+$SPLAT':'+$SPLAT_USER':'

#**********************************************************************
#PATHS TO DATA
#**********************************************************************

#path to level1 data
#-------------------
setenv STA_PLA_L1DATA $HOME/data/plastic/Spacecraft_A/Level1/CDFs   # <-- edit
setenv STB_PLA_L1DATA $HOME/data/plastic/Spacecraft_B/Level1/CDFs   # <-- edit

#**********************************************************************
#PATH TO CALIBRATION FILES
#**********************************************************************
setenv PLACAL $SOFT/splat/cal_data

#**********************************************************************
#AUX PATHS
#**********************************************************************

#path to temporary directory
#---------------------------
setenv SPLAT_TEMP $SPLAT_USER/tmp

#set output directory for plots
#----------------------------------------------
setenv OUT_DIR $SPLAT_USER/Plots

#splat error log file
#--------------------
setenv ERROR_LOG 'OFF'

#splat color table
#--------------------
setenv IDL_CT_FILE $SPLAT/splat_util/papco.tbl

#start idl executing splat_startup
#*******************************
setenv IDL_STARTUP splat_startup
