;+
; PROCEDURE: def_mom_ab_comparison
;
; PURPOSE: To create daily plots that show deflection spectra and
;          on-board moments from 'A' and 'B'
;
; INPUT: Adjust the start_time and end_time
;
; CREATED BY: C. Mouikis
;
; MODIFICATION HISTORY:
;
;-
PRO def_mom_ab_comparison

start_time = '2007-01-21/00:00:00'
end_time   = '2007-02-27/00:00:00'

ts = time_struct(start_time)
te = time_struct(end_time)

nofdays = te.daynum - ts.daynum

ts = time_double(start_time)
FOR ii = 0, nofdays-1 DO BEGIN


    timespan, ts, 1, /DAYS      ; SECONDS, MINUTES, HOURS, DAYS (DEFAULT)

    prod = ['A10/0-1', 'B10/0-1']
    units = 'Counts'            ; 'Counts', 'NCOUNTS', 'RATE', 'NRATE',
                                ; 'DIFF FLUX', 'EFLUX'
    ps = 0
    energy = [100, 99000]       ; eV
    theta = [-90, 90]
    
    pla_plot_def_spec, prod, units, energy, theta, $
                       diagn = 1
    
    
    sat_moment = ['A_D', 'B_D']
    set_com
    set_com_mom
    pl_plot_obmom_from_crib, sat_moment, PS, /INST_COORD
    
    
    p1a = 'STA_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL00'
    p2a = 'STA_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL00_av_theta'
    p3a = 'STA_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL01'
    p4a = 'STA_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL01_av_theta'
    p5a = 'A_mom_density'
    p6a = 'A_mom_velocity_inst_xyz'
    
    p1b = 'STB_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL00'
    p2b = 'STB_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL00_av_theta'
    p3b = 'STB_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL01'
    p4b = 'STB_PLA_DEFSPEC_00100_99000_COUNTS_SW_PRIORITY_CL01_av_theta'
    p5b = 'B_mom_density'
    p6b = 'B_mom_velocity_inst_xyz'
    
    options, '*', 'panel_size', 2
    options, p5a, 'ytitle', 'STA!CH!U+!N!C n (cm!U-3!N)+!C'
    options, p5b, 'ytitle', 'STB!CH!U+!N!C n (cm!U-3!N)+!C'
    options, p6a, 'ytitle', 'STA!CH!U+!N!C V (km s!U-1!N)+!CInstr. Coord'
    options, p6b, 'ytitle', 'STB!CH!U+!N!C V (km s!U-1!N)+!CInstr. Coord'
    options, [p2a, p4a, p2b, p4b],  'thick', 2
    
    options, p1a, 'ytitle', 'STA/PLA!C!CSW_Prior-00!C!CDefl (deg)'
    options, p3a, 'ytitle', 'STA/PLA!C!CSW_Prior-01!C!CDefl (deg)'
    options, p1b, 'ytitle', 'STB/PLA!C!CSW_Prior-00!C!CDefl (deg)'
    options, p3b, 'ytitle', 'STB/PLA!C!CSW_Prior-01!C!CDefl (deg)'

    ylim, p6a, -100, 500,  0
    ylim, p6b, -100, 500,  0
    
    ylim, p5a, 0.01, 3e1,  1
    ylim, p5b, 0.01, 3e1,  1
    
    ylim, [p1a, p3a, p1b, p3b], -25, 25, 0

    tplot,  [p1a, p3a, p5a, p6a, p1b, p3b, p5b, p6b]
    
    tplot_panel, v = p1a, o = p2a
    tplot_panel, v = p3a, o = p4a
    tplot_panel, v = p1b, o = p2b
    tplot_panel, v = p3b, o = p4b

    yline, '*'

    yr = STRMID(time_string(ts), 0, 4)
    mo = STRMID(time_string(ts), 5, 2)
    da = STRMID(time_string(ts), 8, 2)
    ofn = 'PLA_page1_' + yr + mo + da 
    popen, ofn
    tplot,  [p1a, p3a, p5a, p6a, p1b, p3b, p5b, p6b]
    
    tplot_panel, v = p1a, o = p2a
    tplot_panel, v = p3a, o = p4a
    tplot_panel, v = p1b, o = p2b
    tplot_panel, v = p3b, o = p4b

    yline, '*'
    pclose

    ts = ts + 86400.

    tplot_names, '*', names = names
    store_data, names, /DEL

ENDFOR

END
