#!/bin/csh
#
# This script will grab these:
#	ftp://igpp.ucla.edu/pub/stereo/offset/offset_A_r0.dat
#	ftp://igpp.ucla.edu/pub/stereo/offset/offset_B_r0.dat
# two files and compare them to the copies in:
#x	/disks/stereodata/stereo_public/ssw_impact/calibration
# if new versions are detected an email will be sent to Peter
# Schroeder at peters@ssl.berkeley.edu

at -c -f graboffsets.sh noon tomorrow

# keep a log file of which offset data product, if any, has changed
if ( -e offsetstatus ) then
    /bin/rm -f offsetstatus
endif
touch offsetstatus

foreach i ( offset_A_r0.dat offset_B_r0.dat )
    wget -O temp.$$ ftp://igpp.ucla.edu/pub/stereo/offset/$i
    if ( -z temp.$$ ) then
	echo Failed to fetch $i
	exit -1
    endif
    diff $i temp.$$ >& foo.$$
    if ( ! -z foo.$$ ) then
	date -u >> offsetstatus
	echo -n "Running in directory: " >> offsetstatus
	pwd >> offsetstatus
	echo $i has changed >> offsetstatus
	echo From >> offsetstatus
	cat $i >> offsetstatus
	mv temp.$$ $i
	echo To >> offsetstatus
	cat $i >> offsetstatus
	echo ' ' >> offsetstatus
    else
	/bin/rm -f temp.$$
    endif
    /bin/rm -f foo.$$
end

if ( ! -z offsetstatus ) then
    mailx -s "offset files have changed" peters@ssl.berkeley.edu marchant@ssl.berkeley.edu < offsetstatus
    cat offsetstatus
endif
