/*
 * Decompiled with CFR 0.152.
 */
package com.lmsal.pod.client;

import com.lmsal.pod.client.HttpTransferEvent;
import com.lmsal.pod.client.HttpTransferEventListener;
import com.lmsal.pod.client.Log;
import com.lmsal.pod.client.PodUpload;
import com.lmsal.pod.client.PodUploadImplementation;
import com.lmsal.pod.client.PodUploader;
import com.lmsal.pod.client.UploadTask;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import javax.security.sasl.AuthenticationException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.log4j.Logger;

public class PodUploaderImplementation
implements PodUploader {
    HttpClient client;
    String url;
    String username = "";
    String password = "";
    Set<HttpTransferEventListener> listeners;
    private static Logger log = Log.getLogger(PodUploaderImplementation.class);
    private Map<PodUpload, UploadTask> uploads = new HashMap<PodUpload, UploadTask>();

    public PodUploaderImplementation(String url) {
        this(url, null);
    }

    public PodUploaderImplementation(String url, String proxy) {
        System.out.println("PodUploaderImplementation constr " + new Date());
        log.debug("PodUploaderImplementation constr");
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(params, "POD-CLIENT/0.80");
        if (proxy != null && proxy.trim().length() > 0) {
            log.debug("setting proxy host to " + proxy);
            HttpHost proxyHost = new HttpHost(proxy);
            ConnRouteParams.setDefaultProxy(params, proxyHost);
        } else {
            log.debug("no proxy");
        }
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        SocketFactory sf = PlainSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("http", sf, 80));
        sf = SSLSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("https", sf, 443));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(params, supportedSchemes);
        log.debug("about to new HttpClient");
        this.client = new DefaultHttpClient(connectionManager, params);
        this.url = url;
        this.listeners = new HashSet<HttpTransferEventListener>();
        System.out.println("bottom PodUploaderImplementation constr");
    }

    private String getResponseContentAsString(HttpRequestBase request, HttpResponse response) throws IOException, RuntimeException {
        HttpEntity entity = response.getEntity();
        String responseContent = null;
        if (entity != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InputStream instream = entity.getContent();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    pw.println(line);
                }
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                request.abort();
                throw ex;
            }
            finally {
                pw.flush();
                responseContent = sw.toString();
                pw.close();
                instream.close();
            }
        }
        return responseContent;
    }

    private String getURLContent(String url) throws IOException {
        log.debug("getURLContent url=" + url);
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = this.client.execute(httpget);
        System.out.println(response.getStatusLine());
        String responseContent = this.getResponseContentAsString(httpget, response);
        return responseContent;
    }

    private int publicPing() throws IOException {
        log.debug("public ping");
        String pingUrl = this.url + "/ping.txt";
        String response = this.getURLContent(pingUrl);
        log.debug("response=" + response);
        if (response == null) {
            response = "";
        }
        boolean success = response.trim().equals("ping");
        log.debug("success=" + success);
        return success ? 1 : -1;
    }

    private int protectedPing() throws IOException {
        log.debug("protected ping");
        String pingUrl = this.url + "/Nav/ping.txt";
        String response = this.getURLContent(pingUrl);
        if (response == null) {
            response = "";
        }
        boolean authenticated = response.trim().equals("ping");
        log.debug("authenticated=" + authenticated);
        return authenticated ? 1 : -1;
    }

    public void login(String username, String password) throws FailedLoginException {
        log.debug("login");
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        this.username = username;
        this.password = password;
        try {
            if (this.publicPing() < 0) {
                log.debug("public ping returned failure");
                throw new FailedLoginException("Could not connect to server");
            }
        }
        catch (IOException e) {
            log.debug("public ping threw exception: " + e);
            throw new FailedLoginException("Could not connect to server: " + e);
        }
        String callbackUrl = this.url + "/Nav/ping.txt";
        log.debug("callbackUrl=" + callbackUrl);
        String targetUrl = this.url + "/auth-service";
        log.debug("targetUrl=" + targetUrl);
        String mount = "";
        try {
            URL urlObj = new URL(this.url);
            mount = urlObj.getFile();
            log.debug("mount=" + mount);
        }
        catch (MalformedURLException mue) {
            log.debug(mue);
        }
        try {
            Header[] headers;
            HttpPost post = new HttpPost(targetUrl);
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("cmd", "submit-login"));
            nvps.add(new BasicNameValuePair("j_username", username));
            nvps.add(new BasicNameValuePair("j_password", password));
            nvps.add(new BasicNameValuePair("callback-url", callbackUrl));
            if (mount != null && mount.trim().length() > 0) {
                nvps.add(new BasicNameValuePair("mount", mount));
            }
            post.setEntity(new UrlEncodedFormEntity(nvps, "UTF-8"));
            HttpResponse response = this.client.execute(post);
            HttpEntity entity = response.getEntity();
            int status = response.getStatusLine().getStatusCode();
            log.debug("status=" + status);
            for (Header header : headers = response.getAllHeaders()) {
                log.debug("header: " + header.getName() + ": " + header.getValue());
            }
            Header locationHeader = response.getFirstHeader("location");
            String redirectLocation = "";
            if (locationHeader != null) {
                redirectLocation = locationHeader.getValue();
            }
            log.debug("redirectLocation=" + redirectLocation);
            String responseContent = this.getResponseContentAsString(post, response);
            log.debug("responseContent=" + responseContent);
        }
        catch (Exception e) {
            log.error("Error attempting to login to " + this.url + ": " + e.getMessage());
            throw new FailedLoginException("Error attempting to login to " + this.url + ": " + e.getMessage());
        }
        try {
            if (this.protectedPing() != 1) {
                log.error("Protected ping was not successful. Login Failed.");
                throw new FailedLoginException("Login Failed");
            }
        }
        catch (Exception e) {
            log.error("Error attempting to login to " + this.url + ": " + e.getMessage());
            throw new FailedLoginException("Error attempting to login to " + this.url + ": " + e.getMessage());
        }
    }

    public String[] getProfile() throws AuthenticationException, IOException {
        log.debug("getProfile");
        log.debug("about to protectedPing");
        int pingStatus = this.protectedPing();
        log.debug("pingStatus=" + pingStatus);
        if (pingStatus != 1) {
            log.debug("pingStatus results in login call");
            try {
                this.login(this.username, this.password);
            }
            catch (FailedLoginException fle) {
                log.debug("failed login: " + fle);
                throw new AuthenticationException(fle.getMessage());
            }
        }
        String targetUrl = this.url + "/user_admin?cmd=profile-home";
        String response = this.getURLContent(targetUrl);
        log.debug(response);
        Pattern p = Pattern.compile("<br/?>", 2);
        Matcher m = p.matcher(response);
        response = m.replaceAll("");
        log.debug(response);
        String[] keys = new String[]{"Name", "Email", "Institution"};
        String[] values = new String[keys.length];
        int i = 0;
        for (String key : keys) {
            String value = null;
            p = Pattern.compile("^" + key + ":(.*)$", 10);
            m = p.matcher(response);
            if (m.find()) {
                values[i] = value = m.group(1).trim();
            }
            log.debug(key + "=x" + value + "x");
            ++i;
        }
        return values;
    }

    public PodUpload uploadMovie(String title, String description, String thumbnailCaption, File movie, File frameCapture, File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        return this.uploadPod(title, description, thumbnailCaption, movie, frameCapture, voevents, listener);
    }

    public PodUpload uploadImage(String title, String description, String thumbnailCaption, File image, File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        log.debug("uploadImage");
        return this.uploadPod(title, description, thumbnailCaption, null, image, voevents, listener);
    }

    public PodUpload uploadXml(File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        log.debug("uploadImage");
        return this.uploadPod(null, null, null, null, null, voevents, listener);
    }

    private PodUpload uploadPod(String title, String description, String thumbnailCaption, File movie, File image, File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        File[] media = new File[]{movie, image};
        return this.uploadPod(title, description, thumbnailCaption, media, voevents, listener);
    }

    private PodUpload uploadPod(final String title, final String description, final String thumbnailCaption, final File[] media, final File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        boolean synchronous;
        log.debug("uploadPod");
        boolean bl = synchronous = listener == null;
        if (listener != null) {
            this.addHttpTransferEventListener(listener);
        }
        UploadTask uploadTask = new UploadTask(){
            private boolean abort = false;
            private HttpTransferEvent event;

            public void abort() {
                this.abort = true;
            }

            public HttpTransferEvent getHttpTransferEvent() {
                return this.event;
            }

            public void setHttpTransferEvent(HttpTransferEvent event) {
                this.event = event;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                log.debug("UploadTask.run");
                try {
                    if (this.abort) {
                        throw new IOException("Abort called");
                    }
                    log.debug("about to protectedPing");
                    int pingStatus = PodUploaderImplementation.this.protectedPing();
                    log.debug("pingStatus=" + pingStatus);
                    if (pingStatus != 1) {
                        log.debug("pingStatus results in login call");
                        try {
                            PodUploaderImplementation.this.login(PodUploaderImplementation.this.username, PodUploaderImplementation.this.password);
                        }
                        catch (FailedLoginException fle) {
                            log.debug("failed login: " + fle);
                            throw new AuthenticationException(fle.getMessage());
                        }
                    }
                    String targetUrl = PodUploaderImplementation.this.url + "/pod";
                    log.debug("targetUrl=" + targetUrl);
                    if (this.abort) {
                        throw new IOException("Abort called");
                    }
                    log.debug("about to new PostMethod");
                    HttpPost post = new HttpPost(targetUrl);
                    log.debug("about to set curMethod");
                    MultipartEntity reqEntity = new MultipartEntity();
                    reqEntity.addPart("cmd", new StringBody("submit-new-pod"));
                    reqEntity.addPart("category", new StringBody("General"));
                    reqEntity.addPart("content-type", new StringBody("html"));
                    reqEntity.addPart("pod-id", new StringBody(""));
                    if (title != null) {
                        reqEntity.addPart("title", new StringBody(title));
                    }
                    if (description != null) {
                        reqEntity.addPart("description", new StringBody(description));
                    }
                    if (thumbnailCaption != null) {
                        reqEntity.addPart("thumbnail_caption", new StringBody(thumbnailCaption));
                    }
                    log.debug("about to build list of media files");
                    if (media != null) {
                        for (File file : media) {
                            if (file == null) continue;
                            reqEntity.addPart("client_filename", new FileBody(file));
                        }
                    }
                    log.debug("about to build list of voevent files");
                    if (voevents != null) {
                        for (File file : voevents) {
                            reqEntity.addPart("voevent", new FileBody(file));
                        }
                    }
                    post.setEntity(reqEntity);
                    log.debug("executing request " + post.getRequestLine());
                    log.debug("about to executeMethod on multipartrequest");
                    HttpResponse response = PodUploaderImplementation.this.client.execute(post);
                    HttpEntity resEntity = response.getEntity();
                    log.debug("multipart status=" + response.getStatusLine().getStatusCode());
                    if (resEntity != null) {
                        System.out.println("Response content length: " + resEntity.getContentLength());
                        System.out.println("Chunked?: " + resEntity.isChunked());
                    }
                    String responseContent = null;
                    if (resEntity != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        InputStream instream = resEntity.getContent();
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
                            String line = "";
                            while ((line = reader.readLine()) != null) {
                                pw.println(line);
                            }
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        catch (RuntimeException ex) {
                            post.abort();
                            throw ex;
                        }
                        finally {
                            pw.flush();
                            responseContent = sw.toString();
                            pw.close();
                            instream.close();
                        }
                    }
                    log.debug("response from multipart submission=" + responseContent);
                    log.debug("about to parse response for pod id");
                    Pattern p = Pattern.compile("name=['\"]pod[-_]id['\"]\\s+value=['\"]([^'\"]+)['\"]");
                    Matcher m = p.matcher(responseContent);
                    String podId = "";
                    if (m.find()) {
                        podId = m.group(1);
                    }
                    log.debug("podId=" + podId);
                    if (podId == null || podId.trim().length() == 0) {
                        log.debug("Failed to get pod id from server");
                        throw new IOException("Failed to get pod id from server");
                    }
                    String parameterErrorIndicationStr = "The gallery input contains errors";
                    if (responseContent.indexOf(parameterErrorIndicationStr) >= 0) {
                        throw new IOException("Missing parameters");
                    }
                    if (this.abort) {
                        throw new IOException("Abort called");
                    }
                    post = new HttpPost(targetUrl);
                    ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                    nvps.add(new BasicNameValuePair("cmd", "submit-new-pod"));
                    nvps.add(new BasicNameValuePair("confirm", "1"));
                    nvps.add(new BasicNameValuePair("pod-id", podId));
                    post.setEntity(new UrlEncodedFormEntity(nvps, "UTF-8"));
                    log.debug("about to executeMethod for new pod confirmation");
                    response = PodUploaderImplementation.this.client.execute(post);
                    resEntity = response.getEntity();
                    responseContent = null;
                    if (resEntity != null) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        InputStream instream = resEntity.getContent();
                        try {
                            BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
                            String line = "";
                            while ((line = reader.readLine()) != null) {
                                pw.println(line);
                            }
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        catch (RuntimeException ex) {
                            post.abort();
                            throw ex;
                        }
                        finally {
                            pw.flush();
                            responseContent = sw.toString();
                            pw.close();
                            instream.close();
                        }
                    }
                    log.debug("confirmation response=");
                    log.debug(responseContent);
                    String confirmationStr = "Thank you for the POD submission";
                    boolean confirmed = false;
                    if (responseContent.indexOf(confirmationStr) >= 0) {
                        confirmed = true;
                    }
                    log.debug("confirmed=" + confirmed);
                    HttpTransferEvent evt = new HttpTransferEvent();
                    if (confirmed) {
                        evt.setMessage("Upload complete");
                        evt.setStatus(4);
                    } else {
                        Pattern ep = Pattern.compile("<div\\s*class\\s*=\\s*['\"]error['\"][^>]*>([^<]+)</div>");
                        Matcher em = ep.matcher(responseContent);
                        String serverErrorMessage = "";
                        if (em.find()) {
                            serverErrorMessage = em.group(1);
                        }
                        log.debug("serverErrorMessage=" + serverErrorMessage);
                        if (serverErrorMessage != null && serverErrorMessage.trim().length() > 0) {
                            evt.setMessage("Server Error: " + serverErrorMessage);
                        } else {
                            evt.setMessage("Upload problem. Unable to get server confirmation.");
                        }
                        evt.setStatus(32);
                    }
                    PodUploaderImplementation.this.fireHttpTransferEvent(evt);
                    this.setHttpTransferEvent(evt);
                }
                catch (Throwable e) {
                    log.debug(e);
                    HttpTransferEvent evt = new HttpTransferEvent();
                    if (e.toString() != null && e.toString().equals("Abort called")) {
                        evt.setMessage(e.toString());
                        evt.setStatus(8);
                    } else {
                        evt.setMessage("Error uploading files: " + e);
                        evt.setStatus(32);
                    }
                    PodUploaderImplementation.this.fireHttpTransferEvent(evt);
                    this.setHttpTransferEvent(evt);
                }
            }
        };
        Thread uploadThread = new Thread(uploadTask);
        PodUploadImplementation upload = new PodUploadImplementation();
        log.debug("synchronous=" + synchronous);
        if (!synchronous) {
            log.debug("not synchronous");
            upload = new PodUploadImplementation(this);
            this.uploads.put(upload, uploadTask);
        }
        log.debug("about to uploadThread.start");
        uploadThread.start();
        log.debug("did uploadThread.start");
        if (synchronous) {
            long timeout = 3600000L;
            try {
                log.debug("synchronous. about to uploadThread.join");
                uploadThread.join(timeout);
            }
            catch (InterruptedException ie) {
                log.error(ie);
            }
            if (uploadTask == null) {
                log.debug("synchronous. uploadTask is null");
            }
            if (upload == null) {
                log.debug("synchronous. upload is null");
            }
            log.debug("synchronous. about to upload.setHttpTransferEvent");
            upload.setHttpTransferEvent(uploadTask.getHttpTransferEvent());
        }
        log.debug("about to return upload");
        return upload;
    }

    public void abort(PodUpload upload) {
        UploadTask task = this.uploads.get(upload);
        task.abort();
    }

    private synchronized void addHttpTransferEventListener(HttpTransferEventListener listener) {
        this.listeners.add(listener);
    }

    private synchronized void fireHttpTransferEvent(HttpTransferEvent evt) {
        Iterator<HttpTransferEventListener> iter = this.listeners.iterator();
        while (iter.hasNext()) {
            iter.next().dataTransferAcknowledged(evt);
        }
    }

    private static void main(String[] args) throws Exception {
        String response = "Name: David Schiff\n<BR>\nInstitution: LMSSC<BR>\nEmail: schiff@lmsal.com<BR>\nPhone: 650 424 2980<BR>\n\nRole: web master emeritus<br>\n";
        Pattern p = Pattern.compile("<br/?>", 2);
        Matcher m = p.matcher(response);
        response = m.replaceAll("");
        String name = null;
        p = Pattern.compile("^Name:(.*)$", 10);
        m = p.matcher(response);
        if (m.find()) {
            System.out.println("find");
            name = m.group(1).trim();
        }
        System.out.println("name=" + name);
    }

    private static void mainx(String[] args) throws Exception {
        String response = "<html>\n<body>\n<div class='error'>Error: Error while importing string XML: Importing attributes\n failed (no lastid): Importing attributes failed</div>\n</body>\n</html>";
        Pattern ep = Pattern.compile("<div\\s*class\\s*=\\s*['\"]error['\"][^>]*>([^<]+)</div>");
        Matcher em = ep.matcher(response);
        String serverErrorMessage = "";
        if (em.find()) {
            serverErrorMessage = em.group(1);
        }
        System.out.println("serverErrorMessage=" + serverErrorMessage);
    }
}

