/*
 * Decompiled with CFR 0.152.
 */
package com.lmsal.pod.client;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.NullAppender;

public class Log {
    private static volatile Logger log;
    private static final String LOG_CLASS;
    private static final String DEFAULT_FILENAME = "pod.log";
    private static final String PATTERN = "%d{ISO8601} %M %m%n";

    private static String getPackageName() {
        return new ClassGetter().getPackageName();
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public static Logger getLogger() {
        return Logger.getLogger(new CallerClassGetter().getCallingClass());
    }

    public static synchronized void initConsoleLogging() {
        System.out.println("initConsoleLogging");
        ConsoleAppender stdoutAppender = new ConsoleAppender(new PatternLayout(PATTERN));
        log.addAppender(stdoutAppender);
    }

    public static synchronized void initFileLogging(String filename) throws IOException {
        System.out.println("Log.initFileLogging");
        System.out.println("log class name=" + LOG_CLASS);
        System.out.println("filename=" + filename);
        File logFile = null;
        if (filename != null && filename.trim().length() > 0) {
            File file = new File(filename);
            if (file.isDirectory()) {
                if (!file.exists()) {
                    System.out.println("Directory " + filename + " does not exist, will try to create it.");
                    boolean success = file.mkdirs();
                    if (!success) {
                        System.out.println("Failed to create directory " + filename);
                    }
                }
                if (file.exists()) {
                    logFile = new File(file, DEFAULT_FILENAME);
                }
            } else if (!file.exists()) {
                System.out.println(filename + " does not exist");
                File parentDir = file.getParentFile();
                if (!parentDir.exists()) {
                    System.out.println("Directory " + parentDir.getPath() + " does not exist, will try to create it.");
                    boolean success = parentDir.mkdirs();
                    if (!success) {
                        System.out.println("Failed to create directory " + parentDir.getPath());
                    }
                }
                if (parentDir.exists()) {
                    logFile = file;
                }
            } else {
                System.out.println(filename + " exists");
                logFile = file;
            }
        }
        if (logFile != null) {
            System.out.println("log file=" + logFile.getPath());
            System.out.println("About to add file appender");
            FileAppender fileAppender = new FileAppender((Layout)new PatternLayout(PATTERN), logFile.getPath());
            fileAppender.setName("file");
            log.addAppender(fileAppender);
        } else {
            System.out.println("Log file was not created");
        }
    }

    static {
        LOG_CLASS = Log.getPackageName();
        if (log == null) {
            System.out.println("log class=" + LOG_CLASS);
            log = Logger.getLogger(LOG_CLASS);
        }
        log.addAppender(new NullAppender());
        log.setLevel(Level.ALL);
        Logger root = LogManager.getRootLogger();
        Enumeration enu = root.getAllAppenders();
        boolean hasAppender = enu.hasMoreElements();
        if (!hasAppender) {
            root.addAppender(new NullAppender());
        }
    }

    private static class CallerClassGetter
    extends SecurityManager {
        private CallerClassGetter() {
        }

        public Class getCallingClass() {
            Class<?>[] classes = this.getClassContext();
            Class<?> firstClass = null;
            for (int i = 0; i < classes.length; ++i) {
                String className = classes[i].getName();
                if (classes[i].isMemberClass()) continue;
                if (firstClass == null) {
                    firstClass = classes[i];
                }
                if (classes[i].equals(firstClass)) continue;
                System.out.println("returning exec stack i=" + i + ", " + classes[i].getName());
                return classes[i];
            }
            System.out.println("returning 0");
            return firstClass;
        }
    }

    private static class ClassGetter
    extends SecurityManager {
        private ClassGetter() {
        }

        public String getPackageName() {
            return this.getClassContext()[1].getPackage().getName();
        }
    }
}

