/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimePicker
extends JPanel
implements ItemListener {
    private JComboBox yearCombo;
    private JComboBox monthCombo;
    private JComboBox dayCombo;
    private JComboBox hourCombo;
    private JComboBox minuteCombo;
    private int minuteInterval = 10;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private TimePicker otherPicker = null;

    private void initWidgets(JComponent jComponent) {
        String[] stringArray;
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1);
        this.yearCombo = new JComboBox();
        for (int i = n; i >= 1990; --i) {
            this.yearCombo.addItem(Integer.toString(i));
        }
        String[] stringArray2 = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
        this.monthCombo = new JComboBox<String>(stringArray2);
        String[] stringArray3 = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
        this.dayCombo = new JComboBox<String>(stringArray3);
        if (this.minuteInterval > 0 && this.minuteInterval < 60) {
            stringArray = new String[]{"00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"};
            this.hourCombo = new JComboBox<String>(stringArray);
            this.minuteCombo = new JComboBox();
            for (int i = 0; i < 60; i += this.minuteInterval) {
                if (i < 10) {
                    this.minuteCombo.addItem("0" + i);
                    continue;
                }
                this.minuteCombo.addItem("" + i);
            }
        }
        stringArray = this;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 0;
        if (jComponent != null) {
            stringArray.setLayout(new GridBagLayout());
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.gridy = 0;
            stringArray.add((Component)jComponent, gridBagConstraints);
        } else {
            stringArray.setLayout(new GridBagLayout());
        }
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)new JLabel("Year"), gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)new JLabel("Month"), gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)new JLabel("Day"), gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)new JLabel("Hour"), gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)new JLabel("Minute"), gridBagConstraints);
        n2 = jComponent != null ? 1 : 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)this.yearCombo, gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)this.monthCombo, gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)this.dayCombo, gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)this.hourCombo, gridBagConstraints);
        gridBagConstraints.gridx = n2++;
        stringArray.add((Component)this.minuteCombo, gridBagConstraints);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (itemEvent.getStateChange() != 1) {
            return;
        }
        try {
            Date date = this.otherPicker.getDate();
            Date date2 = this.getDate();
            if (jComboBox == this.minuteCombo || jComboBox == this.hourCombo || jComboBox == this.dayCombo || jComboBox == this.monthCombo || jComboBox == this.yearCombo) {
                if (date2.before(date)) {
                    this.otherPicker.setTime(new Date(date2.getTime() - 86400000L));
                }
            } else if (date2.before(date)) {
                this.setTime(new Date(date.getTime() + 86400000L));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void slaveTo(TimePicker timePicker) {
        this.otherPicker = timePicker;
        this.otherPicker.minuteCombo.addItemListener(this);
        this.otherPicker.hourCombo.addItemListener(this);
        this.otherPicker.dayCombo.addItemListener(this);
        this.otherPicker.monthCombo.addItemListener(this);
        this.otherPicker.yearCombo.addItemListener(this);
        this.minuteCombo.addItemListener(this);
        this.hourCombo.addItemListener(this);
        this.dayCombo.addItemListener(this);
        this.monthCombo.addItemListener(this);
        this.yearCombo.addItemListener(this);
    }

    public TimePicker(JComponent jComponent, Date date) {
        this.initWidgets(jComponent);
        this.setTime(date);
    }

    public TimePicker(JComponent jComponent, Date date, TimePicker timePicker) {
        this.initWidgets(jComponent);
        this.setTime(date);
        this.slaveTo(timePicker);
    }

    public TimePicker(JComponent jComponent) {
        this.initWidgets(jComponent);
        this.setTime(new Date(System.currentTimeMillis()));
    }

    public TimePicker(JComponent jComponent, TimePicker timePicker) {
        this.initWidgets(jComponent);
        this.setTime(new Date(System.currentTimeMillis()));
        this.slaveTo(timePicker);
    }

    public TimePicker() {
        this.initWidgets(null);
        this.setTime(new Date(System.currentTimeMillis()));
    }

    public TimePicker(TimePicker timePicker) {
        this.initWidgets(null);
        this.setTime(new Date(System.currentTimeMillis()));
        this.slaveTo(timePicker);
    }

    public int getYear() {
        Integer n = new Integer((String)this.yearCombo.getSelectedItem());
        return n;
    }

    public void setYear(int n) {
        Integer n2 = new Integer(n);
        this.yearCombo.setSelectedItem(n2.toString());
    }

    public int getMonth() {
        Integer n = new Integer((String)this.monthCombo.getSelectedItem());
        return n;
    }

    public void setMonth(int n) {
        Integer n2 = new Integer(n);
        this.monthCombo.setSelectedItem(n2.toString());
    }

    public int getDay() {
        Integer n = new Integer((String)this.dayCombo.getSelectedItem());
        return n;
    }

    public void setDay(int n) {
        Integer n2 = new Integer(n);
        this.dayCombo.setSelectedItem(n2.toString());
    }

    public String getTimeString() {
        String string = (String)this.yearCombo.getSelectedItem();
        String string2 = (String)this.monthCombo.getSelectedItem();
        String string3 = (String)this.dayCombo.getSelectedItem();
        String string4 = (String)this.hourCombo.getSelectedItem();
        String string5 = (String)this.minuteCombo.getSelectedItem();
        return string + "-" + string2 + "-" + string3 + " " + string4 + ":" + string5 + ":00";
    }

    public Date getDate() throws Exception {
        String string = this.getTimeString();
        return this.dateFormat.parse(string);
    }

    public void setTime(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(System.currentTimeMillis());
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date);
        int n = gregorianCalendar2.get(1);
        int n2 = gregorianCalendar.get(1);
        this.yearCombo.setSelectedIndex(n2 - n);
        this.monthCombo.setSelectedIndex(gregorianCalendar2.get(2));
        this.dayCombo.setSelectedIndex(gregorianCalendar2.get(5) - 1);
        this.hourCombo.setSelectedIndex(gregorianCalendar2.get(11));
        this.minuteCombo.setSelectedIndex(gregorianCalendar2.get(12) / 10);
    }
}

