/*
 * Decompiled with CFR 0.152.
 */
import com.lmsal.pod.client.Log;
import com.lmsal.pod.client.PodUploaderImplementation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class HkbLauncher
extends JPanel
implements ActionListener,
ListSelectionListener,
ItemListener {
    public static final String TRACE_BASE_MOVIE_DIR = "/net/vestige/Volumes/disk1/ops/DataCenter/www/htdocs/TRACE";
    public static int debugLevel = 0;
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static String homeDirName = null;
    private long startTimeMs = System.currentTimeMillis();
    private Date timeRangeStart = new Date(this.startTimeMs - 604800000L);
    private Date timeRangeEnd = new Date(this.startTimeMs);
    private static Vector theSearchDirList = new Vector();
    private String instrument = null;
    private TimePicker startTimePicker = null;
    private TimePicker endTimePicker = null;
    private JTable obsTable = null;
    private JTable channelTable = null;
    private ListSelectionModel channelSelectionModel = null;
    private ListSelectionModel obsSelectionModel = null;
    private JComboBox instCombo = null;
    private JComboBox lowWaterCombo = null;
    private JComboBox highWaterCombo = null;
    private JComboBox eventTypeCombo = null;
    private JComboBox windowGeomCombo = null;
    private JButton panoButton = null;
    private JButton addPathButton = null;
    private JButton searchButton = null;
    private JLabel resultsTitle = null;
    private JCheckBox testCheckBox = null;
    private JCheckBox invertColorsCheckBox = null;
    private JCheckBox traceRegionTrackingCheckBox = null;
    private JTextField textSearch = null;
    private JTextField theCmdLine = null;
    private JTextField usernameField = null;
    private JPasswordField passwordField = null;
    private JComboBox subsampleCombo = null;
    private JCheckBox normalizedCheck = null;
    private DefaultTableModel obsTableModel = null;
    private DefaultTableModel channelTableModel = null;
    private boolean sotSel = true;
    private boolean xrtSel = true;
    private boolean traceSel = true;
    private Vector dataRows = null;
    private Vector eventList = null;
    private String[] obsTableColumnNames = new String[]{"NOAA Region", "Observation Title", "Scientific Objectives", "Instrument", "Obs Start Time", "Obs End Time"};
    private String[] channelTableColumnNames = new String[]{"Channel", "# Img", "(xcen,ycen)", "(fovx,fovy)", "(w,h)", "pmin", "pmax"};
    private static String buildId = "$Name: build_20090610 $";
    private static String buildRevision = "$Revision: 1.49 $";

    public static double dtrunc(double d, int n) {
        if (n > 8) {
            n = 8;
        } else if (n < 0) {
            n = 0;
        }
        double d2 = Math.pow(10.0, n);
        double d3 = Math.round(d * d2);
        return d3 / d2;
    }

    public static String getBuildId() {
        if (buildId.length() <= 6) {
            return "";
        }
        return buildId.substring(7, buildId.length() - 2);
    }

    public static String getBuildRevision() {
        if (buildRevision.length() <= 10) {
            return "";
        }
        return buildRevision.substring(11, buildRevision.length() - 2);
    }

    private void readConfigFile() {
        BufferedReader bufferedReader = null;
        File file = new File(homeDirName, ".plauncher.cfg");
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            System.err.println("Exception caught in opening file='" + file + "'");
            return;
        }
        boolean bl = true;
        while (bl) {
            String string = null;
            try {
                string = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                System.err.println("Exception caught reading a line in file='" + file + "'");
                bl = false;
            }
            if (string == null || string.matches("^\\s*$")) {
                bl = false;
                continue;
            }
            String[] stringArray = string.split("\\s*=+\\s*");
            if (stringArray.length == 2) {
                if (stringArray[0].equalsIgnoreCase("addpath") || stringArray[0].equalsIgnoreCase("path")) {
                    theSearchDirList.add(stringArray[1]);
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("starttime")) {
                    this.timeRangeStart = TimeParser.parseTimeString(stringArray[1]);
                    continue;
                }
                if (stringArray[0].equalsIgnoreCase("stoptime")) {
                    this.timeRangeEnd = TimeParser.parseTimeString(stringArray[1]);
                    continue;
                }
                if (!stringArray[0].equalsIgnoreCase("instrument")) continue;
                this.instrument = stringArray[1];
                continue;
            }
            if (stringArray.length != 1 && stringArray.length <= 2) continue;
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println("Exception caught closing file='" + file + "'");
        }
    }

    private void writeConfigFile(String string, String string2) {
        PrintStream printStream = null;
        File file = new File(homeDirName, ".plauncher.cfg");
        try {
            printStream = new PrintStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            System.err.println("Exception caught in opening file='" + file + "'");
            return;
        }
        printStream.println("starttime=" + string);
        printStream.println("stoptime=" + string2);
        printStream.println("instrument=" + (String)this.instCombo.getSelectedItem());
        for (int i = 0; i < theSearchDirList.size(); ++i) {
            printStream.println("addpath=" + (String)theSearchDirList.get(i));
        }
        try {
            printStream.close();
        }
        catch (Exception exception) {
            System.err.println("Exception caught closing file='" + file + "'");
        }
    }

    private void postDirChooser(JComponent jComponent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Choose the TRACE level 1 archive directory");
        jFileChooser.setApproveButtonToolTipText("Add this directory to the Panorama FITS file search path.");
        int n = jFileChooser.showOpenDialog(jComponent);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            PrintStream printStream = null;
            File file2 = new File(homeDirName, ".plauncher.cfg");
            try {
                printStream = new PrintStream(new FileOutputStream(file2, true));
            }
            catch (Exception exception) {
                System.err.println("Unable to create plauncher config file: " + file2.toString());
                exception.printStackTrace();
                return;
            }
            printStream.println("addpath=" + file.toString());
            try {
                printStream.close();
            }
            catch (Exception exception) {
                System.err.println("Exception caught closing file='" + file2.toString() + "'");
            }
        }
    }

    private void getChannelInfo(String string, RsRow rsRow) {
        if (debugLevel > 0) {
            System.out.println("getChannelInfo(eventId=" + string + ")");
        }
        VOEventData vOEventData = SotKbClient.getEventDetail(string);
        rsRow.channelData = new Vector();
        if (vOEventData == null || vOEventData.groups.size() <= 0) {
            System.err.println("getChannelInfo(): No event detail available for eventId=" + string);
            return;
        }
        for (int i = 0; i < vOEventData.groups.size(); ++i) {
            ParamGroup paramGroup = (ParamGroup)vOEventData.groups.get(i);
            ModeInfo modeInfo = new ModeInfo();
            modeInfo.channel = paramGroup.name;
            modeInfo.uMode = paramGroup.getParam("UMODE", "");
            modeInfo.nmatches = Integer.valueOf(paramGroup.getParam("NMATCHES", "0"));
            modeInfo.nss = Integer.valueOf(paramGroup.getParam("NSS", "0"));
            modeInfo.obsDir = paramGroup.getParam("OBSDIR", "");
            modeInfo.urlParent = paramGroup.getParam("URL_MPARENT", "");
            modeInfo.level1DatFile = modeInfo.urlParent.replaceFirst(".html$", "_l1files.dat");
            if (modeInfo.level1Files == null) {
                if (paramGroup.hasParam("LEVEL1_FILES")) {
                    // empty if block
                }
                try {
                    modeInfo.level1Files = IOUtil.readUrl(modeInfo.level1DatFile);
                    if (modeInfo.level1Files == null || modeInfo.level1Files.matches("^\\s*$")) {
                        System.err.println("Empty/blank TRACE Level 1 FITS file list.\nThis URL seems to exist, but the file is empty:\n    " + modeInfo.level1DatFile + "\nParent URL:\n    " + modeInfo.urlParent + "\nChannel: " + modeInfo.channel + "\n\nThis is likely caused by a missing or malformed VOEvent directory\n");
                        JOptionPane.showMessageDialog(this, "Empty/blank TRACE Level 1 FITS file list.\nThis URL seems to exist, but the file is empty:\n    " + modeInfo.level1DatFile + "\nParent URL:\n    " + modeInfo.urlParent + "\nChannel: " + modeInfo.channel + "\n\nThis is likely caused by a missing or malformed VOEvent directory\n", "Error finding FITS file list", 2);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Unable to open TRACE Level 1 FITS file list that should be at URL:\n    " + modeInfo.level1DatFile + "\nParent URL:\n    " + modeInfo.urlParent + "\nChannel: " + modeInfo.channel + "\n\nThis is likely caused by a missing or malformed VOEvent directory\n");
                    JOptionPane.showMessageDialog(this, "Unable to open TRACE Level 1 FITS file list that should be at URL:\n    " + modeInfo.level1DatFile + "\nParent URL:\n    " + modeInfo.urlParent + "\nChannel: " + modeInfo.channel + "\n\nThis is likely caused by a missing or malformed VOEvent directory\n", "Error finding FITS file list", 2);
                    modeInfo.level1Files = "";
                }
            }
            modeInfo.urlMpeg = paramGroup.getParam("URL_MPEG", "");
            modeInfo.urlJavascript = paramGroup.getParam("URL_JAVASCRIPT", "");
            modeInfo.urlContext = paramGroup.getParam("URL_CONTEXT", "");
            modeInfo.fovx = Double.valueOf(paramGroup.getParam("FOVX", "0"));
            modeInfo.fovy = Double.valueOf(paramGroup.getParam("FOVY", "0"));
            modeInfo.xcen = Double.valueOf(paramGroup.getParam("XCEN", "0"));
            modeInfo.ycen = Double.valueOf(paramGroup.getParam("YCEN", "0"));
            modeInfo.nAxis1 = Integer.valueOf(paramGroup.getParam("NAXIS1", "0"));
            modeInfo.nAxis2 = Integer.valueOf(paramGroup.getParam("NAXIS2", "0"));
            modeInfo.progNo = paramGroup.getParam("PROG_NO", "");
            if (paramGroup.hasParam("DATAP01")) {
                modeInfo.datap[0] = Double.valueOf(paramGroup.getParam("DATAP01"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP10")) {
                modeInfo.datap[1] = Double.valueOf(paramGroup.getParam("DATAP10"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP25")) {
                modeInfo.datap[2] = Double.valueOf(paramGroup.getParam("DATAP25"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP75")) {
                modeInfo.datap[3] = Double.valueOf(paramGroup.getParam("DATAP75"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP90")) {
                modeInfo.datap[4] = Double.valueOf(paramGroup.getParam("DATAP90"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP95")) {
                modeInfo.datap[5] = Double.valueOf(paramGroup.getParam("DATAP95"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP98")) {
                modeInfo.datap[6] = Double.valueOf(paramGroup.getParam("DATAP98"));
                modeInfo.hasDatap = true;
            }
            if (paramGroup.hasParam("DATAP99")) {
                modeInfo.datap[7] = Double.valueOf(paramGroup.getParam("DATAP99"));
                modeInfo.hasDatap = true;
            }
            rsRow.channelData.add(modeInfo);
            if (debugLevel < 5) continue;
            System.out.println("chan=" + modeInfo.channel + ", xcen=" + modeInfo.xcen + ", ycen=" + modeInfo.ycen + ", fovx=" + modeInfo.fovx + ", fovy=" + modeInfo.fovy + ", naxis1=" + modeInfo.nAxis1 + ", naxis2=" + modeInfo.nAxis2);
            System.out.println("           DATAP01=" + modeInfo.datap[0] + ", DATAP10=" + modeInfo.datap[1] + ", DATAP25=" + modeInfo.datap[2] + ", DATAP75=" + modeInfo.datap[3] + ", DATAP90=" + modeInfo.datap[4] + ", DATAP95=" + modeInfo.datap[5] + ", DATAP98=" + modeInfo.datap[6] + ", DATAP99=" + modeInfo.datap[7]);
        }
    }

    private void kbSearch() {
        String string = (String)this.instCombo.getSelectedItem();
        SotKbClient.Instrument instrument = null;
        if (string.equalsIgnoreCase("TRACE")) {
            instrument = SotKbClient.Instrument.TRACE;
            this.normalizedCheck.setSelected(true);
        } else if (string.equalsIgnoreCase("SOT")) {
            instrument = SotKbClient.Instrument.HINODE_SOT;
            this.normalizedCheck.setSelected(false);
        } else if (string.equalsIgnoreCase("XRT")) {
            instrument = SotKbClient.Instrument.HINODE_XRT;
            this.normalizedCheck.setSelected(false);
        }
        String string2 = this.textSearch.getText().trim();
        Date date = TimeParser.parseTimeString(this.startTimePicker.getTimeString());
        Date date2 = TimeParser.parseTimeString(this.endTimePicker.getTimeString());
        this.eventList = string2.length() > 0 ? SotKbClient.searchEvents(date, date2, instrument, null, string2, null) : SotKbClient.searchEvents(date, date2, instrument, null);
        this.showResults();
    }

    private void showResults() {
        int n;
        this.dataRows = new Vector();
        Vector vector = new Vector();
        this.obsTableModel.setRowCount(0);
        this.channelTableModel.setRowCount(0);
        String string = (String)this.eventTypeCombo.getSelectedItem();
        int n2 = -1;
        if (!string.equalsIgnoreCase("ANY")) {
            if (string.equalsIgnoreCase("COVERAGE")) {
                n2 = 1000;
            } else if (string.equalsIgnoreCase("OBSERVATION")) {
                n2 = 0;
            }
        }
        for (n = 0; this.eventList != null && n < this.eventList.size(); ++n) {
            VOEventData vOEventData = (VOEventData)this.eventList.get(n);
            if (n2 != -1 && n2 != vOEventData.eventType) continue;
            RsRow rsRow = new RsRow();
            Vector<String> vector2 = new Vector<String>();
            rsRow.eventType = vOEventData.eventType;
            rsRow.panoramaLaunchCount = 0;
            rsRow.instrument = vOEventData.instrument;
            String string2 = vOEventData.parentUrl;
            if (string2 != null) {
                rsRow.parentDir = string2.replaceFirst("http://.*.lmsal.com", "");
                rsRow.parentDir = TRACE_BASE_MOVIE_DIR + rsRow.parentDir.replaceAll("/[^/]*.html", "");
            }
            rsRow.eventId = vOEventData.eventId;
            rsRow.noaaNum = vOEventData.noaaNum;
            if (rsRow.noaaNum == null || rsRow.noaaNum.matches("^\\s*$")) {
                vector2.add("-");
            } else {
                vector2.add(rsRow.noaaNum);
            }
            rsRow.obsTitle = vOEventData.obsTitle;
            if (rsRow.obsTitle == null || rsRow.obsTitle.matches("^\\s*$")) {
                vector2.add("-");
            } else {
                vector2.add(rsRow.obsTitle);
            }
            rsRow.sciObjectives = vOEventData.sciObjectives;
            if (rsRow.sciObjectives == null || rsRow.sciObjectives.matches("^\\s*$")) {
                vector2.add("-");
            } else {
                vector2.add(rsRow.sciObjectives);
            }
            if (rsRow.instrument == null || rsRow.instrument.matches("^\\s*$")) {
                vector2.add("-");
            } else {
                vector2.add(rsRow.instrument);
            }
            rsRow.observers = vOEventData.observers;
            rsRow.startTime = vOEventData.startTime;
            vector2.add(dateFormat.format(rsRow.startTime));
            rsRow.stopTime = vOEventData.stopTime;
            vector2.add(dateFormat.format(rsRow.stopTime));
            vector.add(vector2);
            this.dataRows.add(rsRow);
        }
        for (n = 0; n < vector.size(); ++n) {
            this.obsTableModel.addRow((Vector)vector.get(n));
        }
        TableColumn tableColumn = this.obsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(40);
        tableColumn = this.obsTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.obsTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.obsTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(40);
        tableColumn = this.obsTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(80);
        this.resultsTitle.setText("Search Results: " + vector.size() + " Events");
    }

    private void updateChannelPminPmax() {
        int n = this.obsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        RsRow rsRow = (RsRow)this.dataRows.get(n);
        int n2 = rsRow.channelData.size();
        for (int i = 0; i < n2; ++i) {
            ModeInfo modeInfo = (ModeInfo)rsRow.channelData.get(i);
            int n3 = this.lowWaterCombo.getSelectedIndex();
            int n4 = modeInfo.datap.length - this.highWaterCombo.getSelectedIndex() - 1;
            this.channelTableModel.setValueAt("" + modeInfo.datap[n3], i, 5);
            this.channelTableModel.setValueAt("" + modeInfo.datap[n4], i, 6);
        }
    }

    private void updateChannelsDisplay() {
        this.channelTableModel.setRowCount(0);
        int n = this.obsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        RsRow rsRow = (RsRow)this.dataRows.get(n);
        if (rsRow.channelData == null) {
            this.getChannelInfo(rsRow.eventId, rsRow);
        }
        int n2 = rsRow.channelData.size();
        for (int i = 0; i < n2; ++i) {
            ModeInfo modeInfo = (ModeInfo)rsRow.channelData.get(i);
            Vector<String> vector = new Vector<String>();
            int n3 = this.lowWaterCombo.getSelectedIndex();
            int n4 = modeInfo.datap.length - this.highWaterCombo.getSelectedIndex() - 1;
            vector.add(modeInfo.channel);
            vector.add("" + modeInfo.nmatches);
            vector.add("(" + (long)modeInfo.xcen + ", " + (long)modeInfo.ycen + ")");
            vector.add("(" + (long)modeInfo.fovx + ", " + (long)modeInfo.fovy + ")");
            vector.add("(" + modeInfo.nAxis1 + ", " + modeInfo.nAxis2 + ")");
            vector.add("" + modeInfo.datap[n3]);
            vector.add("" + modeInfo.datap[n4]);
            this.channelTableModel.addRow(vector);
        }
        TableColumn tableColumn = this.channelTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(8);
        tableColumn = this.channelTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(8);
        tableColumn = this.channelTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.channelTable.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.channelTable.getColumnModel().getColumn(4);
        tableColumn.setPreferredWidth(60);
        tableColumn = this.channelTable.getColumnModel().getColumn(5);
        tableColumn.setPreferredWidth(30);
        tableColumn = this.channelTable.getColumnModel().getColumn(6);
        tableColumn.setPreferredWidth(30);
        this.channelSelectionModel.setSelectionInterval(0, n2 - 1);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.obsSelectionModel) {
            this.updateChannelsDisplay();
        } else if (listSelectionEvent.getSource() == this.channelSelectionModel) {
            // empty if block
        }
    }

    private void postFixAuthDialog() {
        JOptionPane.showMessageDialog(this, "Authentication failed.  Please correct username and/or password.");
    }

    private boolean authenticateUser(int n) {
        for (int i = 0; i < n; ++i) {
            String string = this.usernameField.getText().trim();
            String string2 = new String(this.passwordField.getPassword()).trim();
            if (string.length() <= 0 || string2.length() <= 0) {
                return false;
            }
            String string3 = "https://www.lmsal.com/hpkb";
            PodUploaderImplementation podUploaderImplementation = new PodUploaderImplementation(string3);
            try {
                podUploaderImplementation.login(string, string2);
                return true;
            }
            catch (Exception exception) {
                this.postFixAuthDialog();
                continue;
            }
        }
        return false;
    }

    public File findFileInPath(File file, Vector vector) {
        if (file.isFile() && file.canRead()) {
            return file;
        }
        for (Object e : vector) {
            File file2 = new File((String)e, file.toString());
            try {
                if (!file2.isFile() || !file2.canRead()) continue;
                return file2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public void launchPanorama() {
        Object object;
        Object object2;
        Object object3;
        Date date = new Date(System.currentTimeMillis());
        String string = dateFormat.format(date);
        String string2 = string.replaceAll("[ \t:]+", "_");
        if (homeDirName == null) {
            homeDirName = ".";
        }
        File file = new File(homeDirName + "/.panorama");
        file.mkdirs();
        File file2 = new File(file, "plauncher.log");
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(new FileOutputStream(file2, true));
        }
        catch (Exception exception) {
            printStream = System.out;
        }
        String[] stringArray = null;
        String string3 = this.usernameField.getText().trim();
        String string4 = new String(this.passwordField.getPassword()).trim();
        Map<String, String> map = System.getenv();
        int n = 0;
        if (this.testCheckBox.isSelected()) {
            n = 0;
            stringArray = new String[map.size()];
        } else if (string3.length() > 0 && string4.length() > 0 && this.authenticateUser(1)) {
            stringArray = new String[map.size() + 2];
            stringArray[n] = "HKB_USERNAME=" + string3;
            stringArray[++n] = "HKB_PASSWORD=" + string4;
            ++n;
        } else {
            System.out.println("Username/password not authenticated, and Test box is not checked.");
            return;
        }
        Set<String> set = map.keySet();
        for (String object42 : set) {
            object3 = map.get(object42);
            stringArray[n] = object42 + "=" + (String)object3;
            ++n;
        }
        File file3 = new File(file, "plauncher-" + string2 + ".cmd");
        object3 = null;
        try {
            object3 = new PrintStream(new FileOutputStream(file3, true));
        }
        catch (Exception string5) {
            System.err.println("Unable to create Panorama command file: " + file3.toString());
            string5.printStackTrace();
            return;
        }
        System.out.println("Created Panorama command file:  " + file3);
        String string5 = this.theCmdLine.getText().trim();
        if (string5.length() > 0) {
            String[] n2 = string5.split("\\s+");
            for (int rsRow = 0; rsRow < n2.length; ++rsRow) {
                ((PrintStream)object3).println(n2[rsRow]);
            }
        }
        int n2 = this.obsTable.getSelectedRow();
        RsRow rsRow = (RsRow)this.dataRows.get(n2);
        SotKbClient.Instrument instrument = null;
        String string6 = "-data";
        if (this.normalizedCheck.isSelected()) {
            string6 = "-datap";
        }
        if (this.traceRegionTrackingCheckBox.isSelected()) {
            ((PrintStream)object3).println("-traceregiontracking");
        }
        if (rsRow.instrument.matches("^.*TRACE.*$")) {
            instrument = SotKbClient.Instrument.TRACE;
        } else if (rsRow.instrument.matches("^.*SOT.*$")) {
            instrument = SotKbClient.Instrument.HINODE_SOT;
        } else if (rsRow.instrument.matches("^.*XRT.*$")) {
            instrument = SotKbClient.Instrument.HINODE_XRT;
        }
        ((PrintStream)object3).println("-windowgeom");
        ((PrintStream)object3).println((String)this.windowGeomCombo.getSelectedItem());
        for (int vector = 0; vector < theSearchDirList.size(); ++vector) {
            ((PrintStream)object3).println("-addsearchpath");
            ((PrintStream)object3).println((String)theSearchDirList.get(vector));
        }
        Vector vector = new Vector();
        ((PrintStream)object3).println("-cites");
        ((PrintStream)object3).println(rsRow.eventId);
        String string7 = (String)this.subsampleCombo.getSelectedItem();
        int n3 = this.lowWaterCombo.getSelectedIndex();
        int n4 = this.highWaterCombo.getSelectedIndex();
        String string8 = "";
        int n5 = 0;
        int n6 = 0;
        for (int string11 = 0; string11 < rsRow.channelData.size(); ++string11) {
            object2 = (ModeInfo)rsRow.channelData.get(string11);
            if (debugLevel >= 5) {
                System.out.println("mi.channel=" + ((ModeInfo)object2).channel + ", mi.nmatches=" + ((ModeInfo)object2).nmatches + ", mi.level1DatFile=" + ((ModeInfo)object2).level1DatFile + ", FITS files=" + ((ModeInfo)object2).level1Files);
            }
            if (this.invertColorsCheckBox.isSelected()) {
                ((PrintStream)object3).println("-reversecolors");
            }
            if (!this.channelSelectionModel.isSelectedIndex(string11)) continue;
            ((PrintStream)object3).println("-channel");
            ((PrintStream)object3).println("-timesubsample");
            if (((ModeInfo)object2).nmatches > 50) {
                ((PrintStream)object3).println(string7);
            } else {
                ((PrintStream)object3).println("1");
            }
            if (((ModeInfo)object2).hasDatap) {
                ((PrintStream)object3).println(string6 + "min");
                ((PrintStream)object3).println((String)this.channelTableModel.getValueAt(string11, 5));
                ((PrintStream)object3).println(string6 + "max");
                ((PrintStream)object3).println((String)this.channelTableModel.getValueAt(string11, 6));
            }
            object = ((ModeInfo)object2).level1Files.split("[\\s,]+");
            printStream.println("FITS Search Path: " + theSearchDirList);
            System.out.println("FITS Search Path: " + theSearchDirList);
            for (String string9 : object) {
                if (string9.matches("^\\s*$")) continue;
                String string10 = string9.replaceFirst("^.*trace/level1", "trace/level1");
                string10 = string10.replaceFirst("^.*hinode/sot/", "hinode/sot/");
                ++n5;
                File file4 = new File(string10);
                if (!(file4 != null && file4.exists() && file4.isFile() || (file4 = this.findFileInPath(file4, theSearchDirList)) != null || !string10.matches("^.*/QuickLook/.*"))) {
                    string10 = string10.replaceAll("^.*sot/QuickLook/", "hinode/sot/level0/");
                    file4 = this.findFileInPath(new File(string10), theSearchDirList);
                }
                ((PrintStream)object3).println(string10);
                if (n5 <= 5) {
                    printStream.println("Found:  file='" + string9 + "' --> found='" + file4 + "'");
                }
                if (debugLevel >= 2) {
                    System.out.println("file='" + string9 + "' --> found='" + file4 + "'");
                }
                if (file4 != null) continue;
                if (++n6 <= 10) {
                    System.out.println("FILE NOT FOUND:  '" + string10 + "',  tot=" + n5 + ", missing=" + n6);
                } else if (n6 <= 11) {
                    System.out.println("Missing file list truncated at first 10.  Check log file for complete list.");
                }
                printStream.println("FILE NOT FOUND:  '" + string10 + "',  tot=" + n5 + ", missing=" + n6);
            }
        }
        if (debugLevel > 0) {
            System.out.println("FITS file count=" + n5 + ", numMissing=" + n6);
        }
        if (n5 <= 0 || n6 >= 9 * n5 / 10) {
            JOptionPane.showMessageDialog(this, "Unable to launch Panorama.\nSome or all FITS files are missing.\n\nThis is likely caused by a missing or malformed VOEvent directory, or possibly NFS problems.\n", "Error launching Panorama", 2);
            return;
        }
        String string11 = "panorama -quiet ";
        string11 = string11 + " -cmdfile " + file3.toString();
        System.out.println("---------------------------------");
        System.out.println("Citing VOEvent id: '" + rsRow.eventId + "'");
        System.out.println(string + "  -- launching Panorama:   " + string11);
        printStream.println("---------------------------------");
        printStream.println(string + "  -- launching Panorama:   " + string11);
        object2 = Runtime.getRuntime();
        object = null;
        try {
            object = ((Runtime)object2).exec(string11, stringArray);
        }
        catch (IOException iOException) {
            System.err.println("Error running command: " + string11);
            iOException.printStackTrace();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.obsTable.getSelectedRow();
        if (itemEvent.getSource() != this.lowWaterCombo || n != -1) {
            // empty if block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.panoButton) {
            this.launchPanorama();
        } else if (object == this.addPathButton) {
            this.postDirChooser(this);
        } else if (object == this.lowWaterCombo || object == this.highWaterCombo) {
            this.updateChannelPminPmax();
        } else if (object == this.eventTypeCombo) {
            this.showResults();
        } else {
            this.writeConfigFile(this.startTimePicker.getTimeString(), this.endTimePicker.getTimeString());
            this.kbSearch();
        }
    }

    public HkbLauncher() {
        this.readConfigFile();
        HkbLauncher hkbLauncher = this;
        hkbLauncher.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        hkbLauncher.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        this.instCombo = new JComboBox();
        this.instCombo.addItem("TRACE");
        this.instCombo.addItem("SOT");
        this.instCombo.addItem("XRT");
        if (this.instrument != null) {
            this.instCombo.setSelectedItem(this.instrument);
        }
        this.eventTypeCombo = new JComboBox();
        this.eventTypeCombo.addItem("Coverage");
        this.eventTypeCombo.addItem("Observation");
        this.eventTypeCombo.addItem("All");
        this.eventTypeCombo.addActionListener(this);
        this.searchButton = new JButton("Search");
        this.searchButton.addActionListener(this);
        gridBagConstraints.gridy = 1;
        jPanel2.add((Component)new JLabel("        "), gridBagConstraints);
        this.startTimePicker = new TimePicker((JComponent)new JLabel("Start Time  "), this.timeRangeStart);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        jPanel3.add((Component)this.startTimePicker, gridBagConstraints);
        this.endTimePicker = new TimePicker(new JLabel("End Time  "), this.timeRangeEnd, this.startTimePicker);
        gridBagConstraints.gridy += gridBagConstraints.gridheight;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        jPanel3.add((Component)this.endTimePicker, gridBagConstraints);
        gridBagConstraints.gridy += gridBagConstraints.gridheight;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel3.add((Component)new JLabel("Search text"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 5;
        this.textSearch = new JTextField(30);
        jPanel3.add((Component)this.textSearch, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)new JLabel("Instrument"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.instCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)new JLabel("  "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.searchButton, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)new JLabel("  "), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)new JLabel("  "), gridBagConstraints);
        gridBagConstraints.gridy += 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)new JLabel("Event type"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel3.add((Component)this.eventTypeCombo, gridBagConstraints);
        this.resultsTitle = new JLabel("Coverage Search Results");
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)this.resultsTitle, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JLabel jLabel = new JLabel("Channel Data");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 5;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.channelTableModel = new DefaultTableModel(this.channelTableColumnNames, 0);
        this.channelTable = new JTable(this.channelTableModel);
        this.channelTable.setSelectionMode(2);
        this.channelSelectionModel = this.channelTable.getSelectionModel();
        this.channelSelectionModel.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.channelTable);
        jScrollPane.setPreferredSize(new Dimension(525, 150));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 5;
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        int n = gridBagConstraints.ipadx;
        gridBagConstraints.ipadx = 20;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipadx = n;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.obsTableModel = new DefaultTableModel(this.obsTableColumnNames, 0);
        this.obsTable = new JTable(this.obsTableModel);
        this.obsTable.setSelectionMode(0);
        this.obsSelectionModel = this.obsTable.getSelectionModel();
        this.obsSelectionModel.addListSelectionListener(this);
        JScrollPane jScrollPane2 = new JScrollPane(this.obsTable);
        hkbLauncher.add((Component)jScrollPane2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.add(new JLabel("username: "));
        this.usernameField = new JTextField(10);
        jPanel5.add(this.usernameField);
        jPanel5.add(new JLabel("password: "));
        this.passwordField = new JPasswordField(10);
        jPanel5.add(this.passwordField);
        gridBagConstraints.gridwidth = 3;
        jPanel4.add((Component)jPanel5, gridBagConstraints);
        this.addPathButton = new JButton("Add FITS Path");
        this.addPathButton.addActionListener(this);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)this.addPathButton, gridBagConstraints);
        this.traceRegionTrackingCheckBox = new JCheckBox("Region Tracking", true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)this.traceRegionTrackingCheckBox, gridBagConstraints);
        this.invertColorsCheckBox = new JCheckBox("Invert Colors", false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)this.invertColorsCheckBox, gridBagConstraints);
        this.normalizedCheck = new JCheckBox("Normalized", true);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)this.normalizedCheck, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add(new JLabel("flags:"));
        this.theCmdLine = new JTextField(15);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridwidth = 1;
        jPanel4.add((Component)this.theCmdLine, gridBagConstraints);
        this.lowWaterCombo = new JComboBox();
        this.lowWaterCombo.addItem("1%");
        this.lowWaterCombo.addItem("10%");
        this.lowWaterCombo.addItem("25%");
        this.lowWaterCombo.addItem("75%");
        this.lowWaterCombo.addItem("90%");
        this.lowWaterCombo.addItem("95%");
        this.lowWaterCombo.addItem("98%");
        this.lowWaterCombo.addItem("99%");
        this.lowWaterCombo.addActionListener(this);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)this.lowWaterCombo, gridBagConstraints);
        this.highWaterCombo = new JComboBox();
        this.highWaterCombo.addItem("99%");
        this.highWaterCombo.addItem("98%");
        this.highWaterCombo.addItem("95%");
        this.highWaterCombo.addItem("90%");
        this.highWaterCombo.addItem("75%");
        this.highWaterCombo.addItem("25%");
        this.highWaterCombo.addItem("10%");
        this.highWaterCombo.addItem("1%");
        this.highWaterCombo.addActionListener(this);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)this.highWaterCombo, gridBagConstraints);
        JLabel jLabel2 = new JLabel("  subsampling:");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)jLabel2, gridBagConstraints);
        this.subsampleCombo = new JComboBox();
        this.subsampleCombo.addItem("1");
        this.subsampleCombo.addItem("2");
        this.subsampleCombo.addItem("3");
        this.subsampleCombo.addItem("4");
        this.subsampleCombo.addItem("5");
        this.subsampleCombo.addItem("8");
        this.subsampleCombo.addItem("10");
        this.subsampleCombo.addItem("20");
        this.subsampleCombo.addItem("30");
        this.subsampleCombo.addItem("40");
        this.subsampleCombo.addItem("50");
        this.subsampleCombo.addItem("100");
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)this.subsampleCombo, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)new JLabel("  Window:"), gridBagConstraints);
        this.windowGeomCombo = new JComboBox();
        this.windowGeomCombo.addItem("720p");
        this.windowGeomCombo.addItem("Native");
        this.windowGeomCombo.addItem("1080p");
        this.windowGeomCombo.addItem("1Kx1K");
        this.windowGeomCombo.addItem("512x512");
        this.windowGeomCombo.addItem("768x768");
        this.windowGeomCombo.addItem("480p");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)this.windowGeomCombo, gridBagConstraints);
        this.testCheckBox = new JCheckBox("Test");
        gridBagConstraints.gridx = 9;
        jPanel4.add((Component)this.testCheckBox, gridBagConstraints);
        this.panoButton = new JButton("Panorama");
        this.panoButton.addActionListener(this);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel4.add((Component)this.panoButton, gridBagConstraints);
        hkbLauncher.add((Component)jPanel4, "South");
        while (theSearchDirList.size() <= 0) {
            this.postDirChooser(this);
            this.readConfigFile();
            theSearchDirList.add("/net/bigdata/archive");
        }
    }

    private static void buildGui() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        String string = HkbLauncher.getBuildId();
        String string2 = HkbLauncher.getBuildRevision();
        String string3 = "HelioKB Panorama Launcher   (rev: " + string2;
        if (string.length() > 0) {
            string3 = string3 + ", " + string;
        }
        string3 = string3 + ")";
        JFrame jFrame = new JFrame(string3);
        jFrame.setDefaultCloseOperation(3);
        HkbLauncher hkbLauncher = new HkbLauncher();
        jFrame.getContentPane().add(hkbLauncher);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        File file;
        boolean bl;
        boolean bl2;
        block8: {
            bl2 = false;
            bl = false;
            homeDirName = System.getenv("HOME");
            file = new File("plauncher.log");
            int n = 0;
            while (file.exists()) {
                if (!file.isFile() || !file.canWrite()) {
                    file = new File("plauncher-" + ++n + ".log");
                    continue;
                }
                break block8;
            }
            file.createNewFile();
        }
        Log.initFileLogging(file.toString());
        String string = HkbLauncher.getBuildId();
        String string2 = HkbLauncher.getBuildRevision();
        System.out.println("Panorama launcher (rev: " + string2 + ", build: " + string + ")");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase("-lint")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-followup")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-addpath") || stringArray[i].equalsIgnoreCase("-addfitspath") || stringArray[i].equalsIgnoreCase("-addsearchpath")) {
                theSearchDirList.add(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-nopath") || stringArray[i].equalsIgnoreCase("-clearpath") || stringArray[i].equalsIgnoreCase("-nofitspath") || stringArray[i].equalsIgnoreCase("-nosearchpath")) {
                theSearchDirList.clear();
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("-d")) {
                ++debugLevel;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("-v")) continue;
            debugLevel += 5;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HkbLauncher.buildGui();
            }
        });
    }

    private class RsRow {
        public int panoramaLaunchCount = 0;
        public int eventKey = -1;
        public String eventId = null;
        public int eventType = -1;
        public String instrument = null;
        public String parentDir = null;
        public String fitsFiles = null;
        public String obsTitle = null;
        public String sciObjectives = null;
        public String observers = null;
        public String noaaNum = null;
        public Date startTime = null;
        public Date stopTime = null;
        public Vector channelData = null;
        public int viewCount = 0;
        public String channels = null;

        private RsRow() {
        }
    }

    private class ModeInfo {
        public int nmatches = -1;
        public int nss = -1;
        public String obsDir = null;
        public String channel = null;
        public String level1DatFile = null;
        public String urlParent = null;
        public String urlJavascript = null;
        public String urlMpeg = null;
        public String urlContext = null;
        public String uMode = null;
        public String progNo = null;
        public int nAxis1 = 0;
        public int nAxis2 = 0;
        public double fovx = 0.0;
        public double fovy = 0.0;
        public double xcen = 0.0;
        public double ycen = 0.0;
        public int groupId = 0;
        public double[] datap = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        public boolean hasDatap = false;
        public String datFile = null;
        public String level1Files = null;

        private ModeInfo() {
        }
    }
}

