/*
 * Decompiled with CFR 0.152.
 */
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateParser {
    protected static String toThreeLetterMonth(String string) {
        if (Character.isLetter(string.charAt(0))) {
            return string.substring(0, 3);
        }
        return string;
    }

    protected static String removeLeadingZero(String string) {
        if (string.indexOf("0") == 0) {
            return string.substring(1);
        }
        return string;
    }

    protected static String whitespaceToDash(String string) {
        return string.replaceAll("[ ]+", "-");
    }

    public static List<DatePattern> parseMatch(String string) {
        Object object;
        Object object2;
        ArrayList<DatePattern> arrayList = new ArrayList<DatePattern>();
        if (string == null) {
            return arrayList;
        }
        string = string.trim();
        try {
            if (string.length() == 8 && string.matches("^[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$") && (object2 = ((DateFormat)(object = new SimpleDateFormat("yyyyMMdd"))).parse(string)) != null) {
                arrayList.add(new DatePattern((Date)object2, "yyyyMMdd"));
                return arrayList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = new StringTokenizer(string, " -/:\\,.");
            object2 = DateParser.toThreeLetterMonth(DateParser.removeLeadingZero(((StringTokenizer)object).nextToken()));
            String string2 = DateParser.toThreeLetterMonth(DateParser.removeLeadingZero(((StringTokenizer)object).nextToken()));
            String string3 = "";
            if (((StringTokenizer)object).hasMoreTokens()) {
                string3 = DateParser.toThreeLetterMonth(((StringTokenizer)object).nextToken());
            }
            if (((StringTokenizer)object).hasMoreTokens()) {
                System.out.println("too many tokens");
                return arrayList;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            String string4 = simpleDateFormat.format(new Date());
            String[] stringArray = new String[]{"^[0-9][0-9]?-[a-zA-Z][a-zA-Z][a-zA-Z]-[0-9][0-9][0-9][0-9]$", "^[0-9][0-9][0-9][0-9]-[0-9][0-9]?-[0-9][0-9]?$", "^[0-9][0-9]?-[a-zA-Z][a-zA-Z][a-zA-Z]-[0-9][0-9]$", "^[0-9][0-9]-[0-9][0-9]?-[0-9][0-9]?$", "^[0-9][0-9]?-[0-9][0-9]?-[0-9][0-9][0-9][0-9]$", "^[0-9][0-9]?-[0-9][0-9]?-[0-9][0-9]$", "^[a-zA-Z][a-zA-Z][a-zA-Z]-[0-9][0-9]?-[0-9][0-9][0-9][0-9]$", "^[a-zA-Z][a-zA-Z][a-zA-Z]-[0-9][0-9]?-[0-9][0-9]$"};
            String[] stringArray2 = new String[]{"d-MMM-yyyy", "yyyy-M-d", "d-MMM-yy", "yy-M-d", "d-M-yyyy", "d-M-yy", "MMM-d-yyyy", "MMM-d-yy"};
            string = (String)object2 + " " + string2 + " " + string3;
            string = string.trim();
            string = DateParser.whitespaceToDash(string);
            Date date = null;
            boolean bl = false;
            if (string.matches("^[0-9][0-9]?-[a-zA-Z][a-zA-Z][a-zA-Z]$")) {
                string = string + "-" + string4;
            } else if (string.matches("^[a-zA-Z][a-zA-Z][a-zA-Z]-[0-9][0-9]?$")) {
                string = string + "-" + string4;
            }
            for (int i = 0; !bl && i < stringArray2.length; ++i) {
                if (!string.matches(stringArray[i])) continue;
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(stringArray2[i]);
                try {
                    date = simpleDateFormat2.parse(string);
                    if (date == null) continue;
                    bl = true;
                    arrayList.add(new DatePattern(date, stringArray2[i]));
                    continue;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (!bl) {
                System.out.println("couldn't parse string");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static Date parse(String string) {
        List<DatePattern> list = DateParser.parseMatch(string);
        Date date = null;
        if (list.size() > 0) {
            date = list.get(0).getDate();
        }
        return date;
    }

    public static void main(String[] stringArray) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = simpleDateFormat.parse("20070304");
        String[] stringArray2 = new String[]{"20070304", "2007-03-04", "4 March 2007", "04 March 2007", "4 Mar 2007", "4 mar 2007", "4/mar/2007", "4-mar-2007", "4 March 07", "4 mar 07", "4-mar-07", "mar 4 2007", "mar 4 07", "March 4 2007", "3-4-2007", "3-4-07", "4-3-2007", "4-3-07", "4 Mar"};
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string : stringArray2) {
            Date date2 = DateParser.parse(string);
            if (date2 == null) {
                arrayList2.add(string);
            } else if (date2.equals(date)) {
                arrayList.add(string);
            } else {
                arrayList3.add(string);
            }
            System.out.println("---->Input string " + string + "=" + date2);
        }
        System.out.println("----------- Test Results ---------------------------");
        for (String string : arrayList) {
            System.out.println("Passed: " + string);
        }
        for (String string : arrayList2) {
            System.out.println("Not Parsed: " + string);
        }
        for (String string : arrayList3) {
            System.out.println("Wrong Parsed: " + string);
        }
        System.out.println("---------- Test Totals ----------------------------");
        System.out.println("Test Results: Passed=" + arrayList.size() + ", Not Parsed=" + arrayList2.size() + ", Wrong Parsed=" + arrayList3.size());
    }

    public static class DatePattern {
        private Date date;
        private String pattern;

        public DatePattern(Date date, String string) {
            this.date = date;
            this.pattern = string;
        }

        public Date getDate() {
            return this.date;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

