/*
 * Decompiled with CFR 0.152.
 */
package com.lmsal.pod.client;

import com.lmsal.pod.client.EasySSLProtocolSocketFactory;
import com.lmsal.pod.client.HttpTransferEvent;
import com.lmsal.pod.client.HttpTransferEventListener;
import com.lmsal.pod.client.PodUpload;
import com.lmsal.pod.client.PodUploadImplementation;
import com.lmsal.pod.client.PodUploader;
import com.lmsal.pod.client.UploadTask;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.log4j.Logger;

public class PodUploaderImplementation
implements PodUploader {
    HttpClient client;
    String url;
    String username = "";
    String password = "";
    Set listeners;
    static Logger log;
    private Map<PodUpload, UploadTask> uploads = new HashMap<PodUpload, UploadTask>();

    public PodUploaderImplementation(String url) {
        System.out.println("PodUploaderImplementation constr " + new Date());
        log = Logger.getLogger(PodUploaderImplementation.class);
        log.debug("PodUploaderImplementation constr");
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        log.debug("about to connectionManager.getParams");
        HttpConnectionManagerParams params = connectionManager.getParams();
        int maxHostConnections = 10;
        params.setDefaultMaxConnectionsPerHost(maxHostConnections);
        log.debug("about to new HttpClient");
        this.client = new HttpClient(connectionManager);
        Protocol.registerProtocol("https", new Protocol("https", new EasySSLProtocolSocketFactory(), 443));
        this.url = url;
        this.listeners = new HashSet();
        System.out.println("bottom PodUploaderImplementation constr");
    }

    private String getURLContent(String url) throws IOException {
        GetMethod method = new GetMethod(url);
        int status = this.client.executeMethod(method);
        String response = method.getResponseBodyAsString();
        method.releaseConnection();
        return response;
    }

    private int publicPing() throws IOException {
        log.debug("public ping");
        String pingUrl = this.url + "/ping.txt";
        String response = this.getURLContent(pingUrl);
        boolean authenticated = false;
        authenticated = response.trim().equals("ping");
        if (authenticated) {
            return 1;
        }
        return -1;
    }

    private int protectedPing() throws IOException {
        log.debug("protected ping");
        String pingUrl = this.url + "/Nav/ping.txt";
        String response = this.getURLContent(pingUrl);
        boolean authenticated = false;
        authenticated = response.trim().equals("ping");
        if (authenticated) {
            return 1;
        }
        return -1;
    }

    public void login(String username, String password) throws FailedLoginException {
        log.debug("login");
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        this.username = username;
        this.password = password;
        String callbackUrl = this.url + "/Nav/ping.txt";
        log.debug("callbackUrl=" + callbackUrl);
        String targetUrl = this.url + "/auth-service";
        log.debug("targetUrl=" + targetUrl);
        String mount = "";
        try {
            URL urlObj = new URL(this.url);
            mount = urlObj.getFile();
            log.debug("mount=" + mount);
        }
        catch (MalformedURLException mue) {
            log.debug(mue);
        }
        try {
            PostMethod method = new PostMethod(targetUrl);
            method.addParameter("cmd", "submit-login");
            method.addParameter("j_username", username);
            method.addParameter("j_password", password);
            method.addParameter("callback-url", callbackUrl);
            if (mount != null && mount.trim().length() > 0) {
                method.addParameter("mount", mount);
            }
            method.getParams().setCookiePolicy("compatibility");
            this.client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
            int status = this.client.executeMethod(method);
            log.debug("status=" + status);
            String response = method.getResponseBodyAsString();
            log.debug("response=" + response);
            Cookie[] cookies = this.client.getState().getCookies();
            Header locationHeader = method.getResponseHeader("location");
            String redirectLocation = "";
            if (locationHeader != null) {
                redirectLocation = locationHeader.getValue();
            }
            log.debug("redirectLocation=" + redirectLocation);
            log.debug("about to GET redirect");
            GetMethod get = new GetMethod(redirectLocation);
            status = this.client.executeMethod(get);
            log.debug("get status=" + status);
            response = get.getResponseBodyAsString();
            log.debug("response=" + response);
            get.releaseConnection();
            String badLoginStr = "Incorrect username/password";
            if (response.indexOf(badLoginStr) >= 0) {
                throw new FailedLoginException("Incorrect username or password. Error attempting to login to " + this.url);
            }
            if (!response.trim().equals("ping")) {
                throw new FailedLoginException("Error attempting to login to " + this.url);
            }
        }
        catch (Exception e) {
            log.error("Error attempting to login to " + this.url + ": " + e.getMessage());
            throw new FailedLoginException("Error attempting to login to " + this.url + ": " + e.getMessage());
        }
    }

    public PodUpload uploadMovie(String title, String description, String thumbnailCaption, File movie, File frameCapture, File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        return this.uploadPod(title, description, thumbnailCaption, movie, frameCapture, voevents, listener);
    }

    public PodUpload uploadImage(String title, String description, String thumbnailCaption, File image, File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        log.debug("uploadImage");
        return this.uploadPod(title, description, thumbnailCaption, null, image, voevents, listener);
    }

    private PodUpload uploadPod(String title, String description, String thumbnailCaption, File movie, File image, File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        File[] media = new File[]{movie, image};
        return this.uploadPod(title, description, thumbnailCaption, media, voevents, listener);
    }

    private PodUpload uploadPod(final String title, final String description, final String thumbnailCaption, final File[] media, final File[] voevents, HttpTransferEventListener listener) throws AuthenticationException, IOException {
        boolean synchronous;
        log.debug("uploadPod");
        boolean bl = synchronous = listener == null;
        if (listener != null) {
            this.addHttpTransferEventListener(listener);
        }
        UploadTask uploadTask = new UploadTask(){
            private HttpMethod curMethod;
            private boolean abort = false;

            public void abort() {
                this.abort = true;
                if (this.curMethod != null) {
                    this.curMethod.abort();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (this.abort) {
                        throw new IOException("Abort called");
                    }
                    log.debug("about to protectedPing");
                    int pingStatus = PodUploaderImplementation.this.protectedPing();
                    log.debug("pingStatus=" + pingStatus);
                    if (pingStatus != 1) {
                        try {
                            PodUploaderImplementation.this.login(PodUploaderImplementation.this.username, PodUploaderImplementation.this.password);
                        }
                        catch (FailedLoginException fle) {
                            throw new AuthenticationException(fle.getMessage());
                        }
                    }
                    String targetUrl = PodUploaderImplementation.this.url + "/pod";
                    log.debug("targetUrl=" + targetUrl);
                    if (this.abort) {
                        throw new IOException("Abort called");
                    }
                    log.debug("about to new PostMethod");
                    PostMethod method = new PostMethod(targetUrl);
                    log.debug("about to set curMethod");
                    this.curMethod = method;
                    ArrayList<PartBase> partList = new ArrayList<PartBase>();
                    partList.add(new StringPart("cmd", "submit-new-pod"));
                    partList.add(new StringPart("category", "General"));
                    partList.add(new StringPart("content-type", "html"));
                    partList.add(new StringPart("pod-id", ""));
                    partList.add(new StringPart("title", title));
                    partList.add(new StringPart("description", description));
                    partList.add(new StringPart("thumbnail_caption", thumbnailCaption));
                    log.debug("about to build list of media files");
                    if (media != null) {
                        for (File file : media) {
                            if (file == null) continue;
                            partList.add(new FilePart("client_filename", file));
                        }
                    }
                    log.debug("about to build list of voevent files");
                    if (voevents != null) {
                        for (File file : voevents) {
                            partList.add(new FilePart("voevent", file));
                        }
                    }
                    log.debug("about to convert Part list to array");
                    Part[] parts = partList.toArray(new Part[0]);
                    method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));
                    log.debug("about to executeMethod on multipartrequest");
                    int status = PodUploaderImplementation.this.client.executeMethod(method);
                    log.debug("multipart status=" + status);
                    log.debug("upload pod response=");
                    String response = method.getResponseBodyAsString();
                    log.debug(response);
                    method.releaseConnection();
                    log.debug("about to parse response for pod id");
                    Pattern p = Pattern.compile("name=['\"]pod[-_]id['\"]\\s+value=['\"]([^'\"]+)['\"]>");
                    Matcher m = p.matcher(response);
                    String podId = "";
                    if (m.find()) {
                        podId = m.group(1);
                    }
                    log.debug("podId=" + podId);
                    if (podId == null || podId.trim().length() == 0) {
                        throw new IOException("Failed to get pod id from server");
                    }
                    String parameterErrorIndicationStr = "The gallery input contains errors";
                    if (response.indexOf(parameterErrorIndicationStr) >= 0) {
                        throw new IOException("Missing parameters");
                    }
                    if (this.abort) {
                        throw new IOException("Abort called");
                    }
                    method = new PostMethod(targetUrl);
                    this.curMethod = method;
                    method.addParameter("cmd", "submit-new-pod");
                    method.addParameter("confirm", "1");
                    method.addParameter("pod-id", podId);
                    log.debug("about to executeMethod for new pod confirmation");
                    status = PodUploaderImplementation.this.client.executeMethod(method);
                    log.debug("confirmation status=" + status);
                    log.debug("confirmation response=");
                    response = method.getResponseBodyAsString();
                    method.releaseConnection();
                    log.debug(response);
                    String confirmationStr = "Thank you for the POD submission";
                    boolean confirmed = false;
                    if (response.indexOf(confirmationStr) >= 0) {
                        confirmed = true;
                    }
                    log.debug("confirmed=" + confirmed);
                    HttpTransferEvent evt = new HttpTransferEvent();
                    if (confirmed) {
                        evt.setMessage("Upload complete");
                        evt.setStatus(HttpTransferEvent.COMPLETE);
                    } else {
                        evt.setMessage("Upload problem. Unable to get server confirmation.");
                        evt.setStatus(HttpTransferEvent.ERROR);
                    }
                    PodUploaderImplementation.this.fireHttpTransferEvent(evt);
                }
                catch (Exception e) {
                    HttpTransferEvent evt = new HttpTransferEvent();
                    if (e.toString() != null && e.toString().equals("Abort called")) {
                        evt.setMessage(e.toString());
                        evt.setStatus(HttpTransferEvent.STOPPED);
                    } else {
                        evt.setMessage("Error uploading files: " + e);
                        evt.setStatus(HttpTransferEvent.ERROR);
                    }
                    PodUploaderImplementation.this.fireHttpTransferEvent(evt);
                }
            }
        };
        Thread uploadThread = new Thread(uploadTask);
        uploadThread.start();
        PodUploadImplementation upload = null;
        if (synchronous) {
            long timeout = 3600000L;
            try {
                uploadThread.join(timeout);
            }
            catch (InterruptedException ie) {
                log.error(ie);
            }
        } else {
            upload = new PodUploadImplementation(this);
            this.uploads.put(upload, uploadTask);
        }
        return upload;
    }

    public void abort(PodUpload upload) {
        UploadTask task = this.uploads.get(upload);
        task.abort();
    }

    private synchronized void addHttpTransferEventListener(HttpTransferEventListener listener) {
        this.listeners.add(listener);
    }

    private synchronized void removeHttpTransferEventListener(HttpTransferEventListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized void fireHttpTransferEvent(HttpTransferEvent evt) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((HttpTransferEventListener)iter.next()).dataTransferAcknowledged(evt);
        }
    }
}

