/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SotKbClient {
    private static String[] KB_FIELDS = new String[]{"obsTitle", "startTime", "stopTime", "eventId", "date", "cadences", "catalogLink", "category", "coordinateSystem", "descriptions", "goal", "instrument", "joinSb", "jopId", "maxCadence", "minCadence", "noaaNum", "note", "obsId", "obsNum", "observers", "planners", "position2D", "purpose", "ranking", "receiptTime", "role", "sciObjectives", "target", "telescope", "tohbans", "uModes", "viewCount", "waveIds", "wavelengths", "xCen", "xFov", "yCen", "yFov"};
    private static SimpleDateFormat ymd = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat ymdHms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static VOEventData getEventDetail(String string) {
        EventDetailXMLParser eventDetailXMLParser = new EventDetailXMLParser();
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
        String string3 = "http://sot.lmsal.com/sot-data?cmd=view-event&event-id=" + string2 + "&output-format=xml";
        String string4 = null;
        try {
            string4 = IOUtil.readUrl(string3);
            eventDetailXMLParser.parseString(string4);
        }
        catch (Exception exception) {
            System.err.println("getEventDetail(): Exception reading event=" + string + " URL=" + string3);
            exception.printStackTrace();
            return null;
        }
        Vector vector = eventDetailXMLParser.getEventList();
        if (vector == null || vector.size() <= 0) {
            return null;
        }
        return (VOEventData)vector.get(0);
    }

    private static String instrString(Instrument instrument) {
        String string = null;
        if (instrument == null) {
            string = null;
        } else if (instrument == Instrument.HINODE_SOT) {
            string = "SOT";
        } else if (instrument == Instrument.HINODE_XRT) {
            string = "XRT";
        } else if (instrument == Instrument.TRACE) {
            string = "TRACE";
        }
        return string;
    }

    private static Vector<VOEventData> searchEvents(Date date, Date date2, String string, String string2, String string3, String string4) {
        long l;
        long l2;
        long l3;
        Object object;
        EventListXMLParser eventListXMLParser = new EventListXMLParser();
        String string5 = URLEncoder.encode(ymdHms.format(date));
        String string6 = URLEncoder.encode(ymdHms.format(date2));
        String string7 = "http://sot.lmsal.com/sot-data?cmd=submit-search-events2&startTime=" + string5 + "&stopTime=" + string6;
        if (string != null) {
            string7 = string7 + "&instrument=" + string;
        }
        if (string2 != null) {
            string7 = string7 + "&obsTitle=" + string2;
        }
        if (string3 != null && string3.trim().length() > 0) {
            object = string3.trim();
            try {
                object = URLEncoder.encode((String)object, "ISO-8859-1");
                string7 = string7 + "&descriptive=" + (String)object;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = ((String)object).replaceAll("['\"~\\/]+", "");
                string7 = string7 + "&descriptive=" + (String)object;
            }
        }
        if (string4 != null) {
            string7 = string7 + "&noaaNum=" + string4;
        }
        for (String string8 : KB_FIELDS) {
            string7 = string7 + "&select=" + string8;
        }
        string7 = string7 + "&output-format=xml";
        object = null;
        try {
            l3 = System.currentTimeMillis();
            object = IOUtil.readUrl(string7);
            l2 = System.currentTimeMillis();
            eventListXMLParser.parseString((String)object);
            l = System.currentTimeMillis();
        }
        catch (Exception exception) {
            System.err.println("getEventList(): Exception reading event list. URL=" + string7);
            exception.printStackTrace();
            System.err.println((String)object);
            return null;
        }
        Vector vector = eventListXMLParser.getEventList();
        Collections.sort(vector);
        if (vector == null || vector.size() <= 0) {
            System.out.println("SotKbClient.getEventList(): No events found.");
            return null;
        }
        float f = l2 - l3;
        float f2 = l - l2;
        System.out.println("SotKbClient.getEventList(): Read time=" + (l2 - l3) + "ms, XML=" + ((String)object).length() + " bytes (" + (float)((String)object).length() / f + " Kb/sec), parsed " + vector.size() + " KB events in " + f2 + "ms (" + (float)vector.size() / f2 * 1000.0f + " events/sec)");
        return vector;
    }

    public static Vector<VOEventData> searchEvents(Date date, Date date2, Instrument instrument, String string, String string2, String string3) {
        String string4 = SotKbClient.instrString(instrument);
        return SotKbClient.searchEvents(date, date2, string4, string, string2, string3);
    }

    public static Vector<VOEventData> searchEvents(Date date, Date date2, Instrument instrument, String string) {
        String string2 = SotKbClient.instrString(instrument);
        return SotKbClient.searchEvents(date, date2, string2, null, null, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Instrument {
        HINODE_SOT,
        HINODE_XRT,
        TRACE;

    }
}

