/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EventListXMLParser
extends DefaultHandler {
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Vector<VOEventData> events = new Vector();
    private VOEventData curEvent = null;
    private String curGroupName = "";
    private ParamGroup curGroup = null;
    private String path = "";
    private StringBuffer charBuf;
    private int spatialRegionType = 0;
    private int v2Count;
    private String lastTag = "";

    public int size() {
        return this.events.size();
    }

    public Vector getEventList() {
        return this.events;
    }

    public static boolean endsWith(String string, String string2) {
        return string.toLowerCase().endsWith(string2.toLowerCase());
    }

    public static String join(String[] stringArray, String string) {
        if (stringArray.length <= 0) {
            return "";
        }
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + string + stringArray[i];
        }
        return string2;
    }

    public static float parseFloat(String string) {
        if (string == null || string.matches(".*[iI][nN][fF].*") || string.contains("[nN][aA][nN]")) {
            return Float.NaN;
        }
        if (string.matches("^\\s*$")) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public static int parseInt(String string) {
        if (string == null || string.matches(".*[iI][nN][fF].*") || string.contains("[nN][aA][nN]")) {
            return 0;
        }
        if (string.matches("^\\s*$")) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    protected void addToPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.path);
        stringBuffer.append("/");
        stringBuffer.append(string);
        this.path = stringBuffer.toString();
    }

    protected String getPath() {
        return this.path;
    }

    protected void moveUpPath() {
        this.path = this.path.substring(0, this.path.lastIndexOf("/"));
    }

    protected String getCurElementName() {
        return this.path.substring(this.path.lastIndexOf("/") + 1);
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.charBuf == null) {
            this.charBuf = new StringBuffer();
        }
        this.charBuf.append(new String(cArray, n, n2));
    }

    public void endDocument() {
    }

    public void startDocument() {
    }

    public void endElement(String string, String string2, String string3) {
        Float f;
        String string4 = "";
        if (this.charBuf != null) {
            string4 = this.charBuf.toString().trim();
        }
        if (EventListXMLParser.endsWith(this.path, "Description")) {
            this.curEvent.description = this.curEvent.description == null ? new String(string4) + "\n" : this.curEvent.description + string4 + "\n";
        } else if (EventListXMLParser.endsWith(this.path, "/e") || EventListXMLParser.endsWith(this.path, "/VOEventData")) {
            if (this.curEvent != null && (this.curEvent.eventId == null || this.curEvent.startTime == null || this.curEvent.stopTime == null)) {
                this.events.remove(this.events.size() - 1);
            }
        } else if (EventListXMLParser.endsWith(this.path, "cadences")) {
            this.curEvent.cadences = string4;
        } else if (EventListXMLParser.endsWith(this.path, "catalogLink")) {
            this.curEvent.catalogLink = string4;
        } else if (EventListXMLParser.endsWith(this.path, "category")) {
            this.curEvent.category = string4;
        } else if (EventListXMLParser.endsWith(this.path, "coordinateSystem")) {
            this.curEvent.coordinateSystem = string4;
        } else if (EventListXMLParser.endsWith(this.path, "date")) {
            this.curEvent.date = TimeParser.parseTimeString(string4);
        } else if (EventListXMLParser.endsWith(this.path, "descriptions")) {
            this.curEvent.description = string4;
        } else if (EventListXMLParser.endsWith(this.path, "eventId")) {
            this.curEvent.eventId = string4 == null || string4.matches("^\\s*$") ? null : string4;
        } else if (EventListXMLParser.endsWith(this.path, "goal")) {
            this.curEvent.goal = string4;
        } else if (EventListXMLParser.endsWith(this.path, "instrument")) {
            this.curEvent.instrument = string4;
        } else if (EventListXMLParser.endsWith(this.path, "joinSb")) {
            this.curEvent.joinSb = string4;
        } else if (EventListXMLParser.endsWith(this.path, "jopId")) {
            this.curEvent.jopId = string4;
        } else if (EventListXMLParser.endsWith(this.path, "maxCadence")) {
            this.curEvent.maxCadence = string4;
        } else if (EventListXMLParser.endsWith(this.path, "minCadence")) {
            this.curEvent.minCadence = string4;
        } else if (EventListXMLParser.endsWith(this.path, "noaaNum")) {
            this.curEvent.noaaNum = string4;
        } else if (EventListXMLParser.endsWith(this.path, "note")) {
            this.curEvent.note = string4;
        } else if (EventListXMLParser.endsWith(this.path, "obsId")) {
            this.curEvent.obsId = string4;
        } else if (EventListXMLParser.endsWith(this.path, "obsNum")) {
            this.curEvent.obsNum = string4;
        } else if (EventListXMLParser.endsWith(this.path, "obsTitle")) {
            this.curEvent.obsTitle = string4;
        } else if (EventListXMLParser.endsWith(this.path, "observers")) {
            this.curEvent.observers = string4;
        } else if (EventListXMLParser.endsWith(this.path, "planners")) {
            this.curEvent.planners = string4;
        } else if (EventListXMLParser.endsWith(this.path, "position2D")) {
            this.curEvent.position2D = string4;
        } else if (EventListXMLParser.endsWith(this.path, "purpose")) {
            this.curEvent.purpose = string4;
        } else if (EventListXMLParser.endsWith(this.path, "ranking")) {
            this.curEvent.ranking = EventListXMLParser.parseFloat(string4);
        } else if (EventListXMLParser.endsWith(this.path, "receiptTime")) {
            this.curEvent.receiptTime = TimeParser.parseTimeString(string4);
        } else if (EventListXMLParser.endsWith(this.path, "role")) {
            this.curEvent.role = string4;
        } else if (EventListXMLParser.endsWith(this.path, "sciObjectives")) {
            this.curEvent.sciObjectives = string4;
        } else if (EventListXMLParser.endsWith(this.path, "startTime")) {
            this.curEvent.startTime = TimeParser.parseTimeString(string4);
        } else if (EventListXMLParser.endsWith(this.path, "stopTime")) {
            this.curEvent.stopTime = TimeParser.parseTimeString(string4);
        } else if (EventListXMLParser.endsWith(this.path, "target")) {
            this.curEvent.targets = string4;
        } else if (EventListXMLParser.endsWith(this.path, "telescope")) {
            this.curEvent.telescope = string4;
        } else if (EventListXMLParser.endsWith(this.path, "tohbans")) {
            this.curEvent.tohbans = string4;
        } else if (EventListXMLParser.endsWith(this.path, "uModes")) {
            this.curEvent.uModes = string4;
        } else if (EventListXMLParser.endsWith(this.path, "viewCount")) {
            this.curEvent.viewCount = EventListXMLParser.parseInt(string4);
        } else if (EventListXMLParser.endsWith(this.path, "waveIds")) {
            this.curEvent.waveIds = string4;
        } else if (EventListXMLParser.endsWith(this.path, "wavelengths")) {
            this.curEvent.wavelengths = string4;
        } else if (EventListXMLParser.endsWith(this.path, "contactName")) {
            this.curEvent.contactName = string4;
        } else if (EventListXMLParser.endsWith(this.path, "contactInstitution")) {
            this.curEvent.contactInstitution = string4;
        } else if (EventListXMLParser.endsWith(this.path, "contactUri")) {
            this.curEvent.contactUri = string4;
        } else if (EventListXMLParser.endsWith(this.path, "contactAddress")) {
            this.curEvent.contactAddress = string4;
        } else if (EventListXMLParser.endsWith(this.path, "contactTelephone")) {
            this.curEvent.contactTelephone = string4;
        } else if (EventListXMLParser.endsWith(this.path, "contactEmail")) {
            this.curEvent.contactEmail = string4;
        } else if (EventListXMLParser.endsWith(this.path, "telescope")) {
            this.curEvent.telescope = string4;
        } else if (EventListXMLParser.endsWith(this.path, "instrument")) {
            this.curEvent.instrument = string4;
        } else if (EventListXMLParser.endsWith(this.path, "tohbans")) {
            this.curEvent.tohbans = string4;
        } else if (EventListXMLParser.endsWith(this.path, "planners")) {
            this.curEvent.planners = string4;
        } else if (EventListXMLParser.endsWith(this.path, "observers")) {
            this.curEvent.observers = string4;
        } else if (EventListXMLParser.endsWith(this.path, "concept")) {
            this.curEvent.concept = string4;
        } else if (EventListXMLParser.endsWith(this.path, "goal")) {
            this.curEvent.goal = string4.replaceAll("^[ ;]+", "");
            this.curEvent.goal = this.curEvent.goal.replaceAll("[ ;]+$", "");
        } else if (EventListXMLParser.endsWith(this.path, "purpose")) {
            this.curEvent.purpose = string4;
        } else if (EventListXMLParser.endsWith(this.path, "obsId")) {
            this.curEvent.obsId = string4;
        } else if (EventListXMLParser.endsWith(this.path, "obsTitle")) {
            this.curEvent.obsTitle = string4;
        } else if (EventListXMLParser.endsWith(this.path, "obsNum")) {
            this.curEvent.obsNum = string4;
        } else if (EventListXMLParser.endsWith(this.path, "noaaNum")) {
            this.curEvent.noaaNum = string4;
        } else if (EventListXMLParser.endsWith(this.path, "jopId")) {
            this.curEvent.jopId = string4;
        } else if (EventListXMLParser.endsWith(this.path, "jop")) {
            this.curEvent.jop = string4;
        } else if (EventListXMLParser.endsWith(this.path, "joinSb")) {
            this.curEvent.joinSb = string4;
        } else if (EventListXMLParser.endsWith(this.path, "sciObjectives")) {
            this.curEvent.sciObjectives = string4;
        } else if (EventListXMLParser.endsWith(this.path, "objects")) {
            this.curEvent.objects = string4;
        } else if (EventListXMLParser.endsWith(this.path, "Target")) {
            this.curEvent.targets = string4;
        } else if (EventListXMLParser.endsWith(this.path, "slotNumber") || EventListXMLParser.endsWith(this.path, "progNumber") || EventListXMLParser.endsWith(this.path, "progNum") || EventListXMLParser.endsWith(this.path, "progNo")) {
            this.curEvent.progNumber = string4;
        } else if (EventListXMLParser.endsWith(this.path, "progVer")) {
            this.curEvent.progVer = string4;
        } else if (EventListXMLParser.endsWith(this.path, "position2D")) {
            this.curEvent.position2D = string4;
        } else if (EventListXMLParser.endsWith(this.path, "xCen")) {
            if (string4 != null && string4.length() > 0) {
                Float f2 = new Float(string4);
                this.curEvent.xCen = f2.floatValue();
            } else {
                this.curEvent.xCen = -1.0E9f;
            }
        } else if (EventListXMLParser.endsWith(this.path, "yCen")) {
            if (string4 != null && string4.length() > 0) {
                Float f3 = new Float(string4);
                this.curEvent.yCen = f3.floatValue();
            } else {
                this.curEvent.yCen = -1.0E9f;
            }
        } else if (EventListXMLParser.endsWith(this.path, "fovX") || EventListXMLParser.endsWith(this.path, "xFov")) {
            Float f4;
            if (string4 != null && string4.length() > 0 && (f4 = new Float(string4)).floatValue() > this.curEvent.xFov) {
                this.curEvent.xFov = f4.floatValue();
            }
        } else if ((EventListXMLParser.endsWith(this.path, "fovY") || EventListXMLParser.endsWith(this.path, "yFov")) && string4 != null && string4.length() > 0 && (f = new Float(string4)).floatValue() > this.curEvent.yFov) {
            this.curEvent.yFov = f.floatValue();
        }
        this.charBuf = null;
        this.moveUpPath();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.addToPath(string3);
        if (this.charBuf != null) {
            this.charBuf = null;
        }
        if (EventListXMLParser.endsWith(this.path, "/e")) {
            this.curEvent = new VOEventData();
            this.events.add(this.curEvent);
        } else if (EventListXMLParser.endsWith(this.path, "VOEventData")) {
            String string4 = attributes.getValue("ivorn");
            if (string4 == null) {
                string4 = attributes.getValue("id");
            }
            this.curEvent = new VOEventData(string4);
            this.curEvent.eventVersion = attributes.getValue("version");
            this.curEvent.role = attributes.getValue("role");
            this.curEvent.eventType = VOEventData.roleType(this.curEvent.role);
            this.events.add(this.curEvent);
        } else if (!EventListXMLParser.endsWith(this.path, "Reference") && !EventListXMLParser.endsWith(this.path, "VOEventData/Citations/EventIVORN")) {
            if (EventListXMLParser.endsWith(this.path, "Group")) {
                this.curGroupName = attributes.getValue("name");
                this.curGroup = new ParamGroup(this.curGroupName, this.path);
                this.curEvent.groups.add(this.curGroup);
                if (EventListXMLParser.endsWith(this.curGroupName, "_required")) {
                    String string5 = this.curGroupName.replaceAll("(_required)*$", "");
                } else if (EventListXMLParser.endsWith(this.curGroupName, "_optional")) {
                    String string6 = this.curGroupName.replaceAll("(_optional)*$", "");
                }
            } else if (EventListXMLParser.endsWith(this.path, "Param")) {
                String string7 = attributes.getValue("name");
                String string8 = attributes.getValue("value");
                this.curGroup.addParam(new ParamGroup.Param(string7, string8));
            }
        }
        this.lastTag = string3;
    }

    public void parseString(String string) throws Exception {
        byte[] byArray = string.getBytes();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        try {
            sAXParser.parse(new InputSource(byteArrayInputStream), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw sAXException;
        }
    }

    public void parseFile(File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = fileInputStream.available();
        if (n <= 0) {
            return;
        }
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        String string = new String(byArray);
        this.parseString(string);
    }

    public EventListXMLParser() {
    }

    public EventListXMLParser(File file) throws Exception {
        this.parseFile(file);
    }

    public static void main(String[] stringArray) {
        for (String string : stringArray) {
        }
    }
}

